/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import jodd.lagarto.TagWriterUtil;
import jodd.lagarto.dom.Attribute;
import jodd.lagarto.dom.CData;
import jodd.lagarto.dom.Comment;
import jodd.lagarto.dom.DocumentType;
import jodd.lagarto.dom.Element;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.Text;
import jodd.lagarto.dom.XmlDeclaration;
import jodd.util.HtmlEncoder;

public class LagartoNodeHtmlRenderer {
    protected Case tagCase = Case.DEFAULT;
    protected Case attributeCase = Case.DEFAULT;

    public void renderNodeValue(Node node, Appendable appendable) throws IOException {
        String nodeValue = node.getNodeValue();
        if (nodeValue != null) {
            appendable.append(nodeValue);
        }
    }

    public void renderCData(CData cdata, Appendable appendable) throws IOException {
        String nodeValue = cdata.getNodeValue();
        TagWriterUtil.writeCData(appendable, nodeValue);
    }

    public void renderComment(Comment comment, Appendable appendable) throws IOException {
        String nodeValue = comment.getNodeValue();
        if (comment.conditionalDownlevelHidden == null) {
            TagWriterUtil.writeComment(appendable, nodeValue);
        } else {
            TagWriterUtil.writeConditionalComment(appendable, nodeValue, comment.isStartingTag, comment.conditionalDownlevelHidden, comment.additionalComment);
        }
    }

    public void renderDocumentType(DocumentType documentType, Appendable appendable) throws IOException {
        TagWriterUtil.writeDoctype(appendable, documentType.nodeValue, documentType.publicId, documentType.baseUri);
    }

    public void renderText(Text text, Appendable appendable) throws IOException {
        String nodeValue = text.getNodeValue();
        appendable.append(nodeValue);
    }

    public void renderXmlDeclaration(XmlDeclaration xmlDeclaration, Appendable appendable) throws IOException {
        String nodeName = xmlDeclaration.getNodeName();
        appendable.append("<?");
        appendable.append(nodeName);
        int attrCount = xmlDeclaration.getAttributesCount();
        if (attrCount != 0) {
            for (int i = 0; i < attrCount; ++i) {
                Attribute attr = xmlDeclaration.getAttribute(i);
                appendable.append(' ');
                this.renderAttribute(xmlDeclaration, attr, appendable);
            }
        }
        appendable.append("?>");
    }

    public void setTagCase(Case tagCase) {
        this.tagCase = tagCase;
    }

    public Case getTagCase() {
        return this.tagCase;
    }

    public void setAttributeCase(Case attributeCase) {
        this.attributeCase = attributeCase;
    }

    public Case getAttributeCase() {
        return this.attributeCase;
    }

    public void reset() {
        this.tagCase = Case.DEFAULT;
        this.attributeCase = Case.DEFAULT;
    }

    protected String resolveNodeName(Node node) {
        switch (this.tagCase) {
            case DEFAULT: {
                return node.getNodeName();
            }
            case RAW: {
                return node.getNodeRawName();
            }
            case LOWERCASE: {
                return node.getNodeRawName().toLowerCase();
            }
            case UPPERCASE: {
                return node.getNodeRawName().toUpperCase();
            }
        }
        return null;
    }

    protected String resolveAttributeName(Node node, Attribute attribute) {
        switch (this.attributeCase) {
            case DEFAULT: {
                return attribute.getName();
            }
            case RAW: {
                return attribute.getRawName();
            }
            case LOWERCASE: {
                return attribute.getRawName().toLowerCase();
            }
            case UPPERCASE: {
                return attribute.getRawName().toUpperCase();
            }
        }
        return null;
    }

    protected void renderAttribute(Node node, Attribute attribute, Appendable appendable) throws IOException {
        String name = this.resolveAttributeName(node, attribute);
        String value = attribute.getValue();
        appendable.append(name);
        if (value != null) {
            appendable.append('=');
            appendable.append('\"');
            appendable.append(HtmlEncoder.text((String)value));
            appendable.append('\"');
        }
    }

    public void renderElement(Element element, Appendable appendable) throws IOException {
        String nodeName = this.resolveNodeName(element);
        appendable.append('<');
        appendable.append(nodeName);
        int attrCount = element.getAttributesCount();
        if (attrCount != 0) {
            for (int i = 0; i < attrCount; ++i) {
                Attribute attr = element.getAttribute(i);
                appendable.append(' ');
                this.renderAttribute(element, attr, appendable);
            }
        }
        int childCount = element.getChildNodesCount();
        if (element.selfClosed && childCount == 0) {
            appendable.append("/>");
            return;
        }
        appendable.append('>');
        if (element.voidElement) {
            return;
        }
        if (childCount != 0) {
            this.renderElementBody(element, appendable);
        }
        appendable.append("</");
        appendable.append(nodeName);
        appendable.append('>');
    }

    protected void renderElementBody(Element element, Appendable appendable) throws IOException {
        element.toInnerHtml(appendable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Case {
        DEFAULT,
        RAW,
        LOWERCASE,
        UPPERCASE;

    }
}

