/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jodd.lagarto.LagartoLexer;
import jodd.lagarto.dom.Attribute;
import jodd.lagarto.dom.LagartoDOMBuilder;
import jodd.lagarto.dom.LagartoDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements Cloneable {
    protected final String nodeName;
    protected final String nodeRawName;
    protected final NodeType nodeType;
    protected final LagartoDOMBuilder domBuilder;
    protected String nodeValue;
    protected List<Attribute> attributes;
    protected Node parentNode;
    protected List<Node> childNodes;
    protected int childElementNodesCount;
    protected Node[] childElementNodes;
    protected int siblingIndex;
    protected int siblingElementIndex = -1;
    protected int siblingNameIndex = -1;
    protected int deepLevel;
    protected LagartoLexer.Position position;

    protected Node(LagartoDOMBuilder domBuilder, NodeType nodeType, String nodeName) {
        this.domBuilder = domBuilder;
        this.nodeRawName = nodeName;
        this.nodeName = nodeName != null ? (domBuilder.isCaseSensitive() ? nodeName : nodeName.toLowerCase()) : null;
        this.nodeType = nodeType;
    }

    protected <T extends Node> T cloneTo(T dest) {
        int i;
        dest.parentNode = this.parentNode;
        dest.deepLevel = this.deepLevel;
        if (this.attributes != null) {
            dest.attributes = new ArrayList<Attribute>(this.attributes.size());
            int attributesSize = this.attributes.size();
            for (i = 0; i < attributesSize; ++i) {
                Attribute attr = this.attributes.get(i);
                dest.attributes.add(attr.clone());
            }
        }
        if (this.childNodes != null) {
            dest.childNodes = new ArrayList<Node>(this.childNodes.size());
            int childNodesSize = this.childNodes.size();
            for (i = 0; i < childNodesSize; ++i) {
                Node child = this.childNodes.get(i);
                Node childClone = child.clone();
                childClone.parentNode = dest;
                dest.childNodes.add(childClone);
            }
        }
        return dest;
    }

    public abstract Node clone();

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeRawName() {
        return this.nodeRawName;
    }

    public String getNodeValue() {
        return this.nodeValue;
    }

    public void setNodeValue(String value) {
        this.nodeValue = value;
    }

    public LagartoDOMBuilder getDomBuilder() {
        return this.domBuilder;
    }

    public void detachFromParent() {
        if (this.parentNode == null) {
            return;
        }
        if (this.parentNode.childNodes != null) {
            this.parentNode.childNodes.remove(this.siblingIndex);
            this.parentNode.reindexChildren();
        }
        this.parentNode = null;
        this.deepLevel = 0;
    }

    public void addChild(Node node) {
        node.detachFromParent();
        node.parentNode = this;
        node.deepLevel = this.deepLevel + 1;
        this.initChildNodes();
        this.childNodes.add(node);
        this.reindexChildrenOnAdd(1);
    }

    public void addChild(Node ... nodes) {
        for (Node node : nodes) {
            node.detachFromParent();
            node.parentNode = this;
            node.deepLevel = this.deepLevel + 1;
            this.initChildNodes();
            this.childNodes.add(node);
        }
        this.reindexChildrenOnAdd(nodes.length);
    }

    public void insertChild(Node node, int index) {
        node.detachFromParent();
        node.parentNode = this;
        node.deepLevel = this.deepLevel + 1;
        try {
            this.initChildNodes();
            this.childNodes.add(index, node);
        }
        catch (IndexOutOfBoundsException ignore) {
            throw new LagartoDOMException("Invalid node index: " + index);
        }
        this.reindexChildren();
    }

    public void insertBefore(Node newChild, Node refChild) {
        int siblingIndex = refChild.getSiblingIndex();
        refChild.parentNode.insertChild(newChild, siblingIndex);
    }

    public void insertAfter(Node newChild, Node refChild) {
        int siblingIndex = refChild.getSiblingIndex() + 1;
        if (siblingIndex == refChild.parentNode.getChildNodesCount()) {
            refChild.parentNode.addChild(newChild);
        } else {
            refChild.parentNode.insertChild(newChild, siblingIndex);
        }
    }

    public Node removeChild(int index) {
        Node node;
        if (this.childNodes == null) {
            return null;
        }
        try {
            node = this.childNodes.get(index);
        }
        catch (IndexOutOfBoundsException ignore) {
            return null;
        }
        node.detachFromParent();
        return node;
    }

    public void removeChild(Node childNode) {
        if (childNode.getParentNode() != this) {
            return;
        }
        childNode.detachFromParent();
    }

    public void removeAllChilds() {
        List<Node> removedNodes = this.childNodes;
        this.childNodes = null;
        this.childElementNodes = null;
        this.childElementNodesCount = 0;
        if (removedNodes != null) {
            int removedNodesSize = removedNodes.size();
            for (int i = 0; i < removedNodesSize; ++i) {
                Node removedNode = removedNodes.get(i);
                removedNode.detachFromParent();
            }
        }
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public boolean hasAttributes() {
        if (this.attributes == null) {
            return false;
        }
        return !this.attributes.isEmpty();
    }

    public int getAttributesCount() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public Attribute getAttribute(int index) {
        if (this.attributes == null) {
            return null;
        }
        if (index < 0 || index >= this.attributes.size()) {
            return null;
        }
        return this.attributes.get(index);
    }

    public boolean hasAttribute(String name) {
        if (this.attributes == null) {
            return false;
        }
        int attributesSize = this.attributes.size();
        for (int i = 0; i < attributesSize; ++i) {
            Attribute attr = this.attributes.get(i);
            if (!attr.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getAttribute(String name) {
        Attribute attribute = this.getAttributeInstance(name);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    protected Attribute getAttributeInstance(String name) {
        if (this.attributes == null) {
            return null;
        }
        if (!this.domBuilder.isCaseSensitive()) {
            name = name.toLowerCase();
        }
        int attributesSize = this.attributes.size();
        for (int i = 0; i < attributesSize; ++i) {
            Attribute attr = this.attributes.get(i);
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    protected int indexOfAttributeInstance(String name) {
        if (this.attributes == null) {
            return -1;
        }
        if (!this.domBuilder.isCaseSensitive()) {
            name = name.toLowerCase();
        }
        int attributesSize = this.attributes.size();
        for (int i = 0; i < attributesSize; ++i) {
            Attribute attr = this.attributes.get(i);
            if (!attr.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeAttribute(String name) {
        int index = this.indexOfAttributeInstance(name);
        if (index == -1) {
            return false;
        }
        this.attributes.remove(index);
        return true;
    }

    public void setAttribute(String name, String value) {
        this.initAttributes();
        String rawAttributeName = name;
        if (!this.domBuilder.isCaseSensitive()) {
            name = name.toLowerCase();
        }
        int attributesSize = this.attributes.size();
        for (int i = 0; i < attributesSize; ++i) {
            Attribute attr = this.attributes.get(i);
            if (!attr.getName().equals(name)) continue;
            attr.setValue(value);
            return;
        }
        this.attributes.add(new Attribute(rawAttributeName, name, value, true));
    }

    public void setAttribute(String name) {
        this.setAttribute(name, null);
    }

    public boolean isAttributeIncluding(String name, String word) {
        Attribute attr = this.getAttributeInstance(name);
        if (attr == null) {
            return false;
        }
        return attr.isIncluding(word);
    }

    public boolean hasChildNodes() {
        if (this.childNodes == null) {
            return false;
        }
        return !this.childNodes.isEmpty();
    }

    public int getChildNodesCount() {
        if (this.childNodes == null) {
            return 0;
        }
        return this.childNodes.size();
    }

    public int getChildElementsCount() {
        return this.childElementNodesCount;
    }

    public int getChildElementsCount(String elementName) {
        Node lastChild = this.getLastChildElement(elementName);
        return lastChild.siblingNameIndex + 1;
    }

    public Node[] getChildNodes() {
        if (this.childNodes == null) {
            return new Node[0];
        }
        return this.childNodes.toArray(new Node[this.childNodes.size()]);
    }

    public Node[] getChildElements() {
        this.initChildElementNodes();
        return (Node[])this.childElementNodes.clone();
    }

    public Node getChild(int index) {
        if (this.childNodes == null) {
            return null;
        }
        if (index < 0 || index >= this.childNodes.size()) {
            return null;
        }
        return this.childNodes.get(index);
    }

    public Node getChildElement(int index) {
        this.initChildElementNodes();
        if (index < 0 || index >= this.childElementNodes.length) {
            return null;
        }
        return this.childElementNodes[index];
    }

    public Node getFirstChild() {
        if (this.childNodes == null) {
            return null;
        }
        if (this.childNodes.isEmpty()) {
            return null;
        }
        return this.childNodes.get(0);
    }

    public Node getFirstChildElement() {
        this.initChildElementNodes();
        if (this.childElementNodes.length == 0) {
            return null;
        }
        return this.childElementNodes[0];
    }

    public Node getFirstChildElement(String elementName) {
        if (this.childNodes == null) {
            return null;
        }
        int childNodesSize = this.childNodes.size();
        for (int i = 0; i < childNodesSize; ++i) {
            Node child = this.childNodes.get(i);
            if (!elementName.equals(child.getNodeName())) continue;
            child.initSiblingNames();
            return child;
        }
        return null;
    }

    public Node getLastChild() {
        if (this.childNodes == null) {
            return null;
        }
        if (this.childNodes.isEmpty()) {
            return null;
        }
        return this.childNodes.get(this.getChildNodesCount() - 1);
    }

    public Node getLastChildElement() {
        this.initChildElementNodes();
        if (this.childElementNodes.length == 0) {
            return null;
        }
        return this.childElementNodes[this.childElementNodes.length - 1];
    }

    public Node getLastChildElement(String elementName) {
        int from;
        if (this.childNodes == null) {
            return null;
        }
        for (int i = from = this.childNodes.size() - 1; i >= 0; --i) {
            Node child = this.childNodes.get(i);
            if (!elementName.equals(child.getNodeName())) continue;
            child.initSiblingNames();
            return child;
        }
        return null;
    }

    public boolean check() {
        if (this.childNodes == null) {
            return true;
        }
        int siblingElementIndex = 0;
        int childNodesSize = this.childNodes.size();
        for (int i = 0; i < childNodesSize; ++i) {
            Node childNode = this.childNodes.get(i);
            if (childNode.siblingIndex != i) {
                return false;
            }
            if (childNode.getNodeType() != NodeType.ELEMENT) continue;
            if (childNode.siblingElementIndex != siblingElementIndex) {
                return false;
            }
            ++siblingElementIndex;
        }
        if (this.childElementNodesCount != siblingElementIndex) {
            return false;
        }
        if (this.childElementNodes != null) {
            if (this.childElementNodes.length != this.childElementNodesCount) {
                return false;
            }
            int childCount = this.getChildNodesCount();
            for (int i = 0; i < childCount; ++i) {
                Node child = this.getChild(i);
                if (child.siblingElementIndex < 0 || this.childElementNodes[child.siblingElementIndex] == child) continue;
                return false;
            }
        }
        if (this.siblingNameIndex != -1) {
            List<Node> siblings = this.parentNode.childNodes;
            int index = 0;
            int siblingsSize = siblings.size();
            for (int i = 0; i < siblingsSize; ++i) {
                Node sibling = siblings.get(i);
                if (sibling.siblingNameIndex != -1 || this.nodeType != NodeType.ELEMENT || !this.nodeName.equals(sibling.getNodeName()) || sibling.siblingNameIndex == index++) continue;
                return false;
            }
        }
        for (Node childNode : this.childNodes) {
            if (childNode.check()) continue;
            return false;
        }
        return true;
    }

    protected void reindexChildren() {
        int siblingElementIndex = 0;
        int childNodesSize = this.childNodes.size();
        for (int i = 0; i < childNodesSize; ++i) {
            Node childNode = this.childNodes.get(i);
            childNode.siblingIndex = i;
            childNode.siblingNameIndex = -1;
            if (childNode.getNodeType() != NodeType.ELEMENT) continue;
            childNode.siblingElementIndex = siblingElementIndex++;
        }
        this.childElementNodesCount = siblingElementIndex;
        this.childElementNodes = null;
    }

    protected void reindexChildrenOnAdd(int addedCount) {
        int childNodesSize = this.childNodes.size();
        int previousSize = this.childNodes.size() - addedCount;
        int siblingElementIndex = this.childElementNodesCount;
        for (int i = previousSize; i < childNodesSize; ++i) {
            Node childNode = this.childNodes.get(i);
            childNode.siblingIndex = i;
            childNode.siblingNameIndex = -1;
            if (childNode.getNodeType() != NodeType.ELEMENT) continue;
            childNode.siblingElementIndex = siblingElementIndex++;
        }
        this.childElementNodesCount = siblingElementIndex;
        this.childElementNodes = null;
    }

    protected void initChildElementNodes() {
        if (this.childElementNodes == null) {
            this.childElementNodes = new Node[this.childElementNodesCount];
            int childCount = this.getChildNodesCount();
            for (int i = 0; i < childCount; ++i) {
                Node child = this.getChild(i);
                if (child.siblingElementIndex < 0) continue;
                this.childElementNodes[child.siblingElementIndex] = child;
            }
        }
    }

    protected void initSiblingNames() {
        if (this.siblingNameIndex == -1) {
            List<Node> siblings = this.parentNode.childNodes;
            int index = 0;
            int siblingsSize = siblings.size();
            for (int i = 0; i < siblingsSize; ++i) {
                Node sibling = siblings.get(i);
                if (sibling.siblingNameIndex != -1 || this.nodeType != NodeType.ELEMENT || !this.nodeName.equals(sibling.getNodeName())) continue;
                sibling.siblingNameIndex = index++;
            }
        }
    }

    protected void initAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>(5);
        }
    }

    protected void initChildNodes() {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList<Node>();
        }
    }

    public int getSiblingIndex() {
        return this.siblingIndex;
    }

    public int getSiblingElementIndex() {
        return this.siblingElementIndex;
    }

    public int getSiblingNameIndex() {
        this.initSiblingNames();
        return this.siblingNameIndex;
    }

    public Node getNextSibling() {
        int index = this.siblingIndex + 1;
        List<Node> siblings = this.parentNode.childNodes;
        if (index >= siblings.size()) {
            return null;
        }
        return siblings.get(index);
    }

    public Node getNextSiblingElement() {
        this.parentNode.initChildElementNodes();
        if (this.siblingElementIndex == -1) {
            int max = this.parentNode.getChildNodesCount();
            for (int i = this.siblingIndex; i < max; ++i) {
                Node sibling = this.parentNode.childNodes.get(i);
                if (sibling.getNodeType() != NodeType.ELEMENT) continue;
                return sibling;
            }
            return null;
        }
        int index = this.siblingElementIndex + 1;
        if (index >= this.parentNode.childElementNodesCount) {
            return null;
        }
        return this.parentNode.childElementNodes[index];
    }

    public Node getNextSiblingName() {
        if (this.nodeName == null) {
            return null;
        }
        this.initSiblingNames();
        int index = this.siblingNameIndex + 1;
        int max = this.parentNode.getChildNodesCount();
        for (int i = this.siblingIndex + 1; i < max; ++i) {
            Node sibling = this.parentNode.childNodes.get(i);
            if (index != sibling.siblingNameIndex || !this.nodeName.equals(sibling.getNodeName())) continue;
            return sibling;
        }
        return null;
    }

    public Node getPreviousSibling() {
        List<Node> siblings = this.parentNode.childNodes;
        int index = this.siblingIndex - 1;
        if (index < 0) {
            return null;
        }
        return siblings.get(index);
    }

    public Node getPreviousSiblingElement() {
        this.parentNode.initChildElementNodes();
        if (this.siblingElementIndex == -1) {
            for (int i = this.siblingIndex - 1; i >= 0; --i) {
                Node sibling = this.parentNode.childNodes.get(i);
                if (sibling.getNodeType() != NodeType.ELEMENT) continue;
                return sibling;
            }
            return null;
        }
        int index = this.siblingElementIndex - 1;
        if (index < 0) {
            return null;
        }
        return this.parentNode.childElementNodes[index];
    }

    public Node getPreviousSiblingName() {
        if (this.nodeName == null) {
            return null;
        }
        this.initSiblingNames();
        int index = this.siblingNameIndex - 1;
        for (int i = this.siblingIndex; i >= 0; --i) {
            Node sibling = this.parentNode.childNodes.get(i);
            if (index != sibling.siblingNameIndex || !this.nodeName.equals(sibling.getNodeName())) continue;
            return sibling;
        }
        return null;
    }

    public String getTextContent() {
        StringBuilder sb = new StringBuilder(this.getChildNodesCount() + 1);
        this.appendTextContent(sb);
        return sb.toString();
    }

    public void appendTextContent(Appendable appendable) {
        if (this.nodeValue != null && (this.nodeType == NodeType.TEXT || this.nodeType == NodeType.CDATA)) {
            try {
                appendable.append(this.nodeValue);
            }
            catch (IOException ioex) {
                throw new LagartoDOMException(ioex);
            }
        }
        if (this.childNodes != null) {
            int childNodesSize = this.childNodes.size();
            for (int i = 0; i < childNodesSize; ++i) {
                Node childNode = this.childNodes.get(i);
                childNode.appendTextContent(appendable);
            }
        }
    }

    public String getHtml() {
        StringBuilder sb = new StringBuilder();
        try {
            this.toHtml(sb);
        }
        catch (IOException ioex) {
            throw new LagartoDOMException(ioex);
        }
        return sb.toString();
    }

    public String getInnerHtml() {
        StringBuilder sb = new StringBuilder();
        try {
            this.toInnerHtml(sb);
        }
        catch (IOException ioex) {
            throw new LagartoDOMException(ioex);
        }
        return sb.toString();
    }

    public void toHtml(Appendable appendable) throws IOException {
        this.domBuilder.getRenderer().renderNodeValue(this, appendable);
        this.toInnerHtml(appendable);
    }

    protected void toInnerHtml(Appendable appendable) throws IOException {
        if (this.childNodes != null) {
            int childNodesSize = this.childNodes.size();
            for (int i = 0; i < childNodesSize; ++i) {
                Node childNode = this.childNodes.get(i);
                childNode.toHtml(appendable);
            }
        }
    }

    public int getDeepLevel() {
        return this.deepLevel;
    }

    public LagartoLexer.Position getPosition() {
        return this.position;
    }

    public String getCssPath() {
        StringBuilder path = new StringBuilder();
        for (Node node = this; node != null; node = node.getParentNode()) {
            String nodeName = node.getNodeName();
            if (nodeName == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(' ');
            sb.append(nodeName);
            String id = node.getAttribute("id");
            if (id != null) {
                sb.append('#').append(id);
            }
            path.insert(0, sb);
        }
        if (path.charAt(0) == ' ') {
            return path.substring(1);
        }
        return path.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeType {
        DOCUMENT,
        ELEMENT,
        TEXT,
        COMMENT,
        CDATA,
        DOCUMENT_TYPE,
        XML_DECLARATION;

    }
}

