/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import jodd.lagarto.dom.LagartoDOMBuilder;
import jodd.lagarto.dom.LagartoDOMException;
import jodd.lagarto.dom.Node;
import jodd.util.HtmlDecoder;
import jodd.util.HtmlEncoder;
import jodd.util.StringUtil;

public class Text
extends Node {
    protected Boolean blank;

    protected Text(LagartoDOMBuilder domBuilder, String text) {
        super(domBuilder, Node.NodeType.TEXT, null);
        this.nodeValue = text;
    }

    public Text clone() {
        return this.cloneTo(new Text(this.domBuilder, this.nodeValue));
    }

    public boolean isBlank() {
        if (this.blank == null) {
            this.blank = StringUtil.isBlank((String)this.nodeValue);
        }
        return this.blank;
    }

    public void setTextContent(String text) {
        this.nodeValue = HtmlEncoder.text((String)text);
    }

    public String getTextContent() {
        return HtmlDecoder.decode((String)this.nodeValue);
    }

    public void appendTextContent(Appendable appendable) {
        try {
            appendable.append(this.getTextContent());
        }
        catch (IOException ioex) {
            throw new LagartoDOMException(ioex);
        }
    }

    public void setTextStrict(String text) {
        this.nodeValue = HtmlEncoder.strict((String)text);
    }

    public void toHtml(Appendable appendable) throws IOException {
        this.getDomBuilder().getRenderer().renderText(this, appendable);
    }
}

