/*
 * Decompiled with CFR 0.152.
 */
package jodd.jerry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jodd.jerry.JerryFormHandler;
import jodd.jerry.JerryFunction;
import jodd.jerry.JerryNodeFunction;
import jodd.lagarto.dom.DOMBuilder;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.Element;
import jodd.lagarto.dom.LagartoDOMBuilder;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeSelector;
import jodd.lagarto.dom.Text;
import jodd.util.ArraysUtil;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jerry
implements Iterable<Jerry> {
    protected final Jerry parent;
    protected final Node[] nodes;
    protected final DOMBuilder builder;

    public static Jerry jerry(char[] content) {
        return Jerry.jerry().parse(content);
    }

    public static Jerry jerry(String content) {
        return Jerry.jerry().parse(content);
    }

    public static JerryParser jerry() {
        return new JerryParser();
    }

    public static JerryParser jerry(DOMBuilder domBuilder) {
        return new JerryParser(domBuilder);
    }

    protected Jerry(DOMBuilder builder, Node ... nodes) {
        this.parent = null;
        this.nodes = nodes;
        this.builder = builder;
    }

    protected Jerry(Jerry parent, Node ... nodes) {
        this.parent = parent;
        this.nodes = nodes;
        this.builder = parent.builder;
    }

    protected Jerry(Jerry parent, Node[] nodes1, Node[] nodes2) {
        this.parent = parent;
        this.nodes = (Node[])ArraysUtil.join((Object[][])new Node[][]{nodes1, nodes2});
        this.builder = parent.builder;
    }

    protected Jerry(Jerry parent, List<Node> nodeList) {
        this(parent, nodeList.toArray(new Node[nodeList.size()]));
    }

    public int length() {
        return this.nodes.length;
    }

    public int size() {
        return this.nodes.length;
    }

    public Node get(int index) {
        if (index < 0 || index >= this.nodes.length) {
            return null;
        }
        return this.nodes[index];
    }

    public Node[] get() {
        return this.nodes;
    }

    public int index(Node element) {
        int index = 0;
        for (Node node : this.nodes) {
            if (node == element) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Jerry children() {
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            Element[] children = node.getChildElements();
            Collections.addAll(result, children);
        }
        return new Jerry(this, result);
    }

    public Jerry parent() {
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            result.add(node.getParentNode());
        }
        return new Jerry(this, result);
    }

    public Jerry siblings() {
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            Element[] allElements;
            for (Element sibling : allElements = node.getParentNode().getChildElements()) {
                if (sibling == node) continue;
                result.add(sibling);
            }
        }
        return new Jerry(this, result);
    }

    public Jerry next() {
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            result.add(node.getNextSiblingElement());
        }
        return new Jerry(this, result);
    }

    public Jerry prev() {
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            result.add(node.getPreviousSiblingElement());
        }
        return new Jerry(this, result);
    }

    public Jerry find(String cssSelector) {
        NodeList result = new NodeList();
        for (Node node : this.nodes) {
            NodeSelector nodeSelector = this.createNodeSelector(node);
            List<Node> filteredNodes = nodeSelector.select(cssSelector);
            result.addAll(filteredNodes);
        }
        return new Jerry(this, result);
    }

    public Jerry $(String cssSelector) {
        return this.find(cssSelector);
    }

    public static Jerry $(String cssSelector, Jerry context) {
        return context.find(cssSelector);
    }

    protected NodeSelector createNodeSelector(Node node) {
        return new NodeSelector(node);
    }

    public Jerry each(JerryFunction function) {
        for (int i = 0; i < this.nodes.length; ++i) {
            Node node = this.nodes[i];
            Jerry $this = new Jerry(this, node);
            if (!function.onNode($this, i)) break;
        }
        return this;
    }

    public Jerry each(JerryNodeFunction function) {
        Node node;
        for (int i = 0; i < this.nodes.length && function.onNode(node = this.nodes[i], i); ++i) {
        }
        return this;
    }

    public Jerry add(String selector) {
        return new Jerry(this, this.nodes, this.root().find((String)selector).nodes);
    }

    public Jerry end() {
        return this.parent;
    }

    public Jerry not(String cssSelector) {
        Object[] notNodes = this.root().find((String)cssSelector).nodes;
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            if (ArraysUtil.contains((Object[])notNodes, (Object)node)) continue;
            result.add(node);
        }
        return new Jerry(this, result);
    }

    public Jerry root() {
        Jerry jerry = this.parent;
        if (jerry == null) {
            return this;
        }
        while (jerry.parent != null) {
            jerry = jerry.parent;
        }
        return jerry;
    }

    public Jerry first() {
        NodeList result = new NodeList(this.nodes.length);
        if (this.nodes.length > 0) {
            result.add(this.nodes[0]);
        }
        return new Jerry(this, result);
    }

    public Jerry last() {
        NodeList result = new NodeList(this.nodes.length);
        if (this.nodes.length > 0) {
            result.add(this.nodes[this.nodes.length - 1]);
        }
        return new Jerry(this, result);
    }

    public Jerry eq(int value) {
        NodeList result = new NodeList(1);
        int index = 0;
        int matchingIndex = value >= 0 ? value : this.nodes.length + value;
        for (Node node : this.nodes) {
            if (index == matchingIndex) {
                result.add(node);
                break;
            }
            ++index;
        }
        return new Jerry(this, result);
    }

    public Jerry gt(int value) {
        NodeList result = new NodeList(this.nodes.length);
        int index = 0;
        for (Node node : this.nodes) {
            if (index > value) {
                result.add(node);
            }
            ++index;
        }
        return new Jerry(this, result);
    }

    public Jerry lt(int value) {
        NodeList result = new NodeList(this.nodes.length);
        int index = 0;
        for (Node node : this.nodes) {
            if (index < value) {
                result.add(node);
            }
            ++index;
        }
        return new Jerry(this, result);
    }

    public boolean is(String cssSelectors) {
        for (Node node : this.nodes) {
            Node parentNode = node.getParentNode();
            if (parentNode == null) continue;
            NodeSelector nodeSelector = this.createNodeSelector(parentNode);
            List<Node> selectedNodes = nodeSelector.select(cssSelectors);
            for (Node selected : selectedNodes) {
                if (node != selected) continue;
                return true;
            }
        }
        return false;
    }

    public Jerry filter(String cssSelectors) {
        NodeList result = new NodeList(this.nodes.length);
        for (Node node : this.nodes) {
            Node parentNode = node.getParentNode();
            if (parentNode == null) continue;
            NodeSelector nodeSelector = this.createNodeSelector(parentNode);
            List<Node> selectedNodes = nodeSelector.select(cssSelectors);
            for (Node selected : selectedNodes) {
                if (node != selected) continue;
                result.add(node);
            }
        }
        return new Jerry(this, result);
    }

    public Jerry filter(JerryFunction jerryFunction) {
        NodeList result = new NodeList(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            Node node = this.nodes[i];
            Node parentNode = node.getParentNode();
            if (parentNode == null) continue;
            Jerry $this = new Jerry(this, node);
            boolean accept = jerryFunction.onNode($this, i);
            if (!accept) continue;
            result.add(node);
        }
        return new Jerry(this, result);
    }

    public String attr(String name) {
        if (this.nodes.length == 0) {
            return null;
        }
        return this.nodes[0].getAttribute(name);
    }

    public Jerry attr(String name, String value) {
        for (Node node : this.nodes) {
            node.setAttribute(name, value);
        }
        return this;
    }

    public Jerry removeAttr(String name) {
        for (Node node : this.nodes) {
            node.removeAttribute(name);
        }
        return this;
    }

    public String css(String propertyName) {
        if (this.nodes.length == 0) {
            return null;
        }
        propertyName = StringUtil.fromCamelCase((String)propertyName, (char)'-');
        String styleAttrValue = this.nodes[0].getAttribute("style");
        if (styleAttrValue == null) {
            return null;
        }
        Map<String, String> styles = this.createPropertiesMap(styleAttrValue, ';', ':');
        return styles.get(propertyName);
    }

    public Jerry css(String propertyName, String value) {
        propertyName = StringUtil.fromCamelCase((String)propertyName, (char)'-');
        for (Node node : this.nodes) {
            String styleAttrValue = node.getAttribute("style");
            Map<String, String> styles = this.createPropertiesMap(styleAttrValue, ';', ':');
            styles.put(propertyName, value);
            styleAttrValue = this.generateAttributeValue(styles, ';', ':');
            node.setAttribute("style", styleAttrValue);
        }
        return this;
    }

    public Jerry css(String ... css) {
        for (Node node : this.nodes) {
            String styleAttrValue = node.getAttribute("style");
            Map<String, String> styles = this.createPropertiesMap(styleAttrValue, ';', ':');
            for (int i = 0; i < css.length; i += 2) {
                String propertyName = css[i];
                propertyName = StringUtil.fromCamelCase((String)propertyName, (char)'-');
                styles.put(propertyName, css[i + 1]);
            }
            styleAttrValue = this.generateAttributeValue(styles, ';', ':');
            node.setAttribute("style", styleAttrValue);
        }
        return this;
    }

    public Jerry addClass(String ... classNames) {
        for (Node node : this.nodes) {
            String attrClass = node.getAttribute("class");
            Set<String> classes = this.createPropertiesSet(attrClass, ' ');
            boolean wasChange = false;
            for (String className : classNames) {
                if (!classes.add(className = StringUtil.fromCamelCase((String)className, (char)'-'))) continue;
                wasChange = true;
            }
            if (!wasChange) continue;
            String attrValue = this.generateAttributeValue(classes, ' ');
            node.setAttribute("class", attrValue);
        }
        return this;
    }

    public boolean hasClass(String ... classNames) {
        for (Node node : this.nodes) {
            String attrClass = node.getAttribute("class");
            Set<String> classes = this.createPropertiesSet(attrClass, ' ');
            for (String className : classNames) {
                if (!classes.contains(className = StringUtil.fromCamelCase((String)className, (char)'-'))) continue;
                return true;
            }
        }
        return false;
    }

    public Jerry removeClass(String ... classNames) {
        for (Node node : this.nodes) {
            String attrClass = node.getAttribute("class");
            Set<String> classes = this.createPropertiesSet(attrClass, ' ');
            boolean wasChange = false;
            for (String className : classNames) {
                if (!classes.remove(className = StringUtil.fromCamelCase((String)className, (char)'-'))) continue;
                wasChange = true;
            }
            if (!wasChange) continue;
            String attrValue = this.generateAttributeValue(classes, ' ');
            node.setAttribute("class", attrValue);
        }
        return this;
    }

    public Jerry toggleClass(String ... classNames) {
        for (Node node : this.nodes) {
            String attrClass = node.getAttribute("class");
            Set<String> classes = this.createPropertiesSet(attrClass, ' ');
            for (String className : classNames) {
                if (classes.contains(className = StringUtil.fromCamelCase((String)className, (char)'-'))) {
                    classes.remove(className);
                    continue;
                }
                classes.add(className);
            }
            String attrValue = this.generateAttributeValue(classes, ' ');
            node.setAttribute("class", attrValue);
        }
        return this;
    }

    public String text() {
        StringBuilder sb = new StringBuilder();
        for (Node node : this.nodes) {
            sb.append(node.getTextContent());
        }
        return sb.toString();
    }

    public Jerry text(String text) {
        for (Node node : this.nodes) {
            node.removeAllChilds();
            Text textNode = new Text(node.getOwnerDocument(), null);
            textNode.setTextContent(text);
            node.addChild((Node)textNode);
        }
        return this;
    }

    public String html() {
        if (this.nodes.length == 0) {
            return null;
        }
        return this.nodes[0].getInnerHtml();
    }

    public String htmlAll(boolean setIncluded) {
        StringBuilder sb = new StringBuilder();
        for (Node node : this.nodes) {
            sb.append(setIncluded ? node.getHtml() : node.getInnerHtml());
        }
        return sb.toString();
    }

    public Jerry html(String html) {
        Document doc = this.builder.parse(html);
        for (Node node : this.nodes) {
            node.removeAllChilds();
            Document workingDoc = doc.clone();
            node.addChild(workingDoc.getChildNodes());
        }
        return this;
    }

    public Jerry append(String html) {
        Document doc = this.builder.parse(html);
        for (Node node : this.nodes) {
            Document workingDoc = doc.clone();
            node.addChild((Node)workingDoc);
        }
        return this;
    }

    public Jerry before(String html) {
        Document doc = this.builder.parse(html);
        for (Node node : this.nodes) {
            Document workingDoc = doc.clone();
            node.insertBefore(workingDoc, node);
        }
        return this;
    }

    public Jerry remove() {
        for (Node node : this.nodes) {
            node.detachFromParent();
        }
        return this;
    }

    public Jerry detach() {
        for (Node node : this.nodes) {
            node.detachFromParent();
        }
        return this;
    }

    public Jerry empty() {
        for (Node node : this.nodes) {
            node.removeAllChilds();
        }
        return this;
    }

    public Jerry wrap(String html) {
        Document doc = this.builder.parse(html);
        for (Node node : this.nodes) {
            Document workingDoc = doc.clone();
            Node inmostNode = workingDoc;
            while (inmostNode.hasChildNodes()) {
                inmostNode = inmostNode.getFirstChild();
            }
            Node parent = node.getParentNode();
            int index = node.getSiblingIndex();
            inmostNode.addChild(node);
            parent.insertChild(workingDoc.getFirstChild(), index);
        }
        return this;
    }

    @Override
    public Iterator<Jerry> iterator() {
        final Jerry jerry = this;
        return new Iterator<Jerry>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < jerry.nodes.length;
            }

            @Override
            public Jerry next() {
                Jerry nextJerry = new Jerry(jerry, jerry.get(this.index));
                ++this.index;
                return nextJerry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Jerry form(String formCssSelector, JerryFormHandler jerryFormHandler) {
        Jerry form = this.find(formCssSelector);
        for (Node node : form.nodes) {
            Jerry singleForm = new Jerry(this, node);
            final HashMap<String, String[]> parameters = new HashMap<String, String[]>();
            singleForm.$("input").each(new JerryFunction(){

                public boolean onNode(Jerry $inputTag, int index) {
                    String[] value;
                    String type = $inputTag.attr("type");
                    boolean isCheckbox = type.equals("checkbox");
                    boolean isRadio = type.equals("radio");
                    if ((isRadio || isCheckbox) && !$inputTag.nodes[0].hasAttribute("checked")) {
                        return true;
                    }
                    String name = $inputTag.attr("name");
                    if (name == null) {
                        return true;
                    }
                    String tagValue = $inputTag.attr("value");
                    if (tagValue == null && isCheckbox) {
                        tagValue = "on";
                    }
                    value = (value = (String[])parameters.get(name)) == null ? new String[]{tagValue} : ArraysUtil.append((String[])value, (String)tagValue);
                    parameters.put(name, value);
                    return true;
                }
            });
            singleForm.$("select").each(new JerryFunction(){

                public boolean onNode(Jerry $selectTag, int index) {
                    final String name = $selectTag.attr("name");
                    $selectTag.$("option").each(new JerryFunction(){

                        public boolean onNode(Jerry $optionTag, int index) {
                            if ($optionTag.nodes[0].hasAttribute("selected")) {
                                String tagValue = $optionTag.attr("value");
                                String[] value = (String[])parameters.get(name);
                                value = value == null ? new String[]{tagValue} : ArraysUtil.append((String[])value, (String)tagValue);
                                parameters.put(name, value);
                            }
                            return true;
                        }
                    });
                    return true;
                }
            });
            singleForm.$("textarea").each(new JerryFunction(){

                public boolean onNode(Jerry $textarea, int index) {
                    String name = $textarea.attr("name");
                    String value = $textarea.text();
                    parameters.put(name, new String[]{value});
                    return true;
                }
            });
            jerryFormHandler.onForm(singleForm, parameters);
        }
        return this;
    }

    protected Set<String> createPropertiesSet(String attrValue, char propertiesDelimiter) {
        if (attrValue == null) {
            return new LinkedHashSet<String>();
        }
        String[] properties = StringUtil.splitc((String)attrValue, (char)propertiesDelimiter);
        LinkedHashSet<String> set = new LinkedHashSet<String>(properties.length);
        Collections.addAll(set, properties);
        return set;
    }

    protected String generateAttributeValue(Set<String> set, char propertiesDelimiter) {
        StringBuilder sb = new StringBuilder(set.size() * 16);
        boolean first = true;
        for (String entry : set) {
            if (!first) {
                sb.append(propertiesDelimiter);
            } else {
                first = false;
            }
            sb.append(entry);
        }
        return sb.toString();
    }

    protected Map<String, String> createPropertiesMap(String attrValue, char propertiesDelimiter, char valueDelimiter) {
        if (attrValue == null) {
            return new LinkedHashMap<String, String>();
        }
        String[] properties = StringUtil.splitc((String)attrValue, (char)propertiesDelimiter);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(properties.length);
        for (String property : properties) {
            int valueDelimiterIndex = property.indexOf(valueDelimiter);
            if (valueDelimiterIndex == -1) continue;
            String propertyName = property.substring(0, valueDelimiterIndex).trim();
            String propertyValue = property.substring(valueDelimiterIndex + 1).trim();
            map.put(propertyName, propertyValue);
        }
        return map;
    }

    protected String generateAttributeValue(Map<String, String> map, char propertiesDelimiter, char valueDelimiter) {
        StringBuilder sb = new StringBuilder(map.size() * 32);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey());
            sb.append(valueDelimiter);
            sb.append(entry.getValue());
            sb.append(propertiesDelimiter);
        }
        return sb.toString();
    }

    public static class JerryParser {
        protected final DOMBuilder domBuilder;

        public JerryParser() {
            this.domBuilder = new LagartoDOMBuilder();
        }

        public JerryParser(DOMBuilder domBuilder) {
            this.domBuilder = domBuilder;
        }

        public DOMBuilder getDOMBuilder() {
            return this.domBuilder;
        }

        public Jerry parse(char[] content) {
            Document doc = this.domBuilder.parse(content);
            return new Jerry(this.domBuilder, doc);
        }

        public Jerry parse(String content) {
            Document doc = this.domBuilder.parse(content);
            return new Jerry(this.domBuilder, doc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeList
    extends ArrayList<Node> {
        private NodeList(int initialCapacity) {
            super(initialCapacity);
        }

        private NodeList() {
        }

        @Override
        public boolean add(Node o) {
            for (Node node : this) {
                if (node != o) continue;
                return false;
            }
            return super.add(o);
        }
    }
}

