/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import jodd.lagarto.Lexer;

public final class LagartoLexer
extends Lexer {
    private final char[] input;
    private int lastOffset = -1;
    private int lastLine;
    private int lastLastNewLineOffset;

    public LagartoLexer(char[] input) {
        super(input);
        this.input = input;
    }

    public char[] getInput() {
        return this.input;
    }

    public Position currentPosition() {
        int lastNewLineOffset;
        int offset;
        int line;
        int position = this.position();
        if (position > this.lastOffset) {
            line = 1;
            offset = 0;
            lastNewLineOffset = 0;
        } else {
            line = this.lastLine;
            offset = this.lastOffset;
            lastNewLineOffset = this.lastLastNewLineOffset;
        }
        while (offset < position) {
            char c = this.input[offset];
            if (c == '\n') {
                ++line;
                lastNewLineOffset = offset + 1;
            }
            ++offset;
        }
        this.lastOffset = offset;
        this.lastLine = line;
        this.lastLastNewLineOffset = lastNewLineOffset;
        return new Position(position, line, position - lastNewLineOffset);
    }

    public static class Position {
        public int offset;
        public int line;
        public int column;

        public Position(int offset, int line, int column) {
            this.offset = offset;
            this.line = line;
            this.column = column;
        }

        public Position(int line, int column) {
            this.offset = -1;
            this.line = line;
            this.column = column;
        }

        public Position(int offset) {
            this.offset = offset;
            this.line = -1;
            this.column = -1;
        }

        public String toString() {
            if (this.offset == -1) {
                return "[" + this.line + ':' + this.column + ']';
            }
            if (this.line == -1) {
                return "[@" + this.offset + ']';
            }
            return "[" + this.line + ':' + this.column + " @" + this.offset + ']';
        }
    }
}

