/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jodd.util.BinarySearchBase;
import jodd.util.CharUtil;

class HtmlDecoder {
    private static final Map<String, char[]> ENTITY_MAP;
    private static final char[][] ENTITY_NAMES;

    HtmlDecoder() {
    }

    public static String detectName(CharSequence input, int ndx) {
        final Ptr ptr = new Ptr();
        int firstIndex = 0;
        int lastIndex = ENTITY_NAMES.length - 1;
        int len = input.length();
        char[] lastName = null;
        BinarySearchBase binarySearch = new BinarySearchBase(){

            protected int compare(int index) {
                char[] name = ENTITY_NAMES[index];
                if (ptr.offset >= name.length) {
                    return -1;
                }
                return name[ptr.offset] - ptr.c;
            }
        };
        do {
            ptr.c = input.charAt(ndx);
            if (!CharUtil.isAlphaOrDigit((char)ptr.c)) {
                return lastName != null ? new String(lastName) : null;
            }
            if ((firstIndex = binarySearch.findFirst(firstIndex, lastIndex)) < 0) {
                return lastName != null ? new String(lastName) : null;
            }
            char[] element = ENTITY_NAMES[firstIndex];
            if (element.length == ptr.offset + 1) {
                lastName = ENTITY_NAMES[firstIndex];
            }
            if (firstIndex == (lastIndex = binarySearch.findLast(firstIndex, lastIndex))) {
                for (int i = ptr.offset; i < element.length; ++i) {
                    if (ndx == input.length() || element[i] != input.charAt(ndx)) {
                        return lastName != null ? new String(lastName) : null;
                    }
                    ++ndx;
                }
                return new String(element);
            }
            ++ptr.offset;
        } while (++ndx != len);
        return lastName != null ? new String(lastName) : null;
    }

    static {
        Properties entityReferences = new Properties();
        try (InputStream is = HtmlDecoder.class.getResourceAsStream("/jodd/net/HtmlDecoder.properties");){
            entityReferences.load(is);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        ENTITY_MAP = new HashMap<String, char[]>(entityReferences.size());
        Enumeration<?> keys = entityReferences.propertyNames();
        while (keys.hasMoreElements()) {
            char[] chars;
            String name = (String)keys.nextElement();
            String values = entityReferences.getProperty(name);
            String[] array = values.split(",");
            String hex = array[0];
            char value = (char)Integer.parseInt(hex, 16);
            if (array.length == 2) {
                String hex2 = array[1];
                char value2 = (char)Integer.parseInt(hex2, 16);
                chars = new char[]{value, value2};
            } else {
                chars = new char[]{value};
            }
            ENTITY_MAP.put(name, chars);
        }
        ENTITY_NAMES = new char[ENTITY_MAP.size()][];
        int i = 0;
        for (String name : ENTITY_MAP.keySet()) {
            HtmlDecoder.ENTITY_NAMES[i++] = name.toCharArray();
        }
        Arrays.sort(ENTITY_NAMES, Comparator.comparing(String::new));
    }

    private static final class Ptr {
        public int offset;
        public char c;

        private Ptr() {
        }
    }
}

