/*
 * Decompiled with CFR 0.152.
 */
package jodd.csselly;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import jodd.csselly.CSSellyException;
import jodd.csselly.Combinator;
import jodd.csselly.CssSelector;

final class CSSellyLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 4096;
    public static final int YYINITIAL = 0;
    public static final int SELECTOR = 2;
    public static final int ATTR = 4;
    public static final int COMBINATOR = 6;
    public static final int PSEUDO_FN = 8;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4};
    private static final int[] ZZ_CMAP_TOP = CSSellyLexer.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000\u001f\u0100\u0001\u0200\u00b7\u0100\b\u0300\u1020\u0100";
    private static final int[] ZZ_CMAP_BLOCKS = CSSellyLexer.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "\t\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0012\u0000\u0001\u0001\u0001\u0000\u0001\u0006\u0001\u0007\u0001\b\u0002\u0000\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u0000\u0001\u000e\u0001\u000f\u0001\u0000\n\u0010\u0001\u0011\u0002\u0000\u0001\u0012\u0001\u0013\u0002\u0000\u001a\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\b\u0001\u0014\u0001\u0000\u0006\u0018\u0014\u0014\u0001\u0000\u0001\b\u0001\u0000\u0001\u0019\u0001\u0000\u0005\u0014\u0001\u001a\u01a2\u0014\u0002\u001a\u00d6\u0014\u0100\u001a";
    private static final int[] ZZ_ACTION = CSSellyLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0000\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0002\u0001\u0006\u0001\u0002\u0004\u0007\u0001\b\u0002\u0004\u0001\t\u0001\u0004\u0001\n\u0001\u000b\u0001\u0001\u0001\f\u0001\r\u0001\u000e\u0003\u0004\u0001\u000f\u0001\u0004\u0001\u0000\u0001\u0006\u0001\u0010\u0002\u0000\u0001\u0011\u0003\u0000\u0001\u0012\u0004\u0000\u0001\t\u0002\u0000\u0001\t\u0005\u0000\u0001\u000f\u0001\u0000\u0001\u000f\u0001\u0000\u0001\u000f\u0002\u0006\u0001\u0010\u0001\u0011\u0001\u0013\u0001\u0012\u0003\u0000\u0001\t\u0001\u0000\u0002\t\u0001\u000f\u0004\u0000\u0001\u000f\u0004\u0000\u0001\u000f\u0001\u0000\u0001\u0006\u0002\u0010\u0002\u0011\u0002\u0012\u0001\t\u0002\u0000\u0002\t\u0003\u0000\u0001\u000f\u0007\u0000\u0001\u0006\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0000\u0001\t\u0002\u0000\u0001\t\u0001\u0000\u0003\t\u0007\u0000\u0001\u0006\u0001\u0010\u0001\u0011\u0001\u0012\u0002\u0000\u0002\t\u0006\u0000\u0001\u0006\u0001\u0010\u0001\u0011\u0001\u0012\u0002\u0000\u0002\t\u0006\u0000\u0001\u0010\u0001\u0011\u0001\u0012\u0002\u0000\u0001\t\b\u0000\u0001\t\u0007\u0000";
    private static final int[] ZZ_ROWMAP = CSSellyLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u001b\u00006\u0000Q\u0000l\u0000\u0087\u0000\u00a2\u0000\u0087\u0000\u0087\u0000\u00bd\u0000\u00d8\u0000\u00f3\u0000\u0087\u0000\u010e\u0000\u0129\u0000\u0144\u0000\u0087\u0000\u015f\u0000\u017a\u0000\u0195\u0000\u01b0\u0000\u0087\u0000\u0087\u0000\u01cb\u0000\u01e6\u0000\u0201\u0000\u021c\u0000\u0237\u0000\u0252\u0000\u026d\u0000\u0087\u0000\u0288\u0000\u00f3\u0000\u02a3\u0000\u010e\u0000\u02be\u0000\u02d9\u0000\u02f4\u0000\u030f\u0000\u032a\u0000\u0345\u0000\u0360\u0000\u037b\u0000\u015f\u0000\u017a\u0000\u01b0\u0000\u0396\u0000\u03b1\u0000\u03cc\u0000\u03e7\u0000\u0237\u0000\u0252\u0000\u026d\u0000\u0288\u0000\u0402\u0000\u041d\u0000\u0438\u0000\u0453\u0000\u046e\u0000\u0237\u0000\u0489\u0000\u04a4\u0000\u04bf\u0000\u04da\u0000\u0087\u0000\u04f5\u0000\u0510\u0000\u052b\u0000\u0546\u0000\u0561\u0000\u057c\u0000\u0597\u0000\u05b2\u0000\u05cd\u0000\u05e8\u0000\u041d\u0000\u0603\u0000\u061e\u0000\u0252\u0000\u0639\u0000\u0453\u0000\u0654\u0000\u066f\u0000\u026d\u0000\u068a\u0000\u06a5\u0000\u06c0\u0000\u06db\u0000\u06f6\u0000\u0711\u0000\u072c\u0000\u0747\u0000\u0762\u0000\u077d\u0000\u0798\u0000\u07b3\u0000\u07ce\u0000\u05cd\u0000\u07e9\u0000\u0804\u0000\u0402\u0000\u081f\u0000\u083a\u0000\u0855\u0000\u0870\u0000\u088b\u0000\u08a6\u0000\u08c1\u0000\u08dc\u0000\u08f7\u0000\u0912\u0000\u092d\u0000\u0948\u0000\u0963\u0000\u097e\u0000\u0999\u0000\u09b4\u0000\u09cf\u0000\u09ea\u0000\u0a05\u0000\u0a20\u0000\u0a3b\u0000\u0a56\u0000\u0a71\u0000\u0a8c\u0000\u0aa7\u0000\u0ac2\u0000\u0add\u0000\u0af8\u0000\u0b13\u0000\u0b2e\u0000\u0b49\u0000\u0b64\u0000\u0b7f\u0000\u0b9a\u0000\u0bb5\u0000\u0bd0\u0000\u0beb\u0000\u0c06\u0000\u0c21\u0000\u0c3c\u0000\u0c57\u0000\u0c72\u0000\u0c8d\u0000\u0ca8\u0000\u0cc3\u0000\u0cde\u0000\u0cf9\u0000\u0d14\u0000\u0d2f\u0000\u0d4a\u0000\u0d65\u0000\u0d80\u0000\u0d9b\u0000\u0db6\u0000\u0dd1\u0000\u0dec\u0000\u0e07\u0000\u0e22\u0000\u0e3d\u0000\u0e58\u0000\u0e73\u0000\u0e8e\u0000\u0ea9\u0000\u0ec4\u0000\u0edf\u0000\u0efa\u0000\u0f15\u0000\u0f30\u0000\u0f4b\u0000\u0f66\u0000\u0f81\u0000\u0f9c\u0000\u0fb7\u0000\u0fd2\u0000\u0fed\u0000\u1008\u0000\u1023";
    private static final int[] ZZ_TRANS = CSSellyLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0006\u0002\u0007\u0001\b\u0002\u0007\u0006\u0006\u0001\t\u0001\u0006\u0001\n\u0005\u0006\u0001\u000b\u0001\u0006\u0001\f\u0001\u0006\u0001\u000b\u0001\u0006\u0001\u000b\u0002\r\u0004\b\u0001\r\u0001\u000e\u0007\r\u0001\u000f\u0001\r\u0001\u0010\u0003\r\u0001\u0011\u0004\r\u0002\b\u0002\u0012\u0001\b\u0002\u0012\b\b\u0001\u0013\u0005\b\u0001\u0014\u0001\b\u0001\u0015\u0001\u0016\u0001\u0014\u0001\b\u0001\u0014\u0001\u0017\u0002\u0018\u0001\b\u0002\u0018\u0007\u0017\u0001\u0019\u0005\u0017\u0001\u001a\u0005\u0017\u0001\u001b\u0001\b\u0006\u001c\u0001\u001d\u0002\u001c\u0001\u001e\u0001\u001c\u0001\u001f\n\u001c\u0001 \u0004\u001c\u001c\u0000\u0002\u0007\u0001\u0000\u0002\u0007)\u0000\u0001\u000b\u0001\u0000\u0001!\u0001\u0000\u0001\u000b\u0001\u0000\u0001\u000b\u000e\u0000\u0001\u000b\u0001\u0000\u0001\u000b\u0003\u0000\u0001\u000b\u0001\u0000\u0001!\u0001\u0000\u0001\u000b\u0001\u0000\u0003\u000b\u0001\u0000\u0001\u000b\u0002\u0000\n\u000b\u0001\"\u0007\u000b\u0001\"\u0002\u000b\u000e\u0000\u0001#\u0001\u0000\u0001#\u0003\u0000\u0001#\u0001\u0000\u0001$\u0001\u0000\u0001#\u0001\u0000\u0001#\u000e\u0000\u0001%\u0005\u0000\u0001&\u0001\u0000\u0001'\u0001\u0000\u0001&\u0001\u0000\u0001&\u000e\u0000\u0001(\u0002\u0000\u0001)\u0002\u0000\u0001*\u0001\u0000\u0001+\u0001\u0000\u0001*\u0001\u0000\u0001*\u0001\u0000\u0002,\u0001\u0000\u0002,\b\u0000\u0001-\u0005\u0000\u0001\u0014\u0001\u0000\u0001.\u0001\u0000\u0001\u0014\u0001\u0000\u0001\u0014\u0014\u0000\u0001\u0014\u0001\u0000\u0001.\u0001\u0000\u0001\u0014\u0001\u0000\u0001\u0014\u0001\u0000\u0002/\u0001\u0000\u0002/\u0002\u0000\u00010\u0003\u0000\u00010\u0001\u0000\u0001\u0014\u0001\u0000\u0001\u0014\u0001\u0000\u00011\u0001\u0000\u0001\u0014\u0001\u0000\u0001.\u0001\u0000\u0001\u0014\u00010\u0003\u0014\u0001\u0000\u0001\u0014\u0002\u0000\n\u0014\u00012\u0007\u0014\u00012\u0002\u0014\u0001\u0000\u0002\u0018\u0001\u0000\u0002\u0018\u0007\u0000\u0001\u0019\u0005\u0000\u0001\u001a\u0005\u0000\u0001\u001b\u0002\u0000\u0002\u0019\u0001\u0000\u0002\u0019\u0016\u0000\u0002\u001a\u0001\u0000\u0002\u001a\u0016\u0000\u0002\u001b\u0001\u0000\u0002\u001b\u0015\u0000\u00063\u00014\u00023\u00015\u00013\u0001\u001f\n3\u00016\u00043\u00024\u00013\u00014\u00023\u00034\u00017\u00014\u00018\n4\u00019\u00044\u00025\u00013\u00015\u00023\u00017\u00045\u0001:\n5\u0001;\u00045\u00063\u00014\u00023\u00015\u00013\u0001<\n3\u00016\u00043\u0001\u0000\u0002\u000b\u0001\u0000\u0001\u000b\u0001=\b\u0000\u0001\u000b\u0001\u0000\u0001>\u0003\u0000\u0001\u000b\u0001\u0000\u0001!\u0001\u0000\u0001>\u0001\u0000\u0001\u000b\u0002#\u0001\u0000\u0001#\u0002\u0000\n#\u0001?\u0007#\u0001?\u0002#\u0014\u0000\u0001&\u0001\u0000\u0001'\u0001\u0000\u0001&\u0001\u0000\u0001&\u000e\u0000\u0001&\u0001\u0000\u0001&\u0003\u0000\u0001&\u0001\u0000\u0001'\u0001\u0000\u0001&\u0001\u0000\u0003&\u0001\u0000\u0001&\u0002\u0000\n&\u0001@\u0007&\u0001@\u0002&\u0014\u0000\u0001*\u0001\u0000\u0001+\u0001\u0000\u0001*\u0001\u0000\u0001*\u000e\u0000\u0001(\u0005\u0000\u0001*\u0001\u0000\u0001+\u0001\u0000\u0001*\u0001\u0000\u0001*\n\u0000\u0001A\u0003\u0000\u0001*\u0001\u0000\u0001*\u0003\u0000\u0001*\u0001\u0000\u0001+\u0001\u0000\u0001*\u0001\u0000\u0003*\u0001\u0000\u0001*\u0002\u0000\n*\u0001B\u0007*\u0001B\u0002*\u0001\u0000\u0002/\u0001\u0000\u0002/\u0002\u0000\u00010\u0003\u0000\u00010\u0005\u0000\u00011\u0006\u0000\u00010\u0013\u0000\u00011\t\u0000\u00021\u0001\u0000\u00021\u0001C\u0002\u0000\u0001D\u0004\u0000\u0001E\u0005\u0000\u0001F\u0001\u0000\u0001G\u0001\u0000\u0001F\u0001\u0000\u0001F\u0001\u0000\u0002\u0014\u0001\u0000\u0001\u0014\u0001H\u0002\u0000\u00010\u0003\u0000\u00010\u0001\u0000\u0001\u0014\u0001\u0000\u0001I\u0001\u0000\u00011\u0001\u0000\u0001\u0014\u0001\u0000\u0001.\u0001\u0000\u0001I\u00010\u0001\u0014\u00027\u00013\u00017\u00023\u00057\u0001J\n7\u0001K\u00047\u0002L\u0001\u0000\u0001L\u0002\u0000\u00013\u000fL\u0001M\u0004L\u00054\u0001N\u00034\u00017\u00014\u0001O\u00044\u0001P\u00054\u00019\u00014\u0001P\u00024\u0002Q\u0001\u0000\u0001Q\u0002\u0000\u0003Q\u00013\fQ\u0001R\u0004Q\u00055\u0001S\u00017\u00045\u0001T\u00045\u0001U\u00055\u0001;\u00015\u0001U\u00025\u0002\u0000\u0001\u000b\u000b\u0000\u0001\u000b\u0001\u0000\u0001\u000b\u0003\u0000\u0001\u000b\u0001\u0000\u0001!\u0001\u0000\u0001\u000b\u0001\u0000\u0001\u000b\u0001\u0000\u0002\u000b\u0001\u0000\u0001\u000b\u0001=\b\u0000\u0001\u000b\u0001\u0000\u0001V\u0003\u0000\u0001\u000b\u0001\u0000\u0001!\u0001\u0000\u0001V\u0001\u0000\u0001\u000b\u0001\u0000\u0002#\u0001\u0000\u0001#\u0001W\b\u0000\u0001#\u0001\u0000\u0001X\u0003\u0000\u0001#\u0001\u0000\u0001$\u0001\u0000\u0001X\u0001\u0000\u0001#\u0001\u0000\u0002&\u0001\u0000\u0001&\u0001Y\b\u0000\u0001&\u0001\u0000\u0001Z\u0003\u0000\u0001&\u0001\u0000\u0001'\u0001\u0000\u0001Z\u0001\u0000\u0001&\u0001\u0000\u0002*\u0001\u0000\u0001*\u0001[\u0004\u0000\u0001A\u0003\u0000\u0001*\u0001\u0000\u0001\\\u0003\u0000\u0001*\u0001\u0000\u0001+\u0001\u0000\u0001\\\u0001\u0000\u0001*\u0002C\u0001\u0000\u0001C\u0002\u0000\u0001]\u000fC\u0001^\u0004C\u0002D\u0001\u0000\u0001D\u0002\u0000\u0003D\u0001]\fD\u0001_\u0004D\u0014\u0000\u0001F\u0001\u0000\u0001G\u0001\u0000\u0001F\u0001\u0000\u0001F\u0001\u0000\u0002]\u0001\u0000\u0002]\b\u0000\u0001F\u0001\u0000\u0001F\u0003\u0000\u0001F\u0001\u0000\u0001G\u0001\u0000\u0001F\u0001\u0000\u0003F\u0001\u0000\u0001F\u0002\u0000\nF\u0001`\u0007F\u0001`\u0002F\u0001\u0000\u0001/\u0001\u0014\u0001\u0000\u0002/\u0002\u0000\u00010\u0003\u0000\u00010\u0001\u0000\u0001\u0014\u0001\u0000\u0001\u0014\u0001\u0000\u00011\u0001\u0000\u0001\u0014\u0001\u0000\u0001.\u0001\u0000\u0001\u0014\u00010\u0001\u0014\u0001\u0000\u0002\u0014\u0001\u0000\u0001\u0014\u0001H\u0002\u0000\u00010\u0003\u0000\u00010\u0001\u0000\u0001\u0014\u0001\u0000\u0001a\u0001\u0000\u00011\u0001\u0000\u0001\u0014\u0001\u0000\u0001.\u0001\u0000\u0001a\u00010\u0001\u0014\u0002b\u0001\u0000\u0001b\u0002\u0000\u00015\u0002b\u00014\fb\u0001c\u0004b\u00057\u0001d\u00057\u0001e\u00047\u0001f\u00057\u0001K\u00017\u0001f\u00027\u0005L\u0001g\u00014\tL\u0001h\u0005L\u0001M\u0001L\u0001h\u0002L\u00044\u00023\u00034\u00017\u00014\u00018\n4\u00019\t4\u0001N\u00034\u00017\u00014\u00018\u00044\u0001i\u00054\u00019\u00014\u0001i\u00024\u0005Q\u0001j\u0003Q\u00015\u0006Q\u0001k\u0005Q\u0001R\u0001Q\u0001k\u0002Q\u00045\u00023\u00017\u00045\u0001:\n5\u0001;\t5\u0001S\u00017\u00045\u0001:\u00045\u0001l\u00055\u0001;\u00015\u0001l\u00025\u0001\u0000\u0002\u000b\u0001\u0000\u0001\u000b\u0001=\b\u0000\u0001\u000b\u0001\u0000\u0001m\u0003\u0000\u0001\u000b\u0001\u0000\u0001!\u0001\u0000\u0001m\u0001\u0000\u0001\u000b\u0002\u0000\u0001#\u000b\u0000\u0001#\u0001\u0000\u0001#\u0003\u0000\u0001#\u0001\u0000\u0001$\u0001\u0000\u0001#\u0001\u0000\u0001#\u0001\u0000\u0002#\u0001\u0000\u0001#\u0001W\b\u0000\u0001#\u0001\u0000\u0001n\u0003\u0000\u0001#\u0001\u0000\u0001$\u0001\u0000\u0001n\u0001\u0000\u0001#\u0002\u0000\u0001&\u000b\u0000\u0001&\u0001\u0000\u0001&\u0003\u0000\u0001&\u0001\u0000\u0001'\u0001\u0000\u0001&\u0001\u0000\u0001&\u0001\u0000\u0002&\u0001\u0000\u0001&\u0001Y\b\u0000\u0001&\u0001\u0000\u0001o\u0003\u0000\u0001&\u0001\u0000\u0001'\u0001\u0000\u0001o\u0001\u0000\u0001&\u0002\u0000\u0001*\u0007\u0000\u0001A\u0003\u0000\u0001*\u0001\u0000\u0001*\u0003\u0000\u0001*\u0001\u0000\u0001+\u0001\u0000\u0001*\u0001\u0000\u0001*\u0001\u0000\u0002*\u0001\u0000\u0001*\u0001[\u0004\u0000\u0001A\u0003\u0000\u0001*\u0001\u0000\u0001p\u0003\u0000\u0001*\u0001\u0000\u0001+\u0001\u0000\u0001p\u0001\u0000\u0001*\u0001\u0000\u0002]\u0001\u0000\u0002]\u0015\u0000\u0005C\u0001q\u0001r\tC\u0001s\u0005C\u0001^\u0001C\u0001s\u0002C\u0005D\u0001t\u0003D\u0001u\u0006D\u0001v\u0005D\u0001_\u0001D\u0001v\u0002D\u0001\u0000\u0002F\u0001\u0000\u0001F\u0001w\b\u0000\u0001F\u0001\u0000\u0001x\u0003\u0000\u0001F\u0001\u0000\u0001G\u0001\u0000\u0001x\u0001\u0000\u0001F\u0001\u0000\u0002\u0014\u0001\u0000\u0001\u0014\u0001H\u0002\u0000\u00010\u0003\u0000\u00010\u0001\u0000\u0001\u0014\u0001\u0000\u0001y\u0001\u0000\u00011\u0001\u0000\u0001\u0014\u0001\u0000\u0001.\u0001\u0000\u0001y\u00010\u0001\u0014\u0005b\u0001z\u00017\u0002b\u00017\u0006b\u0001{\u0005b\u0001c\u0001b\u0001{\u0002b\u00047\u00023\u00057\u0001J\n7\u0001K\t7\u0001d\u00057\u0001J\u00047\u0001|\u00057\u0001K\u00017\u0001|\u00027\u0004L\u0002\u0000\u00013\u000fL\u0001M\tL\u0001g\u00013\tL\u0001}\u0005L\u0001M\u0001L\u0001}\u0002L\u00054\u0001N\u00034\u00017\u00014\u00018\u00044\u0001~\u00054\u00019\u00014\u0001~\u00024\u0004Q\u0002\u0000\u0003Q\u00013\fQ\u0001R\tQ\u0001j\u0003Q\u00013\u0006Q\u0001\u007f\u0005Q\u0001R\u0001Q\u0001\u007f\u0002Q\u00055\u0001S\u00017\u00045\u0001:\u00045\u0001\u0080\u00055\u0001;\u00015\u0001\u0080\u00025\u0001\u0000\u0002\u000b\u0001\u0000\u0001\u000b\u0001=\b\u0000\u0001\u000b\u0001\u0000\u0001\u0081\u0003\u0000\u0001\u000b\u0001\u0000\u0001!\u0001\u0000\u0001\u0081\u0001\u0000\u0001\u000b\u0001\u0000\u0002#\u0001\u0000\u0001#\u0001W\b\u0000\u0001#\u0001\u0000\u0001\u0082\u0003\u0000\u0001#\u0001\u0000\u0001$\u0001\u0000\u0001\u0082\u0001\u0000\u0001#\u0001\u0000\u0002&\u0001\u0000\u0001&\u0001Y\b\u0000\u0001&\u0001\u0000\u0001\u0083\u0003\u0000\u0001&\u0001\u0000\u0001'\u0001\u0000\u0001\u0083\u0001\u0000\u0001&\u0001\u0000\u0002*\u0001\u0000\u0001*\u0001[\u0004\u0000\u0001A\u0003\u0000\u0001*\u0001\u0000\u0001\u0084\u0003\u0000\u0001*\u0001\u0000\u0001+\u0001\u0000\u0001\u0084\u0001\u0000\u0001*\u0004C\u0002\u0000\u0001]\u000fC\u0001^\u0005C\u0001r\u0001]\u0001C\u0003]\u000fC\u0001^\tC\u0001q\u0001]\tC\u0001\u0085\u0005C\u0001^\u0001C\u0001\u0085\u0002C\u0004D\u0002\u0000\u0003D\u0001]\fD\u0001_\u0005D\u0001u\u0001]\u0001D\u0002]\u0003D\u0001]\fD\u0001_\tD\u0001t\u0003D\u0001]\u0006D\u0001\u0086\u0005D\u0001_\u0001D\u0001\u0086\u0002D\u0001\u0000\u0001]\u0001F\u0001\u0000\u0002]\b\u0000\u0001F\u0001\u0000\u0001F\u0003\u0000\u0001F\u0001\u0000\u0001G\u0001\u0000\u0001F\u0001\u0000\u0001F\u0001\u0000\u0002F\u0001\u0000\u0001F\u0001w\b\u0000\u0001F\u0001\u0000\u0001\u0087\u0003\u0000\u0001F\u0001\u0000\u0001G\u0001\u0000\u0001\u0087\u0001\u0000\u0001F\u0001\u0000\u0002\u0014\u0001\u0000\u0001\u0014\u0001H\u0002\u0000\u00010\u0003\u0000\u00010\u0001\u0000\u0001\u0014\u0001\u0000\u0001\u0088\u0001\u0000\u00011\u0001\u0000\u0001\u0014\u0001\u0000\u0001.\u0001\u0000\u0001\u0088\u00010\u0001\u0014\u0004b\u0002\u0000\u00015\u0002b\u00014\fb\u0001c\tb\u0001z\u00015\u0002b\u00014\u0006b\u0001\u0089\u0005b\u0001c\u0001b\u0001\u0089\u0002b\u00057\u0001d\u00057\u0001J\u00047\u0001\u008a\u00057\u0001K\u00017\u0001\u008a\u00027\u0005L\u0001g\u00013\tL\u0001\u008b\u0005L\u0001M\u0001L\u0001\u008b\u0002L\u00054\u0001N\u00034\u00017\u00014\u00018\u00044\u0001\u008c\u00054\u00019\u00014\u0001\u008c\u00024\u0005Q\u0001j\u0003Q\u00013\u0006Q\u0001\u008d\u0005Q\u0001R\u0001Q\u0001\u008d\u0002Q\u00055\u0001S\u00017\u00045\u0001:\u00045\u0001\u008e\u00055\u0001;\u00015\u0001\u008e\u00025\u0001\u0000\u0002\u000b\u0001\u0000\u0001\u000b\u0001=\b\u0000\u0001\u000b\u0001\u0000\u0001\u008f\u0003\u0000\u0001\u000b\u0001\u0000\u0001!\u0001\u0000\u0001\u008f\u0001\u0000\u0001\u000b\u0001\u0000\u0002#\u0001\u0000\u0001#\u0001W\b\u0000\u0001#\u0001\u0000\u0001\u0090\u0003\u0000\u0001#\u0001\u0000\u0001$\u0001\u0000\u0001\u0090\u0001\u0000\u0001#\u0001\u0000\u0002&\u0001\u0000\u0001&\u0001Y\b\u0000\u0001&\u0001\u0000\u0001\u0091\u0003\u0000\u0001&\u0001\u0000\u0001'\u0001\u0000\u0001\u0091\u0001\u0000\u0001&\u0001\u0000\u0002*\u0001\u0000\u0001*\u0001[\u0004\u0000\u0001A\u0003\u0000\u0001*\u0001\u0000\u0001\u0092\u0003\u0000\u0001*\u0001\u0000\u0001+\u0001\u0000\u0001\u0092\u0001\u0000\u0001*\u0005C\u0001q\u0001]\tC\u0001\u0093\u0005C\u0001^\u0001C\u0001\u0093\u0002C\u0005D\u0001t\u0003D\u0001]\u0006D\u0001\u0094\u0005D\u0001_\u0001D\u0001\u0094\u0002D\u0001\u0000\u0002F\u0001\u0000\u0001F\u0001w\b\u0000\u0001F\u0001\u0000\u0001\u0095\u0003\u0000\u0001F\u0001\u0000\u0001G\u0001\u0000\u0001\u0095\u0001\u0000\u0001F\u0001\u0000\u0002\u0014\u0001\u0000\u0001\u0014\u0001H\u0002\u0000\u00010\u0003\u0000\u00010\u0001\u0000\u0001\u0014\u0001\u0000\u0001\u0096\u0001\u0000\u00011\u0001\u0000\u0001\u0014\u0001\u0000\u0001.\u0001\u0000\u0001\u0096\u00010\u0001\u0014\u0005b\u0001z\u00015\u0002b\u00014\u0006b\u0001\u0097\u0005b\u0001c\u0001b\u0001\u0097\u0002b\u00057\u0001d\u00057\u0001J\u00047\u0001\u0098\u00057\u0001K\u00017\u0001\u0098\u00027\u0005L\u0001g\u00013\tL\u0001\u0099\u0005L\u0001M\u0001L\u0001\u0099\u0002L\u00054\u0001N\u00034\u00017\u00014\u00018\u00044\u0001\u009a\u00054\u00019\u00014\u0001\u009a\u00024\u0005Q\u0001j\u0003Q\u00013\u0006Q\u0001\u009b\u0005Q\u0001R\u0001Q\u0001\u009b\u0002Q\u00055\u0001S\u00017\u00045\u0001:\u00045\u0001\u009c\u00055\u0001;\u00015\u0001\u009c\u00025\u0001\u0000\u0002\u000b\u0001\u0000\u0001\u000b\u0001=\b\u0000\u0001\u000b\u0001\u0000\u0001\u000b\u0003\u0000\u0001\u000b\u0001\u0000\u0001!\u0001\u0000\u0001\u000b\u0001\u0000\u0001\u000b\u0001\u0000\u0002#\u0001\u0000\u0001#\u0001W\b\u0000\u0001#\u0001\u0000\u0001\u009d\u0003\u0000\u0001#\u0001\u0000\u0001$\u0001\u0000\u0001\u009d\u0001\u0000\u0001#\u0001\u0000\u0002&\u0001\u0000\u0001&\u0001Y\b\u0000\u0001&\u0001\u0000\u0001\u009e\u0003\u0000\u0001&\u0001\u0000\u0001'\u0001\u0000\u0001\u009e\u0001\u0000\u0001&\u0001\u0000\u0002*\u0001\u0000\u0001*\u0001[\u0004\u0000\u0001A\u0003\u0000\u0001*\u0001\u0000\u0001\u009f\u0003\u0000\u0001*\u0001\u0000\u0001+\u0001\u0000\u0001\u009f\u0001\u0000\u0001*\u0005C\u0001q\u0001]\tC\u0001\u00a0\u0005C\u0001^\u0001C\u0001\u00a0\u0002C\u0005D\u0001t\u0003D\u0001]\u0006D\u0001\u00a1\u0005D\u0001_\u0001D\u0001\u00a1\u0002D\u0001\u0000\u0002F\u0001\u0000\u0001F\u0001w\b\u0000\u0001F\u0001\u0000\u0001\u00a2\u0003\u0000\u0001F\u0001\u0000\u0001G\u0001\u0000\u0001\u00a2\u0001\u0000\u0001F\u0001\u0000\u0002\u0014\u0001\u0000\u0001\u0014\u0001H\u0002\u0000\u00010\u0003\u0000\u00010\u0001\u0000\u0001\u0014\u0001\u0000\u0001\u0014\u0001\u0000\u00011\u0001\u0000\u0001\u0014\u0001\u0000\u0001.\u0001\u0000\u0001\u0014\u00010\u0001\u0014\u0005b\u0001z\u00015\u0002b\u00014\u0006b\u0001\u00a3\u0005b\u0001c\u0001b\u0001\u00a3\u0002b\u00057\u0001d\u00057\u0001J\u00047\u0001\u00a4\u00057\u0001K\u00017\u0001\u00a4\u00027\u0005L\u0001g\u00013\tL\u0001\u00a5\u0005L\u0001M\u0001L\u0001\u00a5\u0002L\u00054\u0001N\u00034\u00017\u00014\u00018\u00044\u0001\u00a6\u00054\u00019\u00014\u0001\u00a6\u00024\u0005Q\u0001j\u0003Q\u00013\u0006Q\u0001\u00a7\u0005Q\u0001R\u0001Q\u0001\u00a7\u0002Q\u00055\u0001S\u00017\u00045\u0001:\u00045\u0001\u00a8\u00055\u0001;\u00015\u0001\u00a8\u00025\u0001\u0000\u0002#\u0001\u0000\u0001#\u0001W\b\u0000\u0001#\u0001\u0000\u0001#\u0003\u0000\u0001#\u0001\u0000\u0001$\u0001\u0000\u0001#\u0001\u0000\u0001#\u0001\u0000\u0002&\u0001\u0000\u0001&\u0001Y\b\u0000\u0001&\u0001\u0000\u0001&\u0003\u0000\u0001&\u0001\u0000\u0001'\u0001\u0000\u0001&\u0001\u0000\u0001&\u0001\u0000\u0002*\u0001\u0000\u0001*\u0001[\u0004\u0000\u0001A\u0003\u0000\u0001*\u0001\u0000\u0001*\u0003\u0000\u0001*\u0001\u0000\u0001+\u0001\u0000\u0001*\u0001\u0000\u0001*\u0005C\u0001q\u0001]\tC\u0001\u00a9\u0005C\u0001^\u0001C\u0001\u00a9\u0002C\u0005D\u0001t\u0003D\u0001]\u0006D\u0001\u00aa\u0005D\u0001_\u0001D\u0001\u00aa\u0002D\u0001\u0000\u0002F\u0001\u0000\u0001F\u0001w\b\u0000\u0001F\u0001\u0000\u0001\u00ab\u0003\u0000\u0001F\u0001\u0000\u0001G\u0001\u0000\u0001\u00ab\u0001\u0000\u0001F\u0005b\u0001z\u00015\u0002b\u00014\u0006b\u0001\u00ac\u0005b\u0001c\u0001b\u0001\u00ac\u0002b\u00057\u0001d\u00057\u0001J\u00047\u0001\u00ad\u00057\u0001K\u00017\u0001\u00ad\u00027\u0005L\u0001g\u00013\tL\u0001\u00ae\u0005L\u0001M\u0001L\u0001\u00ae\u0002L\u00054\u0001N\u00034\u00017\u00014\u00018\n4\u00019\u00044\u0005Q\u0001j\u0003Q\u00013\u0006Q\u0001\u00af\u0005Q\u0001R\u0001Q\u0001\u00af\u0002Q\u00055\u0001S\u00017\u00045\u0001:\n5\u0001;\u00045\u0005C\u0001q\u0001]\tC\u0001\u00b0\u0005C\u0001^\u0001C\u0001\u00b0\u0002C\u0005D\u0001t\u0003D\u0001]\u0006D\u0001\u00b1\u0005D\u0001_\u0001D\u0001\u00b1\u0002D\u0001\u0000\u0002F\u0001\u0000\u0001F\u0001w\b\u0000\u0001F\u0001\u0000\u0001F\u0003\u0000\u0001F\u0001\u0000\u0001G\u0001\u0000\u0001F\u0001\u0000\u0001F\u0005b\u0001z\u00015\u0002b\u00014\u0006b\u0001\u00b2\u0005b\u0001c\u0001b\u0001\u00b2\u0002b\u00057\u0001d\u00057\u0001J\n7\u0001K\u00047\u0005L\u0001g\u00013\u000fL\u0001M\u0004L\u0005Q\u0001j\u0003Q\u00013\fQ\u0001R\u0004Q\u0005C\u0001q\u0001]\u000fC\u0001^\u0004C\u0005D\u0001t\u0003D\u0001]\fD\u0001_\u0004D\u0005b\u0001z\u00015\u0002b\u00014\fb\u0001c\u0004b";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = CSSellyLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0000\u0001\t\u0001\u0001\u0002\t\u0003\u0001\u0001\t\u0003\u0001\u0001\t\u0004\u0001\u0002\t\u0007\u0001\u0001\t\u0001\u0001\u0001\u0000\u0002\u0001\u0002\u0000\u0001\u0001\u0003\u0000\u0001\u0001\u0004\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0005\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0005\u0001\u0001\t\u0001\u0001\u0003\u0000\u0001\u0001\u0001\u0000\u0003\u0001\u0004\u0000\u0001\u0001\u0004\u0000\u0001\u0001\u0001\u0000\b\u0001\u0002\u0000\u0002\u0001\u0003\u0000\u0001\u0001\u0007\u0000\u0004\u0001\u0001\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0003\u0001\u0007\u0000\u0004\u0001\u0002\u0000\u0002\u0001\u0006\u0000\u0004\u0001\u0002\u0000\u0002\u0001\u0006\u0000\u0003\u0001\u0002\u0000\u0001\u0001\b\u0000\u0001\u0001\u0007\u0000";
    private Reader zzReader;
    private char[] zzChars;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer;
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int zzFinalHighSurrogate = 0;
    private int yyline;
    private int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;
    ArrayList<CssSelector> selectors = new ArrayList();
    CssSelector cssSelector;
    String pseudoFnName;

    private static int[] zzUnpackcmap_top() {
        int[] result = new int[4352];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_top(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] result = new int[1024];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_blocks(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[178];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[178];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[4158];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[178];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public long position() {
        return this.yychar;
    }

    public int length() {
        return this.yylength();
    }

    public int line() {
        return -1;
    }

    public int column() {
        return -1;
    }

    public void stateReset() {
        this.yybegin(0);
    }

    public void stateSelector() {
        this.yybegin(2);
    }

    public void stateAttr() {
        this.yybegin(4);
    }

    public void stateCombinator() {
        this.yybegin(6);
    }

    public void statePseudoFn() {
        this.yybegin(8);
    }

    public final CharSequence xxtext() {
        return CharBuffer.wrap(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final String yytext(int startIndex) {
        return new String(this.zzBuffer, startIndex += this.zzStartRead, this.zzMarkedPos - startIndex);
    }

    public final String yytext(int startIndex, int endIndexOffset) {
        return new String(this.zzBuffer, startIndex += this.zzStartRead, this.zzMarkedPos - endIndexOffset - startIndex);
    }

    CSSellyLexer(Reader in) {
        this.zzReader = in;
    }

    private static int zzCMap(int input) {
        int offset = input & 0xFF;
        return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
    }

    CSSellyLexer(char[] input) {
        this.zzChars = input;
    }

    private boolean zzRefill() {
        if (this.zzBuffer == null) {
            this.zzBuffer = this.zzChars;
            this.zzEndRead += this.zzChars.length;
            return false;
        }
        return true;
    }

    public final void yyclose() {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
    }

    private final void yyResetPosition() {
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzCurrentPos = 0;
        this.zzMarkedPos = 0;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzFinalHighSurrogate = 0;
        this.yyline = 0;
        this.yycolumn = 0;
        this.yychar = 0L;
    }

    public final boolean yyatEOF() {
        return this.zzAtEOF;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int position) {
        return this.zzBuffer[this.zzStartRead + position];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private static void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            CSSellyLexer.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() throws IOException {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.yyclose();
        }
    }

    public int yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block39: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += (long)(zzMarkedPosL - this.zzStartRead);
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + CSSellyLexer.zzCMap(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return 0;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    this.cssSelector.setCombinator(Combinator.DESCENDANT);
                    this.stateReset();
                }
                case 20: {
                    continue block39;
                }
                case 2: {
                    this.cssSelector = new CssSelector();
                    this.selectors.add(this.cssSelector);
                    this.yypushback(1);
                    this.stateSelector();
                }
                case 21: {
                    continue block39;
                }
                case 3: 
                case 22: {
                    continue block39;
                }
                case 4: {
                    throw new CSSellyException("Illegal character <" + this.yytext() + ">.", this.yystate(), this.line(), this.column());
                }
                case 23: {
                    continue block39;
                }
                case 5: {
                    this.cssSelector = new CssSelector();
                    this.selectors.add(this.cssSelector);
                    this.stateSelector();
                }
                case 24: {
                    continue block39;
                }
                case 6: {
                    this.cssSelector = new CssSelector(this.yytext());
                    this.selectors.add(this.cssSelector);
                    this.stateSelector();
                }
                case 25: {
                    continue block39;
                }
                case 7: {
                    this.yypushback(1);
                    this.stateCombinator();
                }
                case 26: {
                    continue block39;
                }
                case 8: {
                    this.stateAttr();
                }
                case 27: {
                    continue block39;
                }
                case 9: {
                    this.cssSelector.addAttributeSelector(this.yytext());
                }
                case 28: {
                    continue block39;
                }
                case 10: {
                    this.stateSelector();
                }
                case 29: {
                    continue block39;
                }
                case 11: {
                    throw new CSSellyException("Invalid combinator <" + this.yytext() + ">.", this.yystate(), this.line(), this.column());
                }
                case 30: {
                    continue block39;
                }
                case 12: {
                    this.cssSelector.setCombinator(Combinator.ADJACENT_SIBLING);
                    this.stateReset();
                }
                case 31: {
                    continue block39;
                }
                case 13: {
                    this.cssSelector.setCombinator(Combinator.CHILD);
                    this.stateReset();
                }
                case 32: {
                    continue block39;
                }
                case 14: {
                    this.cssSelector.setCombinator(Combinator.GENERAL_SIBLING);
                    this.stateReset();
                }
                case 33: {
                    continue block39;
                }
                case 15: {
                    this.cssSelector.addPseudoFunctionSelector(this.pseudoFnName, this.yytext(0, 1));
                    this.stateSelector();
                }
                case 34: {
                    continue block39;
                }
                case 16: {
                    this.cssSelector.addIdSelector(this.yytext(1));
                }
                case 35: {
                    continue block39;
                }
                case 17: {
                    this.cssSelector.addClassSelector(this.yytext(1));
                }
                case 36: {
                    continue block39;
                }
                case 18: {
                    this.cssSelector.addPseudoClassSelector(this.yytext(this.yycharat(1) == ':' ? 2 : 1));
                }
                case 37: {
                    continue block39;
                }
                case 19: {
                    this.pseudoFnName = this.yytext(this.yycharat(1) == ':' ? 2 : 1, 1);
                    this.statePseudoFn();
                }
                case 38: {
                    continue block39;
                }
            }
            CSSellyLexer.zzScanError(1);
        }
    }
}

