/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import jodd.lagarto.dom.Attribute;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.Element;
import jodd.lagarto.dom.LagartoDOMException;
import jodd.lagarto.dom.LagartoDomBuilderConfig;
import jodd.lagarto.dom.NodeVisitor;
import jodd.lagarto.dom.render.LagartoHtmlRenderer;

public abstract class Node
implements Cloneable {
    protected final String nodeName;
    protected final String nodeRawName;
    protected final NodeType nodeType;
    protected Document ownerDocument;
    protected String nodeValue;
    protected List<Attribute> attributes;
    protected Node parentNode;
    protected List<Node> childNodes;
    protected int childElementNodesCount;
    protected Element[] childElementNodes;
    protected int siblingIndex;
    protected int siblingElementIndex = -1;
    protected int siblingNameIndex = -1;

    protected Node(Document document, NodeType nodeType, String nodeName) {
        this.ownerDocument = document;
        this.nodeRawName = nodeName;
        this.nodeName = nodeName != null ? (this.ownerDocument.config.parserConfig.isCaseSensitive() ? nodeName : nodeName.toLowerCase()) : null;
        this.nodeType = nodeType;
    }

    protected <T extends Node> T cloneTo(T dest) {
        int i;
        dest.parentNode = this.parentNode;
        if (this.attributes != null) {
            dest.attributes = new ArrayList<Attribute>(this.attributes.size());
            int attributesSize = this.attributes.size();
            for (i = 0; i < attributesSize; ++i) {
                Attribute attr = this.attributes.get(i);
                dest.attributes.add(attr.clone());
            }
        }
        if (this.childNodes != null) {
            dest.childNodes = new ArrayList<Node>(this.childNodes.size());
            int childNodesSize = this.childNodes.size();
            for (i = 0; i < childNodesSize; ++i) {
                Node child = this.childNodes.get(i);
                Node childClone = child.clone();
                childClone.parentNode = dest;
                dest.childNodes.add(childClone);
            }
        }
        return dest;
    }

    public abstract Node clone();

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeRawName() {
        return this.nodeRawName;
    }

    public String getNodeValue() {
        return this.nodeValue;
    }

    public void setNodeValue(String value) {
        this.nodeValue = value;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public void detachFromParent() {
        if (this.parentNode == null) {
            return;
        }
        if (this.parentNode.childNodes != null) {
            this.parentNode.childNodes.remove(this.siblingIndex);
            this.parentNode.reindexChildren();
        }
        this.parentNode = null;
    }

    public void addChild(Node node) {
        node.detachFromParent();
        node.parentNode = this;
        this.initChildNodes(node);
        this.childNodes.add(node);
        this.reindexChildrenOnAdd(1);
    }

    public void addChild(Node ... nodes) {
        if (nodes.length == 0) {
            return;
        }
        for (Node node : nodes) {
            node.detachFromParent();
            node.parentNode = this;
            this.initChildNodes(node);
            this.childNodes.add(node);
        }
        this.reindexChildrenOnAdd(nodes.length);
    }

    public void insertChild(Node node, int index) {
        node.detachFromParent();
        node.parentNode = this;
        try {
            this.initChildNodes(node);
            this.childNodes.add(index, node);
        }
        catch (IndexOutOfBoundsException ignore) {
            throw new LagartoDOMException("Invalid node index: " + index);
        }
        this.reindexChildren();
    }

    public void insertChild(Node[] nodes, int index) {
        for (Node node : nodes) {
            node.detachFromParent();
            node.parentNode = this;
            try {
                this.initChildNodes(node);
                this.childNodes.add(index, node);
                ++index;
            }
            catch (IndexOutOfBoundsException ignore) {
                throw new LagartoDOMException("Invalid node index: " + index);
            }
        }
        this.reindexChildren();
    }

    public void insertBefore(Node newChild, Node refChild) {
        int siblingIndex = refChild.getSiblingIndex();
        refChild.parentNode.insertChild(newChild, siblingIndex);
    }

    public void insertBefore(Node[] newChilds, Node refChild) {
        if (newChilds.length == 0) {
            return;
        }
        int siblingIndex = refChild.getSiblingIndex();
        refChild.parentNode.insertChild(newChilds, siblingIndex);
    }

    public void insertAfter(Node newChild, Node refChild) {
        int siblingIndex = refChild.getSiblingIndex() + 1;
        if (siblingIndex == refChild.parentNode.getChildNodesCount()) {
            refChild.parentNode.addChild(newChild);
        } else {
            refChild.parentNode.insertChild(newChild, siblingIndex);
        }
    }

    public void insertAfter(Node[] newChilds, Node refChild) {
        if (newChilds.length == 0) {
            return;
        }
        int siblingIndex = refChild.getSiblingIndex() + 1;
        if (siblingIndex == refChild.parentNode.getChildNodesCount()) {
            refChild.parentNode.addChild(newChilds);
        } else {
            refChild.parentNode.insertChild(newChilds, siblingIndex);
        }
    }

    public Node removeChild(int index) {
        Node node;
        if (this.childNodes == null) {
            return null;
        }
        try {
            node = this.childNodes.get(index);
        }
        catch (IndexOutOfBoundsException ignore) {
            return null;
        }
        node.detachFromParent();
        return node;
    }

    public void removeChild(Node childNode) {
        if (childNode.getParentNode() != this) {
            return;
        }
        childNode.detachFromParent();
    }

    public void removeAllChilds() {
        List<Node> removedNodes = this.childNodes;
        this.childNodes = null;
        this.childElementNodes = null;
        this.childElementNodesCount = 0;
        if (removedNodes != null) {
            int removedNodesSize = removedNodes.size();
            for (int i = 0; i < removedNodesSize; ++i) {
                Node removedNode = removedNodes.get(i);
                removedNode.detachFromParent();
            }
        }
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public boolean hasAttributes() {
        if (this.attributes == null) {
            return false;
        }
        return !this.attributes.isEmpty();
    }

    public int getAttributesCount() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public Attribute getAttribute(int index) {
        if (this.attributes == null) {
            return null;
        }
        if (index < 0 || index >= this.attributes.size()) {
            return null;
        }
        return this.attributes.get(index);
    }

    public boolean hasAttribute(String name) {
        if (this.attributes == null) {
            return false;
        }
        if (!this.ownerDocument.config.parserConfig.isCaseSensitive()) {
            name = name.toLowerCase();
        }
        int attributesSize = this.attributes.size();
        for (int i = 0; i < attributesSize; ++i) {
            Attribute attr = this.attributes.get(i);
            if (!attr.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getAttribute(String name) {
        Attribute attribute = this.getAttributeInstance(name);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    protected Attribute getAttributeInstance(String name) {
        if (this.attributes == null) {
            return null;
        }
        if (!this.ownerDocument.config.parserConfig.isCaseSensitive()) {
            name = name.toLowerCase();
        }
        int attributesSize = this.attributes.size();
        for (int i = 0; i < attributesSize; ++i) {
            Attribute attr = this.attributes.get(i);
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    protected int indexOfAttributeInstance(String name) {
        if (this.attributes == null) {
            return -1;
        }
        if (!this.ownerDocument.config.parserConfig.isCaseSensitive()) {
            name = name.toLowerCase();
        }
        int attributesSize = this.attributes.size();
        for (int i = 0; i < attributesSize; ++i) {
            Attribute attr = this.attributes.get(i);
            if (!attr.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeAttribute(String name) {
        int index = this.indexOfAttributeInstance(name);
        if (index == -1) {
            return false;
        }
        this.attributes.remove(index);
        return true;
    }

    public void setAttribute(String name, String value) {
        this.initAttributes();
        String rawAttributeName = name;
        if (!this.ownerDocument.config.parserConfig.isCaseSensitive()) {
            name = name.toLowerCase();
        }
        int attributesSize = this.attributes.size();
        for (int i = 0; i < attributesSize; ++i) {
            Attribute attr = this.attributes.get(i);
            if (!attr.getName().equals(name)) continue;
            attr.setValue(value);
            return;
        }
        this.attributes.add(new Attribute(rawAttributeName, name, value));
    }

    public void setAttribute(String name) {
        this.setAttribute(name, null);
    }

    public boolean isAttributeContaining(String name, String word) {
        Attribute attr = this.getAttributeInstance(name);
        if (attr == null) {
            return false;
        }
        return attr.isContaining(word);
    }

    public boolean hasChildNodes() {
        if (this.childNodes == null) {
            return false;
        }
        return !this.childNodes.isEmpty();
    }

    public int getChildNodesCount() {
        if (this.childNodes == null) {
            return 0;
        }
        return this.childNodes.size();
    }

    public int getChildElementsCount() {
        return this.childElementNodesCount;
    }

    public int getChildElementsCount(String elementName) {
        Element lastChild = this.getLastChildElement(elementName);
        return lastChild.siblingNameIndex + 1;
    }

    public Node[] getChildNodes() {
        if (this.childNodes == null) {
            return new Node[0];
        }
        return this.childNodes.toArray(new Node[0]);
    }

    public Node findChildNodeWithName(String name) {
        if (this.childNodes == null) {
            return null;
        }
        for (Node childNode : this.childNodes) {
            if (!childNode.getNodeName().equals(name)) continue;
            return childNode;
        }
        return null;
    }

    public Node[] filterChildNodes(Predicate<Node> nodePredicate) {
        if (this.childNodes == null) {
            return new Node[0];
        }
        return (Node[])this.childNodes.stream().filter(nodePredicate).toArray(Node[]::new);
    }

    public Element[] getChildElements() {
        this.initChildElementNodes();
        return (Element[])this.childElementNodes.clone();
    }

    public Node getChild(int index) {
        if (this.childNodes == null) {
            return null;
        }
        if (index < 0 || index >= this.childNodes.size()) {
            return null;
        }
        return this.childNodes.get(index);
    }

    public Node getChild(int ... indexes) {
        Node node = this;
        for (int index : indexes) {
            node = node.getChild(index);
        }
        return node;
    }

    public Element getChildElement(int index) {
        this.initChildElementNodes();
        if (index < 0 || index >= this.childElementNodes.length) {
            return null;
        }
        return this.childElementNodes[index];
    }

    public Node getFirstChild() {
        if (this.childNodes == null) {
            return null;
        }
        if (this.childNodes.isEmpty()) {
            return null;
        }
        return this.childNodes.get(0);
    }

    public Element getFirstChildElement() {
        this.initChildElementNodes();
        if (this.childElementNodes.length == 0) {
            return null;
        }
        return this.childElementNodes[0];
    }

    public Element getFirstChildElement(String elementName) {
        if (this.childNodes == null) {
            return null;
        }
        int childNodesSize = this.childNodes.size();
        for (int i = 0; i < childNodesSize; ++i) {
            Node child = this.childNodes.get(i);
            if (child.getNodeType() != NodeType.ELEMENT || !elementName.equals(child.getNodeName())) continue;
            child.initSiblingNames();
            return (Element)child;
        }
        return null;
    }

    public Node getLastChild() {
        if (this.childNodes == null) {
            return null;
        }
        if (this.childNodes.isEmpty()) {
            return null;
        }
        return this.childNodes.get(this.getChildNodesCount() - 1);
    }

    public Element getLastChildElement() {
        this.initChildElementNodes();
        if (this.childElementNodes.length == 0) {
            return null;
        }
        return this.childElementNodes[this.childElementNodes.length - 1];
    }

    public Element getLastChildElement(String elementName) {
        int from;
        if (this.childNodes == null) {
            return null;
        }
        for (int i = from = this.childNodes.size() - 1; i >= 0; --i) {
            Node child = this.childNodes.get(i);
            if (child.getNodeType() != NodeType.ELEMENT || !elementName.equals(child.getNodeName())) continue;
            child.initSiblingNames();
            return (Element)child;
        }
        return null;
    }

    public boolean check() {
        if (this.childNodes == null) {
            return true;
        }
        int siblingElementIndex = 0;
        int childNodesSize = this.childNodes.size();
        for (int i = 0; i < childNodesSize; ++i) {
            Node childNode = this.childNodes.get(i);
            if (childNode.siblingIndex != i) {
                return false;
            }
            if (childNode.getNodeType() != NodeType.ELEMENT) continue;
            if (childNode.siblingElementIndex != siblingElementIndex) {
                return false;
            }
            ++siblingElementIndex;
        }
        if (this.childElementNodesCount != siblingElementIndex) {
            return false;
        }
        if (this.childElementNodes != null) {
            if (this.childElementNodes.length != this.childElementNodesCount) {
                return false;
            }
            int childCount = this.getChildNodesCount();
            for (int i = 0; i < childCount; ++i) {
                Node child = this.getChild(i);
                if (child.siblingElementIndex < 0 || this.childElementNodes[child.siblingElementIndex] == child) continue;
                return false;
            }
        }
        if (this.siblingNameIndex != -1) {
            List<Node> siblings = this.parentNode.childNodes;
            int index = 0;
            int siblingsSize = siblings.size();
            for (int i = 0; i < siblingsSize; ++i) {
                Node sibling = siblings.get(i);
                if (sibling.siblingNameIndex != -1 || this.nodeType != NodeType.ELEMENT || !this.nodeName.equals(sibling.getNodeName()) || sibling.siblingNameIndex == index++) continue;
                return false;
            }
        }
        for (Node childNode : this.childNodes) {
            if (childNode.check()) continue;
            return false;
        }
        return true;
    }

    protected void reindexChildren() {
        int siblingElementIndex = 0;
        int childNodesSize = this.childNodes.size();
        for (int i = 0; i < childNodesSize; ++i) {
            Node childNode = this.childNodes.get(i);
            childNode.siblingIndex = i;
            childNode.siblingNameIndex = -1;
            if (childNode.getNodeType() != NodeType.ELEMENT) continue;
            childNode.siblingElementIndex = siblingElementIndex++;
        }
        this.childElementNodesCount = siblingElementIndex;
        this.childElementNodes = null;
    }

    protected void reindexChildrenOnAdd(int addedCount) {
        int childNodesSize = this.childNodes.size();
        int previousSize = this.childNodes.size() - addedCount;
        int siblingElementIndex = this.childElementNodesCount;
        for (int i = previousSize; i < childNodesSize; ++i) {
            Node childNode = this.childNodes.get(i);
            childNode.siblingIndex = i;
            childNode.siblingNameIndex = -1;
            if (childNode.getNodeType() != NodeType.ELEMENT) continue;
            childNode.siblingElementIndex = siblingElementIndex++;
        }
        this.childElementNodesCount = siblingElementIndex;
        this.childElementNodes = null;
    }

    protected void initChildElementNodes() {
        if (this.childElementNodes == null) {
            this.childElementNodes = new Element[this.childElementNodesCount];
            int childCount = this.getChildNodesCount();
            for (int i = 0; i < childCount; ++i) {
                Node child = this.getChild(i);
                if (child.siblingElementIndex < 0) continue;
                this.childElementNodes[child.siblingElementIndex] = (Element)child;
            }
        }
    }

    protected void initSiblingNames() {
        if (this.siblingNameIndex == -1) {
            List<Node> siblings = this.parentNode.childNodes;
            int index = 0;
            int siblingsSize = siblings.size();
            for (int i = 0; i < siblingsSize; ++i) {
                Node sibling = siblings.get(i);
                if (sibling.siblingNameIndex != -1 || this.nodeType != NodeType.ELEMENT || !this.nodeName.equals(sibling.getNodeName())) continue;
                sibling.siblingNameIndex = index++;
            }
        }
    }

    protected void initAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>(5);
        }
    }

    protected void initChildNodes(Node newNode) {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList<Node>();
        }
        if (this.ownerDocument != null && newNode.ownerDocument != this.ownerDocument) {
            this.changeOwnerDocument(newNode, this.ownerDocument);
        }
    }

    protected void changeOwnerDocument(Node node, Document ownerDocument) {
        node.ownerDocument = ownerDocument;
        int childCount = node.getChildNodesCount();
        for (int i = 0; i < childCount; ++i) {
            Node child = node.getChild(i);
            this.changeOwnerDocument(child, ownerDocument);
        }
    }

    public int getSiblingIndex() {
        return this.siblingIndex;
    }

    public int getSiblingElementIndex() {
        return this.siblingElementIndex;
    }

    public int getSiblingNameIndex() {
        this.initSiblingNames();
        return this.siblingNameIndex;
    }

    public Node getNextSibling() {
        int index = this.siblingIndex + 1;
        List<Node> siblings = this.parentNode.childNodes;
        if (index >= siblings.size()) {
            return null;
        }
        return siblings.get(index);
    }

    public Node getNextSiblingElement() {
        this.parentNode.initChildElementNodes();
        if (this.siblingElementIndex == -1) {
            int max = this.parentNode.getChildNodesCount();
            for (int i = this.siblingIndex; i < max; ++i) {
                Node sibling = this.parentNode.childNodes.get(i);
                if (sibling.getNodeType() != NodeType.ELEMENT) continue;
                return sibling;
            }
            return null;
        }
        int index = this.siblingElementIndex + 1;
        if (index >= this.parentNode.childElementNodesCount) {
            return null;
        }
        return this.parentNode.childElementNodes[index];
    }

    public Node getNextSiblingName() {
        if (this.nodeName == null) {
            return null;
        }
        this.initSiblingNames();
        int index = this.siblingNameIndex + 1;
        int max = this.parentNode.getChildNodesCount();
        for (int i = this.siblingIndex + 1; i < max; ++i) {
            Node sibling = this.parentNode.childNodes.get(i);
            if (index != sibling.siblingNameIndex || !this.nodeName.equals(sibling.getNodeName())) continue;
            return sibling;
        }
        return null;
    }

    public Node getPreviousSibling() {
        List<Node> siblings = this.parentNode.childNodes;
        int index = this.siblingIndex - 1;
        if (index < 0) {
            return null;
        }
        return siblings.get(index);
    }

    public Node getPreviousSiblingElement() {
        this.parentNode.initChildElementNodes();
        if (this.siblingElementIndex == -1) {
            for (int i = this.siblingIndex - 1; i >= 0; --i) {
                Node sibling = this.parentNode.childNodes.get(i);
                if (sibling.getNodeType() != NodeType.ELEMENT) continue;
                return sibling;
            }
            return null;
        }
        int index = this.siblingElementIndex - 1;
        if (index < 0) {
            return null;
        }
        return this.parentNode.childElementNodes[index];
    }

    public Node getPreviousSiblingName() {
        if (this.nodeName == null) {
            return null;
        }
        this.initSiblingNames();
        int index = this.siblingNameIndex - 1;
        for (int i = this.siblingIndex; i >= 0; --i) {
            Node sibling = this.parentNode.childNodes.get(i);
            if (index != sibling.siblingNameIndex || !this.nodeName.equals(sibling.getNodeName())) continue;
            return sibling;
        }
        return null;
    }

    public String getTextContent() {
        StringBuilder sb = new StringBuilder(this.getChildNodesCount() + 1);
        this.appendTextContent(sb);
        return sb.toString();
    }

    public void appendTextContent(Appendable appendable) {
        if (this.nodeValue != null && (this.nodeType == NodeType.TEXT || this.nodeType == NodeType.CDATA)) {
            try {
                appendable.append(this.nodeValue);
            }
            catch (IOException ioex) {
                throw new LagartoDOMException(ioex);
            }
        }
        if (this.childNodes != null) {
            int childNodesSize = this.childNodes.size();
            for (int i = 0; i < childNodesSize; ++i) {
                Node childNode = this.childNodes.get(i);
                childNode.appendTextContent(appendable);
            }
        }
    }

    public String getHtml() {
        LagartoDomBuilderConfig lagartoDomBuilderConfig = this.ownerDocument == null ? ((Document)this).getConfig() : this.ownerDocument.getConfig();
        LagartoHtmlRenderer lagartoHtmlRenderer = lagartoDomBuilderConfig.getHtmlRenderer();
        return lagartoHtmlRenderer.toHtml(this, new StringBuilder());
    }

    public String getInnerHtml() {
        LagartoDomBuilderConfig lagartoDomBuilderConfig = this.ownerDocument == null ? ((Document)this).getConfig() : this.ownerDocument.getConfig();
        LagartoHtmlRenderer lagartoHtmlRenderer = lagartoDomBuilderConfig.getHtmlRenderer();
        return lagartoHtmlRenderer.toInnerHtml(this, new StringBuilder());
    }

    public void visit(NodeVisitor nodeVisitor) {
        this.visitNode(nodeVisitor);
    }

    public void visitChildren(NodeVisitor nodeVisitor) {
        if (this.childNodes != null) {
            int childNodesSize = this.childNodes.size();
            for (int i = 0; i < childNodesSize; ++i) {
                Node childNode = this.childNodes.get(i);
                childNode.visit(nodeVisitor);
            }
        }
    }

    protected abstract void visitNode(NodeVisitor var1);

    public String getCssPath() {
        StringBuilder path = new StringBuilder();
        for (Node node = this; node != null; node = node.getParentNode()) {
            String nodeName = node.getNodeName();
            if (nodeName == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(' ').append(nodeName);
            String id = node.getAttribute("id");
            if (id != null) {
                sb.append('#').append(id);
            }
            path.insert(0, sb);
        }
        if (path.charAt(0) == ' ') {
            return path.substring(1);
        }
        return path.toString();
    }

    public static enum NodeType {
        DOCUMENT,
        ELEMENT,
        TEXT,
        COMMENT,
        CDATA,
        DOCUMENT_TYPE,
        XML_DECLARATION;

    }
}

