/*
 * Decompiled with CFR 0.152.
 */
package jodd.log.impl;

import jodd.log.Logger;

public class Slf4jLogger
implements Logger {
    private final org.slf4j.Logger logger;

    public Slf4jLogger(org.slf4j.Logger logger) {
        this.logger = logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isEnabled(Logger.Level level) {
        switch (level) {
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case WARN: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        throw new IllegalArgumentException();
    }

    public void log(Logger.Level level, String message) {
        switch (level) {
            case TRACE: {
                this.logger.trace(message);
                return;
            }
            case DEBUG: {
                this.logger.debug(message);
                return;
            }
            case INFO: {
                this.logger.info(message);
                return;
            }
            case WARN: {
                this.logger.warn(message);
                return;
            }
            case ERROR: {
                this.logger.error(message);
                return;
            }
        }
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String message) {
        this.logger.trace(message);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String message) {
        this.logger.debug(message);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String message) {
        this.logger.warn(message);
    }

    public void warn(String message, Throwable throwable) {
        this.logger.warn(message, throwable);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public void error(String message, Throwable throwable) {
        this.logger.error(message, throwable);
    }
}

