/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.mail.EmailAddress;
import jodd.mail.EmailMessage;
import jodd.util.ArraysUtil;

public abstract class CommonEmail {
    public static final String X_PRIORITY = "X-Priority";
    public static final int PRIORITY_HIGHEST = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_NORMAL = 3;
    public static final int PRIORITY_LOW = 4;
    public static final int PRIORITY_LOWEST = 5;
    protected EmailAddress from;
    protected EmailAddress[] to = EmailAddress.EMPTY_ARRAY;
    protected EmailAddress[] replyTo = EmailAddress.EMPTY_ARRAY;
    protected EmailAddress[] cc = EmailAddress.EMPTY_ARRAY;
    protected EmailAddress[] bcc = EmailAddress.EMPTY_ARRAY;
    protected String subject;
    protected String subjectEncoding;
    protected List<EmailMessage> messages = new ArrayList<EmailMessage>();
    protected Map<String, String> headers;
    protected Date sentDate;

    public void setFrom(EmailAddress from) {
        this.from = from;
    }

    public EmailAddress getFrom() {
        return this.from;
    }

    public void setTo(EmailAddress ... tos) {
        if (tos == null) {
            tos = EmailAddress.EMPTY_ARRAY;
        }
        this.to = tos;
    }

    public void addTo(EmailAddress to) {
        this.to = (EmailAddress[])ArraysUtil.append((Object[])this.to, (Object)to);
    }

    public EmailAddress[] getTo() {
        return this.to;
    }

    public void setReplyTo(EmailAddress ... replyTo) {
        if (replyTo == null) {
            replyTo = EmailAddress.EMPTY_ARRAY;
        }
        this.replyTo = replyTo;
    }

    public void addReplyTo(EmailAddress to) {
        this.replyTo = (EmailAddress[])ArraysUtil.append((Object[])this.replyTo, (Object)to);
    }

    public EmailAddress[] getReplyTo() {
        return this.replyTo;
    }

    public void setCc(EmailAddress ... ccs) {
        if (ccs == null) {
            ccs = EmailAddress.EMPTY_ARRAY;
        }
        this.cc = ccs;
    }

    public void addCc(EmailAddress to) {
        this.cc = (EmailAddress[])ArraysUtil.append((Object[])this.cc, (Object)to);
    }

    public EmailAddress[] getCc() {
        return this.cc;
    }

    public void setBcc(EmailAddress ... bccs) {
        if (bccs == null) {
            bccs = EmailAddress.EMPTY_ARRAY;
        }
        this.bcc = bccs;
    }

    public void addBcc(EmailAddress to) {
        this.bcc = (EmailAddress[])ArraysUtil.append((Object[])this.bcc, (Object)to);
    }

    public EmailAddress[] getBcc() {
        return this.bcc;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setSubject(String subject, String encoding) {
        this.subject = subject;
        this.subjectEncoding = encoding;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSubjectEncoding() {
        return this.subjectEncoding;
    }

    public List<EmailMessage> getAllMessages() {
        return this.messages;
    }

    public void addMessage(EmailMessage emailMessage) {
        this.messages.add(emailMessage);
    }

    public void addMessage(String text, String mimeType, String encoding) {
        this.messages.add(new EmailMessage(text, mimeType, encoding));
    }

    public void addMessage(String text, String mimeType) {
        this.messages.add(new EmailMessage(text, mimeType));
    }

    protected Map<String, String> getAllHeaders() {
        return this.headers;
    }

    public void setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    public void setPriority(int priority) {
        this.setHeader(X_PRIORITY, String.valueOf(priority));
    }

    public int getPriority() {
        if (this.headers == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.headers.get(X_PRIORITY));
        }
        catch (NumberFormatException ignore) {
            return -1;
        }
    }

    public void setSentDate(Date date) {
        this.sentDate = date;
    }

    public Date getSentDate() {
        return this.sentDate;
    }
}

