/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import jodd.io.StreamUtil;
import jodd.mail.MailException;
import jodd.mail.ReceivedEmail;

public class EMLParser {
    protected Session session;
    protected Properties properties;

    public static EMLParser create() {
        return new EMLParser();
    }

    public EMLParser session(Session session) {
        this.session = session;
        return this;
    }

    public EMLParser defaultSession() {
        this.session = Session.getDefaultInstance((Properties)System.getProperties());
        return this;
    }

    public EMLParser set(Properties properties) {
        this.initProperties();
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public EMLParser set(String name, String value) {
        this.initProperties();
        this.properties.setProperty(name, value);
        return this;
    }

    public ReceivedEmail parse(String emlContent, String charset) throws UnsupportedEncodingException, MessagingException {
        byte[] bytes = emlContent.getBytes(charset);
        return this.parse(bytes);
    }

    public ReceivedEmail parse(String emlContent) throws MessagingException {
        try {
            return this.parse(emlContent, "UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }

    public ReceivedEmail parse(byte[] content) throws MessagingException {
        return this.parse(new ByteArrayInputStream(content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceivedEmail parse(File emlFile) throws FileNotFoundException, MessagingException {
        FileInputStream fileInputStream = new FileInputStream(emlFile);
        try {
            ReceivedEmail receivedEmail = this.parse(fileInputStream);
            return receivedEmail;
        }
        finally {
            StreamUtil.close((Closeable)fileInputStream);
        }
    }

    protected ReceivedEmail parse(InputStream emlContentInputStream) throws MessagingException {
        MimeMessage message;
        if (this.session == null) {
            this.session = this.createSession(this.properties);
        }
        try {
            message = new MimeMessage(this.session, emlContentInputStream);
        }
        finally {
            StreamUtil.close((Closeable)emlContentInputStream);
        }
        return new ReceivedEmail((Message)message);
    }

    protected void initProperties() {
        if (this.session != null) {
            throw new MailException("Can't set properties after session is assigned");
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
    }

    protected Session createSession(Properties properties) {
        if (properties == null) {
            properties = System.getProperties();
        }
        return Session.getInstance((Properties)properties);
    }
}

