/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.File;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import jodd.mail.EmailUtil;
import jodd.mail.MailServer;
import jodd.mail.ReceiveMailSession;

public class ImapServer
extends MailServer<ReceiveMailSession> {
    protected static final String MAIL_IMAP_PORT = "mail.imap.port";
    protected static final String MAIL_IMAP_HOST = "mail.imap.host";
    protected static final String MAIL_IMAP_PARTIALFETCH = "mail.imap.partialfetch";
    protected static final String PROTOCOL_IMAP = "imap";
    protected static final int DEFAULT_IMAP_PORT = 143;

    public ImapServer(String host, int port, Authenticator authenticator, File attachmentStorage) {
        super(host, port == -1 ? 143 : port, authenticator, attachmentStorage);
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = new Properties();
        props.setProperty(MAIL_IMAP_HOST, this.getHost());
        props.setProperty(MAIL_IMAP_PORT, String.valueOf(this.getPort()));
        props.setProperty(MAIL_IMAP_PARTIALFETCH, "false");
        return props;
    }

    protected Store getStore(Session session) throws NoSuchProviderException {
        return session.getStore(PROTOCOL_IMAP);
    }

    @Override
    public ReceiveMailSession createSession() {
        return EmailUtil.createSession(PROTOCOL_IMAP, this.getSessionProperties(), this.getAuthenticator(), this.getAttachmentStorage());
    }
}

