/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import javax.mail.Flags;
import javax.mail.MessagingException;
import jodd.mail.EmailFilter;
import jodd.mail.MailException;
import jodd.mail.ReceiveMailSession;
import jodd.mail.ReceivedEmail;

public class ReceiverBuilder {
    private final ReceiveMailSession session;
    private EmailFilter filter;
    private boolean markSeen;
    private boolean markDeleted;
    private boolean envelopeOnly;
    private String targetFolder;
    private String fromFolder;

    public ReceiverBuilder(ReceiveMailSession session) {
        this.session = session;
    }

    public ReceiverBuilder filter(EmailFilter emailFilter) {
        this.filter = emailFilter;
        return this;
    }

    public ReceiverBuilder markSeen() {
        this.markSeen = true;
        return this;
    }

    public ReceiverBuilder markDeleted() {
        this.markDeleted = true;
        return this;
    }

    public ReceiverBuilder fromFolder(String fromFolder) {
        this.fromFolder = fromFolder;
        return this;
    }

    public ReceiverBuilder moveToFolder(String targetFolder) {
        this.markDeleted = true;
        this.targetFolder = targetFolder;
        return this;
    }

    public ReceiverBuilder envelopeOnly() {
        this.envelopeOnly = true;
        return this;
    }

    public ReceivedEmail[] get() {
        if (this.fromFolder != null) {
            this.session.useFolder(this.fromFolder);
        }
        Flags flags = new Flags();
        if (this.markSeen) {
            flags.add(Flags.Flag.SEEN);
        }
        if (this.markDeleted) {
            flags.add(Flags.Flag.DELETED);
        }
        return this.session.receiveMessages(this.filter, flags, this.envelopeOnly, messages -> {
            if (this.targetFolder != null) {
                try {
                    this.session.folder.copyMessages(messages, this.session.getFolder(this.targetFolder));
                }
                catch (MessagingException e) {
                    throw new MailException("Copying messages failed");
                }
            }
        });
    }
}

