/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import jodd.mail.MailException;
import jodd.mail.MailServer;
import jodd.mail.SendMailSession;

public class SmtpServer<T extends SmtpServer<T>>
extends MailServer<SendMailSession> {
    public static final String MAIL_HOST = "mail.host";
    public static final String MAIL_SMTP_HOST = "mail.smtp.host";
    public static final String MAIL_SMTP_PORT = "mail.smtp.port";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String MAIL_SMTP_FROM = "mail.smtp.from";
    public static final String MAIL_SMTP_CONNECTIONTIMEOUT = "mail.smtp.connectiontimeout";
    public static final String MAIL_SMTP_TIMEOUT = "mail.smtp.timeout";
    public static final String MAIL_SMTP_WRITETIMEOUT = "mail.smtp.writetimeout";
    public static final String MAIL_DEBUG = "mail.debug";
    public static final String MAIL_MIME_ADDRESS_STRICT = "mail.mime.address.strict";
    protected static final String PROTOCOL_SMTP = "smtp";
    protected static final int DEFAULT_SMTP_PORT = 25;
    protected boolean debug = false;
    protected boolean strictAddress = true;
    private int timeout = 0;

    protected T _this() {
        return (T)this;
    }

    public SmtpServer(String host, int port, Authenticator authenticator) {
        super(host, port == -1 ? 25 : port, authenticator, null);
    }

    public T timeout(int timeout) {
        this.timeout = timeout;
        return this._this();
    }

    public T debugMode(boolean debug) {
        this.debug = debug;
        return this._this();
    }

    public T strictAddress(boolean strictAddress) {
        this.strictAddress = strictAddress;
        return this._this();
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = new Properties();
        props.setProperty(MAIL_TRANSPORT_PROTOCOL, PROTOCOL_SMTP);
        props.setProperty(MAIL_HOST, this.getHost());
        props.setProperty(MAIL_SMTP_HOST, this.getHost());
        props.setProperty(MAIL_SMTP_PORT, String.valueOf(this.getPort()));
        if (this.getAuthenticator() != null) {
            props.setProperty(MAIL_SMTP_AUTH, "true");
        }
        if (this.timeout > 0) {
            String timeoutValue = String.valueOf(this.timeout);
            props.put(MAIL_SMTP_CONNECTIONTIMEOUT, timeoutValue);
            props.put(MAIL_SMTP_TIMEOUT, timeoutValue);
            props.put(MAIL_SMTP_WRITETIMEOUT, timeoutValue);
        }
        if (this.debug) {
            props.put(MAIL_DEBUG, "true");
        }
        if (!this.strictAddress) {
            props.put(MAIL_MIME_ADDRESS_STRICT, "false");
        }
        return props;
    }

    @Override
    public SendMailSession createSession() {
        Transport mailTransport;
        Session session = Session.getInstance((Properties)this.getSessionProperties(), (Authenticator)this.getAuthenticator());
        try {
            mailTransport = this.getTransport(session);
        }
        catch (NoSuchProviderException nspex) {
            throw new MailException(nspex);
        }
        return new SendMailSession(session, mailTransport);
    }

    protected Transport getTransport(Session session) throws NoSuchProviderException {
        return session.getTransport(PROTOCOL_SMTP);
    }
}

