/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import jodd.mail.EMLProperties;
import jodd.mail.Email;
import jodd.mail.MailException;
import jodd.mail.ReceivedEmail;
import jodd.mail.SendMailSession;

public class EMLComposer
extends EMLProperties<EMLComposer> {
    public static EMLComposer create() {
        return new EMLComposer();
    }

    public String compose(Email email) {
        if (this.getSession() == null) {
            this.createSession(this.getProperties());
        }
        OutputStreamTransport ost = new OutputStreamTransport(this.getSession());
        SendMailSession sendMailSession = new SendMailSession(this.getSession(), ost);
        sendMailSession.sendMail(email);
        return ost.getEml();
    }

    public String compose(ReceivedEmail receivedEmail) {
        Message msg = receivedEmail.originalMessage();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            msg.writeTo((OutputStream)outputStream);
        }
        catch (IOException | MessagingException e) {
            throw new MailException(e);
        }
        return outputStream.toString();
    }

    private static class OutputStreamTransport
    extends Transport {
        private String eml;

        public OutputStreamTransport(Session session) {
            super(session, new URLName("JODD_MAIL_2_EML", null, -1, null, null, null));
        }

        public void sendMessage(Message msg, Address[] addresses) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                msg.writeTo((OutputStream)outputStream);
            }
            catch (IOException | MessagingException e) {
                throw new MailException(e);
            }
            this.eml = outputStream.toString();
        }

        public String getEml() {
            return this.eml;
        }
    }
}

