/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.File;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeUtility;
import jodd.mail.MailException;
import jodd.mail.ReceiveMailSession;
import jodd.util.CharUtil;

public class EmailUtil {
    protected static final String ATTR_CHARSET = "charset=";
    static final String NO_NAME = "no-name";

    public static String extractMimeType(String contentType) {
        int ndx = contentType.indexOf(59);
        String mime = ndx != -1 ? contentType.substring(0, ndx) : contentType;
        return mime;
    }

    public static String extractEncoding(String contentType) {
        int ndx = contentType.indexOf(59);
        String charset = ndx != -1 ? contentType.substring(ndx + 1) : "";
        String encoding = null;
        ndx = charset.indexOf(ATTR_CHARSET);
        if (ndx != -1) {
            char c;
            int len = charset.length();
            if (charset.charAt(ndx += ATTR_CHARSET.length()) == '\"') {
                ++ndx;
            }
            int start = ndx;
            while (ndx < len && (c = charset.charAt(ndx)) != '\"' && !CharUtil.isWhitespace((char)c) && c != ';') {
                ++ndx;
            }
            encoding = charset.substring(start, ndx);
        }
        return encoding;
    }

    public static String extractEncoding(String contentType, String defaultEncoding) {
        String encoding = EmailUtil.extractEncoding(contentType);
        if (encoding == null) {
            if (defaultEncoding == null) {
                defaultEncoding = "UTF-8";
            }
            encoding = defaultEncoding;
        }
        return encoding;
    }

    public static String resolveFileName(Part part) throws MessagingException {
        String ret;
        if (!(part instanceof MimeBodyPart)) {
            return part.getFileName();
        }
        String contentType = part.getContentType();
        try {
            ret = MimeUtility.decodeText((String)part.getFileName());
        }
        catch (Exception ex) {
            String contentId = ((MimeBodyPart)part).getContentID();
            ret = contentId != null ? contentId + EmailUtil.contentTypeForFileName(contentType) : EmailUtil.defaultFileName(contentType);
        }
        return ret;
    }

    private static String contentTypeForFileName(String contentType) {
        return "." + contentType.substring(contentType.lastIndexOf("/") + 1, contentType.length());
    }

    private static String defaultFileName(String contentType) {
        return NO_NAME + EmailUtil.contentTypeForFileName(contentType);
    }

    public static ReceiveMailSession createSession(String protocol, Properties sessionProperties, Authenticator authenticator, File attachmentStorage) {
        Store store;
        Session session = Session.getInstance((Properties)sessionProperties, (Authenticator)authenticator);
        try {
            store = session.getStore(protocol);
        }
        catch (NoSuchProviderException nspex) {
            String errMsg = String.format("Failed to create %s session", protocol);
            throw new MailException(errMsg, nspex);
        }
        return new ReceiveMailSession(session, store, attachmentStorage);
    }

    public static boolean isEmptyFlags(Flags flags) {
        if (flags == null) {
            return true;
        }
        Flags.Flag[] systemFlags = flags.getSystemFlags();
        if (systemFlags != null && systemFlags.length > 0) {
            return false;
        }
        String[] userFlags = flags.getUserFlags();
        return userFlags == null || userFlags.length <= 0;
    }
}

