/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Properties;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import jodd.mail.EmailUtil;
import jodd.mail.MailServer;
import jodd.mail.ReceiveMailSession;

public class Pop3Server
extends MailServer<ReceiveMailSession> {
    protected static final String PROTOCOL_POP3 = "pop3";
    protected static final int DEFAULT_POP3_PORT = 110;

    public Pop3Server(MailServer.Builder builder) {
        super(builder, 110);
    }

    protected Pop3Server(MailServer.Builder builder, int defaultPort) {
        super(builder, defaultPort);
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = super.createSessionProperties();
        props.setProperty("mail.pop3.host", this.host);
        props.setProperty("mail.pop3.port", String.valueOf(this.port));
        if (this.authenticator != null) {
            props.setProperty("mail.pop3.auth", "true");
        }
        if (this.timeout > 0) {
            String timeoutValue = String.valueOf(this.timeout);
            props.put("mail.pop3.connectiontimeout", timeoutValue);
            props.put("mail.pop3.timeout", timeoutValue);
        }
        return props;
    }

    protected Store getStore(Session session) throws NoSuchProviderException {
        return session.getStore(PROTOCOL_POP3);
    }

    @Override
    public ReceiveMailSession createSession() {
        return EmailUtil.createSession(PROTOCOL_POP3, this.createSessionProperties(), this.authenticator, this.attachmentStorage);
    }
}

