/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import java.util.Properties;
import jodd.mail.EmailUtil;
import jodd.mail.MailServer;
import jodd.mail.ReceiveMailSession;

public class ImapServer
extends MailServer<ReceiveMailSession> {
    protected static final String PROTOCOL_IMAP = "imap";
    protected static final int DEFAULT_IMAP_PORT = 143;

    public ImapServer(MailServer.Builder builder) {
        super(builder, 143);
    }

    protected ImapServer(MailServer.Builder builder, int defaultPort) {
        super(builder, defaultPort);
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = super.createSessionProperties();
        props.setProperty("mail.imap.host", this.host);
        props.setProperty("mail.imap.port", String.valueOf(this.port));
        props.setProperty("mail.imap.partialfetch", "false");
        props.setProperty("mail.imap.peek", "true");
        if (this.timeout > 0) {
            String timeoutValue = String.valueOf(this.timeout);
            props.put("mail.imap.connectiontimeout", timeoutValue);
            props.put("mail.imap.timeout", timeoutValue);
        }
        return props;
    }

    protected Store getStore(Session session) throws NoSuchProviderException {
        return session.getStore(PROTOCOL_IMAP);
    }

    @Override
    public ReceiveMailSession createSession() {
        return EmailUtil.createSession(PROTOCOL_IMAP, this.createSessionProperties(), this.authenticator, this.attachmentStorage, this.debugConsumer);
    }
}

