/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import jakarta.mail.Flags;
import jakarta.mail.Message;
import jakarta.mail.search.AndTerm;
import jakarta.mail.search.BodyTerm;
import jakarta.mail.search.FlagTerm;
import jakarta.mail.search.FromStringTerm;
import jakarta.mail.search.HeaderTerm;
import jakarta.mail.search.MessageIDTerm;
import jakarta.mail.search.MessageNumberTerm;
import jakarta.mail.search.NotTerm;
import jakarta.mail.search.OrTerm;
import jakarta.mail.search.ReceivedDateTerm;
import jakarta.mail.search.RecipientStringTerm;
import jakarta.mail.search.SearchTerm;
import jakarta.mail.search.SentDateTerm;
import jakarta.mail.search.SizeTerm;
import jakarta.mail.search.SubjectTerm;
import java.util.Date;

public class EmailFilter {
    boolean operatorAnd = true;
    boolean nextIsNot;
    protected SearchTerm searchTerm;

    public static EmailFilter filter() {
        return new EmailFilter();
    }

    public EmailFilter subject(String subject) {
        SubjectTerm subjectTerm = new SubjectTerm(subject);
        this.concat((SearchTerm)subjectTerm);
        return this;
    }

    public EmailFilter messageId(String messageId) {
        MessageIDTerm msgIdTerm = new MessageIDTerm(messageId);
        this.concat((SearchTerm)msgIdTerm);
        return this;
    }

    public EmailFilter messageNumber(int messageNumber) {
        MessageNumberTerm msgIdTerm = new MessageNumberTerm(messageNumber);
        this.concat((SearchTerm)msgIdTerm);
        return this;
    }

    public EmailFilter from(String fromAddress) {
        FromStringTerm fromTerm = new FromStringTerm(fromAddress);
        this.concat((SearchTerm)fromTerm);
        return this;
    }

    public EmailFilter to(String toAddress) {
        RecipientStringTerm toTerm = new RecipientStringTerm(Message.RecipientType.TO, toAddress);
        this.concat((SearchTerm)toTerm);
        return this;
    }

    public EmailFilter cc(String ccAddress) {
        RecipientStringTerm toTerm = new RecipientStringTerm(Message.RecipientType.CC, ccAddress);
        this.concat((SearchTerm)toTerm);
        return this;
    }

    public EmailFilter bcc(String bccAddress) {
        RecipientStringTerm toTerm = new RecipientStringTerm(Message.RecipientType.BCC, bccAddress);
        this.concat((SearchTerm)toTerm);
        return this;
    }

    public EmailFilter flags(Flags flags, boolean value) {
        FlagTerm flagTerm = new FlagTerm(flags, value);
        this.concat((SearchTerm)flagTerm);
        return this;
    }

    public EmailFilter flag(Flags.Flag flag, boolean value) {
        Flags flags = new Flags();
        flags.add(flag);
        return this.flags(flags, value);
    }

    public EmailFilter receivedDate(Operator operator, long milliseconds) {
        ReceivedDateTerm term = new ReceivedDateTerm(operator.value, new Date(milliseconds));
        this.concat((SearchTerm)term);
        return this;
    }

    public EmailFilter sentDate(Operator operator, long milliseconds) {
        SentDateTerm term = new SentDateTerm(operator.value, new Date(milliseconds));
        this.concat((SearchTerm)term);
        return this;
    }

    public EmailFilter text(String pattern) {
        BodyTerm term = new BodyTerm(pattern);
        this.concat((SearchTerm)term);
        return this;
    }

    public EmailFilter header(String headerName, String pattern) {
        HeaderTerm term = new HeaderTerm(headerName, pattern);
        this.concat((SearchTerm)term);
        return this;
    }

    public EmailFilter size(Operator comparison, int size) {
        SizeTerm term = new SizeTerm(comparison.value, size);
        this.concat((SearchTerm)term);
        return this;
    }

    public EmailFilter and() {
        this.operatorAnd = true;
        return this;
    }

    public EmailFilter or() {
        this.operatorAnd = false;
        return this;
    }

    public EmailFilter not() {
        this.nextIsNot = true;
        return this;
    }

    public EmailFilter and(EmailFilter ... emailFilters) {
        SearchTerm[] searchTerms = new SearchTerm[emailFilters.length];
        for (int i = 0; i < emailFilters.length; ++i) {
            searchTerms[i] = emailFilters[i].searchTerm;
        }
        this.concat((SearchTerm)new AndTerm(searchTerms));
        return this;
    }

    public EmailFilter or(EmailFilter ... emailFilters) {
        SearchTerm[] searchTerms = new SearchTerm[emailFilters.length];
        for (int i = 0; i < emailFilters.length; ++i) {
            searchTerms[i] = emailFilters[i].searchTerm;
        }
        this.concat((SearchTerm)new OrTerm(searchTerms));
        return this;
    }

    public EmailFilter not(EmailFilter emailFilter) {
        NotTerm searchTerm = new NotTerm(emailFilter.searchTerm);
        this.concat((SearchTerm)searchTerm);
        return this;
    }

    protected void concat(SearchTerm searchTerm) {
        if (this.nextIsNot) {
            searchTerm = new NotTerm(searchTerm);
            this.nextIsNot = false;
        }
        if (this.operatorAnd) {
            this.and(searchTerm);
        } else {
            this.or(searchTerm);
        }
    }

    protected void and(SearchTerm searchTerm) {
        if (this.searchTerm == null) {
            this.searchTerm = searchTerm;
            return;
        }
        this.searchTerm = new AndTerm(this.searchTerm, searchTerm);
    }

    protected void or(SearchTerm searchTerm) {
        if (this.searchTerm == null) {
            this.searchTerm = searchTerm;
            return;
        }
        this.searchTerm = new OrTerm(this.searchTerm, searchTerm);
    }

    public SearchTerm getSearchTerm() {
        return this.searchTerm;
    }

    public static enum Operator {
        EQ(3),
        GE(6),
        GT(5),
        LE(1),
        LT(2),
        NE(4);

        private final int value;

        private Operator(int value) {
            this.value = value;
        }
    }
}

