/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.URLName;
import java.util.Properties;
import jodd.mail.ImapServer;
import jodd.mail.MailServer;
import jodd.mail.SimpleAuthenticator;
import org.eclipse.angus.mail.imap.IMAPSSLStore;

public class ImapSslServer
extends ImapServer {
    public static final int DEFAULT_SSL_PORT = 993;

    public ImapSslServer(MailServer.Builder builder) {
        super(builder, 993);
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = super.createSessionProperties();
        props.setProperty("mail.imap.socketFactory.port", String.valueOf(this.port));
        props.setProperty("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.imap.socketFactory.fallback", "false");
        return props;
    }

    protected IMAPSSLStore getStore(Session session) {
        URLName url;
        SimpleAuthenticator simpleAuthenticator = (SimpleAuthenticator)this.authenticator;
        if (simpleAuthenticator == null) {
            url = new URLName("imap", this.host, this.port, "", null, null);
        } else {
            PasswordAuthentication pa = simpleAuthenticator.getPasswordAuthentication();
            url = new URLName("imap", this.host, this.port, "", pa.getUserName(), pa.getPassword());
        }
        return new IMAPSSLStore(session, url);
    }
}

