/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import jakarta.mail.FetchProfile;
import jakarta.mail.Flags;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import java.util.function.Consumer;
import jodd.mail.EmailUtil;
import jodd.mail.MailException;
import jodd.mail.ReceiveMailSession;
import jodd.mail.ReceivedEmail;

public class ReceivedEmails {
    private final Message[] messages;
    private final boolean envelope;
    private final ReceiveMailSession session;
    private final Flags flagsToSet;
    private final Flags flagsToUnset;
    private final Consumer<Message[]> processedMessageConsumer;

    public ReceivedEmails(ReceiveMailSession session, Message[] messages, Flags flagsToSet, Flags flagsToUnset, boolean envelope, Consumer<Message[]> processedMessageConsumer) {
        this.session = session;
        this.messages = messages;
        this.flagsToSet = flagsToSet;
        this.flagsToUnset = flagsToUnset;
        this.envelope = envelope;
        this.processedMessageConsumer = processedMessageConsumer;
    }

    public ReceivedEmail[] fetch() {
        try {
            return this._fetch();
        }
        catch (MessagingException ex) {
            throw new MailException("Failed to process fetched messages", ex);
        }
    }

    private ReceivedEmail[] _fetch() throws MessagingException {
        boolean isReadOnly;
        if (this.messages.length == 0) {
            return ReceivedEmail.EMPTY_ARRAY;
        }
        boolean bl = isReadOnly = this.session.folder.getMode() == 1;
        if (this.envelope) {
            FetchProfile fetchProfile = new FetchProfile();
            fetchProfile.add(FetchProfile.Item.ENVELOPE);
            fetchProfile.add(FetchProfile.Item.FLAGS);
            this.session.folder.fetch(this.messages, fetchProfile);
        }
        ReceivedEmail[] emails = new ReceivedEmail[this.messages.length];
        for (int i = 0; i < this.messages.length; ++i) {
            Message msg = this.messages[i];
            emails[i] = new ReceivedEmail(msg, this.envelope, this.session.attachmentStorage);
            if (!EmailUtil.isEmptyFlags(this.flagsToSet)) {
                emails[i].flags(this.flagsToSet);
                if (!isReadOnly) {
                    msg.setFlags(this.flagsToSet, true);
                }
            }
            if (!EmailUtil.isEmptyFlags(this.flagsToUnset)) {
                emails[i].flags().remove(this.flagsToUnset);
                if (!isReadOnly) {
                    msg.setFlags(this.flagsToUnset, false);
                }
            }
            if (!EmailUtil.isEmptyFlags(this.flagsToSet) || emails[i].isSeen() || isReadOnly) continue;
            msg.setFlag(Flags.Flag.SEEN, false);
        }
        if (this.processedMessageConsumer != null) {
            this.processedMessageConsumer.accept(this.messages);
        }
        if (!EmailUtil.isEmptyFlags(this.flagsToSet) && !isReadOnly && this.flagsToSet.contains(Flags.Flag.DELETED)) {
            this.session.folder.expunge();
        }
        return emails;
    }

    public static ReceivedEmails empty() {
        return new ReceivedEmails(null, new Message[0], null, null, false, null);
    }
}

