/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Constructor;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.CtorDescriptor;
import jodd.petite.CtorInjectionPoint;
import jodd.petite.InjectionPointFactory;
import jodd.petite.PetiteException;
import jodd.petite.PetiteUtil;
import jodd.petite.meta.PetiteInject;

public class CtorResolver {
    protected final InjectionPointFactory injectionPointFactory;

    public CtorResolver(InjectionPointFactory injectionPointFactory) {
        this.injectionPointFactory = injectionPointFactory;
    }

    public CtorInjectionPoint resolve(Class type, boolean useAnnotation) {
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        CtorDescriptor[] allCtors = cd.getAllCtorDescriptors();
        Constructor foundedCtor = null;
        Constructor defaultCtor = null;
        String refValues = null;
        for (CtorDescriptor ctorDescriptor : allCtors) {
            PetiteInject ref;
            Constructor ctor = ctorDescriptor.getConstructor();
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length == 0) {
                defaultCtor = ctor;
            }
            if (!useAnnotation || (ref = ctor.getAnnotation(PetiteInject.class)) == null) continue;
            if (foundedCtor != null) {
                throw new PetiteException("Two or more constructors are annotated as injection points in bean: " + type.getName());
            }
            foundedCtor = ctor;
            refValues = ref.value().trim();
        }
        if (foundedCtor == null) {
            foundedCtor = allCtors.length == 1 ? allCtors[0].getConstructor() : defaultCtor;
        }
        if (foundedCtor == null) {
            throw new PetiteException("No constructor (annotated, single or default) founded as injection point for: " + type.getName());
        }
        String[][] references = PetiteUtil.convertAnnValueToReferences(refValues);
        return this.injectionPointFactory.createCtorInjectionPoint(foundedCtor, references);
    }
}

