/*
 * Decompiled with CFR 0.152.
 */
package jodd.paramo;

import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import jodd.asm.EmptyClassVisitor;
import jodd.asm9.MethodVisitor;
import jodd.asm9.Type;
import jodd.paramo.MethodParameter;
import jodd.paramo.ParamExtractor;
import jodd.paramo.ParamoException;

final class MethodFinder
extends EmptyClassVisitor {
    private static final Map<String, String> primitives = new HashMap<String, String>(8);
    private static final String TYPE_INT = "int";
    private static final String TYPE_BOOLEAN = "boolean";
    private static final String TYPE_BYTE = "byte";
    private static final String TYPE_CHAR = "char";
    private static final String TYPE_SHORT = "short";
    private static final String TYPE_FLOAT = "float";
    private static final String TYPE_LONG = "long";
    private static final String TYPE_DOUBLE = "double";
    private static final String ARRAY = "[]";
    private final Class declaringClass;
    private final String methodName;
    private final Class[] parameterTypes;
    private final Parameter[] parameters;
    private ParamExtractor paramExtractor;

    MethodFinder(Class declaringClass, String methodName, Class[] parameterTypes, Parameter[] parameters) {
        this.declaringClass = declaringClass;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.parameters = parameters;
        this.paramExtractor = null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.paramExtractor != null) {
            return null;
        }
        if (!name.equals(this.methodName)) {
            return null;
        }
        Type[] argumentTypes = Type.getArgumentTypes(desc);
        int dwordsCount = 0;
        for (Type t : argumentTypes) {
            if (!t.getClassName().equals(TYPE_LONG) && !t.getClassName().equals(TYPE_DOUBLE)) continue;
            ++dwordsCount;
        }
        int paramCount = argumentTypes.length;
        if (paramCount != this.parameterTypes.length) {
            return null;
        }
        for (int i = 0; i < argumentTypes.length; ++i) {
            if (this.isEqualTypeName(argumentTypes[i], this.parameterTypes[i])) continue;
            return null;
        }
        this.paramExtractor = new ParamExtractor(Modifier.isStatic(access) ? 0 : 1, argumentTypes.length + dwordsCount, this.parameters);
        return this.paramExtractor;
    }

    boolean isEqualTypeName(Type argumentType, Class paramType) {
        String s = argumentType.getClassName();
        if (s.endsWith(ARRAY)) {
            String prefix = s.substring(0, s.length() - 2);
            String bytecodeSymbol = primitives.get(prefix);
            s = bytecodeSymbol != null ? '[' + bytecodeSymbol : "[L" + prefix + ';';
        }
        return s.equals(paramType.getName());
    }

    MethodParameter[] getResolvedParameters() {
        if (this.paramExtractor == null) {
            return MethodParameter.EMPTY_ARRAY;
        }
        if (!this.paramExtractor.debugInfoPresent) {
            throw new ParamoException("Parameter names not available for method: " + this.declaringClass.getName() + '#' + this.methodName);
        }
        return this.paramExtractor.getMethodParameters();
    }

    static {
        primitives.put(TYPE_INT, "I");
        primitives.put(TYPE_BOOLEAN, "Z");
        primitives.put(TYPE_CHAR, "C");
        primitives.put(TYPE_BYTE, "B");
        primitives.put(TYPE_FLOAT, "F");
        primitives.put(TYPE_LONG, "J");
        primitives.put(TYPE_DOUBLE, "D");
        primitives.put(TYPE_SHORT, "S");
    }
}

