/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import jodd.asm.MethodAdapter;
import jodd.asm9.Label;
import jodd.asm9.MethodVisitor;
import jodd.proxetta.ProxettaException;

abstract class HistoryMethodAdapter
extends MethodAdapter {
    protected int opcode;
    protected int operand;
    protected boolean isPrevious;
    protected boolean traceNext;
    protected String[] strArgs = new String[2];

    protected HistoryMethodAdapter(MethodVisitor methodVisitor) {
        super(methodVisitor);
    }

    protected int getArgumentIndex() {
        int argIndex;
        if (!this.isPrevious) {
            throw new ProxettaException("Unexpected previous instruction type used for setting argument index");
        }
        switch (this.opcode) {
            case 3: {
                argIndex = 0;
                break;
            }
            case 4: {
                argIndex = 1;
                break;
            }
            case 5: {
                argIndex = 2;
                break;
            }
            case 6: {
                argIndex = 3;
                break;
            }
            case 7: {
                argIndex = 4;
                break;
            }
            case 8: {
                argIndex = 5;
                break;
            }
            case 16: 
            case 17: {
                argIndex = this.operand;
                break;
            }
            default: {
                throw new ProxettaException("Unexpected previous instruction used for setting argument index");
            }
        }
        return argIndex;
    }

    public String[] getLastTwoStringArguments() {
        return this.strArgs;
    }

    private void keepStringArgument(Object value) {
        this.strArgs[0] = this.strArgs[1];
        this.strArgs[1] = value.toString();
    }

    @Override
    public void visitInsn(int opcode) {
        this.opcode = opcode;
        this.isPrevious = true;
        this.traceNext = false;
        super.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.opcode = opcode;
        this.operand = operand;
        this.isPrevious = true;
        this.traceNext = false;
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitMethodInsn(opcode, owner, name, desc, isInterface);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.isPrevious = false;
        this.traceNext = false;
        this.keepStringArgument(cst);
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.isPrevious = false;
        this.traceNext = false;
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    @Override
    public void visitLineNumber(int line, Label start) {
    }
}

