/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.servlet.ServletUtil;

public class DispatcherUtil {
    public static final String INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    public static final String FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    public static final String FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    public static final String FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    public static final String FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";

    public static boolean include(ServletRequest request, ServletResponse response, String page) throws IOException, ServletException {
        RequestDispatcher dispatcher = request.getRequestDispatcher(page);
        if (dispatcher != null) {
            dispatcher.include(request, response);
            return true;
        }
        return false;
    }

    public static boolean includeNamed(HttpServletRequest request, ServletResponse response, String resource) throws IOException, ServletException {
        return DispatcherUtil.includeNamed(request.getSession().getServletContext(), (ServletRequest)request, response, resource);
    }

    public static boolean includeNamed(ServletContext context, ServletRequest request, ServletResponse response, String page) throws IOException, ServletException {
        RequestDispatcher dispatcher = context.getNamedDispatcher(page);
        if (dispatcher != null) {
            dispatcher.include(request, response);
            return true;
        }
        return false;
    }

    public static boolean includeAbsolute(HttpServletRequest request, HttpServletResponse response, String page) throws IOException, ServletException {
        return DispatcherUtil.includeAbsolute(request.getSession().getServletContext(), (ServletRequest)request, response, page);
    }

    public static boolean includeAbsolute(ServletContext context, ServletRequest request, HttpServletResponse response, String page) throws IOException, ServletException {
        RequestDispatcher dispatcher = context.getRequestDispatcher(page);
        if (dispatcher != null) {
            dispatcher.include(request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    public static boolean forward(ServletRequest request, ServletResponse response, String page) throws IOException, ServletException {
        RequestDispatcher dispatcher = request.getRequestDispatcher(page);
        if (dispatcher != null) {
            dispatcher.forward(request, response);
            return true;
        }
        return false;
    }

    public static boolean forwardNamed(HttpServletRequest request, ServletResponse response, String resource) throws IOException, ServletException {
        return DispatcherUtil.forwardNamed(request.getSession().getServletContext(), (ServletRequest)request, response, resource);
    }

    public static boolean forwardNamed(ServletContext context, ServletRequest request, ServletResponse response, String resource) throws IOException, ServletException {
        RequestDispatcher dispatcher = context.getNamedDispatcher(resource);
        if (dispatcher != null) {
            dispatcher.forward(request, response);
            return true;
        }
        return false;
    }

    public static boolean forwardAbsolute(HttpServletRequest request, ServletResponse response, String page) throws IOException, ServletException {
        return DispatcherUtil.forwardAbsolute(request.getSession().getServletContext(), (ServletRequest)request, response, page);
    }

    public static boolean forwardAbsolute(ServletContext context, ServletRequest request, ServletResponse response, String resource) throws IOException, ServletException {
        RequestDispatcher dispatcher = context.getRequestDispatcher(resource);
        if (dispatcher != null) {
            dispatcher.forward(request, response);
            return true;
        }
        return false;
    }

    public static void redirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        if (url.startsWith("/")) {
            url = ServletUtil.getContextPath(request) + url;
        }
        response.sendRedirect(response.encodeRedirectURL(url));
    }

    public static String getFullUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        String query = request.getQueryString();
        if (query != null && query.length() != 0) {
            url = url + '?' + query;
        }
        return url;
    }

    public static String getUrl(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String query = request.getQueryString();
        if (query != null && query.length() != 0) {
            servletPath = servletPath + '?' + query;
        }
        return servletPath;
    }

    public static String getIncludeRequestUri(HttpServletRequest request) {
        return (String)request.getAttribute(INCLUDE_REQUEST_URI);
    }

    public static String getIncludeContextPath(HttpServletRequest request) {
        return (String)request.getAttribute(INCLUDE_CONTEXT_PATH);
    }

    public static String getIncludeServletPath(HttpServletRequest request) {
        return (String)request.getAttribute(INCLUDE_SERVLET_PATH);
    }

    public static String getIncludePathInfo(HttpServletRequest request) {
        return (String)request.getAttribute(INCLUDE_PATH_INFO);
    }

    public static String getIncludeQueryString(HttpServletRequest request) {
        return (String)request.getAttribute(INCLUDE_QUERY_STRING);
    }

    public static String getForwardRequestUri(HttpServletRequest request) {
        return (String)request.getAttribute(FORWARD_REQUEST_URI);
    }

    public static String getForwardContextPath(HttpServletRequest request) {
        return (String)request.getAttribute(FORWARD_CONTEXT_PATH);
    }

    public static String getForwardServletPath(HttpServletRequest request) {
        return (String)request.getAttribute(FORWARD_SERVLET_PATH);
    }

    public static String getForwardPathInfo(HttpServletRequest request) {
        return (String)request.getAttribute(FORWARD_PATH_INFO);
    }

    public static String getForwardQueryString(HttpServletRequest request) {
        return (String)request.getAttribute(FORWARD_QUERY_STRING);
    }

    public static boolean isPageIncluded(HttpServletRequest request, HttpServletResponse response) {
        return response.isCommitted() || DispatcherUtil.getIncludeServletPath(request) != null;
    }

    public static boolean isTopLevelRequest(HttpServletRequest request) {
        return DispatcherUtil.getForwardRequestUri(request) == null && DispatcherUtil.getIncludeRequestUri(request) == null;
    }

    public static String getBaseRequestUri(HttpServletRequest request) {
        String result = DispatcherUtil.getForwardRequestUri(request);
        if (result == null) {
            result = request.getRequestURI();
        }
        return result;
    }

    public static String getRequestUri(HttpServletRequest request) {
        String result = DispatcherUtil.getIncludeRequestUri(request);
        if (result == null) {
            result = request.getRequestURI();
        }
        return result;
    }

    public static String getBaseContextPath(HttpServletRequest request) {
        String result = DispatcherUtil.getForwardContextPath(request);
        if (result == null) {
            result = ServletUtil.getContextPath(request);
        }
        return result;
    }

    public static String getContextPath(HttpServletRequest request) {
        String result = DispatcherUtil.getIncludeContextPath(request);
        if (result == null) {
            result = ServletUtil.getContextPath(request);
        }
        return result;
    }

    public static String getBaseServletPath(HttpServletRequest request) {
        String result = DispatcherUtil.getForwardServletPath(request);
        if (result == null) {
            result = request.getServletPath();
        }
        return result;
    }

    public static String getServletPath(HttpServletRequest request) {
        String result = DispatcherUtil.getIncludeServletPath(request);
        if (result == null) {
            result = request.getServletPath();
        }
        return result;
    }

    public static String getBasePathInfo(HttpServletRequest request) {
        String result = DispatcherUtil.getForwardPathInfo(request);
        if (result == null) {
            result = request.getPathInfo();
        }
        return result;
    }

    public static String getPathInfo(HttpServletRequest request) {
        String result = DispatcherUtil.getIncludePathInfo(request);
        if (result == null) {
            result = request.getPathInfo();
        }
        return result;
    }

    public static String getBaseQueryString(HttpServletRequest request) {
        String result = DispatcherUtil.getForwardQueryString(request);
        if (result == null) {
            result = request.getQueryString();
        }
        return result;
    }

    public static String getQueryString(HttpServletRequest request) {
        String result = DispatcherUtil.getIncludeQueryString(request);
        if (result == null) {
            result = request.getQueryString();
        }
        return result;
    }
}

