/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.form;

import java.util.HashMap;
import java.util.Map;
import jodd.lagarto.Tag;
import jodd.lagarto.TagType;
import jodd.lagarto.visitor.TagWriter;
import jodd.mutable.MutableInteger;
import jodd.servlet.form.FormFieldResolver;
import jodd.util.CharSequenceUtil;
import jodd.util.StringUtil;

public class FormProcessorVisitor
extends TagWriter {
    private static final String INPUT = "input";
    private static final String SELECT = "select";
    private static final String OPTION = "option";
    private static final String TEXTAREA = "textarea";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String NAME = "name";
    private static final String TEXT = "text";
    private static final String HIDDEN = "hidden";
    private static final String IMAGE = "image";
    private static final String PASSWORD = "password";
    private static final String CHECKBOX = "checkbox";
    private static final String TRUE = "true";
    private static final String CHECKED = "checked";
    private static final String RADIO = "radio";
    private static final String SELECTED = "selected";
    private final FormFieldResolver resolver;
    protected Map<String, MutableInteger> valueNameIndexes;
    private boolean inSelect;
    private String currentSelectName;
    private String textAreaValue;
    private boolean inTextArea;

    public FormProcessorVisitor(Appendable appendable, FormFieldResolver resolver) {
        super(appendable);
        this.resolver = resolver;
    }

    public void tag(Tag tag) {
        if (tag.getType().isStartingTag()) {
            if (CharSequenceUtil.equalsToLowercase((CharSequence)tag.getName(), (CharSequence)INPUT)) {
                this.processInputStartTag(tag);
                super.tag(tag);
                return;
            }
            if (this.inSelect && CharSequenceUtil.equalsToLowercase((CharSequence)tag.getName(), (CharSequence)OPTION)) {
                this.processOptionOpenTag(tag);
                super.tag(tag);
                return;
            }
        }
        if (tag.getType() == TagType.START) {
            if (CharSequenceUtil.equalsToLowercase((CharSequence)tag.getName(), (CharSequence)TEXTAREA)) {
                this.processTextareaStartTag(tag);
            } else if (CharSequenceUtil.equalsToLowercase((CharSequence)tag.getName(), (CharSequence)SELECT)) {
                this.processSelectOpenTag(tag);
            }
        } else if (tag.getType() == TagType.END) {
            if (this.inTextArea && CharSequenceUtil.equalsToLowercase((CharSequence)tag.getName(), (CharSequence)TEXTAREA)) {
                this.processTextareaEndTag();
            } else if (this.inSelect && CharSequenceUtil.equalsToLowercase((CharSequence)tag.getName(), (CharSequence)SELECT)) {
                this.processSelectEndTag();
            }
        }
        super.tag(tag);
    }

    public void text(CharSequence text) {
        if (this.inTextArea) {
            return;
        }
        super.text(text);
    }

    private void processInputStartTag(Tag tag) {
        CharSequence tagValue;
        CharSequence tagType = tag.getAttributeValue((CharSequence)TYPE);
        if (tagType == null) {
            return;
        }
        CharSequence nameSequence = tag.getAttributeValue((CharSequence)NAME);
        if (nameSequence == null) {
            return;
        }
        String name = nameSequence.toString();
        Object valueObject = this.resolver.value(name);
        if (valueObject == null) {
            return;
        }
        String tagTypeName = tagType.toString().toLowerCase();
        if (tagTypeName.equals(TEXT) || tagTypeName.equals(HIDDEN) || tagTypeName.equals(IMAGE) || tagTypeName.equals(PASSWORD)) {
            String value = this.valueToString(name, valueObject);
            if (value == null) {
                return;
            }
            tag.setAttribute((CharSequence)VALUE, (CharSequence)value);
        } else if (tagTypeName.equals(CHECKBOX)) {
            CharSequence tagValue2 = tag.getAttributeValue((CharSequence)VALUE);
            if (tagValue2 == null) {
                tagValue2 = TRUE;
            }
            tagValue2 = tagValue2.toString();
            if (valueObject.getClass().isArray()) {
                String[] vs;
                for (String vsk : vs = StringUtil.toStringArray((Object)valueObject)) {
                    if (vsk == null || !vsk.contentEquals(tagValue2)) continue;
                    tag.setAttribute((CharSequence)CHECKED, null);
                }
            } else if (tagValue2.equals(valueObject.toString())) {
                tag.setAttribute((CharSequence)CHECKED, null);
            }
        } else if (tagType.equals(RADIO) && (tagValue = tag.getAttributeValue((CharSequence)VALUE)) != null && (tagValue = tagValue.toString()).equals(valueObject.toString())) {
            tag.setAttribute((CharSequence)CHECKED, null);
        }
    }

    protected String valueToString(String name, Object valueObject) {
        MutableInteger index;
        if (!valueObject.getClass().isArray()) {
            return valueObject.toString();
        }
        String[] array = (String[])valueObject;
        if (this.valueNameIndexes == null) {
            this.valueNameIndexes = new HashMap<String, MutableInteger>();
        }
        if ((index = this.valueNameIndexes.get(name)) == null) {
            index = new MutableInteger(0);
            this.valueNameIndexes.put(name, index);
        }
        if (index.value >= array.length) {
            return null;
        }
        String result = array[index.value];
        ++index.value;
        return result;
    }

    private void processSelectOpenTag(Tag tag) {
        CharSequence name = tag.getAttributeValue((CharSequence)NAME);
        if (name == null) {
            return;
        }
        this.currentSelectName = name.toString();
        this.inSelect = true;
    }

    private void processSelectEndTag() {
        this.inSelect = false;
        this.currentSelectName = null;
    }

    private void processOptionOpenTag(Tag tag) {
        CharSequence tagValue = tag.getAttributeValue((CharSequence)VALUE);
        if (tagValue == null) {
            return;
        }
        Object vals = this.resolver.value(this.currentSelectName);
        if (vals == null) {
            return;
        }
        tagValue = tagValue.toString();
        if (vals.getClass().isArray()) {
            String[] vs;
            for (String vsk : vs = StringUtil.toStringArray((Object)vals)) {
                if (vsk == null || !vsk.contentEquals(tagValue)) continue;
                tag.setAttribute((CharSequence)SELECTED, null);
            }
        } else {
            String value = StringUtil.toString((Object)vals);
            if (value.contentEquals(tagValue)) {
                tag.setAttribute((CharSequence)SELECTED, null);
            }
        }
    }

    private void processTextareaStartTag(Tag tag) {
        this.inTextArea = true;
        CharSequence name = tag.getAttributeValue((CharSequence)NAME);
        if (name == null) {
            return;
        }
        Object valueObject = this.resolver.value(name.toString());
        if (valueObject != null) {
            this.textAreaValue = valueObject.toString();
        }
    }

    private void processTextareaEndTag() {
        this.inTextArea = false;
        if (this.textAreaValue == null) {
            return;
        }
        super.text((CharSequence)this.textAreaValue);
        this.textAreaValue = null;
    }
}

