/*
 * Decompiled with CFR 0.152.
 */
package jodd.swingspy;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import jodd.swingspy.CaddyDialog;
import jodd.swingspy.SwingSpyGlassPane;
import jodd.swingspy.SwingSpyPanel;

public class SwingSpy {
    private static final int MOUSE_HOTKEY = 1216;
    private static SwingSpy spy;
    protected JDialog spyDialog;
    protected SwingSpyPanel spyPanel;
    protected SwingSpyGlassPane spyGlass;

    public SwingSpy() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            public void eventDispatched(AWTEvent awtEvent) {
                MouseEvent event = (MouseEvent)awtEvent;
                if (event.getModifiersEx() == 1216 && event.getClickCount() == 1) {
                    SwingSpy.this.showSpyDialog((Component)event.getSource());
                    event.consume();
                }
            }
        }, 16L);
        this.printUsageMessage();
    }

    protected void printUsageMessage() {
        System.out.println("SHIFT-CTRL-CLICK on any component to activate.");
    }

    public static void install() {
        if (spy == null) {
            System.out.print("SwingSpy has been installed. ");
            spy = new SwingSpy();
        } else {
            System.out.println("SwingSpy already installed.");
        }
    }

    public void showSpyDialog(Component component) {
        this.showSpyDialog(SwingUtilities.getRoot(component), component);
    }

    public void showSpyDialog(final Component rootComponent, final Component component) {
        if (this.spyDialog != null) {
            this.spyDialog.setVisible(true);
            this.spyGlass.setVisible(true);
            this.spyPanel.reload(rootComponent, component);
            return;
        }
        if (rootComponent instanceof RootPaneContainer) {
            RootPaneContainer rootPane = (RootPaneContainer)((Object)rootComponent);
            this.spyGlass = new SwingSpyGlassPane(rootPane);
            rootPane.setGlassPane(this.spyGlass);
            rootPane.getGlassPane().setVisible(true);
            Toolkit.getDefaultToolkit().addAWTEventListener(this.spyGlass, 48L);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingSpy.this.initSpyDialog(rootComponent, component);
            }
        });
    }

    protected void initSpyDialog(Component rootComponent, Component component) {
        this.spyDialog = rootComponent instanceof Dialog ? new CaddyDialog((Dialog)rootComponent){

            protected JRootPane createRootPane() {
                return SwingSpy.this.createSpyRootPane();
            }
        } : (rootComponent instanceof Frame ? new CaddyDialog((Frame)rootComponent){

            protected JRootPane createRootPane() {
                return SwingSpy.this.createSpyRootPane();
            }
        } : new JDialog(){

            protected JRootPane createRootPane() {
                return SwingSpy.this.createSpyRootPane();
            }
        });
        this.spyDialog.setName("SwingSpy");
        this.spyDialog.setTitle("SwingSpy");
        this.spyDialog.setModal(false);
        this.spyDialog.setAlwaysOnTop(true);
        Container contentPane = this.spyDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.spyPanel = new SwingSpyPanel();
        this.spyPanel.reload(rootComponent, component);
        contentPane.add(this.spyPanel);
        this.spyDialog.pack();
        this.spyDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                super.windowClosed(e);
                SwingSpy.this.spyGlass.setVisible(false);
                SwingSpy.this.spyDialog = null;
            }
        });
        this.spyDialog.setLocationRelativeTo(null);
        this.spyDialog.setVisible(true);
    }

    protected JRootPane createSpyRootPane() {
        JRootPane rootPane = new JRootPane();
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingSpy.this.spyGlass.setVisible(false);
                SwingSpy.this.spyDialog.setVisible(false);
            }
        }, escapeKeyStroke, 2);
        return rootPane;
    }
}

