/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import jodd.db.DbSqlException;
import jodd.db.connection.ConnectionProvider;

public class DriverManagerConnectionProvider
implements ConnectionProvider {
    private String url;
    private String username;
    private String password;
    private String driverClass;
    private Integer isolation;
    private Boolean autoCommit;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public Integer getIsolation() {
        return this.isolation;
    }

    public void setIsolation(Integer isolation) {
        this.isolation = isolation;
    }

    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public DriverManagerConnectionProvider(String driverClass, String url, String username, String password) {
        this.driverClass = driverClass;
        this.password = password;
        this.username = username;
        this.url = url;
    }

    public DriverManagerConnectionProvider(String driverClass, String url) {
        this.driverClass = driverClass;
        this.url = url;
    }

    public DriverManagerConnectionProvider() {
    }

    public void init() {
        try {
            Class.forName(this.driverClass);
        }
        catch (ClassNotFoundException cnfex) {
            throw new DbSqlException("Unable to find JDBC driver class: " + this.driverClass, cnfex);
        }
    }

    public Connection getConnection() {
        Connection conn;
        try {
            conn = this.username != null ? DriverManager.getConnection(this.url, this.username, this.password) : DriverManager.getConnection(this.url);
            if (this.isolation != null) {
                conn.setTransactionIsolation(this.isolation);
            }
            if (this.autoCommit != null) {
                conn.setAutoCommit(this.autoCommit);
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to get connection.", sex);
        }
        return conn;
    }

    public void closeConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void close() {
    }
}

