/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import java.io.IOException;
import java.nio.CharBuffer;
import jodd.lagarto.LagartoException;
import jodd.lagarto.LagartoLexer;
import jodd.lagarto.LagartoParserUtil;
import jodd.lagarto.ParsedTag;
import jodd.lagarto.TagType;
import jodd.lagarto.TagVisitor;
import jodd.lagarto.Token;
import jodd.log.Log;
import jodd.util.StringUtil;

public abstract class LagartoParserEngine {
    private static final Log log = Log.getLogger(LagartoParserEngine.class);
    private static final String HTML_QUOTE = "&quot;";
    private CharSequence input;
    private LagartoLexer lexer;
    private ParsedTag tag;
    private TagVisitor visitor;
    private Token lastToken = Token.UNKNOWN;
    private CharSequence lastText;
    private boolean buffering;
    private int buffTextStart;
    private int buffTextEnd;
    protected boolean enableConditionalComments = true;
    protected boolean calculatePosition;
    protected boolean parseSpecialTagsAsCdata = true;

    protected void initialize(CharBuffer input) {
        this.input = input;
        this.lexer = new LagartoLexer(input);
        this.tag = new ParsedTag(input);
        this.buffering = false;
        this.buffTextStart = 0;
        this.buffTextEnd = 0;
        this.lastText = null;
        this.lastToken = Token.UNKNOWN;
    }

    public LagartoLexer getLexer() {
        return this.lexer;
    }

    public boolean isEnableConditionalComments() {
        return this.enableConditionalComments;
    }

    public void setEnableConditionalComments(boolean enableConditionalComments) {
        this.enableConditionalComments = enableConditionalComments;
    }

    public void setCalculatePosition(boolean calculatePosition) {
        this.calculatePosition = calculatePosition;
    }

    public boolean isCalculatePosition() {
        return this.calculatePosition;
    }

    public void setParseSpecialTagsAsCdata(boolean parseSpecialTagsAsCdata) {
        this.parseSpecialTagsAsCdata = parseSpecialTagsAsCdata;
    }

    public boolean isParseSpecialTagsAsCdata() {
        return this.parseSpecialTagsAsCdata;
    }

    protected void parse(TagVisitor visitor) {
        this.visitor = visitor;
        long time = 0L;
        if (log.isDebugEnabled()) {
            log.debug("parsing started");
            time = System.currentTimeMillis();
        }
        try {
            this.parse();
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
        if (log.isDebugEnabled()) {
            if (time != 0L) {
                time = System.currentTimeMillis() - time;
            }
            log.debug("parsing done in " + time + "ms.");
        }
    }

    protected void parse() throws IOException {
        this.lexer.setParseSpecialTagsAsCdata(this.parseSpecialTagsAsCdata);
        this.visitor.start();
        block11: while (true) {
            Token token = this.nextToken();
            switch (token) {
                case EOF: {
                    this.flushText();
                    this.visitor.end();
                    return;
                }
                case COMMENT: {
                    this.parseCommentOrConditionalComment();
                    continue block11;
                }
                case CDATA: {
                    this.parseCDATA();
                    continue block11;
                }
                case DOCTYPE: {
                    this.parseDoctype();
                    continue block11;
                }
                case TEXT: {
                    int start = this.lexer.position();
                    this.parseText(start, start + this.lexer.length());
                    continue block11;
                }
                case LT: {
                    this.parseTag(token, TagType.START);
                    continue block11;
                }
                case XML_LT: {
                    this.parseTag(token, TagType.START);
                    continue block11;
                }
                case CONDITIONAL_COMMENT_START: {
                    this.parseRevealedCCStart();
                    continue block11;
                }
                case CONDITIONAL_COMMENT_END: {
                    this.parseCCEnd();
                    continue block11;
                }
            }
            this.error("Unexpected root token: " + (Object)((Object)token));
        }
    }

    protected void flushText() {
        if (this.buffering) {
            this.visitor.text(this.input.subSequence(this.buffTextStart, this.buffTextEnd));
            this.buffering = false;
        }
    }

    protected void parseText(int start, int end) {
        if (!this.buffering) {
            this.buffering = true;
            this.buffTextStart = start;
            this.buffTextEnd = end;
        } else {
            if (this.buffTextEnd != start) {
                throw new LagartoException();
            }
            this.buffTextEnd = end;
        }
    }

    protected void parseCommentOrConditionalComment() throws IOException {
        this.flushText();
        int start = this.lexer.position() + 4;
        int end = start + this.lexer.length() - 7;
        if (this.enableConditionalComments && LagartoParserUtil.regionStartWith(this.input, start, end, "[if")) {
            int expressionEnd = LagartoParserUtil.regionIndexOf(this.input, start + 3, end, ']');
            int ccend = expressionEnd + 2;
            CharSequence additionalComment = null;
            int commentEnd = LagartoParserUtil.regionIndexOf(this.input, ccend, end, "<![endif]");
            if (commentEnd == -1) {
                additionalComment = this.input.subSequence(ccend, end + 3);
            }
            this.visitor.condComment(this.input.subSequence(start + 1, expressionEnd), true, true, additionalComment);
            if (additionalComment == null) {
                int pushBack = this.lexer.position() + this.lexer.length();
                this.lexer.yypushback(pushBack -= ccend);
            }
            return;
        }
        this.visitor.comment(this.input.subSequence(start, end));
    }

    protected void parseCDATA() throws IOException {
        this.flushText();
        int start = this.lexer.position() + 9;
        int end = start + this.lexer.length() - 12;
        this.visitor.cdata(this.input.subSequence(start, end));
    }

    protected void parseDoctype() throws IOException {
        this.flushText();
        this.skipWhiteSpace();
        String name = null;
        boolean isPublic = false;
        String publicId = null;
        String uri = null;
        int i = 0;
        while (true) {
            this.skipWhiteSpace();
            Token token = this.nextToken();
            if (token == Token.GT) break;
            switch (i) {
                case 0: {
                    name = ((Object)this.text()).toString();
                    break;
                }
                case 1: {
                    if (!((Object)this.text()).toString().equals("PUBLIC")) break;
                    isPublic = true;
                    break;
                }
                case 2: {
                    if (isPublic) {
                        publicId = this.lexer.yytext(1, 1);
                        break;
                    }
                    uri = this.lexer.yytext(1, 1);
                    break;
                }
                case 3: {
                    uri = this.lexer.yytext(1, 1);
                }
            }
            ++i;
        }
        this.visitor.doctype(name, publicId, uri);
    }

    protected void parseRevealedCCStart() throws IOException {
        this.flushText();
        if (!this.enableConditionalComments) {
            this.error("Conditional comments disabled");
            return;
        }
        int start = this.lexer.position();
        int end = start + this.lexer.length();
        int textStart = start;
        int textEnd = end;
        int i = start + 2;
        while (i < end) {
            if (this.input.charAt(i) == '[') {
                textStart = ++i;
                continue;
            }
            if (this.input.charAt(i) == ']') {
                textEnd = i;
                break;
            }
            ++i;
        }
        this.visitor.condComment(this.input.subSequence(textStart, textEnd), true, false, null);
    }

    protected void parseCCEnd() throws IOException {
        boolean hasExtra;
        this.flushText();
        int start = this.lexer.position();
        int end = start + this.lexer.length();
        int textStart = start;
        int textEnd = end;
        int i = start + 2;
        while (i < end) {
            if (this.input.charAt(i) == '[') {
                textStart = ++i;
                continue;
            }
            if (this.input.charAt(i) == ']') {
                textEnd = i;
                break;
            }
            ++i;
        }
        boolean isDownlevelHidden = end - textEnd == 4;
        boolean bl = hasExtra = textStart - start > 3;
        if (!this.enableConditionalComments) {
            if (isDownlevelHidden) {
                this.visitor.comment(this.input.subSequence(start, end));
            } else {
                this.error("Conditional comments disabled");
            }
            return;
        }
        CharSequence additionalComment = null;
        if (hasExtra) {
            additionalComment = this.input.subSequence(start, textStart - 3);
        }
        this.visitor.condComment(this.input.subSequence(textStart, textEnd), false, isDownlevelHidden, additionalComment);
    }

    protected void parseTag(Token tagToken, TagType type) throws IOException {
        int start = this.lexer.position();
        this.skipWhiteSpace();
        Token token = this.nextToken();
        if (this.lexer.nextTagState == -1) {
            this.lexer.nextTagState = -2;
        }
        if (token == Token.SLASH) {
            type = TagType.END;
            token = this.nextToken();
        }
        switch (token) {
            case WORD: {
                String tagName = ((Object)this.text()).toString();
                if (this.acceptTag(tagName)) {
                    this.parseTagAndAttributes(tagToken, tagName, type, start);
                    break;
                }
                this.lexer.stateReset();
                this.stepBack(this.lexer.nextToken());
                this.parseText(start, this.lexer.position());
                break;
            }
            case GT: {
                this.parseText(start, this.lexer.position() + 1);
                break;
            }
            case EOF: {
                this.parseText(start, this.lexer.position());
                break;
            }
            default: {
                this.error("Invalid token in tag <" + this.text() + '>');
                this.lexer.stateReset();
                this.stepBack(this.lexer.nextToken());
                this.parseText(start, this.lexer.position());
            }
        }
    }

    protected boolean acceptTag(String tagName) {
        return true;
    }

    protected void parseTagAndAttributes(Token tagToken, String tagName, TagType type, int start) throws IOException {
        Token token;
        this.tag.startTag(tagName);
        block12: while (true) {
            this.skipWhiteSpace();
            token = this.nextToken();
            this.stepBack(token);
            switch (token) {
                case SLASH: {
                    type = TagType.SELF_CLOSING;
                    this.nextToken();
                    break block12;
                }
                case GT: {
                    break block12;
                }
                case XML_GT: {
                    break block12;
                }
                case WORD: {
                    this.parseAttribute();
                    continue block12;
                }
                case EOF: {
                    this.parseText(start, this.lexer.position());
                    return;
                }
                default: {
                    String tokenText = ((Object)this.text()).toString();
                    if (tokenText == null) {
                        tokenText = this.lexer.yytext();
                    }
                    this.error("Tag <" + tagName + "> invalid token: " + tokenText);
                    this.nextToken();
                    if (tokenText.length() <= 1) continue block12;
                    this.lexer.yypushback(tokenText.length() - 1);
                    continue block12;
                }
            }
            break;
        }
        token = this.nextToken();
        if (tagToken == Token.LT && token == Token.XML_GT) {
            token = Token.GT;
            this.error("Unmatched tag <" + tagName + "?>");
        } else if (tagToken == Token.XML_LT && token == Token.GT) {
            token = Token.XML_GT;
            this.error("Unmatched tag <?" + tagName + '>');
        }
        switch (token) {
            default: {
                this.error("Expected end of tag for <" + tagName + '>');
            }
            case GT: {
                int nextTagState;
                this.flushText();
                int len = this.lexer.position() - start + 1;
                if (type.isStartingTag() && (nextTagState = this.lexer.getNextTagState()) > 0) {
                    this.tag.defineTag(type, start, len);
                    this.tag.increaseDeepLevel();
                    this.parseSpecialTag(nextTagState);
                    this.tag.decreaseDeepLevel();
                    break;
                }
                this.tag.defineTag(type, start, len);
                if (type.isStartingTag()) {
                    this.tag.increaseDeepLevel();
                }
                this.visitor.tag(this.tag);
                if (!type.isEndingTag()) break;
                this.tag.decreaseDeepLevel();
                break;
            }
            case XML_GT: {
                this.flushText();
                int len2 = this.lexer.position() - start + 2;
                this.tag.defineTag(type, start, len2);
                this.tag.setTagMarks("<?", "?>");
                this.tag.increaseDeepLevel();
                this.visitor.xml(this.tag);
                this.tag.decreaseDeepLevel();
                break;
            }
            case EOF: {
                this.parseText(start, this.lexer.position());
            }
        }
    }

    protected void parseAttribute() throws IOException {
        this.nextToken();
        String attributeName = ((Object)this.text()).toString();
        this.skipWhiteSpace();
        Token token = this.nextToken();
        if (token == Token.EQUALS) {
            this.skipWhiteSpace();
            token = this.nextToken();
            if (token == Token.QUOTE) {
                CharSequence charSequence = this.text();
                char quote = charSequence.charAt(0);
                charSequence = charSequence.subSequence(1, charSequence.length() - 1);
                String attributeValue = ((Object)charSequence).toString();
                if (quote == '\'') {
                    attributeValue = StringUtil.replace((String)attributeValue, (String)"\"", (String)HTML_QUOTE);
                }
                this.tag.addAttribute(attributeName, attributeValue);
            } else if (token == Token.WORD) {
                Token next;
                String attributeValue = ((Object)this.text()).toString();
                while ((next = this.nextToken()) != Token.WHITESPACE && next != Token.GT) {
                    attributeValue = attributeValue + this.text();
                }
                this.stepBack(next);
                this.tag.addAttribute(attributeName, attributeValue);
            } else if (token == Token.SLASH || token == Token.GT) {
                this.stepBack(token);
            } else if (token != Token.EOF) {
                this.error("Invalid attribute: " + attributeName);
            }
        } else if (token == Token.SLASH || token == Token.GT || token == Token.WORD) {
            this.tag.addAttribute(attributeName, null);
            this.stepBack(token);
        } else if (token == Token.QUOTE) {
            this.error("Orphan attribute: " + this.text());
            this.tag.addAttribute(attributeName, null);
        } else if (token != Token.EOF) {
            this.error("Invalid attribute: " + attributeName);
        }
    }

    protected void parseSpecialTag(int state) throws IOException {
        int start = this.lexer.position() + 1;
        this.nextToken();
        int end = start + this.lexer.length();
        switch (state) {
            case 6: {
                this.visitor.xmp(this.tag, this.input.subSequence(start, end - 6));
                break;
            }
            case 8: {
                this.visitor.script(this.tag, this.input.subSequence(start, end - 9));
                break;
            }
            case 10: {
                this.visitor.style(this.tag, this.input.subSequence(start, end - 8));
            }
        }
    }

    private void stepBack(Token next) {
        if (this.lastToken != Token.UNKNOWN) {
            throw new LagartoException("Only one step back allowed.");
        }
        this.lastToken = next;
        this.lastText = next == Token.WORD || next == Token.QUOTE || next == Token.SLASH || next == Token.EQUALS ? this.lexer.xxtext() : null;
    }

    protected Token nextToken() throws IOException {
        Token next;
        if (this.lastToken == Token.UNKNOWN) {
            next = this.lexer.nextToken();
        } else {
            next = this.lastToken;
            this.lastToken = Token.UNKNOWN;
        }
        return next;
    }

    protected void skipWhiteSpace() throws IOException {
        Token next;
        while ((next = this.nextToken()) == Token.WHITESPACE) {
        }
        this.stepBack(next);
    }

    protected CharSequence text() {
        if (this.lastToken == Token.UNKNOWN) {
            return this.lexer.xxtext();
        }
        return this.lastText;
    }

    protected void error(String message) {
        int line = this.lexer.line();
        int column = this.lexer.column();
        if (message == null) {
            message = "";
        }
        if (line != -1) {
            message = message + " [" + line + ':' + column + ']';
        } else {
            int position = this.lexer.position();
            if (!this.calculatePosition) {
                message = message + " [@" + position + ']';
            } else {
                LagartoLexer.Position currentPosition = this.lexer.currentPosition();
                message = message + ' ' + currentPosition.toString();
            }
        }
        this.visitor.error(message);
    }
}

