/*
 * Decompiled with CFR 0.152.
 */
package jodd.log;

import jodd.log.Log;
import org.slf4j.Logger;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLog
extends Log {
    private static final String FQCN = Slf4jLog.class.getName();
    private final Logger logger;
    private final LocationAwareLogger locationAwareLogger;

    public Slf4jLog(Logger logger) {
        super(logger.getName());
        this.logger = logger;
        this.locationAwareLogger = logger instanceof LocationAwareLogger ? (LocationAwareLogger)logger : null;
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String message) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 0, message, null, null);
        } else {
            this.logger.trace(message);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String message) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 10, message, null, null);
        } else {
            this.logger.debug(message);
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String message) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 20, message, null, null);
        } else {
            this.logger.info(message);
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String message) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 30, message, null, null);
        } else {
            this.logger.warn(message);
        }
    }

    public void warn(String message, Throwable throwable) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 30, message, null, throwable);
        } else {
            this.logger.warn(message, throwable);
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String message) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 40, message, null, null);
        } else {
            this.logger.error(message);
        }
    }

    public void error(String message, Throwable throwable) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 40, message, null, throwable);
        } else {
            this.logger.error(message, throwable);
        }
    }
}

