/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.result.ActionResult;
import jodd.servlet.DispatcherUtil;

public class ServletDispatcherResult
extends ActionResult {
    public static final String NAME = "dispatch";
    protected static final String EXTENSION = ".jsp";

    public ServletDispatcherResult() {
        super(NAME);
    }

    public void render(ActionRequest actionRequest, Object resultObject, String resultValue, String resultPath) throws Exception {
        String target;
        HttpServletRequest request = actionRequest.getHttpServletRequest();
        HttpServletResponse response = actionRequest.getHttpServletResponse();
        String originalResultPath = resultPath;
        while (true) {
            int dotNdx;
            target = resultPath + EXTENSION;
            try {
                if (this.locateTarget(request, target) != null) {
                    break;
                }
            }
            catch (MalformedURLException muex) {
                // empty catch block
            }
            if ((dotNdx = MadvocUtil.lastIndexOfDotAfterSlash(resultPath)) == -1) {
                response.sendError(404, "Result '" + originalResultPath + EXTENSION + "' or any its variant not found.");
                return;
            }
            resultPath = resultPath.substring(0, dotNdx);
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher(target);
        if (dispatcher == null) {
            response.sendError(404, "Result '" + target + "' not found.");
            return;
        }
        if (DispatcherUtil.isPageIncluded((HttpServletRequest)request, (HttpServletResponse)response)) {
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        } else {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected URL locateTarget(HttpServletRequest request, String target) throws Exception {
        return request.getSession().getServletContext().getResource(target);
    }
}

