/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.net.AssetURLContext;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.MachineDescription;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.Permission;
import java.util.regex.Pattern;
import jogamp.common.Debug;
import jogamp.common.os.AndroidUtils;
import jogamp.common.os.PlatformPropsImpl;

public class IOUtil {
    public static final boolean DEBUG = Debug.debug("IOUtil");
    public static final String SCHEME_SEPARATOR = ":";
    public static final String FILE_SCHEME = "file";
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String JAR_SCHEME = "jar";
    public static final char JAR_SCHEME_SEPARATOR = '!';
    private static final String java_io_tmpdir_propkey = "java.io.tmpdir";
    private static final String user_home_propkey = "user.home";
    private static final String XDG_CACHE_HOME_envkey = "XDG_CACHE_HOME";
    public static final String tmpSubDir = "jogamp";
    private static final Pattern patternSpaceRaw = Pattern.compile(" ");
    private static final Pattern patternSpaceEnc = Pattern.compile("%20");
    private static final Pattern patternSingleBS = Pattern.compile("\\\\{1}");
    private static final Pattern patternSingleFS = Pattern.compile("/{1}");
    private static File tempRootExec = null;
    private static File tempRootNoexec = null;
    private static volatile boolean tempRootSet = false;

    private IOUtil() {
    }

    private static final Constructor<?> getFOSCtor() {
        Throwable throwable;
        Constructor<?> constructor;
        try {
            constructor = ReflectionUtil.getConstructor("java.io.FileOutputStream", new Class[]{File.class}, true, IOUtil.class.getClassLoader());
            throwable = null;
        }
        catch (Throwable throwable2) {
            constructor = null;
            throwable = throwable2;
        }
        if (DEBUG) {
            System.err.println("IOUtil: java.io.FileOutputStream available: " + (null != constructor));
            if (null != throwable) {
                throwable.printStackTrace();
            }
        }
        return constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyURLConn2File(URLConnection uRLConnection, File file) throws IOException {
        uRLConnection.connect();
        int n = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            n = IOUtil.copyStream2File(bufferedInputStream, file, uRLConnection.getContentLength());
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyStream2File(InputStream inputStream, File file, int n) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            n = IOUtil.copyStream2Stream(inputStream, bufferedOutputStream, n);
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
        return n;
    }

    public static int copyStream2Stream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        return IOUtil.copyStream2Stream(Platform.getMachineDescription().pageSizeInBytes(), inputStream, outputStream, n);
    }

    public static int copyStream2Stream(int n, InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[n];
        int n4 = 0;
        while ((n3 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n3);
            n4 += n3;
        }
        return n4;
    }

    public static byte[] copyStream2ByteArray(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = 0;
        int n2 = inputStream.available();
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        do {
            if (n + n2 > byArray2.length) {
                byArray = new byte[n + n2];
                System.arraycopy(byArray2, 0, byArray, 0, n);
                byArray2 = byArray;
            }
            if ((n3 = inputStream.read(byArray2, n, n2)) < 0) continue;
            n += n3;
        } while ((n2 = inputStream.available()) > 0 && n3 >= 0);
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream) throws IOException {
        return IOUtil.copyStream2ByteBuffer(inputStream, -1);
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream, int n) throws IOException {
        int n2;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (n < (n2 = inputStream.available())) {
            n = n2;
        }
        MachineDescription machineDescription = Platform.getMachineDescription();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(machineDescription.pageAlignedSize(n));
        byte[] byArray = new byte[machineDescription.pageSizeInBytes()];
        int n3 = Math.min(machineDescription.pageSizeInBytes(), n2);
        int n4 = 0;
        do {
            if (n2 > byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(machineDescription.pageAlignedSize(byteBuffer.position() + n2));
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
            }
            if ((n4 = inputStream.read(byArray, 0, n3)) > 0) {
                byteBuffer.put(byArray, 0, n4);
            }
            n2 = inputStream.available();
            n3 = Math.min(machineDescription.pageSizeInBytes(), n2);
        } while (n4 > 0);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String slashify(String string, boolean bl, boolean bl2) throws URISyntaxException {
        String string2 = string.replace('\\', '/');
        if (bl && !string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (bl2 && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return IOUtil.cleanPathString(string2);
    }

    public static URI toURISimple(File file) throws URISyntaxException {
        return new URI(FILE_SCHEME, null, IOUtil.slashify(file.getAbsolutePath(), true, file.isDirectory()), null);
    }

    public static URI toURISimple(String string, String string2, boolean bl) throws URISyntaxException {
        return new URI(string, null, IOUtil.slashify(new File(string2).getAbsolutePath(), true, bl), null);
    }

    public static String getFileSuffix(File file) {
        return IOUtil.getFileSuffix(file.getName());
    }

    public static String getFileSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return IOUtil.toLowerCase(string.substring(n + 1));
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static FileOutputStream getFileOutputStream(File file, boolean bl) throws IOException {
        Constructor<?> constructor = IOUtil.getFOSCtor();
        if (null == constructor) {
            throw new IOException("Cannot open file (" + file + ") for writing, FileOutputStream feature not available.");
        }
        if (file.exists() && !bl) {
            throw new IOException("File already exists (" + file + ") and overwrite=false");
        }
        try {
            return (FileOutputStream)constructor.newInstance(file);
        }
        catch (Exception exception) {
            throw new IOException("error opening " + file + " for write. ", exception);
        }
    }

    public static String getClassFileName(String string) {
        return string.replace('.', '/') + ".class";
    }

    public static URL getClassURL(String string, ClassLoader classLoader) throws IOException {
        URL uRL = classLoader.getResource(IOUtil.getClassFileName(string));
        if (null == uRL) {
            throw new IOException("Cannot not find: " + string);
        }
        return uRL;
    }

    public static String getBasename(String string) throws URISyntaxException {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getDirname(String string) throws URISyntaxException {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    public static URI getURIDirname(URI uRI) throws IllegalArgumentException, URISyntaxException {
        if (null == uRI) {
            throw new IllegalArgumentException("URI is null");
        }
        String string = uRI.toString();
        if (DEBUG) {
            System.err.println("getURIDirname " + uRI + ", extForm: " + string);
        }
        return new URI(IOUtil.getURIDirname(string));
    }

    public static String getURIDirname(String string) throws IllegalArgumentException, URISyntaxException {
        if (null == string) {
            throw new IllegalArgumentException("uriS is null");
        }
        int n = string.lastIndexOf(47);
        if (0 > n && 0 > (n = string.lastIndexOf(58))) {
            throw new IllegalArgumentException("URI does not contain protocol terminator ':', in <" + string + ">");
        }
        string = string.substring(0, n + 1);
        if (DEBUG) {
            System.err.println("getJarURIDirname res: " + string);
        }
        return string;
    }

    public static URL toURL(URI uRI) throws IOException, IllegalArgumentException, URISyntaxException {
        return uRI.toURL();
    }

    public static URLConnection getResource(Class<?> clazz, String string) {
        if (null == string) {
            return null;
        }
        ClassLoader classLoader = null != clazz ? clazz.getClassLoader() : IOUtil.class.getClassLoader();
        URLConnection uRLConnection = null;
        if (null != clazz) {
            String string2 = clazz.getName().replace('.', '/');
            int n = string2.lastIndexOf(47);
            if (n >= 0) {
                String string3 = string2.substring(0, n + 1);
                uRLConnection = IOUtil.getResource(string3 + string, classLoader);
                if (DEBUG) {
                    System.err.println("IOUtil: found <" + string + "> within class package <" + string3 + "> of given class <" + clazz.getName() + ">: " + (null != uRLConnection));
                }
            }
        } else if (DEBUG) {
            System.err.println("IOUtil: null context");
        }
        if (null == uRLConnection) {
            uRLConnection = IOUtil.getResource(string, classLoader);
            if (DEBUG) {
                System.err.println("IOUtil: found <" + string + "> by classloader: " + (null != uRLConnection));
            }
        }
        return uRLConnection;
    }

    public static URLConnection getResource(String string, ClassLoader classLoader) {
        if (null == string) {
            return null;
        }
        if (DEBUG) {
            System.err.println("IOUtil: locating <" + string + ">, has cl: " + (null != classLoader));
        }
        if (string.startsWith("asset:")) {
            try {
                return AssetURLContext.createURL(string, classLoader).openConnection();
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    System.err.println("IOUtil: Caught Exception:");
                    iOException.printStackTrace();
                }
                return null;
            }
        }
        try {
            return AssetURLContext.resolve(string, classLoader);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                System.err.println("IOUtil: Caught Exception:");
                iOException.printStackTrace();
            }
            return null;
        }
    }

    public static String getRelativeOf(File file, String string) throws URISyntaxException {
        if (null == string) {
            return null;
        }
        if (file != null) {
            File file2 = new File(file, string);
            return IOUtil.slashify(file2.getPath(), false, false);
        }
        return null;
    }

    public static String getParentOf(String string) throws URISyntaxException {
        int n;
        int n2 = n = null != string ? string.length() : 0;
        if (n == 0) {
            throw new IllegalArgumentException("path is empty <" + string + ">");
        }
        int n3 = string.lastIndexOf("/");
        if (n3 < 0) {
            throw new URISyntaxException(string, "path contains no '/'");
        }
        if (n3 == 0) {
            throw new URISyntaxException(string, "path has no parents");
        }
        if (n3 < n - 1) {
            return string.substring(0, n3 + 1);
        }
        int n4 = string.lastIndexOf("!") + 1;
        int n5 = string.lastIndexOf("/", n3 - 1);
        if (n5 >= n4) {
            return string.substring(0, n5 + 1);
        }
        throw new URISyntaxException(string, "parent of path contains no '/'");
    }

    public static String cleanPathString(String string) throws URISyntaxException {
        int n;
        while ((n = string.indexOf("../")) >= 0) {
            string = IOUtil.getParentOf(string.substring(0, n)) + string.substring(n + 3);
        }
        while ((n = string.indexOf("./")) >= 0) {
            string = string.substring(0, n) + string.substring(n + 2);
        }
        return string;
    }

    public static URI getRelativeOf(URI uRI, String string) throws URISyntaxException {
        return IOUtil.compose(uRI.getScheme(), uRI.getRawSchemeSpecificPart(), string, uRI.getRawFragment());
    }

    public static URL getRelativeOf(URL uRL, String string) throws IOException {
        try {
            return IOUtil.getRelativeOf(uRL.toURI(), string).toURL();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException);
        }
    }

    public static URI compose(String string, String string2, String string3, String string4) throws URISyntaxException {
        String string5;
        int n = string2.lastIndexOf(63);
        if (n >= 0) {
            string5 = string2.substring(n + 1);
            string2 = string2.substring(0, n);
        } else {
            string5 = null;
        }
        if (null != string3) {
            if (!string2.endsWith("/")) {
                string2 = IOUtil.getParentOf(string2);
            }
            string2 = string2 + string3;
        }
        string2 = IOUtil.cleanPathString(string2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(string2);
        if (null != string5) {
            stringBuilder.append('?');
            stringBuilder.append(string5);
        }
        if (null != string4) {
            stringBuilder.append('#');
            stringBuilder.append(string4);
        }
        return new URI(stringBuilder.toString());
    }

    public static String encodeToURI(String string) {
        return patternSpaceRaw.matcher(string).replaceAll("%20");
    }

    public static String decodeFromURI(String string) {
        return patternSpaceEnc.matcher(string).replaceAll(" ");
    }

    public static String encodeFilePathToURI(String string) {
        if (File.separator.equals("\\")) {
            String string2 = patternSingleBS.matcher(string).replaceAll("/");
            if (!string2.startsWith("/")) {
                return "/" + string2;
            }
            return string2;
        }
        return string;
    }

    public static String decodeURIToFilePath(String string) {
        String string2 = patternSpaceEnc.matcher(string).replaceAll(" ");
        if (File.separator.equals("\\")) {
            String string3 = patternSingleFS.matcher(string2).replaceAll("\\\\");
            if (string3.startsWith("\\") && !string3.startsWith("\\\\")) {
                return string3.substring(1);
            }
            return string3;
        }
        return string2;
    }

    public static String decodeURIIfFilePath(URI uRI) {
        if (FILE_SCHEME.equals(uRI.getScheme())) {
            String string = uRI.getAuthority();
            String string2 = null == string ? "" : "//" + string;
            String string3 = patternSpaceEnc.matcher(string2 + uRI.getPath()).replaceAll(" ");
            if (File.separator.equals("\\")) {
                String string4 = patternSingleFS.matcher(string3).replaceAll("\\\\");
                if (string4.startsWith("\\") && !string4.startsWith("\\\\")) {
                    return string4.substring(1);
                }
                return string4;
            }
            return string3;
        }
        return uRI.toASCIIString();
    }

    public static URLConnection openURL(URL uRL) {
        return IOUtil.openURL(uRL, ".");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URLConnection openURL(URL uRL, String string) {
        if (null != uRL) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                if (!DEBUG) return uRLConnection;
                System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - true");
                return uRLConnection;
            }
            catch (IOException iOException) {
                if (!DEBUG) return null;
                System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - false - " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
                iOException.printStackTrace();
                return null;
            }
        } else {
            if (!DEBUG) return null;
            System.err.println("IOUtil: no url - urlExists(null) [" + string + "]");
        }
        return null;
    }

    private static String getShellSuffix() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                return ".bat";
            }
        }
        return ".sh";
    }

    private static String getShellCode() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                return "echo off" + PlatformPropsImpl.NEWLINE;
            }
        }
        return null;
    }

    private static boolean getOSHasNoexecFS() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case OPENKODE: {
                return false;
            }
        }
        return true;
    }

    private static boolean getOSHasFreeDesktopXDG() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: 
            case OPENKODE: 
            case ANDROID: 
            case MACOS: {
                return false;
            }
        }
        return true;
    }

    public static boolean testFile(File file, boolean bl, boolean bl2) {
        if (!file.exists()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: does not exist");
            }
            return false;
        }
        if (bl && !file.isDirectory()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: is not a directory");
            }
            return false;
        }
        if (bl2 && !file.canWrite()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: is not writable");
            }
            return false;
        }
        return true;
    }

    public static boolean testDirExec(File file) throws SecurityException {
        int n;
        long l;
        File file2;
        long l2;
        block14: {
            if (!IOUtil.testFile(file, true, true)) {
                if (DEBUG) {
                    System.err.println("IOUtil.testDirExec: <" + file.getAbsolutePath() + ">: Not writeable dir");
                }
                return false;
            }
            if (!IOUtil.getOSHasNoexecFS()) {
                if (DEBUG) {
                    System.err.println("IOUtil.testDirExec: <" + file.getAbsolutePath() + ">: Always executable");
                }
                return true;
            }
            l2 = DEBUG ? System.currentTimeMillis() : 0L;
            try {
                file2 = File.createTempFile("jogamp_exe_tst", IOUtil.getShellSuffix(), file);
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    iOException.printStackTrace();
                }
                return false;
            }
            l = DEBUG ? System.currentTimeMillis() : 0L;
            n = -1;
            if (file2.setExecutable(true, true)) {
                String string = IOUtil.getShellCode();
                try {
                    Object object;
                    if (IOUtil.isStringSet(string)) {
                        object = new FileWriter(file2);
                        ((Writer)object).write(string);
                        ((OutputStreamWriter)object).close();
                    }
                    object = Runtime.getRuntime().exec(file2.getCanonicalPath());
                    ((Process)object).waitFor();
                    n = ((Process)object).exitValue();
                }
                catch (SecurityException securityException) {
                    throw securityException;
                }
                catch (Throwable throwable) {
                    n = -2;
                    if (!DEBUG) break block14;
                    System.err.println("IOUtil.testDirExec: <" + file2.getAbsolutePath() + ">: Caught " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
                }
            }
        }
        long l3 = DEBUG ? System.currentTimeMillis() : 0L;
        file2.delete();
        if (DEBUG) {
            System.err.println("IOUtil.testDirExec(): <" + file.getAbsolutePath() + ">: res " + n);
            System.err.println("IOUtil.testDirExec(): total " + (l3 - l2) + "ms, create " + (l - l2) + "ms, execute " + (l3 - l) + "ms");
        }
        return 0 == n;
    }

    private static File testDirImpl(File file, boolean bl, boolean bl2, String string) throws SecurityException {
        File file2;
        if (bl && !file.exists()) {
            file.mkdirs();
        }
        if (bl2) {
            file2 = IOUtil.testDirExec(file) ? file : null;
        } else {
            File file3 = file2 = IOUtil.testFile(file, true, true) ? file : null;
        }
        if (DEBUG) {
            System.err.println("IOUtil.testDirImpl(" + string + "): <" + file.getAbsolutePath() + ">, create " + bl + ", exec " + bl2 + ": " + (null != file2));
        }
        return file2;
    }

    public static File testDir(File file, boolean bl, boolean bl2) throws SecurityException {
        return IOUtil.testDirImpl(file, bl, bl2, "testDir");
    }

    private static boolean isStringSet(String string) {
        return null != string && 0 < string.length();
    }

    private static File getSubTempDir(File file, String string, boolean bl, String string2) throws SecurityException {
        File file2 = null;
        if (null != IOUtil.testDirImpl(file, true, bl, string2)) {
            for (int i = 0; null == file2 && i <= 9999; ++i) {
                String string3 = String.format("_%04d", i);
                file2 = IOUtil.testDirImpl(new File(file, string + string3), true, bl, string2);
            }
        }
        return file2;
    }

    private static File getFile(String string) {
        if (IOUtil.isStringSet(string)) {
            return new File(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static File getTempDir(boolean bl) throws SecurityException, RuntimeException {
        Serializable serializable;
        Object object;
        if (!tempRootSet) {
            object = IOUtil.class;
            // MONITORENTER : com.jogamp.common.util.IOUtil.class
            if (!tempRootSet) {
                Object object2;
                String string;
                Object object3;
                Object object4;
                tempRootSet = true;
                serializable = AndroidUtils.getTempRoot();
                if (null != serializable) {
                    tempRootExec = tempRootNoexec = IOUtil.getSubTempDir(serializable, tmpSubDir, false, "Android.ctxTemp");
                    // MONITOREXIT : object
                    return tempRootExec;
                }
                serializable = IOUtil.getFile(PropertyAccess.getProperty(java_io_tmpdir_propkey, false));
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX1 <" + serializable + ">, used " + (null != serializable));
                }
                if (!IOUtil.isStringSet((String)(object4 = System.getenv("TMPDIR")))) {
                    object4 = System.getenv("TEMP");
                }
                File file = null != (object3 = IOUtil.getFile((String)object4)) && !((File)object3).equals(serializable) ? object3 : null;
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX3 <" + object3 + ">, used " + (null != file));
                }
                object4 = IOUtil.getFile(PropertyAccess.getProperty(user_home_propkey, false));
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX4 <" + object4 + ">, used " + (null != object4));
                }
                if (IOUtil.getOSHasFreeDesktopXDG()) {
                    string = System.getenv(XDG_CACHE_HOME_envkey);
                    if (!IOUtil.isStringSet(string) && null != object4) {
                        string = ((File)object4).getAbsolutePath() + File.separator + ".cache";
                    }
                } else {
                    string = null;
                }
                object3 = null != (object2 = IOUtil.getFile(string)) && !((File)object2).equals(serializable) ? object2 : null;
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX2 <" + object2 + ">, used " + (null != object3));
                }
                if (null == tempRootExec && null != serializable) {
                    tempRootExec = Platform.OSType.MACOS == PlatformPropsImpl.OS_TYPE ? IOUtil.getSubTempDir(serializable, tmpSubDir, false, "tempX1") : IOUtil.getSubTempDir(serializable, tmpSubDir, true, "tempX1");
                }
                if (null == tempRootExec && null != object3) {
                    tempRootExec = IOUtil.getSubTempDir((File)object3, tmpSubDir, true, "tempX2");
                }
                if (null == tempRootExec && null != file) {
                    tempRootExec = IOUtil.getSubTempDir(file, tmpSubDir, true, "tempX3");
                }
                if (null == tempRootExec && null != object4) {
                    tempRootExec = IOUtil.getSubTempDir((File)object4, ".jogamp", true, "tempX4");
                }
                if (null != tempRootExec) {
                    tempRootNoexec = tempRootExec;
                } else {
                    if (null == tempRootNoexec && null != serializable) {
                        tempRootNoexec = IOUtil.getSubTempDir(serializable, tmpSubDir, false, "temp01");
                    }
                    if (null == tempRootNoexec && null != object3) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object3, tmpSubDir, false, "temp02");
                    }
                    if (null == tempRootNoexec && null != file) {
                        tempRootNoexec = IOUtil.getSubTempDir(file, tmpSubDir, false, "temp03");
                    }
                    if (null == tempRootNoexec && null != object4) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object4, ".jogamp", false, "temp04");
                    }
                }
                if (DEBUG) {
                    string = null != tempRootExec ? tempRootExec.getAbsolutePath() : null;
                    object2 = null != tempRootNoexec ? tempRootNoexec.getAbsolutePath() : null;
                    System.err.println("IOUtil.getTempRoot(): temp dirs: exec: " + string + ", noexec: " + (String)object2);
                }
            }
            // MONITOREXIT : object
        }
        Object object5 = object = bl ? tempRootExec : tempRootNoexec;
        if (null == object) {
            throw new RuntimeException("Could not determine a temporary directory");
        }
        serializable = new FilePermission(((File)object).getAbsolutePath(), "read,write,delete");
        SecurityUtil.checkPermission((Permission)serializable);
        return object;
    }

    public static File createTempFile(String string, String string2, boolean bl) throws IllegalArgumentException, IOException, SecurityException {
        return File.createTempFile(string, string2, IOUtil.getTempDir(bl));
    }

    public static void close(Closeable closeable, boolean bl) throws RuntimeException {
        block4: {
            if (null != closeable) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (bl) {
                        throw new RuntimeException(iOException);
                    }
                    if (!DEBUG) break block4;
                    System.err.println("Caught Exception: ");
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static class StreamMonitor
    implements Runnable {
        private final InputStream[] istreams;
        private final PrintStream ostream;
        private final String prefix;

        public StreamMonitor(InputStream[] inputStreamArray, PrintStream printStream, String string) {
            this.istreams = inputStreamArray;
            this.ostream = printStream;
            this.prefix = string;
            new Thread((Runnable)this, "StreamMonitor-" + Thread.currentThread().getName()).start();
        }

        @Override
        public void run() {
            byte[] byArray = new byte[4096];
            try {
                int n;
                do {
                    n = 0;
                    for (int i = 0; i < this.istreams.length; ++i) {
                        int n2 = this.istreams[i].read(byArray);
                        if (n2 <= 0) continue;
                        if (null != this.ostream) {
                            if (null != this.prefix) {
                                this.ostream.write(this.prefix.getBytes());
                            }
                            this.ostream.write(byArray, 0, n2);
                        }
                        n += n2;
                    }
                    if (null == this.ostream) continue;
                    this.ostream.flush();
                } while (n >= 0);
            }
            catch (IOException iOException) {
                for (int i = 0; i < this.istreams.length; ++i) {
                    try {
                        this.istreams[i].close();
                        continue;
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class ClassResources {
        public final Class<?> contextCL;
        public final String[] resourcePaths;

        public final int resourceCount() {
            return this.resourcePaths.length;
        }

        public ClassResources(Class<?> clazz, String[] stringArray) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (null != stringArray[i]) continue;
                throw new IllegalArgumentException("resourcePath[" + i + "] is null");
            }
            this.contextCL = clazz;
            this.resourcePaths = stringArray;
        }

        public URLConnection resolve(int n) throws ArrayIndexOutOfBoundsException {
            return IOUtil.getResource(this.contextCL, this.resourcePaths[n]);
        }
    }
}

