/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.egl;

import javax.media.nativewindow.DefaultGraphicsDevice;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;

public class EGLGraphicsDevice
extends DefaultGraphicsDevice
implements Cloneable {
    final long[] nativeDisplayID = new long[1];
    final EGLDisplayLifecycleCallback eglLifecycleCallback;

    public EGLGraphicsDevice() {
        super(NativeWindowFactory.TYPE_EGL, "decon", 0);
        this.nativeDisplayID[0] = 0L;
        this.eglLifecycleCallback = null;
    }

    public EGLGraphicsDevice(long l, long l2, String string, int n, EGLDisplayLifecycleCallback eGLDisplayLifecycleCallback) {
        super(NativeWindowFactory.TYPE_EGL, string, n, l2);
        this.nativeDisplayID[0] = l;
        this.eglLifecycleCallback = eGLDisplayLifecycleCallback;
    }

    public long getNativeDisplayID() {
        return this.nativeDisplayID[0];
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean open() {
        if (null != this.eglLifecycleCallback && 0L == this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - EGLGraphicsDevice.open(): " + this);
            }
            this.handle = this.eglLifecycleCallback.eglGetAndInitDisplay(this.nativeDisplayID);
            if (0L == this.handle) {
                throw new NativeWindowException("EGLGraphicsDevice.open() failed: " + this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean close() {
        if (null != this.eglLifecycleCallback && 0L != this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - EGLGraphicsDevice.close(): " + this);
            }
            this.eglLifecycleCallback.eglTerminate(this.handle);
        }
        return super.close();
    }

    @Override
    public String toString() {
        return "EGLGraphicsDevice[type EGL, connection " + this.getConnection() + ", unitID " + this.getUnitID() + ", handle 0x" + Long.toHexString(this.getHandle()) + ", nativeDisplayID 0x" + Long.toHexString(this.nativeDisplayID[0]) + ", eglLifecycleCallback " + (null != this.eglLifecycleCallback) + "]";
    }

    public static interface EGLDisplayLifecycleCallback {
        public long eglGetAndInitDisplay(long[] var1);

        public void eglTerminate(long var1);
    }
}

