/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.RunnableTask;
import com.jogamp.common.util.locks.Lock;
import com.jogamp.newt.util.EDTUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.media.nativewindow.NativeWindowException;
import jogamp.common.util.locks.LockDebugUtil;
import jogamp.newt.Debug;

public class DefaultEDTUtil
implements EDTUtil {
    public static final boolean DEBUG = Debug.debug("EDT");
    private final Object edtLock = new Object();
    private final ThreadGroup threadGroup;
    private final String name;
    private final Runnable dispatchMessages;
    private NEDT edt = null;
    private int start_iter = 0;
    private static long pollPeriod = 10L;
    private static Runnable nullTask = new Runnable(){

        @Override
        public void run() {
        }
    };

    public DefaultEDTUtil(ThreadGroup threadGroup, String string, Runnable runnable) {
        this.threadGroup = threadGroup;
        this.name = Thread.currentThread().getName() + "-" + string + "-EDT-";
        this.dispatchMessages = runnable;
        this.edt = new NEDT(this.threadGroup, string);
        this.edt.setDaemon(true);
    }

    @Override
    public final long getPollPeriod() {
        return pollPeriod;
    }

    @Override
    public final void setPollPeriod(long l) {
        pollPeriod = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean restart() throws IllegalStateException {
        Object object = this.edtLock;
        synchronized (object) {
            if (this.edt.isRunning()) {
                throw new IllegalStateException("EDT still running and not subject to stop. Curr " + Thread.currentThread().getName() + ", EDT " + this.edt.getName() + ", isRunning " + this.edt.isRunning + ", shouldStop " + this.edt.shouldStop);
            }
            if (DEBUG) {
                if (this.edt.tasks.size() > 0) {
                    System.err.println(Thread.currentThread() + ": Default-EDT reset, remaining tasks: " + this.edt.tasks.size() + " - " + this.edt);
                }
                System.err.println(Thread.currentThread() + ": Default-EDT reset - edt: " + this.edt);
            }
            if (this.edt.getState() != Thread.State.NEW) {
                this.edt = new NEDT(this.threadGroup, this.name);
                this.edt.setDaemon(true);
            }
            this.startImpl();
        }
        return this.invoke(true, nullTask);
    }

    private final void startImpl() {
        if (this.edt.isAlive()) {
            throw new RuntimeException("Default-EDT Thread.isAlive(): true, isRunning: " + this.edt.isRunning + ", shouldStop " + this.edt.shouldStop + ", edt: " + this.edt + ", tasks: " + this.edt.tasks.size());
        }
        ++this.start_iter;
        this.edt.setName(this.name + this.start_iter);
        if (DEBUG) {
            System.err.println(Thread.currentThread() + ": Default-EDT START - edt: " + this.edt);
        }
        this.edt.start();
    }

    @Override
    public final boolean isCurrentThreadEDT() {
        return this.edt == Thread.currentThread();
    }

    @Override
    public final boolean isCurrentThreadNEDT() {
        return this.edt == Thread.currentThread();
    }

    @Override
    public final boolean isCurrentThreadEDTorNEDT() {
        return this.edt == Thread.currentThread();
    }

    @Override
    public final boolean isRunning() {
        return this.edt.isRunning();
    }

    @Override
    public final boolean invokeStop(boolean bl, Runnable runnable) {
        return this.invokeImpl(bl, runnable, true);
    }

    @Override
    public final boolean invoke(boolean bl, Runnable runnable) {
        return this.invokeImpl(bl, runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean invokeImpl(boolean bl, Runnable runnable, boolean bl2) {
        Object object;
        Throwable throwable = null;
        RunnableTask runnableTask = null;
        Object object2 = object = new Object();
        synchronized (object2) {
            Object object3 = this.edtLock;
            synchronized (object3) {
                if (this.edt.shouldStop) {
                    System.err.println(Thread.currentThread() + ": Warning: Default-EDT about (1) to stop, won't enqueue new task: " + this.edt);
                    if (DEBUG) {
                        Thread.dumpStack();
                    }
                    return false;
                }
                if (this.isCurrentThreadEDT()) {
                    if (null != runnable) {
                        runnable.run();
                    }
                    bl = false;
                    if (bl2) {
                        this.edt.shouldStop = true;
                        if (this.edt.tasks.size() > 0) {
                            System.err.println(Thread.currentThread() + ": Warning: Default-EDT about (2) to stop, task executed. Remaining tasks: " + this.edt.tasks.size() + " - " + this.edt);
                            if (DEBUG) {
                                Thread.dumpStack();
                            }
                        }
                    }
                } else {
                    if (!this.edt.isRunning) {
                        if (null != runnable) {
                            if (bl2) {
                                System.err.println(Thread.currentThread() + ": Warning: Default-EDT is about (3) to stop and stopped already, dropping task. Remaining tasks: " + this.edt.tasks.size() + " - " + this.edt);
                            } else {
                                System.err.println(Thread.currentThread() + ": Warning: Default-EDT is not running, dropping task. NEDT " + this.edt);
                            }
                            if (DEBUG) {
                                Thread.dumpStack();
                            }
                        }
                        return false;
                    }
                    if (bl2 && null == runnable) {
                        runnable = nullTask;
                    }
                    if (null != runnable) {
                        ArrayList<RunnableTask> arrayList = this.edt.tasks;
                        synchronized (arrayList) {
                            runnableTask = new RunnableTask(runnable, bl ? object : null, true, bl ? null : System.err);
                            if (bl2) {
                                runnableTask.setAttachment((Object)new Boolean(true));
                            }
                            this.edt.tasks.add(runnableTask);
                            this.edt.tasks.notifyAll();
                        }
                    } else {
                        bl = false;
                    }
                }
            }
            if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = runnableTask.getThrowable();
                }
                if (null != throwable) {
                    if (throwable instanceof NativeWindowException) {
                        throw (NativeWindowException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
            }
            if (DEBUG && bl2) {
                System.err.println(Thread.currentThread() + ": Default-EDT signal STOP X edt: " + this.edt);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean waitUntilIdle() {
        NEDT nEDT;
        ArrayList<RunnableTask> arrayList = this.edtLock;
        synchronized (arrayList) {
            nEDT = this.edt;
        }
        if (!nEDT.isRunning || nEDT == Thread.currentThread()) {
            return false;
        }
        arrayList = nEDT.tasks;
        synchronized (arrayList) {
            while (nEDT.isRunning && nEDT.tasks.size() > 0) {
                try {
                    nEDT.tasks.notifyAll();
                    nEDT.tasks.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean waitUntilStopped() {
        Object object = this.edtLock;
        synchronized (object) {
            if (this.edt.isRunning && this.edt != Thread.currentThread()) {
                while (this.edt.isRunning) {
                    try {
                        this.edtLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                return true;
            }
            return false;
        }
    }

    class NEDT
    extends Thread {
        volatile boolean shouldStop;
        volatile boolean isRunning;
        ArrayList<RunnableTask> tasks;

        public NEDT(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
            this.shouldStop = false;
            this.isRunning = false;
            this.tasks = new ArrayList();
        }

        public final boolean isRunning() {
            return this.isRunning && !this.shouldStop;
        }

        @Override
        public final void start() throws IllegalThreadStateException {
            this.isRunning = true;
            super.start();
        }

        private final void validateNoRecursiveLocksHold() {
            if (LockDebugUtil.getRecursiveLockTrace().size() > 0) {
                LockDebugUtil.dumpRecursiveLockTrace((PrintStream)System.err);
                throw new InternalError("XXX");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Object object;
            RuntimeException runtimeException;
            block33: {
                if (DEBUG) {
                    System.err.println(this.getName() + ": Default-EDT run() START " + this.getName());
                }
                if (Lock.DEBUG) {
                    this.validateNoRecursiveLocksHold();
                }
                runtimeException = null;
                try {
                    do {
                        if (!this.shouldStop) {
                            DefaultEDTUtil.this.dispatchMessages.run();
                        }
                        object = null;
                        ArrayList<RunnableTask> arrayList = this.tasks;
                        synchronized (arrayList) {
                            if (!this.shouldStop && this.tasks.size() == 0) {
                                try {
                                    this.tasks.wait(pollPeriod);
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            }
                            if (this.tasks.size() > 0) {
                                object = this.tasks.remove(0);
                                this.tasks.notifyAll();
                                if (null != object.getAttachment()) {
                                    this.shouldStop = true;
                                }
                            }
                        }
                        if (null == object) continue;
                        object.run();
                        if (Lock.DEBUG) {
                            this.validateNoRecursiveLocksHold();
                        }
                        if (object.hasWaiter() || null == object.getThrowable()) continue;
                        System.err.println("DefaultEDT.run(): Catched exception occured on thread " + Thread.currentThread().getName() + ": " + object.toString());
                        object.getThrowable().printStackTrace();
                    } while (!this.shouldStop);
                    if (!DEBUG) break block33;
                    object = this.tasks.size() > 0 ? this.tasks.get(0) : null;
                }
                catch (Throwable throwable) {
                    Object object2;
                    block34: {
                        try {
                            this.shouldStop = true;
                            runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException("Within Default-EDT", throwable);
                            if (!DEBUG) break block34;
                            object2 = this.tasks.size() > 0 ? this.tasks.get(0) : null;
                        }
                        catch (Throwable throwable2) {
                            Object object3;
                            if (DEBUG) {
                                object3 = this.tasks.size() > 0 ? this.tasks.get(0) : null;
                                System.err.println(this.getName() + ": Default-EDT run() END " + this.getName() + ", tasks: " + this.tasks.size() + ", " + object3 + ", " + runtimeException);
                            }
                            object3 = DefaultEDTUtil.this.edtLock;
                            synchronized (object3) {
                                this.isRunning = false;
                                DefaultEDTUtil.this.edtLock.notifyAll();
                            }
                            if (DEBUG) {
                                System.err.println(this.getName() + ": Default-EDT run() EXIT " + this.getName() + ", exception: " + runtimeException);
                            }
                            if (null != runtimeException) {
                                throw runtimeException;
                            }
                            throw throwable2;
                        }
                        System.err.println(this.getName() + ": Default-EDT run() END " + this.getName() + ", tasks: " + this.tasks.size() + ", " + object2 + ", " + runtimeException);
                    }
                    object2 = DefaultEDTUtil.this.edtLock;
                    synchronized (object2) {
                        this.isRunning = false;
                        DefaultEDTUtil.this.edtLock.notifyAll();
                    }
                    if (DEBUG) {
                        System.err.println(this.getName() + ": Default-EDT run() EXIT " + this.getName() + ", exception: " + runtimeException);
                    }
                    if (null != runtimeException) {
                        throw runtimeException;
                    }
                }
                System.err.println(this.getName() + ": Default-EDT run() END " + this.getName() + ", tasks: " + this.tasks.size() + ", " + object + ", " + runtimeException);
            }
            object = DefaultEDTUtil.this.edtLock;
            synchronized (object) {
                this.isRunning = false;
                DefaultEDTUtil.this.edtLock.notifyAll();
            }
            if (DEBUG) {
                System.err.println(this.getName() + ": Default-EDT run() EXIT " + this.getName() + ", exception: " + runtimeException);
            }
            if (null != runtimeException) {
                throw runtimeException;
            }
        }
    }
}

