package javax.media.opengl;

import java.io.*;
import javax.media.opengl.*;
import com.jogamp.gluegen.runtime.*;
import java.nio.*;
import javax.media.opengl.GL4;
import javax.media.opengl.GL4bc;
import javax.media.opengl.GL3bc;

/**
 * <p>
 * Composable pipeline which wraps an underlying {@link GL} implementation,
 * providing error checking after each OpenGL method call. If an error occurs,
 * causes a {@link GLException} to be thrown at exactly the point of failure.
 * </p>
 * <p>
 * Sample code which installs this pipeline:
 * <pre>
 *   gl = drawable.setGL(new DebugGL(drawable.getGL()));
 * </pre>
 * For automatic instantiation see {@link GLPipelineFactory#create(String, Class, GL, Object[])}
 * </p>
 */
public class DebugGL4bc implements javax.media.opengl.GL3bc, javax.media.opengl.GL4, javax.media.opengl.GL4bc{
  public static final boolean DEBUG = jogamp.opengl.Debug.debug("DebugGL4bc");
  public DebugGL4bc(GL4bc downstreamGL4bc)
  {
    if (downstreamGL4bc == null) {
      throw new IllegalArgumentException("null downstreamGL4bc");
    }
    this.downstreamGL4bc = downstreamGL4bc;
    // Fetch GLContext object for better error checking (if possible)
    _context = downstreamGL4bc.getContext();
  }

  @Override
  public final boolean isGL() {
    return downstreamGL4bc.isGL();
  }
  @Override
  public final boolean isGL4bc() {
    return downstreamGL4bc.isGL4bc();
  }
  @Override
  public final boolean isGL4() {
    return downstreamGL4bc.isGL4();
  }
  @Override
  public final boolean isGL3bc() {
    return downstreamGL4bc.isGL3bc();
  }
  @Override
  public final boolean isGL3() {
    return downstreamGL4bc.isGL3();
  }
  @Override
  public final boolean isGL2() {
    return downstreamGL4bc.isGL2();
  }
  @Override
  public final boolean isGLES1() {
    return downstreamGL4bc.isGLES1();
  }
  @Override
  public final boolean isGLES2() {
    return downstreamGL4bc.isGLES2();
  }
  @Override
  public final boolean isGLES3() {
    return downstreamGL4bc.isGLES3();
  }
  @Override
  public final boolean isGL2ES1() {
    return downstreamGL4bc.isGL2ES1();
  }
  @Override
  public final boolean isGL2ES2() {
    return downstreamGL4bc.isGL2ES2();
  }
  @Override
  public final boolean isGL2ES3() {
    return downstreamGL4bc.isGL2ES3();
  }
  @Override
  public final boolean isGL3ES3() {
    return downstreamGL4bc.isGL3ES3();
  }
  @Override
  public final boolean isGL4ES3() {
    return downstreamGL4bc.isGL4ES3();
  }
  @Override
  public final boolean isGL2GL3() {
    return downstreamGL4bc.isGL2GL3();
  }
  @Override
  public final boolean isGLES() {
    return downstreamGL4bc.isGLES();
  }
  @Override
  public final boolean isGL4core() {
    return downstreamGL4bc.isGL4core();
  }
  @Override
  public final boolean isGL3core() {
    return downstreamGL4bc.isGL3core();
  }
  @Override
  public final boolean isGLcore() {
    return downstreamGL4bc.isGLcore();
  }
  @Override
  public final boolean isGLES2Compatible() {
    return downstreamGL4bc.isGLES2Compatible();
  }
  @Override
  public final boolean isGLES3Compatible() {
    return downstreamGL4bc.isGLES3Compatible();
  }
  @Override
  public final javax.media.opengl.GL getGL() {
    return downstreamGL4bc.getGL();
  }
  @Override
  public final javax.media.opengl.GL4bc getGL4bc() {
    return downstreamGL4bc.getGL4bc();
  }
  @Override
  public final javax.media.opengl.GL4 getGL4() {
    return downstreamGL4bc.getGL4();
  }
  @Override
  public final javax.media.opengl.GL3bc getGL3bc() {
    return downstreamGL4bc.getGL3bc();
  }
  @Override
  public final javax.media.opengl.GL3 getGL3() {
    return downstreamGL4bc.getGL3();
  }
  @Override
  public final javax.media.opengl.GL2 getGL2() {
    return downstreamGL4bc.getGL2();
  }
  @Override
  public final javax.media.opengl.GLES1 getGLES1() {
    return downstreamGL4bc.getGLES1();
  }
  @Override
  public final javax.media.opengl.GLES2 getGLES2() {
    return downstreamGL4bc.getGLES2();
  }
  @Override
  public final javax.media.opengl.GLES3 getGLES3() {
    return downstreamGL4bc.getGLES3();
  }
  @Override
  public final javax.media.opengl.GL2ES1 getGL2ES1() {
    return downstreamGL4bc.getGL2ES1();
  }
  @Override
  public final javax.media.opengl.GL2ES2 getGL2ES2() {
    return downstreamGL4bc.getGL2ES2();
  }
  @Override
  public final javax.media.opengl.GL2ES3 getGL2ES3() {
    return downstreamGL4bc.getGL2ES3();
  }
  @Override
  public final javax.media.opengl.GL3ES3 getGL3ES3() {
    return downstreamGL4bc.getGL3ES3();
  }
  @Override
  public final javax.media.opengl.GL4ES3 getGL4ES3() {
    return downstreamGL4bc.getGL4ES3();
  }
  @Override
  public final javax.media.opengl.GL2GL3 getGL2GL3() {
    return downstreamGL4bc.getGL2GL3();
  }
  @Override
  public final GL getDownstreamGL() throws GLException {
    return downstreamGL4bc;
  }
  @Override
  public final GLProfile getGLProfile() {
    return downstreamGL4bc.getGLProfile();
  }
  public  void glProgramUniform2ui(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2ui(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform2ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedProgramLocalParameterfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetNamedProgramLocalParameterfvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetNamedProgramLocalParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glCullFace(int arg0)
  {
        checkContext();
downstreamGL4bc.glCullFace(arg0);
    String txt = new String("glCullFace(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBlendEquationSeparateIndexedAMD(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glBlendEquationSeparateIndexedAMD(arg0,arg1,arg2);
    String txt = new String("glBlendEquationSeparateIndexedAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3bOES(byte arg0,byte arg1,byte arg2)
  {
        checkContext();
downstreamGL4bc.glTexCoord3bOES(arg0,arg1,arg2);
    String txt = new String("glTexCoord3bOES(" +
    "<byte> "+arg0 +    ", " +
    "<byte> "+arg1 +    ", " +
    "<byte> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  long glGetImageHandleNV(int arg0,int arg1,boolean arg2,int arg3,int arg4)
  {
        checkContext();
    long _res = downstreamGL4bc.glGetImageHandleNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetImageHandleNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glPixelMapuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glPixelMapuiv(arg0,arg1,arg2);
    String txt = new String("glPixelMapuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glTexParameterfv(arg0,arg1,arg2,arg3);
    String txt = new String("glTexParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexGenfEXT(int arg0,int arg1,int arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexGenfEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexGenfEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedFramebufferTextureFaceEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glNamedFramebufferTextureFaceEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glNamedFramebufferTextureFaceEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4bvOES(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex4bvOES(arg0,arg1);
    String txt = new String("glVertex4bvOES(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribfvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribfvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexAttribfvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4usv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4usv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4usv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3iv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3iv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform3iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1uivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1uivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform1uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantdvEXT(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVariantdvEXT(arg0,arg1);
    String txt = new String("glVariantdvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetObjectLabel(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.ByteBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetObjectLabel(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetObjectLabel(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.ByteBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedProgramStringEXT(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetNamedProgramStringEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetNamedProgramStringEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoordP3ui(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoordP3ui(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoordP3ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos2fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glRasterPos2fv(arg0);
    String txt = new String("glRasterPos2fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureImage2DMultisampleNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,boolean arg6)
  {
        checkContext();
downstreamGL4bc.glTextureImage2DMultisampleNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glTextureImage2DMultisampleNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<boolean> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glEndVertexShaderEXT()
  {
        checkContext();
downstreamGL4bc.glEndVertexShaderEXT();
    String txt = new String("glEndVertexShaderEXT(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glEvalPoint2(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glEvalPoint2(arg0,arg1);
    String txt = new String("glEvalPoint2(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2sv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2sv(arg0,arg1);
    String txt = new String("glMultiTexCoord2sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformfvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetUniformfvARB(arg0,arg1,arg2);
    String txt = new String("glGetUniformfvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4dvARB(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4dvARB(arg0,arg1);
    String txt = new String("glVertexAttrib4dvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveAtomicCounterBufferiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetActiveAtomicCounterBufferiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetActiveAtomicCounterBufferiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultMatrixd(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glMultMatrixd(arg0,arg1);
    String txt = new String("glMultMatrixd(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glClearBufferfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glClearBufferfv(arg0,arg1,arg2);
    String txt = new String("glClearBufferfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnPixelMapfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetnPixelMapfv(arg0,arg1,arg2);
    String txt = new String("glGetnPixelMapfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord1dv(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1dv(arg0,arg1);
    String txt = new String("glMultiTexCoord1dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3d(int arg0,double arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glUniform3d(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform3d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetLocalConstantIntegervEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetLocalConstantIntegervEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetLocalConstantIntegervEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexMask(int arg0)
  {
        checkContext();
downstreamGL4bc.glIndexMask(arg0);
    String txt = new String("glIndexMask(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glClearBufferSubData(int arg0,int arg1,long arg2,long arg3,int arg4,int arg5,java.nio.Buffer arg6)
  {
        checkContext();
downstreamGL4bc.glClearBufferSubData(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glClearBufferSubData(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParameter4dvARB(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParameter4dvARB(arg0,arg1,arg2);
    String txt = new String("glProgramEnvParameter4dvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexLevelParameterivEXT(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexLevelParameterivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMultiTexLevelParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedFramebufferAttachmentParameterivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetNamedFramebufferAttachmentParameterivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetNamedFramebufferAttachmentParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1ui(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glUniform1ui(arg0,arg1);
    String txt = new String("glUniform1ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexGeniv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetTexGeniv(arg0,arg1,arg2);
    String txt = new String("glGetTexGeniv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glEnableVertexAttribArray(int arg0)
  {
        checkContext();
downstreamGL4bc.glEnableVertexAttribArray(arg0);
    String txt = new String("glEnableVertexAttribArray(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDebugMessageControl(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5,boolean arg6)
  {
        checkContext();
downstreamGL4bc.glDebugMessageControl(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glDebugMessageControl(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<boolean> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4ui64NV(int arg0,long arg1,long arg2,long arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glUniform4ui64NV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniform4ui64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glInvalidateFramebuffer(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glInvalidateFramebuffer(arg0,arg1,arg2,arg3);
    String txt = new String("glInvalidateFramebuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribIivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribIivEXT(arg0,arg1,arg2);
    String txt = new String("glGetVertexAttribIivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3fv(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3fv(arg0,arg1);
    String txt = new String("glMultiTexCoord3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glPathGlyphsNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6,int arg7,int arg8,float arg9)
  {
        checkContext();
downstreamGL4bc.glPathGlyphsNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glPathGlyphsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg6 +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<float> "+arg9 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompileShaderIncludeARB(int arg0,int arg1,java.lang.String[] arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glCompileShaderIncludeARB(arg0,arg1,arg2,arg3);
    String txt = new String("glCompileShaderIncludeARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[Ljava.lang.String;>" +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glFogCoordPointer(int arg0,int arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glFogCoordPointer(arg0,arg1,arg2);
    String txt = new String("glFogCoordPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3i64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform3i64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform3i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInvariantIntegervEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetInvariantIntegervEXT(arg0,arg1,arg2);
    String txt = new String("glGetInvariantIntegervEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3dv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform3dv(arg0,arg1,arg2);
    String txt = new String("glUniform3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,long arg8)
  {
        checkContext();
downstreamGL4bc.glTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glTexImage2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<long> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedFramebufferTextureLayerEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glNamedFramebufferTextureLayerEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glNamedFramebufferTextureLayerEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBindBufferBase(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glBindBufferBase(arg0,arg1,arg2);
    String txt = new String("glBindBufferBase(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2x3dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2x3dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix2x3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.DoubleBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetLocalConstantFloatvEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetLocalConstantFloatvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetLocalConstantFloatvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexBindingDivisor(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertexBindingDivisor(arg0,arg1);
    String txt = new String("glVertexBindingDivisor(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramBinary(int arg0,int arg1,java.nio.Buffer arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glProgramBinary(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramBinary(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4fv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPrimitiveRestartNV()
  {
        checkContext();
downstreamGL4bc.glPrimitiveRestartNV();
    String txt = new String("glPrimitiveRestartNV(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glGetVideoCaptureivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVideoCaptureivNV(arg0,arg1,arg2);
    String txt = new String("glGetVideoCaptureivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetFramebufferParameterivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetFramebufferParameterivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetFramebufferParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4hv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord4hv(arg0);
    String txt = new String("glTexCoord4hv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1uiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1uiv(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform1uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glBitmap(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5,byte[] arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glBitmap(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glBitmap(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ", " +
    "<float> "+arg5 +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexGenivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexGenivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexGenivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1uiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform1uiv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform1uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1d(int arg0,double arg1)
  {
        checkContext();
downstreamGL4bc.glUniform1d(arg0,arg1);
    String txt = new String("glUniform1d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexImageEXT(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexImageEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetMultiTexImageEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetLightiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetLightiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetLightiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetConvolutionParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetConvolutionParameterfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetConvolutionParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPathDashArrayNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glPathDashArrayNV(arg0,arg1,arg2);
    String txt = new String("glPathDashArrayNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColorPointer(int arg0,int arg1,int arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glSecondaryColorPointer(arg0,arg1,arg2,arg3);
    String txt = new String("glSecondaryColorPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1fARB(int arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glUniform1fARB(arg0,arg1);
    String txt = new String("glUniform1fARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1f(int arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glUniform1f(arg0,arg1);
    String txt = new String("glUniform1f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform3uiv(arg0,arg1,arg2);
    String txt = new String("glUniform3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4bv(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4bv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI4bv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix4x2fvEXT(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4x2fvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix4x2fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  long glVDPAURegisterOutputSurfaceNV(java.nio.Buffer arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
    long _res = downstreamGL4bc.glVDPAURegisterOutputSurfaceNV(arg0,arg1,arg2,arg3);
    String txt = new String("glVDPAURegisterOutputSurfaceNV(" +
    "<java.nio.Buffer> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glProgramUniform1dv(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1dv(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform1dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL2ui64vNV(int arg0,long[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL2ui64vNV(arg0,arg1,arg2);
    String txt = new String("glVertexAttribL2ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMinmaxParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetMinmaxParameterfv(arg0,arg1,arg2);
    String txt = new String("glGetMinmaxParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  int glRenderMode(int arg0)
  {
        checkContext();
    int _res = downstreamGL4bc.glRenderMode(arg0);
    String txt = new String("glRenderMode(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexAttribP4uiv(int arg0,int arg1,boolean arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribP4uiv(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribP4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferRenderbuffer(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glFramebufferRenderbuffer(arg0,arg1,arg2,arg3);
    String txt = new String("glFramebufferRenderbuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix2x3dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix2x3dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix2x3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBindBufferRange(int arg0,int arg1,int arg2,long arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glBindBufferRange(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glBindBufferRange(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glSeparableFilter2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6,long arg7)
  {
        checkContext();
downstreamGL4bc.glSeparableFilter2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glSeparableFilter2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<long> "+arg6 +    ", " +
    "<long> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glSeparableFilter2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6,java.nio.Buffer arg7)
  {
        checkContext();
downstreamGL4bc.glSeparableFilter2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glSeparableFilter2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg6 +    ", " +
    "<java.nio.Buffer> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2i(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2i(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform2i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsVertexAttribEnabledAPPLE(int arg0,int arg1)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsVertexAttribEnabledAPPLE(arg0,arg1);
    String txt = new String("glIsVertexAttribEnabledAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glDeleteSync(long arg0)
  {
        checkContext();
downstreamGL4bc.glDeleteSync(arg0);
    String txt = new String("glDeleteSync(" +
    "<long> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureMaterialEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTextureMaterialEXT(arg0,arg1);
    String txt = new String("glTextureMaterialEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBufferSubData(int arg0,long arg1,long arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glBufferSubData(arg0,arg1,arg2,arg3);
    String txt = new String("glBufferSubData(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2f(int arg0,int arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2f(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform2f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPolygonStipple(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glGetPolygonStipple(arg0);
    String txt = new String("glGetPolygonStipple(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexPointer(int arg0,int arg1,java.nio.Buffer arg2)
  {
        checkContext();
downstreamGL4bc.glIndexPointer(arg0,arg1,arg2);
    String txt = new String("glIndexPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetColorTableParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetColorTableParameteriv(arg0,arg1,arg2);
    String txt = new String("glGetColorTableParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyImageSubData(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,int arg10,int arg11,int arg12,int arg13,int arg14)
  {
        checkContext();
downstreamGL4bc.glCopyImageSubData(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
    String txt = new String("glCopyImageSubData(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg10).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg11).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg12).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg13).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg14).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2d(int arg0,int arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2d(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform2d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGenQueries(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGenQueries(arg0,arg1,arg2);
    String txt = new String("glGenQueries(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2uivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2uivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform2uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSampleMaski(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glSampleMaski(arg0,arg1);
    String txt = new String("glSampleMaski(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  java.nio.ByteBuffer glMapNamedBufferRangeEXT(int arg0,long arg1,long arg2,int arg3)
  {
        checkContext();
    java.nio.ByteBuffer _res = downstreamGL4bc.glMapNamedBufferRangeEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMapNamedBufferRangeEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetnPixelMapusv(int arg0,int arg1,java.nio.ShortBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetnPixelMapusv(arg0,arg1,arg2);
    String txt = new String("glGetnPixelMapusv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2dv(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2dv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glWeightsvARB(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glWeightsvARB(arg0,arg1,arg2);
    String txt = new String("glWeightsvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPathCommandsNV(int arg0,int arg1,byte[] arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6)
  {
        checkContext();
downstreamGL4bc.glPathCommandsNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glPathCommandsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInternalformati64v(int arg0,int arg1,int arg2,int arg3,long[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetInternalformati64v(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetInternalformati64v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1fv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform1fv(arg0,arg1,arg2);
    String txt = new String("glUniform1fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexWeightPointerEXT(int arg0,int arg1,int arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glVertexWeightPointerEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexWeightPointerEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawElements(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glDrawElements(arg0,arg1,arg2,arg3);
    String txt = new String("glDrawElements(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos2sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glWindowPos2sv(arg0,arg1);
    String txt = new String("glWindowPos2sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3bvOES(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3bvOES(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord3bvOES(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordP1uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoordP1uiv(arg0,arg1);
    String txt = new String("glTexCoordP1uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetFenceivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetFenceivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetFenceivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3f(int arg0,float arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glUniform3f(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform3f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glDisablei(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glDisablei(arg0,arg1);
    String txt = new String("glDisablei(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSamplerParameteri(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glSamplerParameteri(arg0,arg1,arg2);
    String txt = new String("glSamplerParameteri(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordP2uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoordP2uiv(arg0,arg1);
    String txt = new String("glTexCoordP2uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoordP1uiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoordP1uiv(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexCoordP1uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyMultiTexSubImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9)
  {
        checkContext();
downstreamGL4bc.glCopyMultiTexSubImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glCopyMultiTexSubImage3DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelDataRangeNV(int arg0,int arg1,java.nio.Buffer arg2)
  {
        checkContext();
downstreamGL4bc.glPixelDataRangeNV(arg0,arg1,arg2);
    String txt = new String("glPixelDataRangeNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexLevelParameterfv(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetTexLevelParameterfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetTexLevelParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glLinkProgramARB(int arg0)
  {
        checkContext();
downstreamGL4bc.glLinkProgramARB(arg0);
    String txt = new String("glLinkProgramARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix3x4dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix3x4dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix3x4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDispatchComputeIndirect(long arg0)
  {
        checkContext();
downstreamGL4bc.glDispatchComputeIndirect(arg0);
    String txt = new String("glDispatchComputeIndirect(" +
    "<long> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glClearColorIi(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glClearColorIi(arg0,arg1,arg2,arg3);
    String txt = new String("glClearColorIi(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glShaderSourceARB(int arg0,int arg1,java.lang.String[] arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glShaderSourceARB(arg0,arg1,arg2,arg3);
    String txt = new String("glShaderSourceARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[Ljava.lang.String;>" +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glObjectPtrLabel(java.nio.Buffer arg0,int arg1,byte[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glObjectPtrLabel(arg0,arg1,arg2,arg3);
    String txt = new String("glObjectPtrLabel(" +
    "<java.nio.Buffer> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean hasFullFBOSupport()
  {
        return downstreamGL4bc.hasFullFBOSupport();
  }
  public  void glGetIntegerui64i_vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetIntegerui64i_vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetIntegerui64i_vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3ui(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glColor3ui(arg0,arg1,arg2);
    String txt = new String("glColor3ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2bOES(byte arg0,byte arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord2bOES(arg0,arg1);
    String txt = new String("glTexCoord2bOES(" +
    "<byte> "+arg0 +    ", " +
    "<byte> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2dv(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform2dv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetObjectParameterivAPPLE(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetObjectParameterivAPPLE(arg0,arg1,arg2,arg3);
    String txt = new String("glGetObjectParameterivAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4i(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4i(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniform4i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor3fv(arg0);
    String txt = new String("glColor3fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexP4ui(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertexP4ui(arg0,arg1);
    String txt = new String("glVertexP4ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int getSwapInterval()
  {
        return downstreamGL4bc.getSwapInterval();
  }
  public  void glBlendFuncSeparate(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glBlendFuncSeparate(arg0,arg1,arg2,arg3);
    String txt = new String("glBlendFuncSeparate(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDepthRangeArrayv(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glDepthRangeArrayv(arg0,arg1,arg2,arg3);
    String txt = new String("glDepthRangeArrayv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4d(int arg0,int arg1,double arg2,double arg3,double arg4,double arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4d(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniform4d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ", " +
    "<double> "+arg4 +    ", " +
    "<double> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteFramebuffers(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDeleteFramebuffers(arg0,arg1,arg2);
    String txt = new String("glDeleteFramebuffers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glResetHistogram(int arg0)
  {
        checkContext();
downstreamGL4bc.glResetHistogram(arg0);
    String txt = new String("glResetHistogram(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4f(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4f(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniform4f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ", " +
    "<float> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnMapdv(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetnMapdv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetnMapdv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGenerateMultiTexMipmapEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glGenerateMultiTexMipmapEXT(arg0,arg1);
    String txt = new String("glGenerateMultiTexMipmapEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramVertexLimitNV(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glProgramVertexLimitNV(arg0,arg1);
    String txt = new String("glProgramVertexLimitNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glClientActiveTexture(int arg0)
  {
        checkContext();
downstreamGL4bc.glClientActiveTexture(arg0);
    String txt = new String("glClientActiveTexture(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEvalCoord2fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glEvalCoord2fv(arg0,arg1);
    String txt = new String("glEvalCoord2fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord1iv(arg0);
    String txt = new String("glTexCoord1iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  int glCreateProgram()
  {
        checkContext();
    int _res = downstreamGL4bc.glCreateProgram();
    String txt = new String("glCreateProgram(" +
    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glProgramUniform1ui64NV(int arg0,int arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1ui64NV(arg0,arg1,arg2);
    String txt = new String("glProgramUniform1ui64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glInvalidateTexSubImage(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glInvalidateTexSubImage(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glInvalidateTexSubImage(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEnableVertexAttribArrayARB(int arg0)
  {
        checkContext();
downstreamGL4bc.glEnableVertexAttribArrayARB(arg0);
    String txt = new String("glEnableVertexAttribArrayARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPauseTransformFeedbackNV()
  {
        checkContext();
downstreamGL4bc.glPauseTransformFeedbackNV();
    String txt = new String("glPauseTransformFeedbackNV(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glUniformBlockBinding(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glUniformBlockBinding(arg0,arg1,arg2);
    String txt = new String("glUniformBlockBinding(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawRangeElements(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
        checkContext();
downstreamGL4bc.glDrawRangeElements(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glDrawRangeElements(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<long> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsTextureHandleResidentNV(long arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsTextureHandleResidentNV(arg0);
    String txt = new String("glIsTextureHandleResidentNV(" +
    "<long> "+arg0 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glSecondaryColor3iv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3iv(arg0,arg1);
    String txt = new String("glSecondaryColor3iv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBeginConditionalRender(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glBeginConditionalRender(arg0,arg1);
    String txt = new String("glBeginConditionalRender(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDepthMask(boolean arg0)
  {
        checkContext();
downstreamGL4bc.glDepthMask(arg0);
    String txt = new String("glDepthMask(" +
    "<boolean> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glSamplerParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glSamplerParameterfv(arg0,arg1,arg2);
    String txt = new String("glSamplerParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnUniformuiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetnUniformuiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetnUniformuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryObjecti64v(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetQueryObjecti64v(arg0,arg1,arg2);
    String txt = new String("glGetQueryObjecti64v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureSubImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,int arg10,java.nio.Buffer arg11)
  {
        checkContext();
downstreamGL4bc.glTextureSubImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    String txt = new String("glTextureSubImage3DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg10).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg11 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4uiv(arg0,arg1);
    String txt = new String("glVertexAttrib4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetQueryiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetQueryiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4bv(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4bv(arg0,arg1);
    String txt = new String("glVertexAttribI4bv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2x3fvEXT(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2x3fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix2x3fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureParameterivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glTextureParameterivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glTextureParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVDPAUInitNV(java.nio.Buffer arg0,java.nio.Buffer arg1)
  {
        checkContext();
downstreamGL4bc.glVDPAUInitNV(arg0,arg1);
    String txt = new String("glVDPAUInitNV(" +
    "<java.nio.Buffer> "+arg0 +    ", " +
    "<java.nio.Buffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferTextureLayer(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glFramebufferTextureLayer(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glFramebufferTextureLayer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNormalPointer(javax.media.opengl.GLArrayData arg0)
  {
        checkContext();
downstreamGL4bc.glNormalPointer(arg0);
    String txt = new String("glNormalPointer(" +
    "<javax.media.opengl.GLArrayData> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  int glGenSymbolsEXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
    int _res = downstreamGL4bc.glGenSymbolsEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGenSymbolsEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glNamedProgramLocalParameter4dEXT(int arg0,int arg1,int arg2,double arg3,double arg4,double arg5,double arg6)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParameter4dEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glNamedProgramLocalParameter4dEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<double> "+arg3 +    ", " +
    "<double> "+arg4 +    ", " +
    "<double> "+arg5 +    ", " +
    "<double> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3fvARB(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3fvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib3fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexP4uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexP4uiv(arg0,arg1);
    String txt = new String("glVertexP4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glDetachObjectARB(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glDetachObjectARB(arg0,arg1);
    String txt = new String("glDetachObjectARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelMapusv(int arg0,int arg1,short[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glPixelMapusv(arg0,arg1,arg2,arg3);
    String txt = new String("glPixelMapusv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMapControlPointsNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,boolean arg7,java.nio.Buffer arg8)
  {
        checkContext();
downstreamGL4bc.glMapControlPointsNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glMapControlPointsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<boolean> "+arg7 +    ", " +
    "<java.nio.Buffer> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI1iEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI1iEXT(arg0,arg1);
    String txt = new String("glVertexAttribI1iEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPointParameteriv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glPointParameteriv(arg0,arg1);
    String txt = new String("glPointParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribLPointer(int arg0,int arg1,int arg2,int arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribLPointer(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribLPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPixelTransformParameterfvEXT(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetPixelTransformParameterfvEXT(arg0,arg1,arg2);
    String txt = new String("glGetPixelTransformParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPolygonStipple(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glGetPolygonStipple(arg0,arg1);
    String txt = new String("glGetPolygonStipple(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1i64NV(int arg0,long arg1)
  {
        checkContext();
downstreamGL4bc.glUniform1i64NV(arg0,arg1);
    String txt = new String("glUniform1i64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glSamplerParameterIiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glSamplerParameterIiv(arg0,arg1,arg2);
    String txt = new String("glSamplerParameterIiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsPathNV(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsPathNV(arg0);
    String txt = new String("glIsPathNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexAttrib4dv(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4dv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos3d(double arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glWindowPos3d(arg0,arg1,arg2);
    String txt = new String("glWindowPos3d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glFogi(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glFogi(arg0,arg1);
    String txt = new String("glFogi(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3iv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord3iv(arg0,arg1);
    String txt = new String("glTexCoord3iv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexParameteriEXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexParameteriEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexParameteriEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawTransformFeedbackInstanced(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDrawTransformFeedbackInstanced(arg0,arg1,arg2);
    String txt = new String("glDrawTransformFeedbackInstanced(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3dvARB(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3dvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib3dvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawElementsInstanced(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glDrawElementsInstanced(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glDrawElementsInstanced(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexImage3DMultisampleCoverageNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,boolean arg7)
  {
        checkContext();
downstreamGL4bc.glTexImage3DMultisampleCoverageNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glTexImage3DMultisampleCoverageNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<boolean> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glGenFramebuffers(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenFramebuffers(arg0,arg1);
    String txt = new String("glGenFramebuffers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glPathCommandsNV(int arg0,int arg1,java.nio.ByteBuffer arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
        checkContext();
downstreamGL4bc.glPathCommandsNV(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glPathCommandsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3us(short arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glColor3us(arg0,arg1,arg2);
    String txt = new String("glColor3us(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetCompressedTexImage(int arg0,int arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glGetCompressedTexImage(arg0,arg1,arg2);
    String txt = new String("glGetCompressedTexImage(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMinmax(int arg0,int arg1,boolean arg2)
  {
        checkContext();
downstreamGL4bc.glMinmax(arg0,arg1,arg2);
    String txt = new String("glMinmax(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glTestObjectAPPLE(int arg0,int arg1)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glTestObjectAPPLE(arg0,arg1);
    String txt = new String("glTestObjectAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glProgramUniformHandleui64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniformHandleui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniformHandleui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribfv(arg0,arg1,arg2);
    String txt = new String("glGetVertexAttribfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2hv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2hv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord2hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3bvOES(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3bvOES(arg0,arg1);
    String txt = new String("glMultiTexCoord3bvOES(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glBeginTransformFeedback(int arg0)
  {
        checkContext();
downstreamGL4bc.glBeginTransformFeedback(arg0);
    String txt = new String("glBeginTransformFeedback(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI1uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI1uiv(arg0,arg1);
    String txt = new String("glVertexAttribI1uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMapdv(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetMapdv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMapdv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveAttrib(int arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6,int[] arg7,int arg8,byte[] arg9,int arg10)
  {
        checkContext();
downstreamGL4bc.glGetActiveAttrib(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glGetActiveAttrib(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg10).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCullParameterdvEXT(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glCullParameterdvEXT(arg0,arg1,arg2);
    String txt = new String("glCullParameterdvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEvalCoord1f(float arg0)
  {
        checkContext();
downstreamGL4bc.glEvalCoord1f(arg0);
    String txt = new String("glEvalCoord1f(" +
    "<float> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos3iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glWindowPos3iv(arg0);
    String txt = new String("glWindowPos3iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glClipPlanef(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glClipPlanef(arg0,arg1,arg2);
    String txt = new String("glClipPlanef(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteSamplers(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDeleteSamplers(arg0,arg1,arg2);
    String txt = new String("glDeleteSamplers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4fv(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4fv(arg0,arg1);
    String txt = new String("glVertexAttrib4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos4dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glRasterPos4dv(arg0);
    String txt = new String("glRasterPos4dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveUniformsiv(int arg0,int arg1,java.nio.IntBuffer arg2,int arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetActiveUniformsiv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetActiveUniformsiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveUniformsiv(int arg0,int arg1,int[] arg2,int arg3,int arg4,int[] arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glGetActiveUniformsiv(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetActiveUniformsiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos3dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos3dv(arg0,arg1);
    String txt = new String("glRasterPos3dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetSeparableFilter(int arg0,int arg1,int arg2,java.nio.Buffer arg3,java.nio.Buffer arg4,java.nio.Buffer arg5)
  {
        checkContext();
downstreamGL4bc.glGetSeparableFilter(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetSeparableFilter(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ", " +
    "<java.nio.Buffer> "+arg4 +    ", " +
    "<java.nio.Buffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2fv(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2fv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glObjectPtrLabel(java.nio.Buffer arg0,int arg1,java.nio.ByteBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glObjectPtrLabel(arg0,arg1,arg2);
    String txt = new String("glObjectPtrLabel(" +
    "<java.nio.Buffer> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMaterialf(int arg0,int arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glMaterialf(arg0,arg1,arg2);
    String txt = new String("glMaterialf(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedBufferSubDataEXT(int arg0,long arg1,long arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetNamedBufferSubDataEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetNamedBufferSubDataEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glResumeTransformFeedbackNV()
  {
        checkContext();
downstreamGL4bc.glResumeTransformFeedbackNV();
    String txt = new String("glResumeTransformFeedbackNV(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glVertexArrayBindVertexBufferEXT(int arg0,int arg1,int arg2,long arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVertexArrayBindVertexBufferEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexArrayBindVertexBufferEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glGetFragDataLocation(int arg0,java.lang.String arg1)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetFragDataLocation(arg0,arg1);
    String txt = new String("glGetFragDataLocation(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.lang.String> "+arg1 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetMultiTexGendvEXT(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexGendvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMultiTexGendvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramLocalParameterI4ivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParameterI4ivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glNamedProgramLocalParameterI4ivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex3dv(arg0);
    String txt = new String("glVertex3dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramStringEXT(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
        checkContext();
downstreamGL4bc.glNamedProgramStringEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glNamedProgramStringEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL3ui64vNV(int arg0,long[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL3ui64vNV(arg0,arg1,arg2);
    String txt = new String("glVertexAttribL3ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsBuffer(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsBuffer(arg0);
    String txt = new String("glIsBuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertex2dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex2dv(arg0,arg1);
    String txt = new String("glVertex2dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDisable(int arg0)
  {
        checkContext();
downstreamGL4bc.glDisable(arg0);
    String txt = new String("glDisable(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glInvalidateTexImage(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glInvalidateTexImage(arg0,arg1);
    String txt = new String("glInvalidateTexImage(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2hv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex2hv(arg0,arg1);
    String txt = new String("glVertex2hv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glScissorIndexedv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glScissorIndexedv(arg0,arg1);
    String txt = new String("glScissorIndexedv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMapVertexAttrib2fAPPLE(int arg0,int arg1,float arg2,float arg3,int arg4,int arg5,float arg6,float arg7,int arg8,int arg9,java.nio.FloatBuffer arg10)
  {
        checkContext();
downstreamGL4bc.glMapVertexAttrib2fAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glMapVertexAttrib2fAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<float> "+arg6 +    ", " +
    "<float> "+arg7 +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg10 +    ")");
    checkGLGetError( txt );
  }
  public  void glResetMinmax(int arg0)
  {
        checkContext();
downstreamGL4bc.glResetMinmax(arg0);
    String txt = new String("glResetMinmax(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4uiEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4uiEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribI4uiEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedFramebufferTexture1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glNamedFramebufferTexture1DEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glNamedFramebufferTexture1DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexEnviv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetTexEnviv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetTexEnviv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glViewportIndexedfv(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glViewportIndexedfv(arg0,arg1,arg2);
    String txt = new String("glViewportIndexedfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPatchParameterfv(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glPatchParameterfv(arg0,arg1);
    String txt = new String("glPatchParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  javax.media.opengl.GLContext getContext()
  {
        return downstreamGL4bc.getContext();
  }
  public  void glTexCoord4sv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord4sv(arg0);
    String txt = new String("glTexCoord4sv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glColorP3ui(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColorP3ui(arg0,arg1);
    String txt = new String("glColorP3ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedBufferSubDataEXT(int arg0,long arg1,long arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glNamedBufferSubDataEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glNamedBufferSubDataEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glPushClientAttrib(int arg0)
  {
        checkContext();
downstreamGL4bc.glPushClientAttrib(arg0);
    String txt = new String("glPushClientAttrib(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelTransformParameterivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glPixelTransformParameterivEXT(arg0,arg1,arg2);
    String txt = new String("glPixelTransformParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramLocalParameters4fvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParameters4fvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramLocalParameters4fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glLightModelfv(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glLightModelfv(arg0,arg1,arg2);
    String txt = new String("glLightModelfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribivARB(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexAttribivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedMultiTexSubImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,int arg10,java.nio.Buffer arg11)
  {
        checkContext();
downstreamGL4bc.glCompressedMultiTexSubImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    String txt = new String("glCompressedMultiTexSubImage3DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg10).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg11 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4bvOES(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex4bvOES(arg0);
    String txt = new String("glVertex4bvOES(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexGenfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexGenfvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMultiTexGenfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribFormat(int arg0,int arg1,int arg2,boolean arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribFormat(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribFormat(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord1sv(arg0,arg1);
    String txt = new String("glTexCoord1sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiDrawElements(int arg0,java.nio.IntBuffer arg1,int arg2,com.jogamp.common.nio.PointerBuffer arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glMultiDrawElements(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiDrawElements(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<com.jogamp.common.nio.PointerBuffer> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDisableVertexArrayAttribEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glDisableVertexArrayAttribEXT(arg0,arg1);
    String txt = new String("glDisableVertexArrayAttribEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFogfv(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glFogfv(arg0,arg1,arg2);
    String txt = new String("glFogfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL4ui64NV(int arg0,long arg1,long arg2,long arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL4ui64NV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribL4ui64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2fvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform2fvARB(arg0,arg1,arg2);
    String txt = new String("glUniform2fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVDPAUGetSurfaceivNV(long arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glVDPAUGetSurfaceivNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glVDPAUGetSurfaceivNV(" +
    "<long> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVDPAUGetSurfaceivNV(long arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glVDPAUGetSurfaceivNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVDPAUGetSurfaceivNV(" +
    "<long> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteTransformFeedbacks(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glDeleteTransformFeedbacks(arg0,arg1);
    String txt = new String("glDeleteTransformFeedbacks(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix4fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4fv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVariantIntegervEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVariantIntegervEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVariantIntegervEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribs1hv(int arg0,int arg1,short[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribs1hv(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribs1hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformSubroutinesuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniformSubroutinesuiv(arg0,arg1,arg2);
    String txt = new String("glUniformSubroutinesuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelMapusv(int arg0,int arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glPixelMapusv(arg0,arg1,arg2);
    String txt = new String("glPixelMapusv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glEvalCoord1d(double arg0)
  {
        checkContext();
downstreamGL4bc.glEvalCoord1d(arg0);
    String txt = new String("glEvalCoord1d(" +
    "<double> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  int getDefaultDrawFramebuffer()
  {
        return downstreamGL4bc.getDefaultDrawFramebuffer();
  }
  public  void glVDPAUMapSurfacesNV(int arg0,com.jogamp.common.nio.PointerBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVDPAUMapSurfacesNV(arg0,arg1);
    String txt = new String("glVDPAUMapSurfacesNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<com.jogamp.common.nio.PointerBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetHistogram(int arg0,boolean arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetHistogram(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetHistogram(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<boolean> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glMakeTextureHandleResidentNV(long arg0)
  {
        checkContext();
downstreamGL4bc.glMakeTextureHandleResidentNV(arg0);
    String txt = new String("glMakeTextureHandleResidentNV(" +
    "<long> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glNormal3fv(arg0,arg1);
    String txt = new String("glNormal3fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEdgeFlagFormatNV(int arg0)
  {
        checkContext();
downstreamGL4bc.glEdgeFlagFormatNV(arg0);
    String txt = new String("glEdgeFlagFormatNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathColorGenfvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetPathColorGenfvNV(arg0,arg1,arg2);
    String txt = new String("glGetPathColorGenfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  int glCheckFramebufferStatus(int arg0)
  {
        checkContext();
    int _res = downstreamGL4bc.glCheckFramebufferStatus(arg0);
    String txt = new String("glCheckFramebufferStatus(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  boolean glIsPointInStrokePathNV(int arg0,float arg1,float arg2)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsPointInStrokePathNV(arg0,arg1,arg2);
    String txt = new String("glIsPointInStrokePathNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glUniform4i(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniform4i(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniform4i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4uiEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4uiEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniform4uiEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMaterialfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glMaterialfv(arg0,arg1,arg2);
    String txt = new String("glMaterialfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4f(int arg0,float arg1,float arg2,float arg3,float arg4)
  {
        checkContext();
downstreamGL4bc.glUniform4f(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniform4f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2ui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform2ui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform2ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawElementsBaseVertex(int arg0,int arg1,int arg2,long arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glDrawElementsBaseVertex(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glDrawElementsBaseVertex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord2fv(arg0,arg1);
    String txt = new String("glTexCoord2fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramEnvParameterdvARB(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetProgramEnvParameterdvARB(arg0,arg1,arg2);
    String txt = new String("glGetProgramEnvParameterdvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glConvolutionParameterf(int arg0,int arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glConvolutionParameterf(arg0,arg1,arg2);
    String txt = new String("glConvolutionParameterf(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyMultiTexSubImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glCopyMultiTexSubImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glCopyMultiTexSubImage1DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenTransformFeedbacksNV(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenTransformFeedbacksNV(arg0,arg1);
    String txt = new String("glGenTransformFeedbacksNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexParameterIivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexParameterIivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMultiTexParameterIivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1iARB(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glUniform1iARB(arg0,arg1);
    String txt = new String("glUniform1iARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenFencesNV(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenFencesNV(arg0,arg1);
    String txt = new String("glGenFencesNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glRectf(float arg0,float arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glRectf(arg0,arg1,arg2,arg3);
    String txt = new String("glRectf(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix3fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix3fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathParameterfvNV(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetPathParameterfvNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetPathParameterfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos3f(float arg0,float arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glWindowPos3f(arg0,arg1,arg2);
    String txt = new String("glWindowPos3f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glRectd(double arg0,double arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glRectd(arg0,arg1,arg2,arg3);
    String txt = new String("glRectd(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glAreTexturesResident(int arg0,int[] arg1,int arg2,byte[] arg3,int arg4)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glAreTexturesResident(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glAreTexturesResident(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glNamedFramebufferTextureEXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glNamedFramebufferTextureEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glNamedFramebufferTextureEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetUniformfv(arg0,arg1,arg2);
    String txt = new String("glGetUniformfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glRecti(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glRecti(arg0,arg1,arg2,arg3);
    String txt = new String("glRecti(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPathParameterivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glPathParameterivNV(arg0,arg1,arg2);
    String txt = new String("glPathParameterivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsQuery(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsQuery(arg0);
    String txt = new String("glIsQuery(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  int glObjectUnpurgeableAPPLE(int arg0,int arg1,int arg2)
  {
        checkContext();
    int _res = downstreamGL4bc.glObjectUnpurgeableAPPLE(arg0,arg1,arg2);
    String txt = new String("glObjectUnpurgeableAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGenPerfMonitorsAMD(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenPerfMonitorsAMD(arg0,arg1);
    String txt = new String("glGenPerfMonitorsAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyColorSubTable(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glCopyColorSubTable(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glCopyColorSubTable(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRects(short arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glRects(arg0,arg1,arg2,arg3);
    String txt = new String("glRects(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedBufferDataEXT(int arg0,long arg1,java.nio.Buffer arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glNamedBufferDataEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glNamedBufferDataEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<java.nio.Buffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsTransformFeedback(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsTransformFeedback(arg0);
    String txt = new String("glIsTransformFeedback(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glBitmap(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5,java.nio.ByteBuffer arg6)
  {
        checkContext();
downstreamGL4bc.glBitmap(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glBitmap(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ", " +
    "<float> "+arg5 +    ", " +
    "<java.nio.ByteBuffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexParameterfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glMultiTexParameterfvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiTexParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPatchParameteri(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glPatchParameteri(arg0,arg1);
    String txt = new String("glPatchParameteri(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexLevelParameterfvEXT(int arg0,int arg1,int arg2,int arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexLevelParameterfvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMultiTexLevelParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixIndexuivARB(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMatrixIndexuivARB(arg0,arg1);
    String txt = new String("glMatrixIndexuivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedTexImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,long arg7)
  {
        checkContext();
downstreamGL4bc.glCompressedTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glCompressedTexImage2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<long> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glWeightPathsNV(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glWeightPathsNV(arg0,arg1,arg2,arg3);
    String txt = new String("glWeightPathsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnColorTable(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetnColorTable(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetnColorTable(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos2fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glWindowPos2fv(arg0,arg1);
    String txt = new String("glWindowPos2fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glInsertComponentEXT(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glInsertComponentEXT(arg0,arg1,arg2);
    String txt = new String("glInsertComponentEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPolygonStipple(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glPolygonStipple(arg0,arg1);
    String txt = new String("glPolygonStipple(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveUniform(int arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6,int[] arg7,int arg8,byte[] arg9,int arg10)
  {
        checkContext();
downstreamGL4bc.glGetActiveUniform(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glGetActiveUniform(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg10).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferTextureLayerARB(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glFramebufferTextureLayerARB(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glFramebufferTextureLayerARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3usv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor3usv(arg0);
    String txt = new String("glColor3usv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexSubImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,int arg10,java.nio.Buffer arg11)
  {
        checkContext();
downstreamGL4bc.glMultiTexSubImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    String txt = new String("glMultiTexSubImage3DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg10).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg11 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos4sv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glRasterPos4sv(arg0);
    String txt = new String("glRasterPos4sv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix3x2dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix3x2dv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix3x2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2i64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2i64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform2i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL1d(int arg0,double arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL1d(arg0,arg1);
    String txt = new String("glVertexAttribL1d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3f(float arg0,float arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glVertex3f(arg0,arg1,arg2);
    String txt = new String("glVertex3f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexParameterIuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glTexParameterIuiv(arg0,arg1,arg2,arg3);
    String txt = new String("glTexParameterIuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexGenfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glTexGenfv(arg0,arg1,arg2);
    String txt = new String("glTexGenfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  int glObjectPurgeableAPPLE(int arg0,int arg1,int arg2)
  {
        checkContext();
    int _res = downstreamGL4bc.glObjectPurgeableAPPLE(arg0,arg1,arg2);
    String txt = new String("glObjectPurgeableAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetMapControlPointsNV(int arg0,int arg1,int arg2,int arg3,int arg4,boolean arg5,java.nio.Buffer arg6)
  {
        checkContext();
downstreamGL4bc.glGetMapControlPointsNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetMapControlPointsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<boolean> "+arg5 +    ", " +
    "<java.nio.Buffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glUseProgramStages(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glUseProgramStages(arg0,arg1,arg2);
    String txt = new String("glUseProgramStages(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramPipelineiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetProgramPipelineiv(arg0,arg1,arg2);
    String txt = new String("glGetProgramPipelineiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2dvARB(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2dvARB(arg0,arg1);
    String txt = new String("glVertexAttrib2dvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glListBase(int arg0)
  {
        checkContext();
downstreamGL4bc.glListBase(arg0);
    String txt = new String("glListBase(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureBarrierNV()
  {
        checkContext();
downstreamGL4bc.glTextureBarrierNV();
    String txt = new String("glTextureBarrierNV(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramResourceName(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5,byte[] arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glGetProgramResourceName(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glGetProgramResourceName(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveUniformBlockName(int arg0,int arg1,int arg2,int[] arg3,int arg4,byte[] arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glGetActiveUniformBlockName(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetActiveUniformBlockName(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI2iv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI2iv(arg0,arg1);
    String txt = new String("glVertexAttribI2iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribdvARB(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribdvARB(arg0,arg1,arg2);
    String txt = new String("glGetVertexAttribdvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2bOES(byte arg0)
  {
        checkContext();
downstreamGL4bc.glVertex2bOES(arg0);
    String txt = new String("glVertex2bOES(" +
    "<byte> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3hv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor3hv(arg0);
    String txt = new String("glColor3hv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL1ui64NV(int arg0,long arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL1ui64NV(arg0,arg1);
    String txt = new String("glVertexAttribL1ui64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix4dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.DoubleBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glAccum(int arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glAccum(arg0,arg1);
    String txt = new String("glAccum(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMapiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetMapiv(arg0,arg1,arg2);
    String txt = new String("glGetMapiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  long glFenceSync(int arg0,int arg1)
  {
        checkContext();
    long _res = downstreamGL4bc.glFenceSync(arg0,arg1);
    String txt = new String("glFenceSync(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexAttribI1ui(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI1ui(arg0,arg1);
    String txt = new String("glVertexAttribI1ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribP2ui(int arg0,int arg1,boolean arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribP2ui(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribP2ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSetMultisamplefvAMD(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glSetMultisamplefvAMD(arg0,arg1,arg2,arg3);
    String txt = new String("glSetMultisamplefvAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDisableVertexArrayEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glDisableVertexArrayEXT(arg0,arg1);
    String txt = new String("glDisableVertexArrayEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetFramebufferParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetFramebufferParameteriv(arg0,arg1,arg2);
    String txt = new String("glGetFramebufferParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4ubv(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor4ubv(arg0,arg1);
    String txt = new String("glColor4ubv(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glActiveStencilFaceEXT(int arg0)
  {
        checkContext();
downstreamGL4bc.glActiveStencilFaceEXT(arg0);
    String txt = new String("glActiveStencilFaceEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPrimitiveRestartIndex(int arg0)
  {
        checkContext();
downstreamGL4bc.glPrimitiveRestartIndex(arg0);
    String txt = new String("glPrimitiveRestartIndex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCoverStrokePathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,java.nio.FloatBuffer arg6)
  {
        checkContext();
downstreamGL4bc.glCoverStrokePathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glCoverStrokePathInstancedNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos4fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos4fv(arg0,arg1);
    String txt = new String("glRasterPos4fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos3sv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glWindowPos3sv(arg0);
    String txt = new String("glWindowPos3sv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexGendvEXT(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glMultiTexGendvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiTexGendvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix3x4fvEXT(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix3x4fvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix3x4fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetDoubleIndexedvEXT(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetDoubleIndexedvEXT(arg0,arg1,arg2);
    String txt = new String("glGetDoubleIndexedvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramLocalParameterIuivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetProgramLocalParameterIuivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramLocalParameterIuivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix4dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix4dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4bvARB(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4bvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4bvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyBufferSubData(int arg0,int arg1,long arg2,long arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glCopyBufferSubData(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glCopyBufferSubData(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribIuivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribIuivEXT(arg0,arg1,arg2);
    String txt = new String("glGetVertexAttribIuivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3ui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform3ui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform3ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4iEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4iEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribI4iEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultisamplefvNV(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetMultisamplefvNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMultisamplefvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDepthRangef(float arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glDepthRangef(arg0,arg1);
    String txt = new String("glDepthRangef(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexImage2DMultisample(int arg0,int arg1,int arg2,int arg3,int arg4,boolean arg5)
  {
        checkContext();
downstreamGL4bc.glTexImage2DMultisample(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glTexImage2DMultisample(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<boolean> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3bv(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3bv(arg0,arg1);
    String txt = new String("glSecondaryColor3bv(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL3d(int arg0,double arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL3d(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribL3d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantPointerEXT(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glVariantPointerEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glVariantPointerEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2dv(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2dv(arg0,arg1);
    String txt = new String("glVertexAttrib2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVideoCaptureStreamivNV(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetVideoCaptureStreamivNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetVideoCaptureStreamivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glWeightPathsNV(int arg0,int arg1,int[] arg2,int arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glWeightPathsNV(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glWeightPathsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexP3uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexP3uiv(arg0,arg1);
    String txt = new String("glVertexP3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glScaled(double arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glScaled(arg0,arg1,arg2);
    String txt = new String("glScaled(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsFramebuffer(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsFramebuffer(arg0);
    String txt = new String("glIsFramebuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glMultiTexEnvfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glMultiTexEnvfvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiTexEnvfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glGetProgramResourceLocationIndex(int arg0,int arg1,byte[] arg2,int arg3)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetProgramResourceLocationIndex(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramResourceLocationIndex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glNormalPointer(int arg0,int arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glNormalPointer(arg0,arg1,arg2);
    String txt = new String("glNormalPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glFinishFenceAPPLE(int arg0)
  {
        checkContext();
downstreamGL4bc.glFinishFenceAPPLE(arg0);
    String txt = new String("glFinishFenceAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedMultiTexImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
        checkContext();
downstreamGL4bc.glCompressedMultiTexImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glCompressedMultiTexImage2DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos2dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glWindowPos2dv(arg0);
    String txt = new String("glWindowPos2dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoordP4uiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoordP4uiv(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexCoordP4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColorMaterial(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColorMaterial(arg0,arg1);
    String txt = new String("glColorMaterial(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBlendFuncSeparateINGR(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glBlendFuncSeparateINGR(arg0,arg1,arg2,arg3);
    String txt = new String("glBlendFuncSeparateINGR(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexParameterIiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetTexParameterIiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetTexParameterIiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1bOES(byte arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord1bOES(arg0);
    String txt = new String("glTexCoord1bOES(" +
    "<byte> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribIuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribIuiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexAttribIuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4sv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4sv(arg0,arg1);
    String txt = new String("glVertexAttrib4sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetConvolutionFilter(int arg0,int arg1,int arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glGetConvolutionFilter(arg0,arg1,arg2,arg3);
    String txt = new String("glGetConvolutionFilter(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4dv(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4dv(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex3fv(arg0,arg1);
    String txt = new String("glVertex3fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramSubroutineParameteruivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetProgramSubroutineParameteruivNV(arg0,arg1,arg2);
    String txt = new String("glGetProgramSubroutineParameteruivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4i64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4i64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform4i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix3x2fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix3x2fv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix3x2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveUniformName(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.ByteBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetActiveUniformName(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetActiveUniformName(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.ByteBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4svEXT(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4svEXT(arg0,arg1);
    String txt = new String("glVertexAttribI4svEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPerfMonitorGroupsAMD(java.nio.IntBuffer arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetPerfMonitorGroupsAMD(arg0,arg1,arg2);
    String txt = new String("glGetPerfMonitorGroupsAMD(" +
    "<java.nio.IntBuffer> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPerfMonitorGroupsAMD(int[] arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetPerfMonitorGroupsAMD(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetPerfMonitorGroupsAMD(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteRenderbuffers(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glDeleteRenderbuffers(arg0,arg1);
    String txt = new String("glDeleteRenderbuffers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParameters4fvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParameters4fvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramEnvParameters4fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInternalformativ(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetInternalformativ(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetInternalformativ(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTextureLevelParameterfvEXT(int arg0,int arg1,int arg2,int arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetTextureLevelParameterfvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetTextureLevelParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnUniformdv(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetnUniformdv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetnUniformdv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3uiv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3uiv(arg0);
    String txt = new String("glSecondaryColor3uiv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4uivARB(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4uivARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4uivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTransformFeedbackVarying(int arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6,int[] arg7,int arg8,byte[] arg9,int arg10)
  {
        checkContext();
downstreamGL4bc.glGetTransformFeedbackVarying(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glGetTransformFeedbackVarying(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg10).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteNamesAMD(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glDeleteNamesAMD(arg0,arg1,arg2);
    String txt = new String("glDeleteNamesAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexGenfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glMultiTexGenfvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiTexGenfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform4uiv(arg0,arg1,arg2);
    String txt = new String("glUniform4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glScalef(float arg0,float arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glScalef(arg0,arg1,arg2);
    String txt = new String("glScalef(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glColorTableParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glColorTableParameteriv(arg0,arg1,arg2,arg3);
    String txt = new String("glColorTableParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVDPAUFiniNV()
  {
        checkContext();
downstreamGL4bc.glVDPAUFiniNV();
    String txt = new String("glVDPAUFiniNV(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord4fv(arg0);
    String txt = new String("glTexCoord4fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2iv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2iv(arg0,arg1);
    String txt = new String("glMultiTexCoord2iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glNormal3dv(arg0);
    String txt = new String("glNormal3dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelMapfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glPixelMapfv(arg0,arg1,arg2,arg3);
    String txt = new String("glPixelMapfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTextureParameterfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetTextureParameterfvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetTextureParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3ub(byte arg0,byte arg1,byte arg2)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3ub(arg0,arg1,arg2);
    String txt = new String("glSecondaryColor3ub(" +
    "<byte> "+arg0 +    ", " +
    "<byte> "+arg1 +    ", " +
    "<byte> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glBufferParameteri(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glBufferParameteri(arg0,arg1,arg2);
    String txt = new String("glBufferParameteri(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedTexImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6)
  {
        checkContext();
downstreamGL4bc.glCompressedTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glCompressedTexImage1D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<long> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformHandleui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniformHandleui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformHandleui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPixelTransformParameterivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetPixelTransformParameterivEXT(arg0,arg1,arg2);
    String txt = new String("glGetPixelTransformParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexEnvfEXT(int arg0,int arg1,int arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexEnvfEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexEnvfEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexEnviv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glTexEnviv(arg0,arg1,arg2,arg3);
    String txt = new String("glTexEnviv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedProgramLocalParameterIivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetNamedProgramLocalParameterIivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetNamedProgramLocalParameterIivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3sv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3sv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib3sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL4ui64vNV(int arg0,long[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL4ui64vNV(arg0,arg1,arg2);
    String txt = new String("glVertexAttribL4ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glShaderBinary(int arg0,java.nio.IntBuffer arg1,int arg2,java.nio.Buffer arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glShaderBinary(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glShaderBinary(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3fvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform3fvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform3fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetAttachedObjectsARB(int arg0,int arg1,int[] arg2,int arg3,int[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetAttachedObjectsARB(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetAttachedObjectsARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetAttachedObjectsARB(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetAttachedObjectsARB(arg0,arg1,arg2,arg3);
    String txt = new String("glGetAttachedObjectsARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glMakeNamedBufferNonResidentNV(int arg0)
  {
        checkContext();
downstreamGL4bc.glMakeNamedBufferNonResidentNV(arg0);
    String txt = new String("glMakeNamedBufferNonResidentNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2ui64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2ui64vNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform2ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexGenivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexGenivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMultiTexGenivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelMapuiv(int arg0,int arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glPixelMapuiv(arg0,arg1,arg2);
    String txt = new String("glPixelMapuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix4x3fvEXT(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4x3fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix4x3fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenProgramsARB(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGenProgramsARB(arg0,arg1,arg2);
    String txt = new String("glGenProgramsARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord2dv(arg0);
    String txt = new String("glTexCoord2dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteProgram(int arg0)
  {
        checkContext();
downstreamGL4bc.glDeleteProgram(arg0);
    String txt = new String("glDeleteProgram(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryObjectiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetQueryObjectiv(arg0,arg1,arg2);
    String txt = new String("glGetQueryObjectiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glLineStipple(int arg0,short arg1)
  {
        checkContext();
downstreamGL4bc.glLineStipple(arg0,arg1);
    String txt = new String("glLineStipple(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4bv(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor4bv(arg0,arg1);
    String txt = new String("glColor4bv(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenSamplers(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenSamplers(arg0,arg1);
    String txt = new String("glGenSamplers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glFlush()
  {
        checkContext();
downstreamGL4bc.glFlush();
    String txt = new String("glFlush(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1hv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord1hv(arg0,arg1);
    String txt = new String("glTexCoord1hv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos2sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos2sv(arg0,arg1);
    String txt = new String("glRasterPos2sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI3uivEXT(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI3uivEXT(arg0,arg1);
    String txt = new String("glVertexAttribI3uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix3dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix3dv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMapParameterfvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetMapParameterfvNV(arg0,arg1,arg2);
    String txt = new String("glGetMapParameterfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord1dv(arg0,arg1);
    String txt = new String("glTexCoord1dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMap1d(int arg0,double arg1,double arg2,int arg3,int arg4,double[] arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glMap1d(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glMap1d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveSubroutineName(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4,java.nio.ByteBuffer arg5)
  {
        checkContext();
downstreamGL4bc.glGetActiveSubroutineName(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetActiveSubroutineName(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ", " +
    "<java.nio.ByteBuffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetBufferParameteri64v(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetBufferParameteri64v(arg0,arg1,arg2,arg3);
    String txt = new String("glGetBufferParameteri64v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixPushEXT(int arg0)
  {
        checkContext();
downstreamGL4bc.glMatrixPushEXT(arg0);
    String txt = new String("glMatrixPushEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedFramebufferTexture3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glNamedFramebufferTexture3DEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glNamedFramebufferTexture3DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2iv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform2iv(arg0,arg1,arg2);
    String txt = new String("glUniform2iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glWeightusvARB(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glWeightusvARB(arg0,arg1,arg2);
    String txt = new String("glWeightusvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3dv(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3dv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBindAttribLocation(int arg0,int arg1,java.lang.String arg2)
  {
        checkContext();
downstreamGL4bc.glBindAttribLocation(arg0,arg1,arg2);
    String txt = new String("glBindAttribLocation(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.lang.String> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTextureParameterIuivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetTextureParameterIuivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetTextureParameterIuivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferDrawBuffersEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glFramebufferDrawBuffersEXT(arg0,arg1,arg2);
    String txt = new String("glFramebufferDrawBuffersEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3bvOES(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord3bvOES(arg0,arg1);
    String txt = new String("glTexCoord3bvOES(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeletePathsNV(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glDeletePathsNV(arg0,arg1);
    String txt = new String("glDeletePathsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetHistogramParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetHistogramParameteriv(arg0,arg1,arg2);
    String txt = new String("glGetHistogramParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI3uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI3uiv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3hv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3hv(arg0,arg1);
    String txt = new String("glMultiTexCoord3hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureParameterfEXT(int arg0,int arg1,int arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glTextureParameterfEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glTextureParameterfEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glColorSubTable(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
        checkContext();
downstreamGL4bc.glColorSubTable(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glColorSubTable(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<long> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI3ivEXT(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI3ivEXT(arg0,arg1);
    String txt = new String("glVertexAttribI3ivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glWeightfvARB(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glWeightfvARB(arg0,arg1);
    String txt = new String("glWeightfvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3d(double arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glVertex3d(arg0,arg1,arg2);
    String txt = new String("glVertex3d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4NubvARB(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4NubvARB(arg0,arg1);
    String txt = new String("glVertexAttrib4NubvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedTexImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,long arg8)
  {
        checkContext();
downstreamGL4bc.glCompressedTexImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glCompressedTexImage3D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<long> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiDrawArrays(int arg0,int[] arg1,int arg2,int[] arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glMultiDrawArrays(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glMultiDrawArrays(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiDrawArrays(int arg0,java.nio.IntBuffer arg1,java.nio.IntBuffer arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glMultiDrawArrays(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiDrawArrays(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMap2d(int arg0,double arg1,double arg2,int arg3,int arg4,double arg5,double arg6,int arg7,int arg8,double[] arg9,int arg10)
  {
        checkContext();
downstreamGL4bc.glMap2d(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glMap2d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<double> "+arg5 +    ", " +
    "<double> "+arg6 +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg10).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformi64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetUniformi64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetUniformi64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBeginOcclusionQueryNV(int arg0)
  {
        checkContext();
downstreamGL4bc.glBeginOcclusionQueryNV(arg0);
    String txt = new String("glBeginOcclusionQueryNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4NubARB(int arg0,byte arg1,byte arg2,byte arg3,byte arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4NubARB(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttrib4NubARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<byte> "+arg1 +    ", " +
    "<byte> "+arg2 +    ", " +
    "<byte> "+arg3 +    ", " +
    "<byte> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glTransformPathNV(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glTransformPathNV(arg0,arg1,arg2,arg3);
    String txt = new String("glTransformPathNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex2sv(arg0,arg1);
    String txt = new String("glVertex2sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBeginConditionalRenderNVX(int arg0)
  {
        checkContext();
downstreamGL4bc.glBeginConditionalRenderNVX(arg0);
    String txt = new String("glBeginConditionalRenderNVX(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixLoadfEXT(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMatrixLoadfEXT(arg0,arg1,arg2);
    String txt = new String("glMatrixLoadfEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramLocalParameterI4uivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParameterI4uivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glNamedProgramLocalParameterI4uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexEnvfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexEnvfvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMultiTexEnvfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI2uivEXT(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI2uivEXT(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI2uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4iv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform4iv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform4iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMapVertexAttrib2dAPPLE(int arg0,int arg1,double arg2,double arg3,int arg4,int arg5,double arg6,double arg7,int arg8,int arg9,double[] arg10,int arg11)
  {
        checkContext();
downstreamGL4bc.glMapVertexAttrib2dAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    String txt = new String("glMapVertexAttrib2dAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<double> "+arg6 +    ", " +
    "<double> "+arg7 +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg11).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsProgramPipeline(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsProgramPipeline(arg0);
    String txt = new String("glIsProgramPipeline(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glMultiTexEnvivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexEnvivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexEnvivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL2dv(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL2dv(arg0,arg1);
    String txt = new String("glVertexAttribL2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexSubImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6)
  {
        checkContext();
downstreamGL4bc.glTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glTexSubImage1D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord1sv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1sv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord1sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex2iv(arg0);
    String txt = new String("glVertex2iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glTexParameteriv(arg0,arg1,arg2,arg3);
    String txt = new String("glTexParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1fv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform1fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4uiv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor4uiv(arg0,arg1);
    String txt = new String("glColor4uiv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexParameterIuivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glMultiTexParameterIuivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiTexParameterIuivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathTexGenivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetPathTexGenivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetPathTexGenivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3ui64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3ui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform3ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glScissor(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glScissor(arg0,arg1,arg2,arg3);
    String txt = new String("glScissor(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexArrayIntegeri_vEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetVertexArrayIntegeri_vEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetVertexArrayIntegeri_vEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glConvolutionParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glConvolutionParameteriv(arg0,arg1,arg2,arg3);
    String txt = new String("glConvolutionParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2fv(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2fv(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGenRenderbuffers(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenRenderbuffers(arg0,arg1);
    String txt = new String("glGenRenderbuffers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glWeightuivARB(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glWeightuivARB(arg0,arg1);
    String txt = new String("glWeightuivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantuivEXT(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVariantuivEXT(arg0,arg1);
    String txt = new String("glVariantuivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2sARB(int arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2sARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib2sARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMapAttribParameterivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetMapAttribParameterivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMapAttribParameterivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glBeginQueryIndexed(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glBeginQueryIndexed(arg0,arg1,arg2);
    String txt = new String("glBeginQueryIndexed(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetUniformuiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetUniformuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexParameterIiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glTexParameterIiv(arg0,arg1,arg2,arg3);
    String txt = new String("glTexParameterIiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVideoCaptureStreamParameterivNV(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVideoCaptureStreamParameterivNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVideoCaptureStreamParameterivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPixelMapusv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGetPixelMapusv(arg0,arg1);
    String txt = new String("glGetPixelMapusv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParameter4dARB(int arg0,int arg1,double arg2,double arg3,double arg4,double arg5)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParameter4dARB(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramEnvParameter4dARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ", " +
    "<double> "+arg4 +    ", " +
    "<double> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramLocalParameterIivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetProgramLocalParameterIivNV(arg0,arg1,arg2);
    String txt = new String("glGetProgramLocalParameterIivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetCompressedTextureImageEXT(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetCompressedTextureImageEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetCompressedTextureImageEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3b(byte arg0,byte arg1,byte arg2)
  {
        checkContext();
downstreamGL4bc.glNormal3b(arg0,arg1,arg2);
    String txt = new String("glNormal3b(" +
    "<byte> "+arg0 +    ", " +
    "<byte> "+arg1 +    ", " +
    "<byte> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramLocalParametersI4uivEXT(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParametersI4uivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glNamedProgramLocalParametersI4uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1fvARB(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1fvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib1fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,long arg9)
  {
        checkContext();
downstreamGL4bc.glTexImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glTexImage3D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<long> "+arg9 +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexfv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glIndexfv(arg0);
    String txt = new String("glIndexfv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3bOES(int arg0,byte arg1,byte arg2,byte arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3bOES(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexCoord3bOES(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<byte> "+arg1 +    ", " +
    "<byte> "+arg2 +    ", " +
    "<byte> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexSubImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
        checkContext();
downstreamGL4bc.glTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glTexSubImage2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribIPointerEXT(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribIPointerEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribIPointerEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetShaderiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetShaderiv(arg0,arg1,arg2);
    String txt = new String("glGetShaderiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  int glGetAttribLocation(int arg0,java.lang.String arg1)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetAttribLocation(arg0,arg1);
    String txt = new String("glGetAttribLocation(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.lang.String> "+arg1 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glDrawArraysIndirect(int arg0,java.nio.Buffer arg1)
  {
        checkContext();
downstreamGL4bc.glDrawArraysIndirect(arg0,arg1);
    String txt = new String("glDrawArraysIndirect(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  java.nio.ByteBuffer glMapBuffer(int arg0,int arg1)
  {
        checkContext();
    java.nio.ByteBuffer _res = downstreamGL4bc.glMapBuffer(arg0,arg1);
    String txt = new String("glMapBuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glColor4bv(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor4bv(arg0);
    String txt = new String("glColor4bv(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramLocalParametersI4ivEXT(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParametersI4ivEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glNamedProgramLocalParametersI4ivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSetFenceNV(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glSetFenceNV(arg0,arg1);
    String txt = new String("glSetFenceNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix4x3fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix4x3fv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix4x3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  int glGetFragDataIndex(int arg0,java.lang.String arg1)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetFragDataIndex(arg0,arg1);
    String txt = new String("glGetFragDataIndex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.lang.String> "+arg1 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glSetInvariantEXT(int arg0,int arg1,java.nio.Buffer arg2)
  {
        checkContext();
downstreamGL4bc.glSetInvariantEXT(arg0,arg1,arg2);
    String txt = new String("glSetInvariantEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordP3uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glTexCoordP3uiv(arg0,arg1,arg2);
    String txt = new String("glTexCoordP3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4ui64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4ui64vNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform4ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRectsv(short[] arg0,int arg1,short[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glRectsv(arg0,arg1,arg2,arg3);
    String txt = new String("glRectsv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRectsv(java.nio.ShortBuffer arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glRectsv(arg0,arg1);
    String txt = new String("glRectsv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL2i64NV(int arg0,long arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL2i64NV(arg0,arg1,arg2);
    String txt = new String("glVertexAttribL2i64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetColorTable(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetColorTable(arg0,arg1,arg2,arg3);
    String txt = new String("glGetColorTable(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glMapVertexAttrib1dAPPLE(int arg0,int arg1,double arg2,double arg3,int arg4,int arg5,java.nio.DoubleBuffer arg6)
  {
        checkContext();
downstreamGL4bc.glMapVertexAttrib1dAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glMapVertexAttrib1dAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferTexture(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glFramebufferTexture(arg0,arg1,arg2,arg3);
    String txt = new String("glFramebufferTexture(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPauseTransformFeedback()
  {
        checkContext();
downstreamGL4bc.glPauseTransformFeedback();
    String txt = new String("glPauseTransformFeedback(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glNamedRenderbufferStorageMultisampleEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glNamedRenderbufferStorageMultisampleEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glNamedRenderbufferStorageMultisampleEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexSubImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,java.nio.Buffer arg10)
  {
        checkContext();
downstreamGL4bc.glTexSubImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glTexSubImage3D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg10 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3bvOES(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord3bvOES(arg0);
    String txt = new String("glTexCoord3bvOES(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  int glGetBoundBuffer(int arg0)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetBoundBuffer(arg0);
    String txt = new String("glGetBoundBuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glTextureImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
        checkContext();
downstreamGL4bc.glTextureImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glTextureImage1DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix4x3dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4x3dv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix4x3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEvalPoint1(int arg0)
  {
        checkContext();
downstreamGL4bc.glEvalPoint1(arg0);
    String txt = new String("glEvalPoint1(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenTextures(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenTextures(arg0,arg1);
    String txt = new String("glGenTextures(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glSyncTextureINTEL(int arg0)
  {
        checkContext();
downstreamGL4bc.glSyncTextureINTEL(arg0);
    String txt = new String("glSyncTextureINTEL(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4NubvARB(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4NubvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4NubvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int getBoundFramebuffer(int arg0)
  {
        return downstreamGL4bc.getBoundFramebuffer(arg0);
  }
  public  void glFrustum(double arg0,double arg1,double arg2,double arg3,double arg4,double arg5)
  {
        checkContext();
downstreamGL4bc.glFrustum(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glFrustum(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ", " +
    "<double> "+arg4 +    ", " +
    "<double> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawBuffersATI(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glDrawBuffersATI(arg0,arg1);
    String txt = new String("glDrawBuffersATI(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos3iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glRasterPos3iv(arg0);
    String txt = new String("glRasterPos3iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramParameteriARB(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glProgramParameteriARB(arg0,arg1,arg2);
    String txt = new String("glProgramParameteriARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRenderbufferStorageMultisampleCoverageNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glRenderbufferStorageMultisampleCoverageNV(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glRenderbufferStorageMultisampleCoverageNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4iv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4iv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord4iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnMapfv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetnMapfv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetnMapfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVideoCaptureStreamParameterdvNV(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVideoCaptureStreamParameterdvNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVideoCaptureStreamParameterdvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexWeighthv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertexWeighthv(arg0);
    String txt = new String("glVertexWeighthv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glBindFragDataLocationIndexed(int arg0,int arg1,int arg2,java.lang.String arg3)
  {
        checkContext();
downstreamGL4bc.glBindFragDataLocationIndexed(arg0,arg1,arg2,arg3);
    String txt = new String("glBindFragDataLocationIndexed(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.lang.String> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordP2ui(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoordP2ui(arg0,arg1);
    String txt = new String("glTexCoordP2ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribPointer(int arg0,int arg1,int arg2,boolean arg3,int arg4,java.nio.Buffer arg5)
  {
        checkContext();
downstreamGL4bc.glVertexAttribPointer(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glVertexAttribPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix2x4dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix2x4dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix2x4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexGendv(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetTexGendv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetTexGendv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetProgramivARB(arg0,arg1,arg2);
    String txt = new String("glGetProgramivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos3dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glWindowPos3dv(arg0,arg1);
    String txt = new String("glWindowPos3dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glViewport(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glViewport(arg0,arg1,arg2,arg3);
    String txt = new String("glViewport(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL1dv(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL1dv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribL1dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexP2uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexP2uiv(arg0,arg1,arg2);
    String txt = new String("glVertexP2uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix2x4fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix2x4fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix2x4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPolygonStipple(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glPolygonStipple(arg0);
    String txt = new String("glPolygonStipple(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4hv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4hv(arg0,arg1);
    String txt = new String("glVertexAttrib4hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4uiv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCullParameterfvEXT(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glCullParameterfvEXT(arg0,arg1,arg2);
    String txt = new String("glCullParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramLocalParametersI4uivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParametersI4uivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramLocalParametersI4uivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glNewList(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glNewList(arg0,arg1);
    String txt = new String("glNewList(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteFencesNV(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDeleteFencesNV(arg0,arg1,arg2);
    String txt = new String("glDeleteFencesNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2fvARB(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2fvARB(arg0,arg1);
    String txt = new String("glVertexAttrib2fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glHistogram(int arg0,int arg1,int arg2,boolean arg3)
  {
        checkContext();
downstreamGL4bc.glHistogram(arg0,arg1,arg2,arg3);
    String txt = new String("glHistogram(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glColorMaskIndexed(int arg0,boolean arg1,boolean arg2,boolean arg3,boolean arg4)
  {
        checkContext();
downstreamGL4bc.glColorMaskIndexed(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glColorMaskIndexed(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<boolean> "+arg1 +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<boolean> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glRotated(double arg0,double arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glRotated(arg0,arg1,arg2,arg3);
    String txt = new String("glRotated(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glRotatef(float arg0,float arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glRotatef(arg0,arg1,arg2,arg3);
    String txt = new String("glRotatef(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetSamplerParameterIuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetSamplerParameterIuiv(arg0,arg1,arg2);
    String txt = new String("glGetSamplerParameterIuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glFlushVertexArrayRangeAPPLE(int arg0,java.nio.Buffer arg1)
  {
        checkContext();
downstreamGL4bc.glFlushVertexArrayRangeAPPLE(arg0,arg1);
    String txt = new String("glFlushVertexArrayRangeAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedTextureSubImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
        checkContext();
downstreamGL4bc.glCompressedTextureSubImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glCompressedTextureSubImage1DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2i64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform2i64vNV(arg0,arg1,arg2);
    String txt = new String("glUniform2i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramLocalParameter4dvEXT(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParameter4dvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glNamedProgramLocalParameter4dvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2fARB(int arg0,float arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glUniform2fARB(arg0,arg1,arg2);
    String txt = new String("glUniform2fARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPerfMonitorGroupStringAMD(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetPerfMonitorGroupStringAMD(arg0,arg1,arg2,arg3);
    String txt = new String("glGetPerfMonitorGroupStringAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<java.nio.ByteBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetSamplerParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetSamplerParameterfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetSamplerParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixLoadTransposedEXT(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMatrixLoadTransposedEXT(arg0,arg1,arg2);
    String txt = new String("glMatrixLoadTransposedEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedProgramivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetNamedProgramivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetNamedProgramivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramInfoLog(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetProgramInfoLog(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramInfoLog(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<java.nio.ByteBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4uivEXT(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4uivEXT(arg0,arg1);
    String txt = new String("glVertexAttribI4uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramLocalParameter4dvARB(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParameter4dvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramLocalParameter4dvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2bOES(int arg0,byte arg1,byte arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2bOES(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord2bOES(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<byte> "+arg1 +    ", " +
    "<byte> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribs2hv(int arg0,int arg1,short[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribs2hv(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribs2hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramResourceiv(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4,int arg5,java.nio.IntBuffer arg6,java.nio.IntBuffer arg7)
  {
        checkContext();
downstreamGL4bc.glGetProgramResourceiv(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glGetProgramResourceiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg6 +    ", " +
    "<java.nio.IntBuffer> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixMultfEXT(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMatrixMultfEXT(arg0,arg1,arg2);
    String txt = new String("glMatrixMultfEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPixelMapfv(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGetPixelMapfv(arg0,arg1,arg2);
    String txt = new String("glGetPixelMapfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribIPointer(int arg0,int arg1,int arg2,int arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribIPointer(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribIPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4ubv(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor4ubv(arg0);
    String txt = new String("glColor4ubv(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteBuffers(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glDeleteBuffers(arg0,arg1);
    String txt = new String("glDeleteBuffers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexParameterIivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexParameterIivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexParameterIivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryObjectuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetQueryObjectuiv(arg0,arg1,arg2);
    String txt = new String("glGetQueryObjectuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantsvEXT(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVariantsvEXT(arg0,arg1,arg2);
    String txt = new String("glVariantsvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3hv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3hv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib3hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4bvARB(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4bvARB(arg0,arg1);
    String txt = new String("glVertexAttrib4bvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiDrawElementsIndirectAMD(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glMultiDrawElementsIndirectAMD(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiDrawElementsIndirectAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord1fv(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1fv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord1fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3bv(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3bv(arg0);
    String txt = new String("glSecondaryColor3bv(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glPathCoordsNV(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glPathCoordsNV(arg0,arg1,arg2,arg3);
    String txt = new String("glPathCoordsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4iv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4iv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI4iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glGetProgramResourceLocationIndex(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetProgramResourceLocationIndex(arg0,arg1,arg2);
    String txt = new String("glGetProgramResourceLocationIndex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glProgramUniformMatrix4x2dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4x2dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix4x2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.DoubleBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glColorP3uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glColorP3uiv(arg0,arg1,arg2);
    String txt = new String("glColorP3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPushClientAttribDefaultEXT(int arg0)
  {
        checkContext();
downstreamGL4bc.glPushClientAttribDefaultEXT(arg0);
    String txt = new String("glPushClientAttribDefaultEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4iv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor4iv(arg0,arg1);
    String txt = new String("glColor4iv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexParameterfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexParameterfvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMultiTexParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEvalCoord1dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glEvalCoord1dv(arg0,arg1);
    String txt = new String("glEvalCoord1dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSetLocalConstantEXT(int arg0,int arg1,java.nio.Buffer arg2)
  {
        checkContext();
downstreamGL4bc.glSetLocalConstantEXT(arg0,arg1,arg2);
    String txt = new String("glSetLocalConstantEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4iv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex4iv(arg0,arg1);
    String txt = new String("glVertex4iv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformIndices(int arg0,int arg1,java.lang.String[] arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetUniformIndices(arg0,arg1,arg2,arg3);
    String txt = new String("glGetUniformIndices(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[Ljava.lang.String;>" +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetOcclusionQueryivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetOcclusionQueryivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetOcclusionQueryivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenNamesAMD(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGenNamesAMD(arg0,arg1,arg2);
    String txt = new String("glGenNamesAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramEnvParameterfvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetProgramEnvParameterfvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramEnvParameterfvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMaterialiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetMaterialiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMaterialiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3sv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor3sv(arg0);
    String txt = new String("glColor3sv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,long arg7)
  {
        checkContext();
downstreamGL4bc.glTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glTexImage1D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<long> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4Nusv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4Nusv(arg0,arg1);
    String txt = new String("glVertexAttrib4Nusv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glEvalCoord2dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glEvalCoord2dv(arg0);
    String txt = new String("glEvalCoord2dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetFloatIndexedvEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetFloatIndexedvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetFloatIndexedvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixMultTransposefEXT(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMatrixMultTransposefEXT(arg0,arg1,arg2);
    String txt = new String("glMatrixMultTransposefEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int getDefaultReadBuffer()
  {
        return downstreamGL4bc.getDefaultReadBuffer();
  }
  public  void glGetTexParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetTexParameterfv(arg0,arg1,arg2);
    String txt = new String("glGetTexParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexEnvivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexEnvivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMultiTexEnvivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2x3fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2x3fv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix2x3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix4x2fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4x2fv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix4x2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3i(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3i(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform3i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexsv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glIndexsv(arg0);
    String txt = new String("glIndexsv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramLocalParameter4fARB(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParameter4fARB(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramLocalParameter4fARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ", " +
    "<float> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3fv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform3fv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPathColorGenNV(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glPathColorGenNV(arg0,arg1,arg2,arg3);
    String txt = new String("glPathColorGenNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4uivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4uivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform4uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelTransferf(int arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glPixelTransferf(arg0,arg1);
    String txt = new String("glPixelTransferf(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexEnvi(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glTexEnvi(arg0,arg1,arg2);
    String txt = new String("glTexEnvi(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParametersI4ivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParametersI4ivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramEnvParametersI4ivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformHandleui64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformHandleui64vNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformHandleui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramLocalParameter4fvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParameter4fvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glNamedProgramLocalParameter4fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glClearDepthf(float arg0)
  {
        checkContext();
downstreamGL4bc.glClearDepthf(arg0);
    String txt = new String("glClearDepthf(" +
    "<float> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4fv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform4fv(arg0,arg1,arg2);
    String txt = new String("glUniform4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInfoLogARB(int arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetInfoLogARB(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetInfoLogARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3hv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3hv(arg0);
    String txt = new String("glSecondaryColor3hv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix2x3dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix2x3dv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix2x3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultisamplefv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetMultisamplefv(arg0,arg1,arg2);
    String txt = new String("glGetMultisamplefv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2iv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2iv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform2iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1iv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1iv(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform1iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParameter4fvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParameter4fvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramEnvParameter4fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1dv(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform1dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramPipelineInfoLog(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetProgramPipelineInfoLog(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramPipelineInfoLog(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<java.nio.ByteBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetObjectParameterfvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetObjectParameterfvARB(arg0,arg1,arg2);
    String txt = new String("glGetObjectParameterfvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glReadPixels(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6)
  {
        checkContext();
downstreamGL4bc.glReadPixels(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glReadPixels(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramBufferParametersIivNV(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramBufferParametersIivNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramBufferParametersIivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL3ui64vNV(int arg0,java.nio.LongBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL3ui64vNV(arg0,arg1);
    String txt = new String("glVertexAttribL3ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPerfMonitorCountersAMD(int arg0,int[] arg1,int arg2,int[] arg3,int arg4,int arg5,int[] arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glGetPerfMonitorCountersAMD(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glGetPerfMonitorCountersAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawElementsInstancedBaseVertexBaseInstance(int arg0,int arg1,int arg2,long arg3,int arg4,int arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glDrawElementsInstancedBaseVertexBaseInstance(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glDrawElementsInstancedBaseVertexBaseInstance(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4s(int arg0,short arg1,short arg2,short arg3,short arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4s(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttrib4s(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ", " +
    "<short> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3sv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3sv(arg0,arg1);
    String txt = new String("glMultiTexCoord3sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex4fv(arg0);
    String txt = new String("glVertex4fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glDepthRangeIndexed(int arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glDepthRangeIndexed(arg0,arg1,arg2);
    String txt = new String("glDepthRangeIndexed(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoordP2ui(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoordP2ui(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoordP2ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI2uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI2uiv(arg0,arg1);
    String txt = new String("glVertexAttribI2uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramEnvParameterIuivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetProgramEnvParameterIuivNV(arg0,arg1,arg2);
    String txt = new String("glGetProgramEnvParameterIuivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glPrioritizeTextures(int arg0,int[] arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glPrioritizeTextures(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glPrioritizeTextures(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferReadBufferEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glFramebufferReadBufferEXT(arg0,arg1);
    String txt = new String("glFramebufferReadBufferEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4h(int arg0,short arg1,short arg2,short arg3,short arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4h(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttrib4h(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ", " +
    "<short> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2dv(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2dv(arg0,arg1);
    String txt = new String("glMultiTexCoord2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glPathGlyphRangeNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,int arg6,int arg7,float arg8)
  {
        checkContext();
downstreamGL4bc.glPathGlyphRangeNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glPathGlyphRangeNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<float> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4f(int arg0,float arg1,float arg2,float arg3,float arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4f(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttrib4f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4d(int arg0,double arg1,double arg2,double arg3,double arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4d(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttrib4d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ", " +
    "<double> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetConvolutionParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetConvolutionParameteriv(arg0,arg1,arg2);
    String txt = new String("glGetConvolutionParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetTexParameteriv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetTexParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexParameterIuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetTexParameterIuiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetTexParameterIuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetProgramiv(arg0,arg1,arg2);
    String txt = new String("glGetProgramiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexGeni(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glTexGeni(arg0,arg1,arg2);
    String txt = new String("glTexGeni(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParameterI4iNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParameterI4iNV(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramEnvParameterI4iNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL1i64NV(int arg0,long arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL1i64NV(arg0,arg1);
    String txt = new String("glVertexAttribL1i64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryObjecti64v(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetQueryObjecti64v(arg0,arg1,arg2,arg3);
    String txt = new String("glGetQueryObjecti64v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix4x3fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4x3fv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix4x3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2ivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform2ivARB(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform2ivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3f(float arg0,float arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glColor3f(arg0,arg1,arg2);
    String txt = new String("glColor3f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1svARB(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1svARB(arg0,arg1);
    String txt = new String("glVertexAttrib1svARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureLightEXT(int arg0)
  {
        checkContext();
downstreamGL4bc.glTextureLightEXT(arg0);
    String txt = new String("glTextureLightEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathMetricRangeNV(int arg0,int arg1,int arg2,int arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetPathMetricRangeNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetPathMetricRangeNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix3x4dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix3x4dv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix3x4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramBufferParametersIuivNV(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramBufferParametersIuivNV(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramBufferParametersIuivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean isFunctionAvailable(java.lang.String arg0)
  {
        return downstreamGL4bc.isFunctionAvailable(arg0);
  }
  public  void glVertexAttribIFormatNV(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribIFormatNV(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribIFormatNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2svARB(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2svARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib2svARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glBindMaterialParameterEXT(int arg0,int arg1)
  {
        checkContext();
    int _res = downstreamGL4bc.glBindMaterialParameterEXT(arg0,arg1);
    String txt = new String("glBindMaterialParameterEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glCopyPathNV(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glCopyPathNV(arg0,arg1);
    String txt = new String("glCopyPathNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMaterialfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetMaterialfv(arg0,arg1,arg2);
    String txt = new String("glGetMaterialfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glDepthRangeArrayv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glDepthRangeArrayv(arg0,arg1,arg2);
    String txt = new String("glDepthRangeArrayv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiDrawArraysIndirect(int arg0,java.nio.Buffer arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glMultiDrawArraysIndirect(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiDrawArraysIndirect(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveUniformBlockiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetActiveUniformBlockiv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetActiveUniformBlockiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glActiveTexture(int arg0)
  {
        checkContext();
downstreamGL4bc.glActiveTexture(arg0);
    String txt = new String("glActiveTexture(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2dv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform2dv(arg0,arg1,arg2);
    String txt = new String("glUniform2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glLoadMatrixf(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glLoadMatrixf(arg0);
    String txt = new String("glLoadMatrixf(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetIntegeri_v(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetIntegeri_v(arg0,arg1,arg2,arg3);
    String txt = new String("glGetIntegeri_v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix2fvARB(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix2fvARB(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix2fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBindTransformFeedback(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glBindTransformFeedback(arg0,arg1);
    String txt = new String("glBindTransformFeedback(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMapVertexAttrib1fAPPLE(int arg0,int arg1,float arg2,float arg3,int arg4,int arg5,float[] arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glMapVertexAttrib1fAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glMapVertexAttrib1fAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteQueries(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glDeleteQueries(arg0,arg1);
    String txt = new String("glDeleteQueries(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnMapdv(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetnMapdv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetnMapdv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsProgram(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsProgram(arg0);
    String txt = new String("glIsProgram(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexAttribL3ui64NV(int arg0,long arg1,long arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL3ui64NV(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribL3ui64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedFramebufferParameterivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetNamedFramebufferParameterivEXT(arg0,arg1,arg2);
    String txt = new String("glGetNamedFramebufferParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2ui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform2ui64vNV(arg0,arg1,arg2);
    String txt = new String("glUniform2ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetColorTableParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetColorTableParameterfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetColorTableParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParametersI4uivNV(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParametersI4uivNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramEnvParametersI4uivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsNameAMD(int arg0,int arg1)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsNameAMD(arg0,arg1);
    String txt = new String("glIsNameAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glConvolutionFilter2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6)
  {
        checkContext();
downstreamGL4bc.glConvolutionFilter2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glConvolutionFilter2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1ui64NV(int arg0,long arg1)
  {
        checkContext();
downstreamGL4bc.glUniform1ui64NV(arg0,arg1);
    String txt = new String("glUniform1ui64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glDebugMessageInsert(int arg0,int arg1,int arg2,int arg3,int arg4,java.lang.String arg5)
  {
        checkContext();
downstreamGL4bc.glDebugMessageInsert(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glDebugMessageInsert(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.lang.String> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramLocalParameter4fvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParameter4fvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramLocalParameter4fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUseProgram(int arg0)
  {
        checkContext();
downstreamGL4bc.glUseProgram(arg0);
    String txt = new String("glUseProgram(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenerateMipmap(int arg0)
  {
        checkContext();
downstreamGL4bc.glGenerateMipmap(arg0);
    String txt = new String("glGenerateMipmap(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVDPAUUnmapSurfacesNV(int arg0,com.jogamp.common.nio.PointerBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVDPAUUnmapSurfacesNV(arg0,arg1);
    String txt = new String("glVDPAUUnmapSurfacesNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<com.jogamp.common.nio.PointerBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  java.lang.String glGetString(int arg0)
  {
        checkContext();
    java.lang.String _res = downstreamGL4bc.glGetString(arg0);
    String txt = new String("glGetString(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glObjectLabel(int arg0,int arg1,int arg2,byte[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glObjectLabel(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glObjectLabel(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTextureLevelParameterivEXT(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetTextureLevelParameterivEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetTextureLevelParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantdvEXT(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVariantdvEXT(arg0,arg1,arg2);
    String txt = new String("glVariantdvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTextureParameterIivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetTextureParameterIivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetTextureParameterIivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsVBOArrayBound()
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsVBOArrayBound();
    String txt = new String("glIsVBOArrayBound(" +
    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetOcclusionQueryuivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetOcclusionQueryuivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetOcclusionQueryuivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixLoadIdentityEXT(int arg0)
  {
        checkContext();
downstreamGL4bc.glMatrixLoadIdentityEXT(arg0);
    String txt = new String("glMatrixLoadIdentityEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultMatrixd(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glMultMatrixd(arg0);
    String txt = new String("glMultMatrixd(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformSubroutineuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetUniformSubroutineuiv(arg0,arg1,arg2);
    String txt = new String("glGetUniformSubroutineuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4dvARB(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4dvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4dvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnPolygonStipple(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGetnPolygonStipple(arg0,arg1,arg2);
    String txt = new String("glGetnPolygonStipple(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2i64NV(int arg0,int arg1,long arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2i64NV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform2i64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4ivARB(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4ivARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4ivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4s(short arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glTexCoord4s(arg0,arg1,arg2,arg3);
    String txt = new String("glTexCoord4s(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedFramebufferTexture2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glNamedFramebufferTexture2DEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glNamedFramebufferTexture2DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix3fvARB(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix3fvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix3fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4NsvARB(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4NsvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4NsvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3ui64NV(int arg0,int arg1,long arg2,long arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3ui64NV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform3ui64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glValidateProgram(int arg0)
  {
        checkContext();
downstreamGL4bc.glValidateProgram(arg0);
    String txt = new String("glValidateProgram(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInvariantBooleanvEXT(int arg0,int arg1,byte[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetInvariantBooleanvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetInvariantBooleanvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParameterI4ivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParameterI4ivNV(arg0,arg1,arg2);
    String txt = new String("glProgramEnvParameterI4ivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInvariantFloatvEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetInvariantFloatvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetInvariantFloatvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4i(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glTexCoord4i(arg0,arg1,arg2,arg3);
    String txt = new String("glTexCoord4i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribIiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribIiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexAttribIiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int getDefaultReadFramebuffer()
  {
        return downstreamGL4bc.getDefaultReadFramebuffer();
  }
  public  void glMultiTexCoord1dv(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1dv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord1dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4d(double arg0,double arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glTexCoord4d(arg0,arg1,arg2,arg3);
    String txt = new String("glTexCoord4d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveUniformARB(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4,java.nio.IntBuffer arg5,java.nio.ByteBuffer arg6)
  {
        checkContext();
downstreamGL4bc.glGetActiveUniformARB(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetActiveUniformARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ", " +
    "<java.nio.IntBuffer> "+arg5 +    ", " +
    "<java.nio.ByteBuffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4h(short arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glTexCoord4h(arg0,arg1,arg2,arg3);
    String txt = new String("glTexCoord4h(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3d(double arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glColor3d(arg0,arg1,arg2);
    String txt = new String("glColor3d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4f(float arg0,float arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glTexCoord4f(arg0,arg1,arg2,arg3);
    String txt = new String("glTexCoord4f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexArrayIntegervEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexArrayIntegervEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexArrayIntegervEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3ui(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3ui(arg0,arg1,arg2);
    String txt = new String("glSecondaryColor3ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4iv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4iv(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform4iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParameter4dvARB(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParameter4dvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramEnvParameter4dvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3ivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform3ivARB(arg0,arg1,arg2);
    String txt = new String("glUniform3ivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixRotatefEXT(int arg0,float arg1,float arg2,float arg3,float arg4)
  {
        checkContext();
downstreamGL4bc.glMatrixRotatefEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMatrixRotatefEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsBufferResidentNV(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsBufferResidentNV(arg0);
    String txt = new String("glIsBufferResidentNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetnTexImage(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
        checkContext();
downstreamGL4bc.glGetnTexImage(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetnTexImage(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelMapfv(int arg0,int arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glPixelMapfv(arg0,arg1,arg2);
    String txt = new String("glPixelMapfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4fv(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4fv(arg0,arg1);
    String txt = new String("glMultiTexCoord4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3s(short arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glNormal3s(arg0,arg1,arg2);
    String txt = new String("glNormal3s(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord1hv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1hv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord1hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2dARB(int arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2dARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib2dARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramLocalParameterI4uiNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParameterI4uiNV(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramLocalParameterI4uiNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDebugMessageEnableAMD(int arg0,int arg1,int arg2,int[] arg3,int arg4,boolean arg5)
  {
        checkContext();
downstreamGL4bc.glDebugMessageEnableAMD(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glDebugMessageEnableAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<boolean> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColorP3uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glSecondaryColorP3uiv(arg0,arg1,arg2);
    String txt = new String("glSecondaryColorP3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3h(short arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glNormal3h(arg0,arg1,arg2);
    String txt = new String("glNormal3h(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexGenfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetTexGenfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetTexGenfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2x3dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2x3dv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix2x3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI1uivEXT(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI1uivEXT(arg0,arg1);
    String txt = new String("glVertexAttribI1uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glBindBuffer(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glBindBuffer(arg0,arg1);
    String txt = new String("glBindBuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glInitNames()
  {
        checkContext();
downstreamGL4bc.glInitNames();
    String txt = new String("glInitNames(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferParameteri(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glFramebufferParameteri(arg0,arg1,arg2);
    String txt = new String("glFramebufferParameteri(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3hv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex3hv(arg0,arg1);
    String txt = new String("glVertex3hv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3dv(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform3dv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBlendEquationSeparate(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glBlendEquationSeparate(arg0,arg1);
    String txt = new String("glBlendEquationSeparate(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4sv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex4sv(arg0);
    String txt = new String("glVertex4sv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3hv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord3hv(arg0);
    String txt = new String("glTexCoord3hv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glEvalCoord1fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glEvalCoord1fv(arg0,arg1);
    String txt = new String("glEvalCoord1fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawElementsIndirect(int arg0,int arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glDrawElementsIndirect(arg0,arg1,arg2);
    String txt = new String("glDrawElementsIndirect(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetFramebufferAttachmentParameteriv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetFramebufferAttachmentParameteriv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetFramebufferAttachmentParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexiv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glIndexiv(arg0,arg1);
    String txt = new String("glIndexiv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2sv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2sv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib2sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramSubroutineParametersuivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glProgramSubroutineParametersuivNV(arg0,arg1,arg2);
    String txt = new String("glProgramSubroutineParametersuivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3uiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3uiv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  long glCreateSyncFromCLeventARB(long arg0,long arg1,int arg2)
  {
        checkContext();
    long _res = downstreamGL4bc.glCreateSyncFromCLeventARB(arg0,arg1,arg2);
    String txt = new String("glCreateSyncFromCLeventARB(" +
    "<long> "+arg0 +    ", " +
    "<long> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glTextureBufferEXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glTextureBufferEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glTextureBufferEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3uiv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor3uiv(arg0,arg1);
    String txt = new String("glColor3uiv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetObjectPtrLabel(java.nio.Buffer arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetObjectPtrLabel(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetObjectPtrLabel(" +
    "<java.nio.Buffer> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPerfMonitorCounterStringAMD(int arg0,int arg1,int arg2,int[] arg3,int arg4,byte[] arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glGetPerfMonitorCounterStringAMD(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetPerfMonitorCounterStringAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyMultiTexImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8)
  {
        checkContext();
downstreamGL4bc.glCopyMultiTexImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glCopyMultiTexImage2DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4usvARB(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4usvARB(arg0,arg1);
    String txt = new String("glVertexAttrib4usvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI3i(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI3i(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribI3i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnUniformfv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetnUniformfv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetnUniformfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFogCoordfv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glFogCoordfv(arg0);
    String txt = new String("glFogCoordfv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathDashArrayNV(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGetPathDashArrayNV(arg0,arg1);
    String txt = new String("glGetPathDashArrayNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glObjectLabel(int arg0,int arg1,int arg2,java.nio.ByteBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glObjectLabel(arg0,arg1,arg2,arg3);
    String txt = new String("glObjectLabel(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glEndPerfMonitorAMD(int arg0)
  {
        checkContext();
downstreamGL4bc.glEndPerfMonitorAMD(arg0);
    String txt = new String("glEndPerfMonitorAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelStorei(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glPixelStorei(arg0,arg1);
    String txt = new String("glPixelStorei(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glNormal3iv(arg0);
    String txt = new String("glNormal3iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glValidateProgramARB(int arg0)
  {
        checkContext();
downstreamGL4bc.glValidateProgramARB(arg0);
    String txt = new String("glValidateProgramARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3i64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform3i64vNV(arg0,arg1,arg2);
    String txt = new String("glUniform3i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI3iEXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI3iEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribI3iEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnPolygonStipple(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGetnPolygonStipple(arg0,arg1);
    String txt = new String("glGetnPolygonStipple(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  int glVideoCaptureNV(int arg0,int[] arg1,int arg2,long[] arg3,int arg4)
  {
        checkContext();
    int _res = downstreamGL4bc.glVideoCaptureNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVideoCaptureNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glProgramLocalParameterI4ivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParameterI4ivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramLocalParameterI4ivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathParameterivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetPathParameterivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetPathParameterivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCoverStrokePathNV(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glCoverStrokePathNV(arg0,arg1);
    String txt = new String("glCoverStrokePathNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2h(int arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2h(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord2h(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2i(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2i(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord2i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3i(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glNormal3i(arg0,arg1,arg2);
    String txt = new String("glNormal3i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2x4fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2x4fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix2x4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryIndexediv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetQueryIndexediv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetQueryIndexediv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInvariantBooleanvEXT(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetInvariantBooleanvEXT(arg0,arg1,arg2);
    String txt = new String("glGetInvariantBooleanvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2d(int arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2d(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord2d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2f(int arg0,float arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2f(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord2f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glCallLists(int arg0,int arg1,java.nio.Buffer arg2)
  {
        checkContext();
downstreamGL4bc.glCallLists(arg0,arg1,arg2);
    String txt = new String("glCallLists(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramLocalParameters4fvEXT(int arg0,int arg1,int arg2,int arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParameters4fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glNamedProgramLocalParameters4fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnUniformiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetnUniformiv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetnUniformiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glInterpolatePathsNV(int arg0,int arg1,int arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glInterpolatePathsNV(arg0,arg1,arg2,arg3);
    String txt = new String("glInterpolatePathsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyConvolutionFilter1D(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glCopyConvolutionFilter1D(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glCopyConvolutionFilter1D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3us(short arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3us(arg0,arg1,arg2);
    String txt = new String("glSecondaryColor3us(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glSwizzleEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glSwizzleEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glSwizzleEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4Nsv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4Nsv(arg0,arg1);
    String txt = new String("glVertexAttrib4Nsv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  int glCreateProgramObjectARB()
  {
        checkContext();
    int _res = downstreamGL4bc.glCreateProgramObjectARB();
    String txt = new String("glCreateProgramObjectARB(" +
    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetProgramEnvParameterdvARB(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetProgramEnvParameterdvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramEnvParameterdvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDisableVertexAttribArray(int arg0)
  {
        checkContext();
downstreamGL4bc.glDisableVertexAttribArray(arg0);
    String txt = new String("glDisableVertexAttribArray(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBindSampler(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glBindSampler(arg0,arg1);
    String txt = new String("glBindSampler(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4sv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4sv(arg0,arg1);
    String txt = new String("glVertexAttribI4sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedProgramLocalParameterIuivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetNamedProgramLocalParameterIuivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetNamedProgramLocalParameterIuivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glClampColor(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glClampColor(arg0,arg1);
    String txt = new String("glClampColor(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBindVertexShaderEXT(int arg0)
  {
        checkContext();
downstreamGL4bc.glBindVertexShaderEXT(arg0);
    String txt = new String("glBindVertexShaderEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBlendFuncSeparateIndexedAMD(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glBlendFuncSeparateIndexedAMD(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glBlendFuncSeparateIndexedAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix4fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix4fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glLinkProgram(int arg0)
  {
        checkContext();
downstreamGL4bc.glLinkProgram(arg0);
    String txt = new String("glLinkProgram(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteFencesAPPLE(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glDeleteFencesAPPLE(arg0,arg1);
    String txt = new String("glDeleteFencesAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribIFormat(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribIFormat(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribIFormat(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColorTableParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glColorTableParameterfv(arg0,arg1,arg2);
    String txt = new String("glColorTableParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glFlushVertexArrayRangeNV()
  {
        checkContext();
downstreamGL4bc.glFlushVertexArrayRangeNV();
    String txt = new String("glFlushVertexArrayRangeNV(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2d(double arg0,double arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord2d(arg0,arg1);
    String txt = new String("glTexCoord2d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2f(float arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord2f(arg0,arg1);
    String txt = new String("glTexCoord2f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexStorage3DMultisample(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,boolean arg6)
  {
        checkContext();
downstreamGL4bc.glTexStorage3DMultisample(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glTexStorage3DMultisample(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<boolean> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glMapParameterfvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glMapParameterfvNV(arg0,arg1,arg2);
    String txt = new String("glMapParameterfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexStorageSparseAMD(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glTexStorageSparseAMD(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glTexStorageSparseAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4ui(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4ui(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribI4ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord2iv(arg0);
    String txt = new String("glTexCoord2iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2uiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2uiv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform2uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteVertexArrays(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDeleteVertexArrays(arg0,arg1,arg2);
    String txt = new String("glDeleteVertexArrays(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glGetUniformBlockIndex(int arg0,java.lang.String arg1)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetUniformBlockIndex(arg0,arg1);
    String txt = new String("glGetUniformBlockIndex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.lang.String> "+arg1 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glTexCoord2h(short arg0,short arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord2h(arg0,arg1);
    String txt = new String("glTexCoord2h(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2ui64NV(int arg0,long arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glUniform2ui64NV(arg0,arg1,arg2);
    String txt = new String("glUniform2ui64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2i(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord2i(arg0,arg1);
    String txt = new String("glTexCoord2i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2s(short arg0,short arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord2s(arg0,arg1);
    String txt = new String("glTexCoord2s(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4Nub(int arg0,byte arg1,byte arg2,byte arg3,byte arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4Nub(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttrib4Nub(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<byte> "+arg1 +    ", " +
    "<byte> "+arg2 +    ", " +
    "<byte> "+arg3 +    ", " +
    "<byte> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetRenderbufferParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetRenderbufferParameteriv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetRenderbufferParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexBlendARB(int arg0)
  {
        checkContext();
downstreamGL4bc.glVertexBlendARB(arg0);
    String txt = new String("glVertexBlendARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsRenderbuffer(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsRenderbuffer(arg0);
    String txt = new String("glIsRenderbuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetFloati_v(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetFloati_v(arg0,arg1,arg2,arg3);
    String txt = new String("glGetFloati_v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetClipPlanef(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGetClipPlanef(arg0,arg1);
    String txt = new String("glGetClipPlanef(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantivEXT(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVariantivEXT(arg0,arg1);
    String txt = new String("glVariantivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glPointParameterfv(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glPointParameterfv(arg0,arg1,arg2);
    String txt = new String("glPointParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexImage3DMultisample(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,boolean arg6)
  {
        checkContext();
downstreamGL4bc.glTexImage3DMultisample(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glTexImage3DMultisample(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<boolean> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glColorPointer(javax.media.opengl.GLArrayData arg0)
  {
        checkContext();
downstreamGL4bc.glColorPointer(arg0);
    String txt = new String("glColorPointer(" +
    "<javax.media.opengl.GLArrayData> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribs4hv(int arg0,int arg1,java.nio.ShortBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribs4hv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribs4hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetUniformivARB(arg0,arg1,arg2,arg3);
    String txt = new String("glGetUniformivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexEnvfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetTexEnvfv(arg0,arg1,arg2);
    String txt = new String("glGetTexEnvfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glConvolutionParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glConvolutionParameterfv(arg0,arg1,arg2);
    String txt = new String("glConvolutionParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3sv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord3sv(arg0);
    String txt = new String("glTexCoord3sv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glEnableClientStateIndexedEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glEnableClientStateIndexedEXT(arg0,arg1);
    String txt = new String("glEnableClientStateIndexedEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEnableIndexed(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glEnableIndexed(arg0,arg1);
    String txt = new String("glEnableIndexed(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPolygonOffset(float arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glPolygonOffset(arg0,arg1);
    String txt = new String("glPolygonOffset(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4s(int arg0,short arg1,short arg2,short arg3,short arg4)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4s(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiTexCoord4s(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ", " +
    "<short> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord2sv(arg0,arg1);
    String txt = new String("glTexCoord2sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix3x2fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix3x2fv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix3x2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedBufferParameterivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetNamedBufferParameterivEXT(arg0,arg1,arg2);
    String txt = new String("glGetNamedBufferParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiDrawElementsIndirect(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glMultiDrawElementsIndirect(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiDrawElementsIndirect(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveSubroutineUniformName(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4,java.nio.ByteBuffer arg5)
  {
        checkContext();
downstreamGL4bc.glGetActiveSubroutineUniformName(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetActiveSubroutineUniformName(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ", " +
    "<java.nio.ByteBuffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetShaderInfoLog(int arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetShaderInfoLog(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetShaderInfoLog(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMap1f(int arg0,float arg1,float arg2,int arg3,int arg4,float[] arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glMap1f(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glMap1f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCoverFillPathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,float[] arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glCoverFillPathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glCoverFillPathInstancedNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMakeTextureHandleNonResidentNV(long arg0)
  {
        checkContext();
downstreamGL4bc.glMakeTextureHandleNonResidentNV(arg0);
    String txt = new String("glMakeTextureHandleNonResidentNV(" +
    "<long> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetIntegerui64i_vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetIntegerui64i_vNV(arg0,arg1,arg2);
    String txt = new String("glGetIntegerui64i_vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnSeparableFilter(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4,int arg5,java.nio.Buffer arg6,java.nio.Buffer arg7)
  {
        checkContext();
downstreamGL4bc.glGetnSeparableFilter(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glGetnSeparableFilter(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg4 +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg6 +    ", " +
    "<java.nio.Buffer> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4dv(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4dv(arg0,arg1);
    String txt = new String("glVertexAttrib4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTessellationModeAMD(int arg0)
  {
        checkContext();
downstreamGL4bc.glTessellationModeAMD(arg0);
    String txt = new String("glTessellationModeAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glScissorArrayv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glScissorArrayv(arg0,arg1,arg2,arg3);
    String txt = new String("glScissorArrayv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPopMatrix()
  {
        checkContext();
downstreamGL4bc.glPopMatrix();
    String txt = new String("glPopMatrix(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glTexEnvfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glTexEnvfv(arg0,arg1,arg2);
    String txt = new String("glTexEnvfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexRenderbufferNV(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexRenderbufferNV(arg0,arg1);
    String txt = new String("glTexRenderbufferNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4i64NV(int arg0,long arg1,long arg2,long arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glUniform4i64NV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniform4i64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glStencilClearTagEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glStencilClearTagEXT(arg0,arg1);
    String txt = new String("glStencilClearTagEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenVertexArrays(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGenVertexArrays(arg0,arg1,arg2);
    String txt = new String("glGenVertexArrays(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glWaitSync(long arg0,int arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glWaitSync(arg0,arg1,arg2);
    String txt = new String("glWaitSync(" +
    "<long> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glShadeModel(int arg0)
  {
        checkContext();
downstreamGL4bc.glShadeModel(arg0);
    String txt = new String("glShadeModel(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glLightModeliv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glLightModeliv(arg0,arg1);
    String txt = new String("glLightModeliv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4iv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord4iv(arg0,arg1);
    String txt = new String("glTexCoord4iv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColorPointer(int arg0,int arg1,int arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glColorPointer(arg0,arg1,arg2,arg3);
    String txt = new String("glColorPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3dvARB(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3dvARB(arg0,arg1);
    String txt = new String("glVertexAttrib3dvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4NuivARB(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4NuivARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4NuivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMap2f(int arg0,float arg1,float arg2,int arg3,int arg4,float arg5,float arg6,int arg7,int arg8,float[] arg9,int arg10)
  {
        checkContext();
downstreamGL4bc.glMap2f(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glMap2f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<float> "+arg5 +    ", " +
    "<float> "+arg6 +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg10).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix4fvARB(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix4fvARB(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix4fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCullParameterdvEXT(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glCullParameterdvEXT(arg0,arg1);
    String txt = new String("glCullParameterdvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glFogiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glFogiv(arg0,arg1);
    String txt = new String("glFogiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexWeightfvEXT(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertexWeightfvEXT(arg0,arg1);
    String txt = new String("glVertexWeightfvEXT(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexArrayPointervEXT(int arg0,int arg1,com.jogamp.common.nio.PointerBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVertexArrayPointervEXT(arg0,arg1,arg2);
    String txt = new String("glGetVertexArrayPointervEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<com.jogamp.common.nio.PointerBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord1fv(arg0,arg1);
    String txt = new String("glTexCoord1fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3fv(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3fv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyTexSubImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glCopyTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glCopyTexSubImage2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMapdv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetMapdv(arg0,arg1,arg2);
    String txt = new String("glGetMapdv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureParameteriEXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glTextureParameteriEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glTextureParameteriEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPixelMapfv(int arg0,long arg1)
  {
        checkContext();
downstreamGL4bc.glGetPixelMapfv(arg0,arg1);
    String txt = new String("glGetPixelMapfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glValidateProgramPipeline(int arg0)
  {
        checkContext();
downstreamGL4bc.glValidateProgramPipeline(arg0);
    String txt = new String("glValidateProgramPipeline(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glGetDebugMessageLog(int arg0,int arg1,int[] arg2,int arg3,int[] arg4,int arg5,int[] arg6,int arg7,int[] arg8,int arg9,int[] arg10,int arg11,byte[] arg12,int arg13)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetDebugMessageLog(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
    String txt = new String("glGetDebugMessageLog(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg11).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg13).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetPathTexGenfvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetPathTexGenfvNV(arg0,arg1,arg2);
    String txt = new String("glGetPathTexGenfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glNormalP3uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glNormalP3uiv(arg0,arg1,arg2);
    String txt = new String("glNormalP3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL2ui64vNV(int arg0,java.nio.LongBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL2ui64vNV(arg0,arg1);
    String txt = new String("glVertexAttribL2ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2s(int arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2s(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord2s(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos3dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glRasterPos3dv(arg0);
    String txt = new String("glRasterPos3dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos2iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glWindowPos2iv(arg0);
    String txt = new String("glWindowPos2iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedStringARB(int arg0,java.lang.String arg1,int arg2,int[] arg3,int arg4,byte[] arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glGetNamedStringARB(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetNamedStringARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.lang.String> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos4dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos4dv(arg0,arg1);
    String txt = new String("glRasterPos4dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexGeniv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glTexGeniv(arg0,arg1,arg2,arg3);
    String txt = new String("glTexGeniv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glBindTextureUnitParameterEXT(int arg0,int arg1)
  {
        checkContext();
    int _res = downstreamGL4bc.glBindTextureUnitParameterEXT(arg0,arg1);
    String txt = new String("glBindTextureUnitParameterEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glPathCoverDepthFuncNV(int arg0)
  {
        checkContext();
downstreamGL4bc.glPathCoverDepthFuncNV(arg0);
    String txt = new String("glPathCoverDepthFuncNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI1i(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI1i(arg0,arg1);
    String txt = new String("glVertexAttribI1i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean hasBasicFBOSupport()
  {
        return downstreamGL4bc.hasBasicFBOSupport();
  }
  public  long glVDPAURegisterVideoSurfaceNV(java.nio.Buffer arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
    long _res = downstreamGL4bc.glVDPAURegisterVideoSurfaceNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVDPAURegisterVideoSurfaceNV(" +
    "<java.nio.Buffer> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexAttribI1uiEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI1uiEXT(arg0,arg1);
    String txt = new String("glVertexAttribI1uiEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4d(int arg0,double arg1,double arg2,double arg3,double arg4)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4d(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiTexCoord4d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ", " +
    "<double> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glResumeTransformFeedback()
  {
        checkContext();
downstreamGL4bc.glResumeTransformFeedback();
    String txt = new String("glResumeTransformFeedback(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2d(int arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2d(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib2d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyTexSubImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glCopyTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glCopyTexSubImage1D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4f(int arg0,float arg1,float arg2,float arg3,float arg4)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4f(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiTexCoord4f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixIndexusvARB(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMatrixIndexusvARB(arg0,arg1);
    String txt = new String("glMatrixIndexusvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3uivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3uivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform3uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4i(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4i(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiTexCoord4i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex2dv(arg0);
    String txt = new String("glVertex2dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2f(int arg0,float arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2f(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib2f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glFinishTextureSUNX()
  {
        checkContext();
downstreamGL4bc.glFinishTextureSUNX();
    String txt = new String("glFinishTextureSUNX(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4h(int arg0,short arg1,short arg2,short arg3,short arg4)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4h(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiTexCoord4h(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ", " +
    "<short> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetFloatv(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGetFloatv(arg0,arg1,arg2);
    String txt = new String("glGetFloatv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2h(int arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2h(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib2h(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribP3uiv(int arg0,int arg1,boolean arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribP3uiv(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribP3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexGendvEXT(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexGendvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMultiTexGendvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex3dv(arg0,arg1);
    String txt = new String("glVertex3dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetIntegerv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGetIntegerv(arg0,arg1,arg2);
    String txt = new String("glGetIntegerv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glStencilFillPathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,int arg6,java.nio.FloatBuffer arg7)
  {
        checkContext();
downstreamGL4bc.glStencilFillPathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glStencilFillPathInstancedNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParameter4fARB(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParameter4fARB(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramEnvParameter4fARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ", " +
    "<float> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVideoCaptureStreamfvNV(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetVideoCaptureStreamfvNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVideoCaptureStreamfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos3fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glWindowPos3fv(arg0,arg1);
    String txt = new String("glWindowPos3fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetIntegerIndexedv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetIntegerIndexedv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetIntegerIndexedv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2s(int arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2s(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib2s(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsPBOPackBound()
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsPBOPackBound();
    String txt = new String("glIsPBOPackBound(" +
    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexAttribPointerARB(int arg0,int arg1,int arg2,boolean arg3,int arg4,long arg5)
  {
        checkContext();
downstreamGL4bc.glVertexAttribPointerARB(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glVertexAttribPointerARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<long> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInternalformati64v(int arg0,int arg1,int arg2,int arg3,java.nio.LongBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetInternalformati64v(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetInternalformati64v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1hv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1hv(arg0,arg1);
    String txt = new String("glVertexAttrib1hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetBufferParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetBufferParameteriv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetBufferParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteTextures(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDeleteTextures(arg0,arg1,arg2);
    String txt = new String("glDeleteTextures(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureParameterIuivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glTextureParameterIuivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glTextureParameterIuivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBeginVertexShaderEXT()
  {
        checkContext();
downstreamGL4bc.glBeginVertexShaderEXT();
    String txt = new String("glBeginVertexShaderEXT(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord1bvOES(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1bvOES(arg0,arg1);
    String txt = new String("glMultiTexCoord1bvOES(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMinmaxParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetMinmaxParameteriv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMinmaxParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4ubvEXT(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4ubvEXT(arg0,arg1);
    String txt = new String("glVertexAttribI4ubvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnUniformdv(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetnUniformdv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetnUniformdv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glBindFramebuffer(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glBindFramebuffer(arg0,arg1);
    String txt = new String("glBindFramebuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexd(double arg0)
  {
        checkContext();
downstreamGL4bc.glIndexd(arg0);
    String txt = new String("glIndexd(" +
    "<double> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPerfMonitorCounterDataAMD(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetPerfMonitorCounterDataAMD(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetPerfMonitorCounterDataAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPerfMonitorCounterDataAMD(int arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glGetPerfMonitorCounterDataAMD(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetPerfMonitorCounterDataAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4i(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4i(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribI4i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedMultiTexImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
        checkContext();
downstreamGL4bc.glCompressedMultiTexImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glCompressedMultiTexImage1DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3usv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3usv(arg0,arg1);
    String txt = new String("glSecondaryColor3usv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTextureImageEXT(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
        checkContext();
downstreamGL4bc.glGetTextureImageEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetTextureImageEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glShaderSource(int arg0,int arg1,java.lang.String[] arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glShaderSource(arg0,arg1,arg2,arg3);
    String txt = new String("glShaderSource(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[Ljava.lang.String;>" +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultTransposeMatrixf(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glMultTransposeMatrixf(arg0);
    String txt = new String("glMultTransposeMatrixf(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2bvOES(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord2bvOES(arg0);
    String txt = new String("glTexCoord2bvOES(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4ui64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4ui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform4ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVariantFloatvEXT(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVariantFloatvEXT(arg0,arg1,arg2);
    String txt = new String("glGetVariantFloatvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedTexSubImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,long arg10)
  {
        checkContext();
downstreamGL4bc.glCompressedTexSubImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glCompressedTexSubImage3D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<long> "+arg10 +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3sv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glNormal3sv(arg0);
    String txt = new String("glNormal3sv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glSetFenceAPPLE(int arg0)
  {
        checkContext();
downstreamGL4bc.glSetFenceAPPLE(arg0);
    String txt = new String("glSetFenceAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetFloati_vEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetFloati_vEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetFloati_vEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveSubroutineUniformiv(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetActiveSubroutineUniformiv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetActiveSubroutineUniformiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3f(float arg0,float arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3f(arg0,arg1,arg2);
    String txt = new String("glSecondaryColor3f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glEndVideoCaptureNV(int arg0)
  {
        checkContext();
downstreamGL4bc.glEndVideoCaptureNV(arg0);
    String txt = new String("glEndVideoCaptureNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glGenPathsNV(int arg0)
  {
        checkContext();
    int _res = downstreamGL4bc.glGenPathsNV(arg0);
    String txt = new String("glGenPathsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glUniform1fvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform1fvARB(arg0,arg1,arg2);
    String txt = new String("glUniform1fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glSamplerParameterIuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glSamplerParameterIuiv(arg0,arg1,arg2);
    String txt = new String("glSamplerParameterIuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4hv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor4hv(arg0);
    String txt = new String("glColor4hv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix2fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix2fv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnPixelMapuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetnPixelMapuiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetnPixelMapuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribs3hv(int arg0,int arg1,short[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribs3hv(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribs3hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1i64NV(int arg0,int arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1i64NV(arg0,arg1,arg2);
    String txt = new String("glProgramUniform1i64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoordP3uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoordP3uiv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoordP3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glNormal3dv(arg0,arg1);
    String txt = new String("glNormal3dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawRangeElementsBaseVertex(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glDrawRangeElementsBaseVertex(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glDrawRangeElementsBaseVertex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<long> "+arg5 +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexArrayIndexOffsetEXT(int arg0,int arg1,int arg2,int arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glVertexArrayIndexOffsetEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexArrayIndexOffsetEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3i(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glTexCoord3i(arg0,arg1,arg2);
    String txt = new String("glTexCoord3i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantbvEXT(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVariantbvEXT(arg0,arg1,arg2);
    String txt = new String("glVariantbvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4iv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4iv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFogCoordf(float arg0)
  {
        checkContext();
downstreamGL4bc.glFogCoordf(arg0);
    String txt = new String("glFogCoordf(" +
    "<float> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos3f(float arg0,float arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glRasterPos3f(arg0,arg1,arg2);
    String txt = new String("glRasterPos3f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelTransformParameterfvEXT(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glPixelTransformParameterfvEXT(arg0,arg1,arg2);
    String txt = new String("glPixelTransformParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMap1d(int arg0,double arg1,double arg2,int arg3,int arg4,java.nio.DoubleBuffer arg5)
  {
        checkContext();
downstreamGL4bc.glMap1d(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glMap1d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos3sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos3sv(arg0,arg1);
    String txt = new String("glRasterPos3sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3bv(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor3bv(arg0,arg1);
    String txt = new String("glColor3bv(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPathTexGenNV(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glPathTexGenNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glPathTexGenNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix3dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix3dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord1dv(arg0);
    String txt = new String("glTexCoord1dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI2i(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI2i(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI2i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glGetDebugMessageLogAMD(int arg0,int arg1,int[] arg2,int arg3,int[] arg4,int arg5,int[] arg6,int arg7,int[] arg8,int arg9,byte[] arg10,int arg11)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetDebugMessageLogAMD(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    String txt = new String("glGetDebugMessageLogAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg11).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetnMapiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetnMapiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetnMapiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos3fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos3fv(arg0,arg1);
    String txt = new String("glRasterPos3fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord2dv(arg0,arg1);
    String txt = new String("glTexCoord2dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1f(int arg0,int arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1f(arg0,arg1,arg2);
    String txt = new String("glProgramUniform1f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glWeightivARB(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glWeightivARB(arg0,arg1);
    String txt = new String("glWeightivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
        checkContext();
downstreamGL4bc.glMultiTexImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glMultiTexImage2DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg9 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetLightfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetLightfv(arg0,arg1,arg2);
    String txt = new String("glGetLightfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3ui64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3ui64vNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform3ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenOcclusionQueriesNV(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenOcclusionQueriesNV(arg0,arg1);
    String txt = new String("glGenOcclusionQueriesNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawPixels(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
        checkContext();
downstreamGL4bc.glDrawPixels(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glDrawPixels(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoordP2uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoordP2uiv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoordP2uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glLightfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glLightfv(arg0,arg1,arg2);
    String txt = new String("glLightfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glOrtho(double arg0,double arg1,double arg2,double arg3,double arg4,double arg5)
  {
        checkContext();
downstreamGL4bc.glOrtho(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glOrtho(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ", " +
    "<double> "+arg4 +    ", " +
    "<double> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMapAttribParameterfvNV(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetMapAttribParameterfvNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMapAttribParameterfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3ubv(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor3ubv(arg0,arg1);
    String txt = new String("glColor3ubv(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4Niv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4Niv(arg0,arg1);
    String txt = new String("glVertexAttrib4Niv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3dv(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3dv(arg0,arg1);
    String txt = new String("glVertexAttrib3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glEnablei(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glEnablei(arg0,arg1);
    String txt = new String("glEnablei(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMapfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetMapfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMapfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMap2d(int arg0,double arg1,double arg2,int arg3,int arg4,double arg5,double arg6,int arg7,int arg8,java.nio.DoubleBuffer arg9)
  {
        checkContext();
downstreamGL4bc.glMap2d(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glMap2d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<double> "+arg5 +    ", " +
    "<double> "+arg6 +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg9 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramStageiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetProgramStageiv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetProgramStageiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetUniformiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetUniformiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyConvolutionFilter2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glCopyConvolutionFilter2D(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glCopyConvolutionFilter2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexArraySecondaryColorOffsetEXT(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
        checkContext();
downstreamGL4bc.glVertexArraySecondaryColorOffsetEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glVertexArraySecondaryColorOffsetEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<long> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glPassThrough(float arg0)
  {
        checkContext();
downstreamGL4bc.glPassThrough(arg0);
    String txt = new String("glPassThrough(" +
    "<float> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4hv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex4hv(arg0);
    String txt = new String("glVertex4hv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramLocalParameterfvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetProgramLocalParameterfvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramLocalParameterfvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPointParameteri(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glPointParameteri(arg0,arg1);
    String txt = new String("glPointParameteri(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBindTexture(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glBindTexture(arg0,arg1);
    String txt = new String("glBindTexture(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexGendEXT(int arg0,int arg1,int arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexGendEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexGendEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2fv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform2fv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3svARB(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3svARB(arg0,arg1);
    String txt = new String("glVertexAttrib3svARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1i(int arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord1i(arg0);
    String txt = new String("glTexCoord1i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3dARB(int arg0,double arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3dARB(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttrib3dARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexFormatNV(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glIndexFormatNV(arg0,arg1);
    String txt = new String("glIndexFormatNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex3sv(arg0,arg1);
    String txt = new String("glVertex3sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetHistogramParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetHistogramParameterfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetHistogramParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex2fv(arg0,arg1);
    String txt = new String("glVertex2fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord1i(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1i(arg0,arg1);
    String txt = new String("glMultiTexCoord1i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteLists(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glDeleteLists(arg0,arg1);
    String txt = new String("glDeleteLists(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI1iv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI1iv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI1iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureNormalEXT(int arg0)
  {
        checkContext();
downstreamGL4bc.glTextureNormalEXT(arg0);
    String txt = new String("glTextureNormalEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix3x2dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix3x2dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix3x2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.DoubleBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexAttribiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexParameterIuivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexParameterIuivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMultiTexParameterIuivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glViewportArrayv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glViewportArrayv(arg0,arg1,arg2,arg3);
    String txt = new String("glViewportArrayv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPathSubCoordsNV(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
        checkContext();
downstreamGL4bc.glPathSubCoordsNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glPathSubCoordsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribLFormat(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribLFormat(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribLFormat(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRenderbufferStorageMultisample(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glRenderbufferStorageMultisample(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glRenderbufferStorageMultisample(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2dvARB(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2dvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib2dvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glLightiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glLightiv(arg0,arg1,arg2,arg3);
    String txt = new String("glLightiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4hv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4hv(arg0,arg1);
    String txt = new String("glMultiTexCoord4hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathColorGenivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetPathColorGenivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetPathColorGenivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnMinmax(int arg0,boolean arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
        checkContext();
downstreamGL4bc.glGetnMinmax(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetnMinmax(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<boolean> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexArrayNormalOffsetEXT(int arg0,int arg1,int arg2,int arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glVertexArrayNormalOffsetEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexArrayNormalOffsetEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  int glCreateShaderObjectARB(int arg0)
  {
        checkContext();
    int _res = downstreamGL4bc.glCreateShaderObjectARB(arg0);
    String txt = new String("glCreateShaderObjectARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetPathMetricsNV(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4,int arg5,java.nio.FloatBuffer arg6)
  {
        checkContext();
downstreamGL4bc.glGetPathMetricsNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetPathMetricsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetSamplerParameterIiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetSamplerParameterIiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetSamplerParameterIiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordPointer(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glTexCoordPointer(arg0,arg1,arg2,arg3);
    String txt = new String("glTexCoordPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3ub(byte arg0,byte arg1,byte arg2)
  {
        checkContext();
downstreamGL4bc.glColor3ub(arg0,arg1,arg2);
    String txt = new String("glColor3ub(" +
    "<byte> "+arg0 +    ", " +
    "<byte> "+arg1 +    ", " +
    "<byte> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glPushAttrib(int arg0)
  {
        checkContext();
downstreamGL4bc.glPushAttrib(arg0);
    String txt = new String("glPushAttrib(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix4dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4dv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI3iv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI3iv(arg0,arg1);
    String txt = new String("glVertexAttribI3iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1sv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1sv(arg0,arg1);
    String txt = new String("glVertexAttrib1sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribdvARB(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribdvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexAttribdvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1fv(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1fv(arg0,arg1);
    String txt = new String("glVertexAttrib1fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord1iv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1iv(arg0,arg1);
    String txt = new String("glMultiTexCoord1iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4ubv(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4ubv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI4ubv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord3fv(arg0);
    String txt = new String("glTexCoord3fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glUnmapBuffer(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glUnmapBuffer(arg0);
    String txt = new String("glUnmapBuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glFogCoordd(double arg0)
  {
        checkContext();
downstreamGL4bc.glFogCoordd(arg0);
    String txt = new String("glFogCoordd(" +
    "<double> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3i(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3i(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexCoord3i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribP3ui(int arg0,int arg1,boolean arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribP3ui(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribP3ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEnableVertexArrayAttribEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glEnableVertexArrayAttribEXT(arg0,arg1);
    String txt = new String("glEnableVertexArrayAttribEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEnd()
  {
        checkContext();
downstreamGL4bc.glEnd();
    insideBeginEndPair = false;
    String txt = new String("glEnd(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos3d(double arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glRasterPos3d(arg0,arg1,arg2);
    String txt = new String("glRasterPos3d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantusvEXT(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVariantusvEXT(arg0,arg1);
    String txt = new String("glVariantusvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1d(int arg0,int arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1d(arg0,arg1,arg2);
    String txt = new String("glProgramUniform1d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4fARB(int arg0,float arg1,float arg2,float arg3,float arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4fARB(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttrib4fARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  int glGetSubroutineIndex(int arg0,int arg1,java.lang.String arg2)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetSubroutineIndex(arg0,arg1,arg2);
    String txt = new String("glGetSubroutineIndex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.lang.String> "+arg2 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glColorP4uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glColorP4uiv(arg0,arg1);
    String txt = new String("glColorP4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3fv(arg0);
    String txt = new String("glSecondaryColor3fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3iv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform3iv(arg0,arg1,arg2);
    String txt = new String("glUniform3iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramInterfaceiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetProgramInterfaceiv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetProgramInterfaceiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenProgramPipelines(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenProgramPipelines(arg0,arg1);
    String txt = new String("glGenProgramPipelines(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyTextureSubImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8)
  {
        checkContext();
downstreamGL4bc.glCopyTextureSubImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glCopyTextureSubImage2DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramLocalParametersI4ivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParametersI4ivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramLocalParametersI4ivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix4dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix4dv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2uiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform2uiv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform2uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexub(byte arg0)
  {
        checkContext();
downstreamGL4bc.glIndexub(arg0);
    String txt = new String("glIndexub(" +
    "<byte> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetDoubleIndexedvEXT(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetDoubleIndexedvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetDoubleIndexedvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramEnvParameterIivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetProgramEnvParameterIivNV(arg0,arg1,arg2);
    String txt = new String("glGetProgramEnvParameterIivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexGendvEXT(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexGendvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexGendvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantfvEXT(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVariantfvEXT(arg0,arg1);
    String txt = new String("glVariantfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexParameterivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexParameterivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMultiTexParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2i64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform2i64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform2i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSelectPerfMonitorCountersAMD(int arg0,boolean arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glSelectPerfMonitorCountersAMD(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glSelectPerfMonitorCountersAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<boolean> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix3fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix3fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedTexSubImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6)
  {
        checkContext();
downstreamGL4bc.glCompressedTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glCompressedTexSubImage1D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<long> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glLightf(int arg0,int arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glLightf(arg0,arg1,arg2);
    String txt = new String("glLightf(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyTexSubImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8)
  {
        checkContext();
downstreamGL4bc.glCopyTexSubImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glCopyTexSubImage3D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2dv(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2dv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMakeBufferResidentNV(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glMakeBufferResidentNV(arg0,arg1);
    String txt = new String("glMakeBufferResidentNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathCommandsNV(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGetPathCommandsNV(arg0,arg1);
    String txt = new String("glGetPathCommandsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glEndOcclusionQueryNV()
  {
        checkContext();
downstreamGL4bc.glEndOcclusionQueryNV();
    String txt = new String("glEndOcclusionQueryNV(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix3x4fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix3x4fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix3x4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4fvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform4fvARB(arg0,arg1,arg2);
    String txt = new String("glUniform4fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glClearBufferuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glClearBufferuiv(arg0,arg1,arg2);
    String txt = new String("glClearBufferuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsVariantEnabledEXT(int arg0,int arg1)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsVariantEnabledEXT(arg0,arg1);
    String txt = new String("glIsVariantEnabledEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexAttrib4svARB(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4svARB(arg0,arg1);
    String txt = new String("glVertexAttrib4svARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glColorMaski(int arg0,boolean arg1,boolean arg2,boolean arg3,boolean arg4)
  {
        checkContext();
downstreamGL4bc.glColorMaski(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glColorMaski(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<boolean> "+arg1 +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<boolean> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos2dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glWindowPos2dv(arg0,arg1);
    String txt = new String("glWindowPos2dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureSubImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
        checkContext();
downstreamGL4bc.glTextureSubImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glTextureSubImage2DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg9 +    ")");
    checkGLGetError( txt );
  }
  public  void glInterleavedArrays(int arg0,int arg1,java.nio.Buffer arg2)
  {
        checkContext();
downstreamGL4bc.glInterleavedArrays(arg0,arg1,arg2);
    String txt = new String("glInterleavedArrays(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3d(double arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3d(arg0,arg1,arg2);
    String txt = new String("glSecondaryColor3d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexf(float arg0)
  {
        checkContext();
downstreamGL4bc.glIndexf(arg0);
    String txt = new String("glIndexf(" +
    "<float> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMapParameterivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetMapParameterivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMapParameterivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureParameterfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glTextureParameterfvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glTextureParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramLocalParameterI4uivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParameterI4uivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramLocalParameterI4uivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4NusvARB(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4NusvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4NusvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4dv(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedTexSubImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,long arg8)
  {
        checkContext();
downstreamGL4bc.glCompressedTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glCompressedTexSubImage2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<long> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glLoadTransposeMatrixf(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glLoadTransposeMatrixf(arg0);
    String txt = new String("glLoadTransposeMatrixf(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos4iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glRasterPos4iv(arg0);
    String txt = new String("glRasterPos4iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribP1uiv(int arg0,int arg1,boolean arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribP1uiv(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribP1uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTextureParameterivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetTextureParameterivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetTextureParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4ui(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniform4ui(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniform4ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4uiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4uiv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex3iv(arg0);
    String txt = new String("glVertex3iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMinSampleShading(float arg0)
  {
        checkContext();
downstreamGL4bc.glMinSampleShading(arg0);
    String txt = new String("glMinSampleShading(" +
    "<float> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glInvalidateBufferData(int arg0)
  {
        checkContext();
downstreamGL4bc.glInvalidateBufferData(arg0);
    String txt = new String("glInvalidateBufferData(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL1dv(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL1dv(arg0,arg1);
    String txt = new String("glVertexAttribL1dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexPointer(int arg0,int arg1,int arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glVertexPointer(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4ui64NV(int arg0,int arg1,long arg2,long arg3,long arg4,long arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4ui64NV(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniform4ui64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ", " +
    "<long> "+arg4 +    ", " +
    "<long> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1h(int arg0,short arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1h(arg0,arg1);
    String txt = new String("glVertexAttrib1h(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glBindVideoCaptureStreamTextureNV(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glBindVideoCaptureStreamTextureNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glBindVideoCaptureStreamTextureNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glInvalidateBufferSubData(int arg0,long arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glInvalidateBufferSubData(arg0,arg1,arg2);
    String txt = new String("glInvalidateBufferSubData(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3ui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform3ui64vNV(arg0,arg1,arg2);
    String txt = new String("glUniform3ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexLevelParameteriv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetTexLevelParameteriv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetTexLevelParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glClearNamedBufferSubDataEXT(int arg0,int arg1,int arg2,int arg3,long arg4,long arg5,java.nio.Buffer arg6)
  {
        checkContext();
downstreamGL4bc.glClearNamedBufferSubDataEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glClearNamedBufferSubDataEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<long> "+arg4 +    ", " +
    "<long> "+arg5 +    ", " +
    "<java.nio.Buffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glGenBuffers(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenBuffers(arg0,arg1);
    String txt = new String("glGenBuffers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1s(int arg0,short arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1s(arg0,arg1);
    String txt = new String("glVertexAttrib1s(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramBufferParametersfvNV(int arg0,int arg1,int arg2,int arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramBufferParametersfvNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramBufferParametersfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glMaterialiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glMaterialiv(arg0,arg1,arg2,arg3);
    String txt = new String("glMaterialiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDisableClientState(int arg0)
  {
        checkContext();
downstreamGL4bc.glDisableClientState(arg0);
    String txt = new String("glDisableClientState(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glLightModeli(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glLightModeli(arg0,arg1);
    String txt = new String("glLightModeli(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramLocalParameter4dvEXT(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParameter4dvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glNamedProgramLocalParameter4dvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glStencilOpValueAMD(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glStencilOpValueAMD(arg0,arg1);
    String txt = new String("glStencilOpValueAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4i64NV(int arg0,int arg1,long arg2,long arg3,long arg4,long arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4i64NV(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniform4i64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ", " +
    "<long> "+arg4 +    ", " +
    "<long> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glEdgeFlagPointer(int arg0,java.nio.Buffer arg1)
  {
        checkContext();
downstreamGL4bc.glEdgeFlagPointer(arg0,arg1);
    String txt = new String("glEdgeFlagPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetShaderSourceARB(int arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetShaderSourceARB(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetShaderSourceARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramLocalParameter4dvARB(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParameter4dvARB(arg0,arg1,arg2);
    String txt = new String("glProgramLocalParameter4dvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedRenderbufferParameterivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetNamedRenderbufferParameterivEXT(arg0,arg1,arg2);
    String txt = new String("glGetNamedRenderbufferParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3hv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glNormal3hv(arg0,arg1);
    String txt = new String("glNormal3hv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1iv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform1iv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform1iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glAlphaFunc(int arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glAlphaFunc(arg0,arg1);
    String txt = new String("glAlphaFunc(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixLoadTransposedEXT(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMatrixLoadTransposedEXT(arg0,arg1);
    String txt = new String("glMatrixLoadTransposedEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4usvEXT(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4usvEXT(arg0,arg1);
    String txt = new String("glVertexAttribI4usvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3sARB(int arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3sARB(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttrib3sARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4ubv(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4ubv(arg0,arg1);
    String txt = new String("glVertexAttribI4ubv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix3x2fvEXT(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix3x2fvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix3x2fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  float glGetPathLengthNV(int arg0,int arg1,int arg2)
  {
        checkContext();
    float _res = downstreamGL4bc.glGetPathLengthNV(arg0,arg1,arg2);
    String txt = new String("glGetPathLengthNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGenTransformFeedbacks(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenTransformFeedbacks(arg0,arg1);
    String txt = new String("glGenTransformFeedbacks(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  int glGenVertexShadersEXT(int arg0)
  {
        checkContext();
    int _res = downstreamGL4bc.glGenVertexShadersEXT(arg0);
    String txt = new String("glGenVertexShadersEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glRasterPos2iv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos2iv(arg0,arg1);
    String txt = new String("glRasterPos2iv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glClearBufferiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glClearBufferiv(arg0,arg1,arg2,arg3);
    String txt = new String("glClearBufferiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteProgramsARB(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDeleteProgramsARB(arg0,arg1,arg2);
    String txt = new String("glDeleteProgramsARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexPointer(javax.media.opengl.GLArrayData arg0)
  {
        checkContext();
downstreamGL4bc.glVertexPointer(arg0);
    String txt = new String("glVertexPointer(" +
    "<javax.media.opengl.GLArrayData> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4i64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4i64vNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform4i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetSamplerParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetSamplerParameteriv(arg0,arg1,arg2);
    String txt = new String("glGetSamplerParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2ui64NV(int arg0,int arg1,long arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2ui64NV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform2ui64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glLineWidth(float arg0)
  {
        checkContext();
downstreamGL4bc.glLineWidth(arg0);
    String txt = new String("glLineWidth(" +
    "<float> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3h(int arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3h(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexCoord3h(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedCopyBufferSubDataEXT(int arg0,int arg1,long arg2,long arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glNamedCopyBufferSubDataEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glNamedCopyBufferSubDataEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordP4uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoordP4uiv(arg0,arg1);
    String txt = new String("glTexCoordP4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  java.lang.Object getExtension(java.lang.String arg0)
  {
        return downstreamGL4bc.getExtension(arg0);
  }
  public  void glScissorIndexed(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glScissorIndexed(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glScissorIndexed(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI1ivEXT(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI1ivEXT(arg0,arg1);
    String txt = new String("glVertexAttribI1ivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4fvARB(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4fvARB(arg0,arg1);
    String txt = new String("glVertexAttrib4fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3h(int arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3h(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttrib3h(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2i64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2i64vNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform2i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4usv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4usv(arg0,arg1);
    String txt = new String("glVertexAttribI4usv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3s(int arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3s(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttrib3s(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexArrayVertexBindingDivisorEXT(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexArrayVertexBindingDivisorEXT(arg0,arg1,arg2);
    String txt = new String("glVertexArrayVertexBindingDivisorEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureParameterIivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glTextureParameterIivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glTextureParameterIivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix3x4fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix3x4fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix3x4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathSpacingNV(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4,float arg5,float arg6,int arg7,float[] arg8,int arg9)
  {
        checkContext();
downstreamGL4bc.glGetPathSpacingNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glGetPathSpacingNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<float> "+arg5 +    ", " +
    "<float> "+arg6 +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix4x2dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4x2dv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix4x2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor4fv(arg0);
    String txt = new String("glColor4fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2hv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord2hv(arg0,arg1);
    String txt = new String("glTexCoord2hv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexP3ui(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertexP3ui(arg0,arg1);
    String txt = new String("glVertexP3ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1ivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform1ivARB(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform1ivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean isExtensionAvailable(java.lang.String arg0)
  {
        return downstreamGL4bc.isExtensionAvailable(arg0);
  }
  public  void glGenFencesAPPLE(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGenFencesAPPLE(arg0,arg1,arg2);
    String txt = new String("glGenFencesAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathCommandsNV(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGetPathCommandsNV(arg0,arg1,arg2);
    String txt = new String("glGetPathCommandsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedTextureImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
        checkContext();
downstreamGL4bc.glCompressedTextureImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glCompressedTextureImage1DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawBuffers(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDrawBuffers(arg0,arg1,arg2);
    String txt = new String("glDrawBuffers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3iv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3iv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord3iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMapParameterivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glMapParameterivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glMapParameterivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMinmax(int arg0,boolean arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetMinmax(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMinmax(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<boolean> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultMatrixf(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glMultMatrixf(arg0,arg1);
    String txt = new String("glMultMatrixf(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEvalCoord1dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glEvalCoord1dv(arg0);
    String txt = new String("glEvalCoord1dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4sv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor4sv(arg0);
    String txt = new String("glColor4sv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVideoCaptureStreamParameterfvNV(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVideoCaptureStreamParameterfvNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVideoCaptureStreamParameterfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3s(int arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3s(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexCoord3s(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3ui(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3ui(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform3ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordP1ui(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoordP1ui(arg0,arg1);
    String txt = new String("glTexCoordP1ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedTextureImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
        checkContext();
downstreamGL4bc.glCompressedTextureImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glCompressedTextureImage3DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg9 +    ")");
    checkGLGetError( txt );
  }
  public  void glEvalCoord2dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glEvalCoord2dv(arg0,arg1);
    String txt = new String("glEvalCoord2dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetObjectParameterivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetObjectParameterivARB(arg0,arg1,arg2);
    String txt = new String("glGetObjectParameterivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexEnviEXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexEnviEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexEnviEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteOcclusionQueriesNV(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glDeleteOcclusionQueriesNV(arg0,arg1);
    String txt = new String("glDeleteOcclusionQueriesNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParameterI4uivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParameterI4uivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramEnvParameterI4uivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4ubvEXT(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4ubvEXT(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI4ubvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord1bvOES(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1bvOES(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord1bvOES(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUseProgramObjectARB(int arg0)
  {
        checkContext();
downstreamGL4bc.glUseProgramObjectARB(arg0);
    String txt = new String("glUseProgramObjectARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord1h(int arg0,short arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1h(arg0,arg1);
    String txt = new String("glMultiTexCoord1h(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordFormatNV(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glTexCoordFormatNV(arg0,arg1,arg2);
    String txt = new String("glTexCoordFormatNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFrontFace(int arg0)
  {
        checkContext();
downstreamGL4bc.glFrontFace(arg0);
    String txt = new String("glFrontFace(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL2dv(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL2dv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribL2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1h(short arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord1h(arg0);
    String txt = new String("glTexCoord1h(" +
    "<short> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix2x3fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix2x3fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix2x3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramLocalParameter4fEXT(int arg0,int arg1,int arg2,float arg3,float arg4,float arg5,float arg6)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParameter4fEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glNamedProgramLocalParameter4fEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ", " +
    "<float> "+arg5 +    ", " +
    "<float> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetShaderSource(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetShaderSource(arg0,arg1,arg2,arg3);
    String txt = new String("glGetShaderSource(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<java.nio.ByteBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetBufferParameteri64v(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetBufferParameteri64v(arg0,arg1,arg2);
    String txt = new String("glGetBufferParameteri64v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMapVertexAttrib2dAPPLE(int arg0,int arg1,double arg2,double arg3,int arg4,int arg5,double arg6,double arg7,int arg8,int arg9,java.nio.DoubleBuffer arg10)
  {
        checkContext();
downstreamGL4bc.glMapVertexAttrib2dAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glMapVertexAttrib2dAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<double> "+arg6 +    ", " +
    "<double> "+arg7 +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg10 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexParameterivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexParameterivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedMultiTexSubImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
        checkContext();
downstreamGL4bc.glCompressedMultiTexSubImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glCompressedMultiTexSubImage2DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg9 +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteTransformFeedbacksNV(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDeleteTransformFeedbacksNV(arg0,arg1,arg2);
    String txt = new String("glDeleteTransformFeedbacksNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribLFormatNV(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribLFormatNV(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribLFormatNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glBindLightParameterEXT(int arg0,int arg1)
  {
        checkContext();
    int _res = downstreamGL4bc.glBindLightParameterEXT(arg0,arg1);
    String txt = new String("glBindLightParameterEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetPixelMapuiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGetPixelMapuiv(arg0,arg1,arg2);
    String txt = new String("glGetPixelMapuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI3uiEXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI3uiEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribI3uiEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathCoordsNV(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGetPathCoordsNV(arg0,arg1,arg2);
    String txt = new String("glGetPathCoordsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedStringivARB(int arg0,java.lang.String arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetNamedStringivARB(arg0,arg1,arg2,arg3);
    String txt = new String("glGetNamedStringivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.lang.String> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glBindFragDataLocation(int arg0,int arg1,java.lang.String arg2)
  {
        checkContext();
downstreamGL4bc.glBindFragDataLocation(arg0,arg1,arg2);
    String txt = new String("glBindFragDataLocation(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.lang.String> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1s(short arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord1s(arg0);
    String txt = new String("glTexCoord1s(" +
    "<short> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2bvOES(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord2bvOES(arg0,arg1);
    String txt = new String("glTexCoord2bvOES(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixLoadTransposefEXT(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMatrixLoadTransposefEXT(arg0,arg1);
    String txt = new String("glMatrixLoadTransposefEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribP2uiv(int arg0,int arg1,boolean arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribP2uiv(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribP2uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureImage2DMultisampleCoverageNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,boolean arg7)
  {
        checkContext();
downstreamGL4bc.glTextureImage2DMultisampleCoverageNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glTextureImage2DMultisampleCoverageNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<boolean> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glConvolutionFilter1D(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
        checkContext();
downstreamGL4bc.glConvolutionFilter1D(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glConvolutionFilter1D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawElementsInstancedBaseInstance(int arg0,int arg1,int arg2,long arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glDrawElementsInstancedBaseInstance(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glDrawElementsInstancedBaseInstance(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSamplerParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glSamplerParameteriv(arg0,arg1,arg2,arg3);
    String txt = new String("glSamplerParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3sv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3sv(arg0);
    String txt = new String("glSecondaryColor3sv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3fv(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3fv(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glPrioritizeTextures(int arg0,java.nio.IntBuffer arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glPrioritizeTextures(arg0,arg1,arg2);
    String txt = new String("glPrioritizeTextures(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4ub(byte arg0,byte arg1,byte arg2,byte arg3)
  {
        checkContext();
downstreamGL4bc.glColor4ub(arg0,arg1,arg2,arg3);
    String txt = new String("glColor4ub(" +
    "<byte> "+arg0 +    ", " +
    "<byte> "+arg1 +    ", " +
    "<byte> "+arg2 +    ", " +
    "<byte> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2fv(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2fv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformi64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetUniformi64vNV(arg0,arg1,arg2);
    String txt = new String("glGetUniformi64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1fARB(int arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1fARB(arg0,arg1);
    String txt = new String("glVertexAttrib1fARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4ui(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glColor4ui(arg0,arg1,arg2,arg3);
    String txt = new String("glColor4ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4ivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform4ivARB(arg0,arg1,arg2);
    String txt = new String("glUniform4ivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4usv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor4usv(arg0);
    String txt = new String("glColor4usv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4us(short arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glColor4us(arg0,arg1,arg2,arg3);
    String txt = new String("glColor4us(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI2iEXT(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI2iEXT(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI2iEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glBindParameterEXT(int arg0)
  {
        checkContext();
    int _res = downstreamGL4bc.glBindParameterEXT(arg0);
    String txt = new String("glBindParameterEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glMultiTexCoord1s(int arg0,short arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1s(arg0,arg1);
    String txt = new String("glMultiTexCoord1s(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4ivEXT(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4ivEXT(arg0,arg1);
    String txt = new String("glVertexAttribI4ivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glStencilStrokePathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,int arg6,float[] arg7,int arg8)
  {
        checkContext();
downstreamGL4bc.glStencilStrokePathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glStencilStrokePathInstancedNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  java.lang.String glGetStringi(int arg0,int arg1)
  {
        checkContext();
    java.lang.String _res = downstreamGL4bc.glGetStringi(arg0,arg1);
    String txt = new String("glGetStringi(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVariantbvEXT(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVariantbvEXT(arg0,arg1);
    String txt = new String("glVariantbvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3bv(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor3bv(arg0);
    String txt = new String("glColor3bv(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2hv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2hv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib2hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsSync(long arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsSync(arg0);
    String txt = new String("glIsSync(" +
    "<long> "+arg0 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glPathParameterfvNV(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glPathParameterfvNV(arg0,arg1,arg2,arg3);
    String txt = new String("glPathParameterfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix4x2fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix4x2fv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix4x2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glPolygonMode(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glPolygonMode(arg0,arg1);
    String txt = new String("glPolygonMode(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glGetDebugMessageLogAMD(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4,java.nio.IntBuffer arg5,java.nio.ByteBuffer arg6)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetDebugMessageLogAMD(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetDebugMessageLogAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ", " +
    "<java.nio.IntBuffer> "+arg5 +    ", " +
    "<java.nio.ByteBuffer> "+arg6 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glMatrixScalefEXT(int arg0,float arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glMatrixScalefEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMatrixScalefEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3h(short arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glTexCoord3h(arg0,arg1,arg2);
    String txt = new String("glTexCoord3h(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix4x3dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4x3dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix4x3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.DoubleBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3ubv(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor3ubv(arg0);
    String txt = new String("glColor3ubv(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glDeletePerfMonitorsAMD(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDeletePerfMonitorsAMD(arg0,arg1,arg2);
    String txt = new String("glDeletePerfMonitorsAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2x4fvEXT(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2x4fvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix2x4fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glInvalidateSubFramebuffer(int arg0,int arg1,int[] arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glInvalidateSubFramebuffer(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glInvalidateSubFramebuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3s(short arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glTexCoord3s(arg0,arg1,arg2);
    String txt = new String("glTexCoord3s(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexParameterf(int arg0,int arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glTexParameterf(arg0,arg1,arg2);
    String txt = new String("glTexParameterf(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4sv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4sv(arg0,arg1);
    String txt = new String("glMultiTexCoord4sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4Nuiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4Nuiv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4Nuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixIndexPointer(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glMatrixIndexPointer(arg0,arg1,arg2,arg3);
    String txt = new String("glMatrixIndexPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glBeginPerfMonitorAMD(int arg0)
  {
        checkContext();
downstreamGL4bc.glBeginPerfMonitorAMD(arg0);
    String txt = new String("glBeginPerfMonitorAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFogCoordhv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glFogCoordhv(arg0);
    String txt = new String("glFogCoordhv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMapVertexAttrib1dAPPLE(int arg0,int arg1,double arg2,double arg3,int arg4,int arg5,double[] arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glMapVertexAttrib1dAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glMapVertexAttrib1dAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteProgramPipelines(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glDeleteProgramPipelines(arg0,arg1);
    String txt = new String("glDeleteProgramPipelines(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI2uiEXT(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI2uiEXT(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI2uiEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI2ivEXT(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI2ivEXT(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI2ivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glQueryCounter(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glQueryCounter(arg0,arg1);
    String txt = new String("glQueryCounter(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4NivARB(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4NivARB(arg0,arg1);
    String txt = new String("glVertexAttrib4NivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsVBOElementArrayBound()
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsVBOElementArrayBound();
    String txt = new String("glIsVBOElementArrayBound(" +
    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glUniformHandleui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniformHandleui64vNV(arg0,arg1,arg2);
    String txt = new String("glUniformHandleui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3iv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor3iv(arg0,arg1);
    String txt = new String("glColor3iv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos3dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glWindowPos3dv(arg0);
    String txt = new String("glWindowPos3dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL4ui64vNV(int arg0,java.nio.LongBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL4ui64vNV(arg0,arg1);
    String txt = new String("glVertexAttribL4ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix2x4dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix2x4dv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix2x4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexImage(int arg0,int arg1,int arg2,int arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glGetTexImage(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetTexImage(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexGendv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetTexGendv(arg0,arg1,arg2);
    String txt = new String("glGetTexGendv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawElementsInstancedBaseVertex(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glDrawElementsInstancedBaseVertex(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glDrawElementsInstancedBaseVertex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColorTable(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
        checkContext();
downstreamGL4bc.glColorTable(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glColorTable(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexGeniEXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexGeniEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexGeniEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2ui64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2ui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform2ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVideoCaptureStreamParameterdvNV(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glVideoCaptureStreamParameterdvNV(arg0,arg1,arg2,arg3);
    String txt = new String("glVideoCaptureStreamParameterdvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParameterI4uiNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParameterI4uiNV(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramEnvParameterI4uiNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordP1uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glTexCoordP1uiv(arg0,arg1,arg2);
    String txt = new String("glTexCoordP1uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL1ui64vNV(int arg0,java.nio.LongBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL1ui64vNV(arg0,arg1);
    String txt = new String("glVertexAttribL1ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glReleaseShaderCompiler()
  {
        checkContext();
downstreamGL4bc.glReleaseShaderCompiler();
    String txt = new String("glReleaseShaderCompiler(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveAttrib(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4,java.nio.IntBuffer arg5,java.nio.ByteBuffer arg6)
  {
        checkContext();
downstreamGL4bc.glGetActiveAttrib(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetActiveAttrib(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ", " +
    "<java.nio.IntBuffer> "+arg5 +    ", " +
    "<java.nio.ByteBuffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2bvOES(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex2bvOES(arg0);
    String txt = new String("glVertex2bvOES(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetFenceivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetFenceivNV(arg0,arg1,arg2);
    String txt = new String("glGetFenceivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantubvEXT(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVariantubvEXT(arg0,arg1);
    String txt = new String("glVariantubvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glShaderSourceARB(int arg0,int arg1,java.lang.String[] arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glShaderSourceARB(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glShaderSourceARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[Ljava.lang.String;>" +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferTexture1D(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glFramebufferTexture1D(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glFramebufferTexture1D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordP2uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glTexCoordP2uiv(arg0,arg1,arg2);
    String txt = new String("glTexCoordP2uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoordP1uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoordP1uiv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoordP1uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureStorage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glTextureStorage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glTextureStorage3D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryObjecti64vEXT(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetQueryObjecti64vEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetQueryObjecti64vEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4sARB(int arg0,short arg1,short arg2,short arg3,short arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4sARB(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttrib4sARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ", " +
    "<short> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3hv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glNormal3hv(arg0);
    String txt = new String("glNormal3hv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4usvEXT(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4usvEXT(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI4usvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnMapfv(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetnMapfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetnMapfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4NbvARB(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4NbvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4NbvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glReadPixels(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6)
  {
        checkContext();
downstreamGL4bc.glReadPixels(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glReadPixels(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<long> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos2i(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos2i(arg0,arg1);
    String txt = new String("glRasterPos2i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix4x3fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix4x3fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix4x3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetObjectParameterivAPPLE(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetObjectParameterivAPPLE(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetObjectParameterivAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3f(float arg0,float arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glNormal3f(arg0,arg1,arg2);
    String txt = new String("glNormal3f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos2f(float arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos2f(arg0,arg1);
    String txt = new String("glRasterPos2f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteFramebuffers(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glDeleteFramebuffers(arg0,arg1);
    String txt = new String("glDeleteFramebuffers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glFreeMemoryNV(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glFreeMemoryNV(arg0);
    String txt = new String("glFreeMemoryNV(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawElementsInstancedBaseVertexBaseInstance(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4,int arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glDrawElementsInstancedBaseVertexBaseInstance(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glDrawElementsInstancedBaseVertexBaseInstance(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos2d(double arg0,double arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos2d(arg0,arg1);
    String txt = new String("glRasterPos2d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3dv(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3dv(arg0,arg1);
    String txt = new String("glMultiTexCoord3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL4dv(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL4dv(arg0,arg1);
    String txt = new String("glVertexAttribL4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyTexImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glCopyTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glCopyTexImage2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPathParameteriNV(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glPathParameteriNV(arg0,arg1,arg2);
    String txt = new String("glPathParameteriNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferDrawBufferEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glFramebufferDrawBufferEXT(arg0,arg1);
    String txt = new String("glFramebufferDrawBufferEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos2s(short arg0,short arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos2s(arg0,arg1);
    String txt = new String("glRasterPos2s(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1iv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord1iv(arg0,arg1);
    String txt = new String("glTexCoord1iv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4bv(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4bv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4bv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4bvOES(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4bvOES(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord4bvOES(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetLightiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetLightiv(arg0,arg1,arg2);
    String txt = new String("glGetLightiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniformui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1dv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform1dv(arg0,arg1,arg2);
    String txt = new String("glUniform1dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glLoadMatrixd(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glLoadMatrixd(arg0,arg1);
    String txt = new String("glLoadMatrixd(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glClearStencil(int arg0)
  {
        checkContext();
downstreamGL4bc.glClearStencil(arg0);
    String txt = new String("glClearStencil(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  java.nio.ByteBuffer glMapTexture2DINTEL(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
    java.nio.ByteBuffer _res = downstreamGL4bc.glMapTexture2DINTEL(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMapTexture2DINTEL(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  java.nio.ByteBuffer glMapTexture2DINTEL(int arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6)
  {
        checkContext();
    java.nio.ByteBuffer _res = downstreamGL4bc.glMapTexture2DINTEL(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glMapTexture2DINTEL(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glUniform3uiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform3uiv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBindMultiTextureEXT(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glBindMultiTextureEXT(arg0,arg1,arg2);
    String txt = new String("glBindMultiTextureEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribP4uiv(int arg0,int arg1,boolean arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribP4uiv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribP4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  java.nio.ByteBuffer glMapNamedBufferEXT(int arg0,int arg1)
  {
        checkContext();
    java.nio.ByteBuffer _res = downstreamGL4bc.glMapNamedBufferEXT(arg0,arg1);
    String txt = new String("glMapNamedBufferEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glColor4sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor4sv(arg0,arg1);
    String txt = new String("glColor4sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4ui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform4ui64vNV(arg0,arg1,arg2);
    String txt = new String("glUniform4ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glEnableClientState(int arg0)
  {
        checkContext();
downstreamGL4bc.glEnableClientState(arg0);
    String txt = new String("glEnableClientState(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexfv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glIndexfv(arg0,arg1);
    String txt = new String("glIndexfv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  long glVDPAURegisterOutputSurfaceNV(java.nio.Buffer arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
    long _res = downstreamGL4bc.glVDPAURegisterOutputSurfaceNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVDPAURegisterOutputSurfaceNV(" +
    "<java.nio.Buffer> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertex4dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex4dv(arg0,arg1);
    String txt = new String("glVertex4dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3bvOES(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex3bvOES(arg0);
    String txt = new String("glVertex3bvOES(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2uiEXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2uiEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform2uiEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1fvARB(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1fvARB(arg0,arg1);
    String txt = new String("glVertexAttrib1fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureStorage1D(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glTextureStorage1D(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glTextureStorage1D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFinishObjectAPPLE(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glFinishObjectAPPLE(arg0,arg1);
    String txt = new String("glFinishObjectAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1fv(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1fv(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform1fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribParameteriAMD(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribParameteriAMD(arg0,arg1,arg2);
    String txt = new String("glVertexAttribParameteriAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelStoref(int arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glPixelStoref(arg0,arg1);
    String txt = new String("glPixelStoref(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3uiEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3uiEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform3uiEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformui64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniformui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniformui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3ui(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform3ui(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform3ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1ui64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1ui64vNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform1ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos4d(double arg0,double arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glRasterPos4d(arg0,arg1,arg2,arg3);
    String txt = new String("glRasterPos4d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2hv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord2hv(arg0);
    String txt = new String("glTexCoord2hv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGenQueries(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenQueries(arg0,arg1);
    String txt = new String("glGenQueries(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2uivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2uivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform2uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos4i(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glRasterPos4i(arg0,arg1,arg2,arg3);
    String txt = new String("glRasterPos4i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColorMask(boolean arg0,boolean arg1,boolean arg2,boolean arg3)
  {
        checkContext();
downstreamGL4bc.glColorMask(arg0,arg1,arg2,arg3);
    String txt = new String("glColorMask(" +
    "<boolean> "+arg0 +    ", " +
    "<boolean> "+arg1 +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<boolean> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetColorTableParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetColorTableParameteriv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetColorTableParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos4f(float arg0,float arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glRasterPos4f(arg0,arg1,arg2,arg3);
    String txt = new String("glRasterPos4f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glPushName(int arg0)
  {
        checkContext();
downstreamGL4bc.glPushName(arg0);
    String txt = new String("glPushName(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2fv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferTexture2D(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glFramebufferTexture2D(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glFramebufferTexture2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4usv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4usv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI4usv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexFormatNV(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexFormatNV(arg0,arg1,arg2);
    String txt = new String("glVertexFormatNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos4s(short arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glRasterPos4s(arg0,arg1,arg2,arg3);
    String txt = new String("glRasterPos4s(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glBitmap(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5,long arg6)
  {
        checkContext();
downstreamGL4bc.glBitmap(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glBitmap(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ", " +
    "<float> "+arg5 +    ", " +
    "<long> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glConvolutionFilter2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6)
  {
        checkContext();
downstreamGL4bc.glConvolutionFilter2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glConvolutionFilter2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<long> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexLevelParameterivEXT(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexLevelParameterivEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetMultiTexLevelParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramEnvParameterfvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetProgramEnvParameterfvARB(arg0,arg1,arg2);
    String txt = new String("glGetProgramEnvParameterfvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glExtractComponentEXT(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glExtractComponentEXT(arg0,arg1,arg2);
    String txt = new String("glExtractComponentEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramLocalParameter4dARB(int arg0,int arg1,double arg2,double arg3,double arg4,double arg5)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParameter4dARB(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramLocalParameter4dARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ", " +
    "<double> "+arg4 +    ", " +
    "<double> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glClearAccum(float arg0,float arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glClearAccum(arg0,arg1,arg2,arg3);
    String txt = new String("glClearAccum(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1ui(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1ui(arg0,arg1,arg2);
    String txt = new String("glProgramUniform1ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexParameterfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexParameterfvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMultiTexParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4usv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor4usv(arg0,arg1);
    String txt = new String("glColor4usv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexGeniv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetTexGeniv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetTexGeniv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedFramebufferAttachmentParameterivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetNamedFramebufferAttachmentParameterivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetNamedFramebufferAttachmentParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawArraysInstancedBaseInstance(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glDrawArraysInstancedBaseInstance(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glDrawArraysInstancedBaseInstance(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3fv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform3fv(arg0,arg1,arg2);
    String txt = new String("glUniform3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixMode(int arg0)
  {
        checkContext();
downstreamGL4bc.glMatrixMode(arg0);
    String txt = new String("glMatrixMode(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix4x2fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4x2fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix4x2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2x3fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2x3fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix2x3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribIivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribIivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexAttribIivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glInvalidateFramebuffer(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glInvalidateFramebuffer(arg0,arg1,arg2);
    String txt = new String("glInvalidateFramebuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetTexParameterfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetTexParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDebugMessageControl(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4,boolean arg5)
  {
        checkContext();
downstreamGL4bc.glDebugMessageControl(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glDebugMessageControl(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ", " +
    "<boolean> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixMultTransposefEXT(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMatrixMultTransposefEXT(arg0,arg1);
    String txt = new String("glMatrixMultTransposefEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInvariantIntegervEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetInvariantIntegervEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetInvariantIntegervEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetFloatIndexedvEXT(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetFloatIndexedvEXT(arg0,arg1,arg2);
    String txt = new String("glGetFloatIndexedvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompileShaderIncludeARB(int arg0,int arg1,java.lang.String[] arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glCompileShaderIncludeARB(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glCompileShaderIncludeARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[Ljava.lang.String;>" +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetDoublei_v(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetDoublei_v(arg0,arg1,arg2);
    String txt = new String("glGetDoublei_v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glAreTexturesResident(int arg0,java.nio.IntBuffer arg1,java.nio.ByteBuffer arg2)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glAreTexturesResident(arg0,arg1,arg2);
    String txt = new String("glAreTexturesResident(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ", " +
    "<java.nio.ByteBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexAttribL4i64NV(int arg0,long arg1,long arg2,long arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL4i64NV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribL4i64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glEdgeFlagv(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glEdgeFlagv(arg0);
    String txt = new String("glEdgeFlagv(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  int glGetUniformLocationARB(int arg0,java.lang.String arg1)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetUniformLocationARB(arg0,arg1);
    String txt = new String("glGetUniformLocationARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.lang.String> "+arg1 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexArrayEdgeFlagOffsetEXT(int arg0,int arg1,int arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glVertexArrayEdgeFlagOffsetEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexArrayEdgeFlagOffsetEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1dARB(int arg0,double arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1dARB(arg0,arg1);
    String txt = new String("glVertexAttrib1dARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureSubImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
        checkContext();
downstreamGL4bc.glTextureSubImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glTextureSubImage1DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  int glVideoCaptureNV(int arg0,java.nio.IntBuffer arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
    int _res = downstreamGL4bc.glVideoCaptureNV(arg0,arg1,arg2);
    String txt = new String("glVideoCaptureNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glSecondaryColor3sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3sv(arg0,arg1);
    String txt = new String("glSecondaryColor3sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixTranslatedEXT(int arg0,double arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glMatrixTranslatedEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMatrixTranslatedEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4dv(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4dv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glLoadIdentity()
  {
        checkContext();
downstreamGL4bc.glLoadIdentity();
    String txt = new String("glLoadIdentity(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL3dv(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL3dv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribL3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glReadnPixels(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
        checkContext();
downstreamGL4bc.glReadnPixels(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glReadnPixels(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1uiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1uiv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform1uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVideoCaptureivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVideoCaptureivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVideoCaptureivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetFramebufferParameterivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetFramebufferParameterivEXT(arg0,arg1,arg2);
    String txt = new String("glGetFramebufferParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glBlendColor(float arg0,float arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glBlendColor(arg0,arg1,arg2,arg3);
    String txt = new String("glBlendColor(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform1uiv(arg0,arg1,arg2);
    String txt = new String("glUniform1uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexGenivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glMultiTexGenivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiTexGenivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glGetSubroutineUniformLocation(int arg0,int arg1,java.lang.String arg2)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetSubroutineUniformLocation(arg0,arg1,arg2);
    String txt = new String("glGetSubroutineUniformLocation(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.lang.String> "+arg2 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glMultiTexCoord1fv(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1fv(arg0,arg1);
    String txt = new String("glMultiTexCoord1fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiDrawElementsBaseVertex(int arg0,java.nio.IntBuffer arg1,int arg2,com.jogamp.common.nio.PointerBuffer arg3,int arg4,java.nio.IntBuffer arg5)
  {
        checkContext();
downstreamGL4bc.glMultiDrawElementsBaseVertex(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glMultiDrawElementsBaseVertex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<com.jogamp.common.nio.PointerBuffer> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedMultiTexSubImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
        checkContext();
downstreamGL4bc.glCompressedMultiTexSubImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glCompressedMultiTexSubImage1DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelMapuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glPixelMapuiv(arg0,arg1,arg2,arg3);
    String txt = new String("glPixelMapuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetSamplerParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetSamplerParameterfv(arg0,arg1,arg2);
    String txt = new String("glGetSamplerParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteNamedStringARB(int arg0,java.lang.String arg1)
  {
        checkContext();
downstreamGL4bc.glDeleteNamedStringARB(arg0,arg1);
    String txt = new String("glDeleteNamedStringARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.lang.String> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixMultfEXT(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMatrixMultfEXT(arg0,arg1);
    String txt = new String("glMatrixMultfEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPixelMapfv(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGetPixelMapfv(arg0,arg1);
    String txt = new String("glGetPixelMapfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3s(short arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glColor3s(arg0,arg1,arg2);
    String txt = new String("glColor3s(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3ubv(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3ubv(arg0,arg1);
    String txt = new String("glSecondaryColor3ubv(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int getMaxRenderbufferSamples()
  {
        return downstreamGL4bc.getMaxRenderbufferSamples();
  }
  public  void glPopClientAttrib()
  {
        checkContext();
downstreamGL4bc.glPopClientAttrib();
    String txt = new String("glPopClientAttrib(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3d(double arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glNormal3d(arg0,arg1,arg2);
    String txt = new String("glNormal3d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1uivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1uivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform1uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3iv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3iv(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform3iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3h(short arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glColor3h(arg0,arg1,arg2);
    String txt = new String("glColor3h(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glFogCoordhv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glFogCoordhv(arg0,arg1);
    String txt = new String("glFogCoordhv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2fvARB(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2fvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib2fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEndQuery(int arg0)
  {
        checkContext();
downstreamGL4bc.glEndQuery(arg0);
    String txt = new String("glEndQuery(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCullParameterfvEXT(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glCullParameterfvEXT(arg0,arg1);
    String txt = new String("glCullParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveAtomicCounterBufferiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetActiveAtomicCounterBufferiv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetActiveAtomicCounterBufferiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix2x4fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix2x4fv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix2x4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4sv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4sv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord4sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsEnabledi(int arg0,int arg1)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsEnabledi(arg0,arg1);
    String txt = new String("glIsEnabledi(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glBindProgramPipeline(int arg0)
  {
        checkContext();
downstreamGL4bc.glBindProgramPipeline(arg0);
    String txt = new String("glBindProgramPipeline(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  long glImportSyncEXT(int arg0,long arg1,int arg2)
  {
        checkContext();
    long _res = downstreamGL4bc.glImportSyncEXT(arg0,arg1,arg2);
    String txt = new String("glImportSyncEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glUniform4dv(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform4dv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetLocalConstantIntegervEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetLocalConstantIntegervEXT(arg0,arg1,arg2);
    String txt = new String("glGetLocalConstantIntegervEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glEnableVertexArrayEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glEnableVertexArrayEXT(arg0,arg1);
    String txt = new String("glEnableVertexArrayEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexArrayVertexAttribOffsetEXT(int arg0,int arg1,int arg2,int arg3,int arg4,boolean arg5,int arg6,long arg7)
  {
        checkContext();
downstreamGL4bc.glVertexArrayVertexAttribOffsetEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glVertexArrayVertexAttribOffsetEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<boolean> "+arg5 +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<long> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2hv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2hv(arg0,arg1);
    String txt = new String("glVertexAttrib2hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL1i64vNV(int arg0,java.nio.LongBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL1i64vNV(arg0,arg1);
    String txt = new String("glVertexAttribL1i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawElementsIndirect(int arg0,int arg1,java.nio.Buffer arg2)
  {
        checkContext();
downstreamGL4bc.glDrawElementsIndirect(arg0,arg1,arg2);
    String txt = new String("glDrawElementsIndirect(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferTextureEXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glFramebufferTextureEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glFramebufferTextureEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureImage3DMultisampleCoverageNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,boolean arg8)
  {
        checkContext();
downstreamGL4bc.glTextureImage3DMultisampleCoverageNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glTextureImage3DMultisampleCoverageNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<boolean> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyMultiTexImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glCopyMultiTexImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glCopyMultiTexImage1DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFrustumf(float arg0,float arg1,float arg2,float arg3,float arg4,float arg5)
  {
        checkContext();
downstreamGL4bc.glFrustumf(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glFrustumf(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ", " +
    "<float> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsTransformFeedbackNV(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsTransformFeedbackNV(arg0);
    String txt = new String("glIsTransformFeedbackNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexAttrib1dvARB(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1dvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib1dvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenTransformFeedbacksNV(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGenTransformFeedbacksNV(arg0,arg1,arg2);
    String txt = new String("glGenTransformFeedbacksNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelZoom(float arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glPixelZoom(arg0,arg1);
    String txt = new String("glPixelZoom(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4ui(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4ui(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniform4ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyMultiTexSubImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8)
  {
        checkContext();
downstreamGL4bc.glCopyMultiTexSubImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glCopyMultiTexSubImage2DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenFencesNV(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGenFencesNV(arg0,arg1,arg2);
    String txt = new String("glGenFencesNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformdv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetUniformdv(arg0,arg1,arg2);
    String txt = new String("glGetUniformdv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedBufferParameterui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetNamedBufferParameterui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetNamedBufferParameterui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoordP1ui(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoordP1ui(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoordP1ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexParameterIivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexParameterIivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMultiTexParameterIivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4i64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform4i64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform4i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix3x2fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix3x2fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix3x2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribs3hv(int arg0,int arg1,java.nio.ShortBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribs3hv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribs3hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glShaderOp3EXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glShaderOp3EXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glShaderOp3EXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glGetError()
  {
        checkContext();
    int _res = downstreamGL4bc.glGetError();
    String txt = new String("glGetError(" +
    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glColor4hv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor4hv(arg0,arg1);
    String txt = new String("glColor4hv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEdgeFlagv(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glEdgeFlagv(arg0,arg1);
    String txt = new String("glEdgeFlagv(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex3fv(arg0);
    String txt = new String("glVertex3fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInteger64i_v(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetInteger64i_v(arg0,arg1,arg2);
    String txt = new String("glGetInteger64i_v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glApplyTextureEXT(int arg0)
  {
        checkContext();
downstreamGL4bc.glApplyTextureEXT(arg0);
    String txt = new String("glApplyTextureEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix3x4dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix3x4dv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix3x4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultisamplefvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetMultisamplefvNV(arg0,arg1,arg2);
    String txt = new String("glGetMultisamplefvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3i(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glColor3i(arg0,arg1,arg2);
    String txt = new String("glColor3i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPathParameterivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glPathParameterivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glPathParameterivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord4dv(arg0,arg1);
    String txt = new String("glTexCoord4dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBindVertexArray(int arg0)
  {
        checkContext();
downstreamGL4bc.glBindVertexArray(arg0);
    String txt = new String("glBindVertexArray(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPolygonStipple(long arg0)
  {
        checkContext();
downstreamGL4bc.glGetPolygonStipple(arg0);
    String txt = new String("glGetPolygonStipple(" +
    "<long> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix3x4fvEXT(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix3x4fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix3x4fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glWeightdvARB(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glWeightdvARB(arg0,arg1);
    String txt = new String("glWeightdvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos4fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glRasterPos4fv(arg0);
    String txt = new String("glRasterPos4fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixLoaddEXT(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMatrixLoaddEXT(arg0,arg1);
    String txt = new String("glMatrixLoaddEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glNormal3sv(arg0,arg1);
    String txt = new String("glNormal3sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenPerfMonitorsAMD(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGenPerfMonitorsAMD(arg0,arg1,arg2);
    String txt = new String("glGenPerfMonitorsAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCoverStrokePathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,float[] arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glCoverStrokePathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glCoverStrokePathInstancedNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexEnvfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexEnvfvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexEnvfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedRenderbufferStorageMultisampleCoverageEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glNamedRenderbufferStorageMultisampleCoverageEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glNamedRenderbufferStorageMultisampleCoverageEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexStorage1D(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glTexStorage1D(arg0,arg1,arg2,arg3);
    String txt = new String("glTexStorage1D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3usv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3usv(arg0);
    String txt = new String("glSecondaryColor3usv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexGenf(int arg0,int arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glTexGenf(arg0,arg1,arg2);
    String txt = new String("glTexGenf(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixIndexuivARB(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMatrixIndexuivARB(arg0,arg1,arg2);
    String txt = new String("glMatrixIndexuivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDisableIndexed(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glDisableIndexed(arg0,arg1);
    String txt = new String("glDisableIndexed(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEndConditionalRenderNVX()
  {
        checkContext();
downstreamGL4bc.glEndConditionalRenderNVX();
    String txt = new String("glEndConditionalRenderNVX(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glHintPGI(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glHintPGI(arg0,arg1);
    String txt = new String("glHintPGI(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEndQueryIndexed(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glEndQueryIndexed(arg0,arg1);
    String txt = new String("glEndQueryIndexed(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyTextureSubImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9)
  {
        checkContext();
downstreamGL4bc.glCopyTextureSubImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glCopyTextureSubImage3DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramParameteri(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glProgramParameteri(arg0,arg1,arg2);
    String txt = new String("glProgramParameteri(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos2dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glRasterPos2dv(arg0);
    String txt = new String("glRasterPos2dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glShaderOp2EXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glShaderOp2EXT(arg0,arg1,arg2,arg3);
    String txt = new String("glShaderOp2EXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3svARB(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3svARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib3svARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelTransformParameterivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glPixelTransformParameterivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glPixelTransformParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelTransformParameterfEXT(int arg0,int arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glPixelTransformParameterfEXT(arg0,arg1,arg2);
    String txt = new String("glPixelTransformParameterfEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribP4ui(int arg0,int arg1,boolean arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribP4ui(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribP4ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3sv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex3sv(arg0);
    String txt = new String("glVertex3sv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawTransformFeedbackNV(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glDrawTransformFeedbackNV(arg0,arg1);
    String txt = new String("glDrawTransformFeedbackNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsSampler(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsSampler(arg0);
    String txt = new String("glIsSampler(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertex4hv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex4hv(arg0,arg1);
    String txt = new String("glVertex4hv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRenderbufferStorage(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glRenderbufferStorage(arg0,arg1,arg2,arg3);
    String txt = new String("glRenderbufferStorage(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3ubv(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3ubv(arg0);
    String txt = new String("glSecondaryColor3ubv(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribivARB(arg0,arg1,arg2);
    String txt = new String("glGetVertexAttribivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1i64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1i64vNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform1i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2i64NV(int arg0,long arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glUniform2i64NV(arg0,arg1,arg2);
    String txt = new String("glUniform2i64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexArrayVertexAttribLFormatEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVertexArrayVertexAttribLFormatEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexArrayVertexAttribLFormatEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSetMultisamplefvAMD(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glSetMultisamplefvAMD(arg0,arg1,arg2);
    String txt = new String("glSetMultisamplefvAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramLocalParameterdvARB(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetProgramLocalParameterdvARB(arg0,arg1,arg2);
    String txt = new String("glGetProgramLocalParameterdvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  int glGetHandleARB(int arg0)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetHandleARB(arg0);
    String txt = new String("glGetHandleARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetObjectLabel(int arg0,int arg1,int arg2,int[] arg3,int arg4,byte[] arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glGetObjectLabel(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetObjectLabel(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glOrthof(float arg0,float arg1,float arg2,float arg3,float arg4,float arg5)
  {
        checkContext();
downstreamGL4bc.glOrthof(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glOrthof(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ", " +
    "<float> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glMakeNamedBufferResidentNV(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glMakeNamedBufferResidentNV(arg0,arg1);
    String txt = new String("glMakeNamedBufferResidentNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3bOES(byte arg0,byte arg1)
  {
        checkContext();
downstreamGL4bc.glVertex3bOES(arg0,arg1);
    String txt = new String("glVertex3bOES(" +
    "<byte> "+arg0 +    ", " +
    "<byte> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  int glGetUniformLocation(int arg0,java.lang.String arg1)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetUniformLocation(arg0,arg1);
    String txt = new String("glGetUniformLocation(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.lang.String> "+arg1 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetVariantIntegervEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVariantIntegervEXT(arg0,arg1,arg2);
    String txt = new String("glGetVariantIntegervEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteTransformFeedbacks(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDeleteTransformFeedbacks(arg0,arg1,arg2);
    String txt = new String("glDeleteTransformFeedbacks(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexStorage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glTexStorage3D(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glTexStorage3D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glHint(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glHint(arg0,arg1);
    String txt = new String("glHint(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexEnvf(int arg0,int arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glTexEnvf(arg0,arg1,arg2);
    String txt = new String("glTexEnvf(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformSubroutinesuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniformSubroutinesuiv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformSubroutinesuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelTransferi(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glPixelTransferi(arg0,arg1);
    String txt = new String("glPixelTransferi(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexGenfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glTexGenfv(arg0,arg1,arg2,arg3);
    String txt = new String("glTexGenfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMakeImageHandleNonResidentNV(long arg0)
  {
        checkContext();
downstreamGL4bc.glMakeImageHandleNonResidentNV(arg0);
    String txt = new String("glMakeImageHandleNonResidentNV(" +
    "<long> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryObjectui64v(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetQueryObjectui64v(arg0,arg1,arg2,arg3);
    String txt = new String("glGetQueryObjectui64v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glQueryMatrixxOES(java.nio.IntBuffer arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
    int _res = downstreamGL4bc.glQueryMatrixxOES(arg0,arg1);
    String txt = new String("glQueryMatrixxOES(" +
    "<java.nio.IntBuffer> "+arg0 +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  int glQueryMatrixxOES(int[] arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
    int _res = downstreamGL4bc.glQueryMatrixxOES(arg0,arg1,arg2,arg3);
    String txt = new String("glQueryMatrixxOES(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glRasterPos3sv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glRasterPos3sv(arg0);
    String txt = new String("glRasterPos3sv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glTransformPathNV(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glTransformPathNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glTransformPathNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantusvEXT(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVariantusvEXT(arg0,arg1,arg2);
    String txt = new String("glVariantusvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean isNPOTTextureAvailable()
  {
        return downstreamGL4bc.isNPOTTextureAvailable();
  }
  public  void glWeightfvARB(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glWeightfvARB(arg0,arg1,arg2);
    String txt = new String("glWeightfvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2bvOES(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex2bvOES(arg0,arg1);
    String txt = new String("glVertex2bvOES(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetBufferParameterui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetBufferParameterui64vNV(arg0,arg1,arg2);
    String txt = new String("glGetBufferParameterui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI1uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI1uiv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI1uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureRenderbufferEXT(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glTextureRenderbufferEXT(arg0,arg1,arg2);
    String txt = new String("glTextureRenderbufferEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPushMatrix()
  {
        checkContext();
downstreamGL4bc.glPushMatrix();
    String txt = new String("glPushMatrix(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteSamplers(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glDeleteSamplers(arg0,arg1);
    String txt = new String("glDeleteSamplers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribLui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribLui64vNV(arg0,arg1,arg2);
    String txt = new String("glGetVertexAttribLui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glBindVertexBuffer(int arg0,int arg1,long arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glBindVertexBuffer(arg0,arg1,arg2,arg3);
    String txt = new String("glBindVertexBuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glClearNamedBufferDataEXT(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
        checkContext();
downstreamGL4bc.glClearNamedBufferDataEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glClearNamedBufferDataEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glLogicOp(int arg0)
  {
        checkContext();
downstreamGL4bc.glLogicOp(arg0);
    String txt = new String("glLogicOp(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos3iv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glWindowPos3iv(arg0,arg1);
    String txt = new String("glWindowPos3iv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexEnvfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexEnvfvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMultiTexEnvfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glFlushPixelDataRangeNV(int arg0)
  {
        checkContext();
downstreamGL4bc.glFlushPixelDataRangeNV(arg0);
    String txt = new String("glFlushPixelDataRangeNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsPointInFillPathNV(int arg0,int arg1,float arg2,float arg3)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsPointInFillPathNV(arg0,arg1,arg2,arg3);
    String txt = new String("glIsPointInFillPathNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVariantubvEXT(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVariantubvEXT(arg0,arg1,arg2);
    String txt = new String("glVariantubvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramStringARB(int arg0,int arg1,int arg2,java.lang.String arg3)
  {
        checkContext();
downstreamGL4bc.glProgramStringARB(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramStringARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.lang.String> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixLoadfEXT(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMatrixLoadfEXT(arg0,arg1);
    String txt = new String("glMatrixLoadfEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glBlendEquationIndexedAMD(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glBlendEquationIndexedAMD(arg0,arg1);
    String txt = new String("glBlendEquationIndexedAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexArrayMultiTexCoordOffsetEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6)
  {
        checkContext();
downstreamGL4bc.glVertexArrayMultiTexCoordOffsetEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glVertexArrayMultiTexCoordOffsetEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<long> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1sv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1sv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib1sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramLocalParameterI4ivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParameterI4ivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glNamedProgramLocalParameterI4ivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMapParameterfvNV(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetMapParameterfvNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMapParameterfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4NbvARB(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4NbvARB(arg0,arg1);
    String txt = new String("glVertexAttrib4NbvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribdv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribdv(arg0,arg1,arg2);
    String txt = new String("glGetVertexAttribdv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4hv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4hv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord4hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glScissorIndexedv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glScissorIndexedv(arg0,arg1,arg2);
    String txt = new String("glScissorIndexedv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelTransformParameteriEXT(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glPixelTransformParameteriEXT(arg0,arg1,arg2);
    String txt = new String("glPixelTransformParameteriEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2fv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMemoryBarrier(int arg0)
  {
        checkContext();
downstreamGL4bc.glMemoryBarrier(arg0);
    String txt = new String("glMemoryBarrier(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexEnviv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetTexEnviv(arg0,arg1,arg2);
    String txt = new String("glGetTexEnviv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glColorPointer(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glColorPointer(arg0,arg1,arg2,arg3);
    String txt = new String("glColorPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribPointer(javax.media.opengl.GLArrayData arg0)
  {
        checkContext();
downstreamGL4bc.glVertexAttribPointer(arg0);
    String txt = new String("glVertexAttribPointer(" +
    "<javax.media.opengl.GLArrayData> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glAttachObjectARB(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glAttachObjectARB(arg0,arg1);
    String txt = new String("glAttachObjectARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  javax.media.opengl.GL getRootGL()
  {
        return downstreamGL4bc.getRootGL();
  }
  public  void glSecondaryColor3iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3iv(arg0);
    String txt = new String("glSecondaryColor3iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4bvOES(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4bvOES(arg0,arg1);
    String txt = new String("glMultiTexCoord4bvOES(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,java.nio.Buffer arg10)
  {
        checkContext();
downstreamGL4bc.glTextureImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glTextureImage3DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg10 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4bv(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4bv(arg0,arg1);
    String txt = new String("glVertexAttrib4bv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformHandleui64NV(int arg0,long arg1)
  {
        checkContext();
downstreamGL4bc.glUniformHandleui64NV(arg0,arg1);
    String txt = new String("glUniformHandleui64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetQueryiv(arg0,arg1,arg2);
    String txt = new String("glGetQueryiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexGend(int arg0,int arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glTexGend(arg0,arg1,arg2);
    String txt = new String("glTexGend(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4uiv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetBufferSubData(int arg0,long arg1,long arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetBufferSubData(arg0,arg1,arg2,arg3);
    String txt = new String("glGetBufferSubData(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTextureParameterfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetTextureParameterfvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetTextureParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4NusvARB(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4NusvARB(arg0,arg1);
    String txt = new String("glVertexAttrib4NusvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInteger64v(int arg0,long[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGetInteger64v(arg0,arg1,arg2);
    String txt = new String("glGetInteger64v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnUniformuiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetnUniformuiv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetnUniformuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelMapfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glPixelMapfv(arg0,arg1,arg2);
    String txt = new String("glPixelMapfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord4fv(arg0,arg1);
    String txt = new String("glTexCoord4fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2x4dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2x4dv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix2x4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformui64NV(int arg0,int arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glProgramUniformui64NV(arg0,arg1,arg2);
    String txt = new String("glProgramUniformui64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix4x3fvEXT(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4x3fvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix4x3fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexBufferEXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexBufferEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexBufferEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribBinding(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribBinding(arg0,arg1);
    String txt = new String("glVertexAttribBinding(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureParameterivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glTextureParameterivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glTextureParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexArrayTexCoordOffsetEXT(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
        checkContext();
downstreamGL4bc.glVertexArrayTexCoordOffsetEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glVertexArrayTexCoordOffsetEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<long> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedFramebufferParameteriEXT(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glNamedFramebufferParameteriEXT(arg0,arg1,arg2);
    String txt = new String("glNamedFramebufferParameteriEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3fvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform3fvARB(arg0,arg1,arg2);
    String txt = new String("glUniform3fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompileShader(int arg0)
  {
        checkContext();
downstreamGL4bc.glCompileShader(arg0);
    String txt = new String("glCompileShader(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4svARB(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4svARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4svARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexP4uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexP4uiv(arg0,arg1,arg2);
    String txt = new String("glVertexP4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2iARB(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glUniform2iARB(arg0,arg1,arg2);
    String txt = new String("glUniform2iARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3bvOES(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex3bvOES(arg0,arg1);
    String txt = new String("glVertex3bvOES(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFogCoorddv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glFogCoorddv(arg0,arg1);
    String txt = new String("glFogCoorddv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glStencilOpSeparate(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glStencilOpSeparate(arg0,arg1,arg2,arg3);
    String txt = new String("glStencilOpSeparate(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPointParameteriv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glPointParameteriv(arg0,arg1,arg2);
    String txt = new String("glPointParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTextureLevelParameterfvEXT(int arg0,int arg1,int arg2,int arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetTextureLevelParameterfvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetTextureLevelParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glSamplerParameterIiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glSamplerParameterIiv(arg0,arg1,arg2,arg3);
    String txt = new String("glSamplerParameterIiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParameters4fvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParameters4fvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramEnvParameters4fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribPointerARB(int arg0,int arg1,int arg2,boolean arg3,int arg4,java.nio.Buffer arg5)
  {
        checkContext();
downstreamGL4bc.glVertexAttribPointerARB(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glVertexAttribPointerARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix3x2dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix3x2dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix3x2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBlendFunci(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glBlendFunci(arg0,arg1,arg2);
    String txt = new String("glBlendFunci(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsFenceAPPLE(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsFenceAPPLE(arg0);
    String txt = new String("glIsFenceAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glCompressedTextureSubImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
        checkContext();
downstreamGL4bc.glCompressedTextureSubImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glCompressedTextureSubImage2DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg9 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord3iv(arg0);
    String txt = new String("glTexCoord3iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glDepthFunc(int arg0)
  {
        checkContext();
downstreamGL4bc.glDepthFunc(arg0);
    String txt = new String("glDepthFunc(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPathStencilDepthOffsetNV(float arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glPathStencilDepthOffsetNV(arg0,arg1);
    String txt = new String("glPathStencilDepthOffsetNV(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexGenfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexGenfvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexGenfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGenFramebuffers(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGenFramebuffers(arg0,arg1,arg2);
    String txt = new String("glGenFramebuffers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsEnabledIndexed(int arg0,int arg1)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsEnabledIndexed(arg0,arg1);
    String txt = new String("glIsEnabledIndexed(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  long glGetTextureSamplerHandleNV(int arg0,int arg1)
  {
        checkContext();
    long _res = downstreamGL4bc.glGetTextureSamplerHandleNV(arg0,arg1);
    String txt = new String("glGetTextureSamplerHandleNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexAttribL4i64vNV(int arg0,java.nio.LongBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL4i64vNV(arg0,arg1);
    String txt = new String("glVertexAttribL4i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGenSamplers(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGenSamplers(arg0,arg1,arg2);
    String txt = new String("glGenSamplers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryObjectiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetQueryObjectiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetQueryObjectiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPolygonStipple(long arg0)
  {
        checkContext();
downstreamGL4bc.glPolygonStipple(arg0);
    String txt = new String("glPolygonStipple(" +
    "<long> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2iv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform2iv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform2iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEnableVariantClientStateEXT(int arg0)
  {
        checkContext();
downstreamGL4bc.glEnableVariantClientStateEXT(arg0);
    String txt = new String("glEnableVariantClientStateEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI3uivEXT(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI3uivEXT(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI3uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glViewportIndexedfv(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glViewportIndexedfv(arg0,arg1);
    String txt = new String("glViewportIndexedfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glPatchParameterfv(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glPatchParameterfv(arg0,arg1,arg2);
    String txt = new String("glPatchParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTextureParameterIuivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetTextureParameterIuivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetTextureParameterIuivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedTexSubImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,java.nio.Buffer arg10)
  {
        checkContext();
downstreamGL4bc.glCompressedTexSubImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glCompressedTexSubImage3D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg10 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL2i64vNV(int arg0,long[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL2i64vNV(arg0,arg1,arg2);
    String txt = new String("glVertexAttribL2i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultTransposeMatrixd(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glMultTransposeMatrixd(arg0,arg1);
    String txt = new String("glMultTransposeMatrixd(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMapVertexAttrib2fAPPLE(int arg0,int arg1,float arg2,float arg3,int arg4,int arg5,float arg6,float arg7,int arg8,int arg9,float[] arg10,int arg11)
  {
        checkContext();
downstreamGL4bc.glMapVertexAttrib2fAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    String txt = new String("glMapVertexAttrib2fAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<float> "+arg6 +    ", " +
    "<float> "+arg7 +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg11).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetHistogramParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetHistogramParameteriv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetHistogramParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNormalP3ui(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glNormalP3ui(arg0,arg1);
    String txt = new String("glNormalP3ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferDrawBuffersEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glFramebufferDrawBuffersEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glFramebufferDrawBuffersEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix3dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix3dv(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI3ivEXT(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI3ivEXT(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI3ivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI3uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI3uiv(arg0,arg1);
    String txt = new String("glVertexAttribI3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawRangeElementsBaseVertex(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glDrawRangeElementsBaseVertex(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glDrawRangeElementsBaseVertex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg5 +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexAttribfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPopName()
  {
        checkContext();
downstreamGL4bc.glPopName();
    String txt = new String("glPopName(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.DoubleBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4usvARB(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4usvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4usvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2fv(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2fv(arg0,arg1);
    String txt = new String("glVertexAttrib2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramLocalParameterI4uivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParameterI4uivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glNamedProgramLocalParameterI4uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColorFormatNV(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glColorFormatNV(arg0,arg1,arg2);
    String txt = new String("glColorFormatNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glShaderStorageBlockBinding(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glShaderStorageBlockBinding(arg0,arg1,arg2);
    String txt = new String("glShaderStorageBlockBinding(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI2uivEXT(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI2uivEXT(arg0,arg1);
    String txt = new String("glVertexAttribI2uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixMultdEXT(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMatrixMultdEXT(arg0,arg1);
    String txt = new String("glMatrixMultdEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2sv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2sv(arg0,arg1);
    String txt = new String("glVertexAttrib2sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4fv(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4fv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDisableVertexAttribArrayARB(int arg0)
  {
        checkContext();
downstreamGL4bc.glDisableVertexAttribArrayARB(arg0);
    String txt = new String("glDisableVertexAttribArrayARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDepthRange(double arg0,double arg1)
  {
        checkContext();
downstreamGL4bc.glDepthRange(arg0,arg1);
    String txt = new String("glDepthRange(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glClipPlanef(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glClipPlanef(arg0,arg1);
    String txt = new String("glClipPlanef(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  long glGetTextureHandleNV(int arg0)
  {
        checkContext();
    long _res = downstreamGL4bc.glGetTextureHandleNV(arg0);
    String txt = new String("glGetTextureHandleNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetInternalformativ(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetInternalformativ(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetInternalformativ(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordP4ui(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoordP4ui(arg0,arg1);
    String txt = new String("glTexCoordP4ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVDPAUIsSurfaceNV(long arg0)
  {
        checkContext();
downstreamGL4bc.glVDPAUIsSurfaceNV(arg0);
    String txt = new String("glVDPAUIsSurfaceNV(" +
    "<long> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColorP3ui(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glSecondaryColorP3ui(arg0,arg1);
    String txt = new String("glSecondaryColorP3ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexs(short arg0)
  {
        checkContext();
downstreamGL4bc.glIndexs(arg0);
    String txt = new String("glIndexs(" +
    "<short> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixScaledEXT(int arg0,double arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glMatrixScaledEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMatrixScaledEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glWeightubvARB(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glWeightubvARB(arg0,arg1);
    String txt = new String("glWeightubvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4uivARB(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4uivARB(arg0,arg1);
    String txt = new String("glVertexAttrib4uivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3uiv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3uiv(arg0,arg1);
    String txt = new String("glSecondaryColor3uiv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPixelTransformParameterfvEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetPixelTransformParameterfvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetPixelTransformParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4iARB(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniform4iARB(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniform4iARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColorTableParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glColorTableParameteriv(arg0,arg1,arg2);
    String txt = new String("glColorTableParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix2dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix2dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4uiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform4uiv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexParameteri(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glTexParameteri(arg0,arg1,arg2);
    String txt = new String("glTexParameteri(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1ui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform1ui64vNV(arg0,arg1,arg2);
    String txt = new String("glUniform1ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteNamesAMD(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glDeleteNamesAMD(arg0,arg1,arg2,arg3);
    String txt = new String("glDeleteNamesAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBlitFramebuffer(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9)
  {
        checkContext();
downstreamGL4bc.glBlitFramebuffer(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glBlitFramebuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawPixels(int arg0,int arg1,int arg2,int arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glDrawPixels(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glDrawPixels(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  int glCheckNamedFramebufferStatusEXT(int arg0,int arg1)
  {
        checkContext();
    int _res = downstreamGL4bc.glCheckNamedFramebufferStatusEXT(arg0,arg1);
    String txt = new String("glCheckNamedFramebufferStatusEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetClipPlane(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGetClipPlane(arg0,arg1,arg2);
    String txt = new String("glGetClipPlane(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPNTrianglesfATI(int arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glPNTrianglesfATI(arg0,arg1);
    String txt = new String("glPNTrianglesfATI(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glFlushMappedNamedBufferRangeEXT(int arg0,long arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glFlushMappedNamedBufferRangeEXT(arg0,arg1,arg2);
    String txt = new String("glFlushMappedNamedBufferRangeEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glClearColor(float arg0,float arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glClearColor(arg0,arg1,arg2,arg3);
    String txt = new String("glClearColor(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glWeightbvARB(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glWeightbvARB(arg0,arg1,arg2);
    String txt = new String("glWeightbvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4d(double arg0,double arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glColor4d(arg0,arg1,arg2,arg3);
    String txt = new String("glColor4d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2x3fvEXT(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2x3fvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix2x3fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4b(byte arg0,byte arg1,byte arg2,byte arg3)
  {
        checkContext();
downstreamGL4bc.glColor4b(arg0,arg1,arg2,arg3);
    String txt = new String("glColor4b(" +
    "<byte> "+arg0 +    ", " +
    "<byte> "+arg1 +    ", " +
    "<byte> "+arg2 +    ", " +
    "<byte> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2iv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2iv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord2iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSamplerParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glSamplerParameterfv(arg0,arg1,arg2,arg3);
    String txt = new String("glSamplerParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixPopEXT(int arg0)
  {
        checkContext();
downstreamGL4bc.glMatrixPopEXT(arg0);
    String txt = new String("glMatrixPopEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glGetProgramResourceIndex(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetProgramResourceIndex(arg0,arg1,arg2);
    String txt = new String("glGetProgramResourceIndex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glTexEnviv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glTexEnviv(arg0,arg1,arg2);
    String txt = new String("glTexEnviv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexStorage2D(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glTexStorage2D(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glTexStorage2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPixelTransformParameterivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetPixelTransformParameterivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetPixelTransformParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteObjectARB(int arg0)
  {
        checkContext();
downstreamGL4bc.glDeleteObjectARB(arg0);
    String txt = new String("glDeleteObjectARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferTextureARB(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glFramebufferTextureARB(arg0,arg1,arg2,arg3);
    String txt = new String("glFramebufferTextureARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glShaderBinary(int arg0,int[] arg1,int arg2,int arg3,java.nio.Buffer arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glShaderBinary(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glShaderBinary(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg4 +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4s(short arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glColor4s(arg0,arg1,arg2,arg3);
    String txt = new String("glColor4s(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureImage3DMultisampleNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,boolean arg7)
  {
        checkContext();
downstreamGL4bc.glTextureImage3DMultisampleNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glTextureImage3DMultisampleNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<boolean> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3fvARB(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3fvARB(arg0,arg1);
    String txt = new String("glVertexAttrib3fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedProgramLocalParameterIivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetNamedProgramLocalParameterIivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetNamedProgramLocalParameterIivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGenProgramsARB(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenProgramsARB(arg0,arg1);
    String txt = new String("glGenProgramsARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexGenivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexGenivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMultiTexGenivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4Nsv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4Nsv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4Nsv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4i(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glColor4i(arg0,arg1,arg2,arg3);
    String txt = new String("glColor4i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4h(short arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glColor4h(arg0,arg1,arg2,arg3);
    String txt = new String("glColor4h(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glLightModelf(int arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glLightModelf(arg0,arg1);
    String txt = new String("glLightModelf(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glClipPlane(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glClipPlane(arg0,arg1,arg2);
    String txt = new String("glClipPlane(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4sv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4sv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI4sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4f(float arg0,float arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glColor4f(arg0,arg1,arg2,arg3);
    String txt = new String("glColor4f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3s(short arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3s(arg0,arg1,arg2);
    String txt = new String("glSecondaryColor3s(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetUniformfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetUniformfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsProgramARB(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsProgramARB(arg0);
    String txt = new String("glIsProgramARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexAttrib4ubv(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4ubv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4ubv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribIuivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribIuivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexAttribIuivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glStencilFillPathNV(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glStencilFillPathNV(arg0,arg1,arg2);
    String txt = new String("glStencilFillPathNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramLocalParameterIuivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetProgramLocalParameterIuivNV(arg0,arg1,arg2);
    String txt = new String("glGetProgramLocalParameterIuivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos2fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glWindowPos2fv(arg0);
    String txt = new String("glWindowPos2fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVideoCaptureStreamivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetVideoCaptureStreamivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVideoCaptureStreamivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexGendv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glTexGendv(arg0,arg1,arg2);
    String txt = new String("glTexGendv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordPointer(javax.media.opengl.GLArrayData arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoordPointer(arg0);
    String txt = new String("glTexCoordPointer(" +
    "<javax.media.opengl.GLArrayData> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexLevelParameterfvEXT(int arg0,int arg1,int arg2,int arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexLevelParameterfvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetMultiTexLevelParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPointeri_vEXT(int arg0,int arg1,com.jogamp.common.nio.PointerBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetPointeri_vEXT(arg0,arg1,arg2);
    String txt = new String("glGetPointeri_vEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<com.jogamp.common.nio.PointerBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glStencilStrokePathNV(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glStencilStrokePathNV(arg0,arg1,arg2);
    String txt = new String("glStencilStrokePathNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexParameterfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexParameterfvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexP3uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexP3uiv(arg0,arg1,arg2);
    String txt = new String("glVertexP3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3h(short arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3h(arg0,arg1,arg2);
    String txt = new String("glSecondaryColor3h(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoordP4uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoordP4uiv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoordP4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord2fv(arg0);
    String txt = new String("glTexCoord2fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordPointer(int arg0,int arg1,int arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glTexCoordPointer(arg0,arg1,arg2,arg3);
    String txt = new String("glTexCoordPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glEndTransformFeedback()
  {
        checkContext();
downstreamGL4bc.glEndTransformFeedback();
    String txt = new String("glEndTransformFeedback(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glMaterialfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glMaterialfv(arg0,arg1,arg2,arg3);
    String txt = new String("glMaterialfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribIuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribIuiv(arg0,arg1,arg2);
    String txt = new String("glGetVertexAttribIuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  long glGetUniformOffsetEXT(int arg0,int arg1)
  {
        checkContext();
    long _res = downstreamGL4bc.glGetUniformOffsetEXT(arg0,arg1);
    String txt = new String("glGetUniformOffsetEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetTexParameterIiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetTexParameterIiv(arg0,arg1,arg2);
    String txt = new String("glGetTexParameterIiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord2sv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord2sv(arg0);
    String txt = new String("glTexCoord2sv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsPBOUnpackBound()
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsPBOUnpackBound();
    String txt = new String("glIsPBOUnpackBound(" +
    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexAttribL3i64vNV(int arg0,long[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL3i64vNV(arg0,arg1,arg2);
    String txt = new String("glVertexAttribL3i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribFormatNV(int arg0,int arg1,int arg2,boolean arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribFormatNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribFormatNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathParameterfvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetPathParameterfvNV(arg0,arg1,arg2);
    String txt = new String("glGetPathParameterfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribs4hv(int arg0,int arg1,short[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribs4hv(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribs4hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix3fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix3fv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord3sv(arg0,arg1);
    String txt = new String("glTexCoord3sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glLockArraysEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glLockArraysEXT(arg0,arg1);
    String txt = new String("glLockArraysEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3i64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3i64vNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform3i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteRenderbuffers(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDeleteRenderbuffers(arg0,arg1,arg2);
    String txt = new String("glDeleteRenderbuffers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexBuffer(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glTexBuffer(arg0,arg1,arg2);
    String txt = new String("glTexBuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramSubroutineParameteruivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetProgramSubroutineParameteruivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramSubroutineParameteruivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix4fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glLoadTransposeMatrixd(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glLoadTransposeMatrixd(arg0,arg1);
    String txt = new String("glLoadTransposeMatrixd(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1hv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1hv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib1hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2fvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform2fvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform2fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetUniformui64vNV(arg0,arg1,arg2);
    String txt = new String("glGetUniformui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glFogCoordh(short arg0)
  {
        checkContext();
downstreamGL4bc.glFogCoordh(arg0);
    String txt = new String("glFogCoordh(" +
    "<short> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glFogfv(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glFogfv(arg0,arg1);
    String txt = new String("glFogfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyTextureSubImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glCopyTextureSubImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glCopyTextureSubImage1DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1dv(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1dv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib1dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexParameterIuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glTexParameterIuiv(arg0,arg1,arg2);
    String txt = new String("glTexParameterIuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord3dv(arg0,arg1);
    String txt = new String("glTexCoord3dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathColorGenfvNV(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetPathColorGenfvNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetPathColorGenfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexArrayVertexAttribBindingEXT(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexArrayVertexAttribBindingEXT(arg0,arg1,arg2);
    String txt = new String("glVertexArrayVertexAttribBindingEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNormal3fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glNormal3fv(arg0);
    String txt = new String("glNormal3fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetIntegerui64vNV(int arg0,long[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGetIntegerui64vNV(arg0,arg1,arg2);
    String txt = new String("glGetIntegerui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramPipelineiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetProgramPipelineiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramPipelineiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPerfMonitorGroupStringAMD(int arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetPerfMonitorGroupStringAMD(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetPerfMonitorGroupStringAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureBufferRangeEXT(int arg0,int arg1,int arg2,int arg3,long arg4,long arg5)
  {
        checkContext();
downstreamGL4bc.glTextureBufferRangeEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glTextureBufferRangeEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<long> "+arg4 +    ", " +
    "<long> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos3s(short arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glRasterPos3s(arg0,arg1,arg2);
    String txt = new String("glRasterPos3s(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedTexSubImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6)
  {
        checkContext();
downstreamGL4bc.glCompressedTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glCompressedTexSubImage1D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixIndexusvARB(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMatrixIndexusvARB(arg0,arg1,arg2);
    String txt = new String("glMatrixIndexusvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramLocalParameters4fvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParameters4fvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramLocalParameters4fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI2iv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI2iv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI2iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPointSize(float arg0)
  {
        checkContext();
downstreamGL4bc.glPointSize(arg0);
    String txt = new String("glPointSize(" +
    "<float> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexArrayRangeAPPLE(int arg0,java.nio.Buffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexArrayRangeAPPLE(arg0,arg1);
    String txt = new String("glVertexArrayRangeAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  java.lang.Object getPlatformGLExtensions()
  {
        return downstreamGL4bc.getPlatformGLExtensions();
  }
  public  void glNamedProgramLocalParameterI4iEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParameterI4iEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glNamedProgramLocalParameterI4iEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
        checkContext();
downstreamGL4bc.glTextureImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glTextureImage2DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg9 +    ")");
    checkGLGetError( txt );
  }
  public  void glInterleavedArrays(int arg0,int arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glInterleavedArrays(arg0,arg1,arg2);
    String txt = new String("glInterleavedArrays(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVDPAUSurfaceAccessNV(long arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVDPAUSurfaceAccessNV(arg0,arg1);
    String txt = new String("glVDPAUSurfaceAccessNV(" +
    "<long> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramInfoLog(int arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetProgramInfoLog(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetProgramInfoLog(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  int glGenLists(int arg0)
  {
        checkContext();
    int _res = downstreamGL4bc.glGenLists(arg0);
    String txt = new String("glGenLists(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glMultiTexSubImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
        checkContext();
downstreamGL4bc.glMultiTexSubImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glMultiTexSubImage2DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg9 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4bvOES(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord4bvOES(arg0);
    String txt = new String("glTexCoord4bvOES(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glBufferAddressRangeNV(int arg0,int arg1,long arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glBufferAddressRangeNV(arg0,arg1,arg2,arg3);
    String txt = new String("glBufferAddressRangeNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedMultiTexImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
        checkContext();
downstreamGL4bc.glCompressedMultiTexImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    String txt = new String("glCompressedMultiTexImage3DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg9 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMapiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetMapiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMapiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexGenfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexGenfvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMultiTexGenfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glCompressedTexSubImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
        checkContext();
downstreamGL4bc.glCompressedTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glCompressedTexSubImage2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glLightModelfv(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glLightModelfv(arg0,arg1);
    String txt = new String("glLightModelfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetFramebufferParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetFramebufferParameteriv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetFramebufferParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4fv(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4fv(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetDoublev(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGetDoublev(arg0,arg1);
    String txt = new String("glGetDoublev(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryObjectuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetQueryObjectuiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetQueryObjectuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsNamedBufferResidentNV(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsNamedBufferResidentNV(arg0);
    String txt = new String("glIsNamedBufferResidentNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glMultiTexParameterIivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glMultiTexParameterIivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiTexParameterIivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteBuffers(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDeleteBuffers(arg0,arg1,arg2);
    String txt = new String("glDeleteBuffers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetLocalConstantFloatvEXT(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetLocalConstantFloatvEXT(arg0,arg1,arg2);
    String txt = new String("glGetLocalConstantFloatvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1f(float arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord1f(arg0);
    String txt = new String("glTexCoord1f(" +
    "<float> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glTestFenceAPPLE(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glTestFenceAPPLE(arg0);
    String txt = new String("glTestFenceAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glMultiTexCoord1f(int arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1f(arg0,arg1);
    String txt = new String("glMultiTexCoord1f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glDispatchCompute(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDispatchCompute(arg0,arg1,arg2);
    String txt = new String("glDispatchCompute(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureStorage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glTextureStorage2D(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glTextureStorage2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsShader(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsShader(arg0);
    String txt = new String("glIsShader(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertexPointer(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glVertexPointer(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4ubv(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4ubv(arg0,arg1);
    String txt = new String("glVertexAttrib4ubv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glClear(int arg0)
  {
        checkContext();
downstreamGL4bc.glClear(arg0);
    String txt = new String("glClear(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3sv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3sv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord3sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColorP3uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glColorP3uiv(arg0,arg1);
    String txt = new String("glColorP3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glEdgeFlagPointer(int arg0,long arg1)
  {
        checkContext();
downstreamGL4bc.glEdgeFlagPointer(arg0,arg1);
    String txt = new String("glEdgeFlagPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glPointParameterf(int arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glPointParameterf(arg0,arg1);
    String txt = new String("glPointParameterf(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexBufferRange(int arg0,int arg1,int arg2,long arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glTexBufferRange(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glTexBufferRange(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4iv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4iv(arg0,arg1);
    String txt = new String("glVertexAttribI4iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor4dv(arg0,arg1);
    String txt = new String("glColor4dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTranslated(double arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glTranslated(arg0,arg1,arg2);
    String txt = new String("glTranslated(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glStencilMask(int arg0)
  {
        checkContext();
downstreamGL4bc.glStencilMask(arg0);
    String txt = new String("glStencilMask(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryObjectui64vEXT(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetQueryObjectui64vEXT(arg0,arg1,arg2);
    String txt = new String("glGetQueryObjectui64vEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor4iv(arg0);
    String txt = new String("glColor4iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI3ui(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI3ui(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribI3ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix4x2dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix4x2dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix4x2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMaterialiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetMaterialiv(arg0,arg1,arg2);
    String txt = new String("glGetMaterialiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glFramebufferTexture3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glFramebufferTexture3D(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glFramebufferTexture3D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenNamesAMD(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGenNamesAMD(arg0,arg1,arg2,arg3);
    String txt = new String("glGenNamesAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetOcclusionQueryivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetOcclusionQueryivNV(arg0,arg1,arg2);
    String txt = new String("glGetOcclusionQueryivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformIndices(int arg0,int arg1,java.lang.String[] arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetUniformIndices(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetUniformIndices(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[Ljava.lang.String;>" +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex4iv(arg0);
    String txt = new String("glVertex4iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1i64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform1i64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform1i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3hv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3hv(arg0,arg1);
    String txt = new String("glSecondaryColor3hv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnHistogram(int arg0,boolean arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
        checkContext();
downstreamGL4bc.glGetnHistogram(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetnHistogram(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<boolean> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVideoCaptureStreamdvNV(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetVideoCaptureStreamdvNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetVideoCaptureStreamdvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos3i(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glRasterPos3i(arg0,arg1,arg2);
    String txt = new String("glRasterPos3i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3dv(double[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3dv(arg0,arg1);
    String txt = new String("glSecondaryColor3dv(" +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCallList(int arg0)
  {
        checkContext();
downstreamGL4bc.glCallList(arg0);
    String txt = new String("glCallList(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformHandleui64NV(int arg0,int arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glProgramUniformHandleui64NV(arg0,arg1,arg2);
    String txt = new String("glProgramUniformHandleui64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3d(int arg0,double arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3d(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttrib3d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveUniformName(int arg0,int arg1,int arg2,int[] arg3,int arg4,byte[] arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glGetActiveUniformName(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetActiveUniformName(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3fv(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3fv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL4d(int arg0,double arg1,double arg2,double arg3,double arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL4d(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribL4d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ", " +
    "<double> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMultiTexEnvivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetMultiTexEnvivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMultiTexEnvivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3d(int arg0,double arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3d(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexCoord3d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1i(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1i(arg0,arg1,arg2);
    String txt = new String("glProgramUniform1i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4uiv(arg0,arg1);
    String txt = new String("glVertexAttribI4uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveUniform(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4,java.nio.IntBuffer arg5,java.nio.ByteBuffer arg6)
  {
        checkContext();
downstreamGL4bc.glGetActiveUniform(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetActiveUniform(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ", " +
    "<java.nio.IntBuffer> "+arg5 +    ", " +
    "<java.nio.ByteBuffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexP2uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexP2uiv(arg0,arg1);
    String txt = new String("glVertexP2uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformfvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetUniformfvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glGetUniformfvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1uiEXT(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1uiEXT(arg0,arg1,arg2);
    String txt = new String("glProgramUniform1uiEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetShaderPrecisionFormat(int arg0,int arg1,int[] arg2,int arg3,int[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetShaderPrecisionFormat(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetShaderPrecisionFormat(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetShaderPrecisionFormat(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetShaderPrecisionFormat(arg0,arg1,arg2,arg3);
    String txt = new String("glGetShaderPrecisionFormat(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteFencesNV(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glDeleteFencesNV(arg0,arg1);
    String txt = new String("glDeleteFencesNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos2fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos2fv(arg0,arg1);
    String txt = new String("glRasterPos2fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
        checkContext();
downstreamGL4bc.glMultiTexImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glMultiTexImage1DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramLocalParametersI4uivNV(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParametersI4uivNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramLocalParametersI4uivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3f(float arg0,float arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glTexCoord3f(arg0,arg1,arg2);
    String txt = new String("glTexCoord3f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetSamplerParameterIuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetSamplerParameterIuiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetSamplerParameterIuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib2svARB(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib2svARB(arg0,arg1);
    String txt = new String("glVertexAttrib2svARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glClearColorIui(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glClearColorIui(arg0,arg1,arg2,arg3);
    String txt = new String("glClearColorIui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMakeImageHandleResidentNV(long arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glMakeImageHandleResidentNV(arg0,arg1);
    String txt = new String("glMakeImageHandleResidentNV(" +
    "<long> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glClearBufferfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glClearBufferfv(arg0,arg1,arg2,arg3);
    String txt = new String("glClearBufferfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetnPixelMapfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetnPixelMapfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetnPixelMapfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2dv(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2dv(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glTexParameterfv(arg0,arg1,arg2);
    String txt = new String("glTexParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMinmax(int arg0,boolean arg1,int arg2,int arg3,long arg4)
  {
        checkContext();
downstreamGL4bc.glGetMinmax(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMinmax(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<boolean> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<long> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramResourceName(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4,java.nio.ByteBuffer arg5)
  {
        checkContext();
downstreamGL4bc.glGetProgramResourceName(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetProgramResourceName(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ", " +
    "<java.nio.ByteBuffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveUniformBlockName(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.ByteBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetActiveUniformBlockName(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetActiveUniformBlockName(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.ByteBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3i(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3i(arg0,arg1,arg2);
    String txt = new String("glSecondaryColor3i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexWeighth(short arg0)
  {
        checkContext();
downstreamGL4bc.glVertexWeighth(arg0);
    String txt = new String("glVertexWeighth(" +
    "<short> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glBeginQuery(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glBeginQuery(arg0,arg1);
    String txt = new String("glBeginQuery(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4uivEXT(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4uivEXT(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI4uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedProgramivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetNamedProgramivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetNamedProgramivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedProgramLocalParameterfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetNamedProgramLocalParameterfvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetNamedProgramLocalParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1svARB(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1svARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib1svARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4bOES(byte arg0,byte arg1,byte arg2,byte arg3)
  {
        checkContext();
downstreamGL4bc.glTexCoord4bOES(arg0,arg1,arg2,arg3);
    String txt = new String("glTexCoord4bOES(" +
    "<byte> "+arg0 +    ", " +
    "<byte> "+arg1 +    ", " +
    "<byte> "+arg2 +    ", " +
    "<byte> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyTexImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glCopyTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glCopyTexImage1D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4bvOES(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord4bvOES(arg0,arg1);
    String txt = new String("glTexCoord4bvOES(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsImageHandleResidentNV(long arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsImageHandleResidentNV(arg0);
    String txt = new String("glIsImageHandleResidentNV(" +
    "<long> "+arg0 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetProgramResourceiv(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5,int arg6,int[] arg7,int arg8,int[] arg9,int arg10)
  {
        checkContext();
downstreamGL4bc.glGetProgramResourceiv(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glGetProgramResourceiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg10).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribfvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribfvARB(arg0,arg1,arg2);
    String txt = new String("glGetVertexAttribfvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1d(int arg0,double arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1d(arg0,arg1);
    String txt = new String("glVertexAttrib1d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedProgramLocalParameterdvEXT(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetNamedProgramLocalParameterdvEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetNamedProgramLocalParameterdvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribLi64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribLi64vNV(arg0,arg1,arg2);
    String txt = new String("glGetVertexAttribLi64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1f(int arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1f(arg0,arg1);
    String txt = new String("glVertexAttrib1f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramLocalParametersI4ivEXT(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParametersI4ivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glNamedProgramLocalParametersI4ivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glBlendEquationSeparatei(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glBlendEquationSeparatei(arg0,arg1,arg2);
    String txt = new String("glBlendEquationSeparatei(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMakeBufferNonResidentNV(int arg0)
  {
        checkContext();
downstreamGL4bc.glMakeBufferNonResidentNV(arg0);
    String txt = new String("glMakeBufferNonResidentNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glClearBufferData(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
        checkContext();
downstreamGL4bc.glClearBufferData(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glClearBufferData(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexi(int arg0)
  {
        checkContext();
downstreamGL4bc.glIndexi(arg0);
    String txt = new String("glIndexi(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoordP3uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoordP3uiv(arg0,arg1);
    String txt = new String("glTexCoordP3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glFrameTerminatorGREMEDY()
  {
        checkContext();
downstreamGL4bc.glFrameTerminatorGREMEDY();
    String txt = new String("glFrameTerminatorGREMEDY(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveSubroutineName(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5,byte[] arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glGetActiveSubroutineName(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glGetActiveSubroutineName(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor3fv(arg0,arg1);
    String txt = new String("glColor3fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureView(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glTextureView(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glTextureView(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetDoublei_vEXT(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetDoublei_vEXT(arg0,arg1,arg2);
    String txt = new String("glGetDoublei_vEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribLdv(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribLdv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexAttribLdv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUnmapTexture2DINTEL(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glUnmapTexture2DINTEL(arg0,arg1);
    String txt = new String("glUnmapTexture2DINTEL(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4NsvARB(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4NsvARB(arg0,arg1);
    String txt = new String("glVertexAttrib4NsvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glEvalCoord2fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glEvalCoord2fv(arg0);
    String txt = new String("glEvalCoord2fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGenTextures(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGenTextures(arg0,arg1,arg2);
    String txt = new String("glGenTextures(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glClientAttribDefaultEXT(int arg0)
  {
        checkContext();
downstreamGL4bc.glClientAttribDefaultEXT(arg0);
    String txt = new String("glClientAttribDefaultEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexArrayRangeNV(int arg0,java.nio.Buffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexArrayRangeNV(arg0,arg1);
    String txt = new String("glVertexArrayRangeNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawElementsInstancedBaseInstance(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glDrawElementsInstancedBaseInstance(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glDrawElementsInstancedBaseInstance(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glConvolutionFilter1D(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
        checkContext();
downstreamGL4bc.glConvolutionFilter1D(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glConvolutionFilter1D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<long> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureRangeAPPLE(int arg0,int arg1,java.nio.Buffer arg2)
  {
        checkContext();
downstreamGL4bc.glTextureRangeAPPLE(arg0,arg1,arg2);
    String txt = new String("glTextureRangeAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  int glGetUniformBufferSizeEXT(int arg0,int arg1)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetUniformBufferSizeEXT(arg0,arg1);
    String txt = new String("glGetUniformBufferSizeEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glNormalFormatNV(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glNormalFormatNV(arg0,arg1);
    String txt = new String("glNormalFormatNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glLighti(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glLighti(arg0,arg1,arg2);
    String txt = new String("glLighti(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix4x3dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix4x3dv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix4x3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord4iv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4iv(arg0,arg1);
    String txt = new String("glMultiTexCoord4iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawBuffersATI(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDrawBuffersATI(arg0,arg1,arg2);
    String txt = new String("glDrawBuffersATI(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos3iv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos3iv(arg0,arg1);
    String txt = new String("glRasterPos3iv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor3dv(arg0);
    String txt = new String("glColor3dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedStringARB(int arg0,int arg1,java.lang.String arg2,int arg3,java.lang.String arg4)
  {
        checkContext();
downstreamGL4bc.glNamedStringARB(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glNamedStringARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.lang.String> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.lang.String> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexArrayPointeri_vEXT(int arg0,int arg1,int arg2,com.jogamp.common.nio.PointerBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexArrayPointeri_vEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexArrayPointeri_vEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<com.jogamp.common.nio.PointerBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glPathStencilFuncNV(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glPathStencilFuncNV(arg0,arg1,arg2);
    String txt = new String("glPathStencilFuncNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexStorage2DMultisample(int arg0,int arg1,int arg2,int arg3,int arg4,boolean arg5)
  {
        checkContext();
downstreamGL4bc.glTexStorage2DMultisample(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glTexStorage2DMultisample(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<boolean> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetProgramivARB(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexLevelParameterfv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetTexLevelParameterfv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetTexLevelParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3d(double arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glTexCoord3d(arg0,arg1,arg2);
    String txt = new String("glTexCoord3d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  int glGetGraphicsResetStatus()
  {
        checkContext();
    int _res = downstreamGL4bc.glGetGraphicsResetStatus();
    String txt = new String("glGetGraphicsResetStatus(" +
    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glStencilMaskSeparate(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glStencilMaskSeparate(arg0,arg1);
    String txt = new String("glStencilMaskSeparate(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexEnvivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glMultiTexEnvivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glMultiTexEnvivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4iv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform4iv(arg0,arg1,arg2);
    String txt = new String("glUniform4iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathTexGenivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetPathTexGenivNV(arg0,arg1,arg2);
    String txt = new String("glGetPathTexGenivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3f(int arg0,float arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3f(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexCoord3f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glStencilFunc(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glStencilFunc(arg0,arg1,arg2);
    String txt = new String("glStencilFunc(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4uiv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glColor4uiv(arg0);
    String txt = new String("glColor4uiv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexParameterIuivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexParameterIuivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexParameterIuivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glPathStringNV(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glPathStringNV(arg0,arg1,arg2,arg3);
    String txt = new String("glPathStringNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex4sv(arg0,arg1);
    String txt = new String("glVertex4sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3f(int arg0,float arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3f(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttrib3f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexdv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glIndexdv(arg0);
    String txt = new String("glIndexdv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glTexParameteriv(arg0,arg1,arg2);
    String txt = new String("glTexParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glWeightubvARB(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glWeightubvARB(arg0,arg1,arg2);
    String txt = new String("glWeightubvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord3hv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord3hv(arg0,arg1);
    String txt = new String("glTexCoord3hv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2iv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex2iv(arg0,arg1);
    String txt = new String("glVertex2iv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSampleMaskIndexedNV(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glSampleMaskIndexedNV(arg0,arg1);
    String txt = new String("glSampleMaskIndexedNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTransformFeedbackVarying(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4,java.nio.IntBuffer arg5,java.nio.ByteBuffer arg6)
  {
        checkContext();
downstreamGL4bc.glGetTransformFeedbackVarying(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetTransformFeedbackVarying(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ", " +
    "<java.nio.IntBuffer> "+arg5 +    ", " +
    "<java.nio.ByteBuffer> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1fv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform1fv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform1fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixMultTransposedEXT(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMatrixMultTransposedEXT(arg0,arg1,arg2);
    String txt = new String("glMatrixMultTransposedEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexArrayIntegeri_vEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexArrayIntegeri_vEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexArrayIntegeri_vEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glWriteMaskEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glWriteMaskEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glWriteMaskEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTranslatef(float arg0,float arg1,float arg2)
  {
        checkContext();
downstreamGL4bc.glTranslatef(arg0,arg1,arg2);
    String txt = new String("glTranslatef(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex3hv(java.nio.ShortBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex3hv(arg0);
    String txt = new String("glVertex3hv(" +
    "<java.nio.ShortBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedFramebufferRenderbufferEXT(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glNamedFramebufferRenderbufferEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glNamedFramebufferRenderbufferEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glWeightbvARB(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glWeightbvARB(arg0,arg1);
    String txt = new String("glWeightbvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantuivEXT(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVariantuivEXT(arg0,arg1,arg2);
    String txt = new String("glVariantuivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexArrayVertexAttribIFormatEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVertexArrayVertexAttribIFormatEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexArrayVertexAttribIFormatEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glWeightuivARB(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glWeightuivARB(arg0,arg1,arg2);
    String txt = new String("glWeightuivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenRenderbuffers(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGenRenderbuffers(arg0,arg1,arg2);
    String txt = new String("glGenRenderbuffers(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glConvolutionParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glConvolutionParameteriv(arg0,arg1,arg2);
    String txt = new String("glConvolutionParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetUniformuiv(arg0,arg1,arg2);
    String txt = new String("glGetUniformuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsNamedStringARB(int arg0,java.lang.String arg1)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsNamedStringARB(arg0,arg1);
    String txt = new String("glIsNamedStringARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.lang.String> "+arg1 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glProgramUniformMatrix4x2fvEXT(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix4x2fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix4x2fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMapAttribParameterivNV(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetMapAttribParameterivNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMapAttribParameterivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNamedProgramLocalParametersI4uivEXT(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glNamedProgramLocalParametersI4uivEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glNamedProgramLocalParametersI4uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPathDashArrayNV(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glPathDashArrayNV(arg0,arg1,arg2,arg3);
    String txt = new String("glPathDashArrayNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord1hv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1hv(arg0,arg1);
    String txt = new String("glMultiTexCoord1hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProvokingVertex(int arg0)
  {
        checkContext();
downstreamGL4bc.glProvokingVertex(arg0);
    String txt = new String("glProvokingVertex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramLocalParameterIivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetProgramLocalParameterIivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramLocalParameterIivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVideoCaptureStreamParameterivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glVideoCaptureStreamParameterivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glVideoCaptureStreamParameterivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetConvolutionParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetConvolutionParameterfv(arg0,arg1,arg2);
    String txt = new String("glGetConvolutionParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexParameterIiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glTexParameterIiv(arg0,arg1,arg2);
    String txt = new String("glTexParameterIiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  int glGetProgramResourceIndex(int arg0,int arg1,byte[] arg2,int arg3)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetProgramResourceIndex(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramResourceIndex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  long glGetBufferSize(int arg0)
  {
        checkContext();
    long _res = downstreamGL4bc.glGetBufferSize(arg0);
    String txt = new String("glGetBufferSize(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glColorTable(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
        checkContext();
downstreamGL4bc.glColorTable(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glColorTable(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<long> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawElementsInstancedBaseVertex(int arg0,int arg1,int arg2,long arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glDrawElementsInstancedBaseVertex(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glDrawElementsInstancedBaseVertex(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexParameterfEXT(int arg0,int arg1,int arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glMultiTexParameterfEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glMultiTexParameterfEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexP2ui(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertexP2ui(arg0,arg1);
    String txt = new String("glVertexP2ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBindImageTexture(int arg0,int arg1,int arg2,boolean arg3,int arg4,int arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glBindImageTexture(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glBindImageTexture(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexImage(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetTexImage(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetTexImage(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPerfMonitorCounterInfoAMD(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetPerfMonitorCounterInfoAMD(arg0,arg1,arg2,arg3);
    String txt = new String("glGetPerfMonitorCounterInfoAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord1d(int arg0,double arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1d(arg0,arg1);
    String txt = new String("glMultiTexCoord1d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1d(double arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord1d(arg0);
    String txt = new String("glTexCoord1d(" +
    "<double> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetShaderiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetShaderiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetShaderiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMinmaxParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetMinmaxParameterfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetMinmaxParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3dv(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glClearIndex(float arg0)
  {
        checkContext();
downstreamGL4bc.glClearIndex(arg0);
    String txt = new String("glClearIndex(" +
    "<float> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glPointAlongPathNV(int arg0,int arg1,int arg2,float arg3,float[] arg4,int arg5,float[] arg6,int arg7,float[] arg8,int arg9,float[] arg10,int arg11)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glPointAlongPathNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    String txt = new String("glPointAlongPathNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<float> "+arg3 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg11).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  boolean glPointAlongPathNV(int arg0,int arg1,int arg2,float arg3,java.nio.FloatBuffer arg4,java.nio.FloatBuffer arg5,java.nio.FloatBuffer arg6,java.nio.FloatBuffer arg7)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glPointAlongPathNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glPointAlongPathNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<float> "+arg3 +    ", " +
    "<java.nio.FloatBuffer> "+arg4 +    ", " +
    "<java.nio.FloatBuffer> "+arg5 +    ", " +
    "<java.nio.FloatBuffer> "+arg6 +    ", " +
    "<java.nio.FloatBuffer> "+arg7 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glVertex2i(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertex2i(arg0,arg1);
    String txt = new String("glVertex2i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexArrayIntegervEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVertexArrayIntegervEXT(arg0,arg1,arg2);
    String txt = new String("glGetVertexArrayIntegervEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2s(short arg0,short arg1)
  {
        checkContext();
downstreamGL4bc.glVertex2s(arg0,arg1);
    String txt = new String("glVertex2s(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4iv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4iv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform4iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultMatrixf(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glMultMatrixf(arg0);
    String txt = new String("glMultMatrixf(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3ivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform3ivARB(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform3ivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4Nubv(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4Nubv(arg0,arg1);
    String txt = new String("glVertexAttrib4Nubv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glBlendFuncIndexedAMD(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glBlendFuncIndexedAMD(arg0,arg1,arg2);
    String txt = new String("glBlendFuncIndexedAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPixelMapusv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glGetPixelMapusv(arg0,arg1,arg2);
    String txt = new String("glGetPixelMapusv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetDoublei_v(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetDoublei_v(arg0,arg1,arg2,arg3);
    String txt = new String("glGetDoublei_v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBlendFunc(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glBlendFunc(arg0,arg1);
    String txt = new String("glBlendFunc(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1i64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1i64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform1i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3iARB(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform3iARB(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform3iARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColorP3uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glSecondaryColorP3uiv(arg0,arg1);
    String txt = new String("glSecondaryColorP3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVideoCaptureStreamParameterfvNV(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glVideoCaptureStreamParameterfvNV(arg0,arg1,arg2,arg3);
    String txt = new String("glVideoCaptureStreamParameterfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glDebugMessageEnableAMD(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,boolean arg4)
  {
        checkContext();
downstreamGL4bc.glDebugMessageEnableAMD(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glDebugMessageEnableAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<boolean> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glPopAttrib()
  {
        checkContext();
downstreamGL4bc.glPopAttrib();
    String txt = new String("glPopAttrib(" +
    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribDivisor(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribDivisor(arg0,arg1);
    String txt = new String("glVertexAttribDivisor(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI1uivEXT(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI1uivEXT(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI1uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL3dv(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL3dv(arg0,arg1);
    String txt = new String("glVertexAttribL3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureStorage3DMultisampleEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,boolean arg7)
  {
        checkContext();
downstreamGL4bc.glTextureStorage3DMultisampleEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glTextureStorage3DMultisampleEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<boolean> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsTexture(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsTexture(arg0);
    String txt = new String("glIsTexture(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glMultiTexCoord4dv(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord4dv(arg0,arg1);
    String txt = new String("glMultiTexCoord4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glBlendEquation(int arg0)
  {
        checkContext();
downstreamGL4bc.glBlendEquation(arg0);
    String txt = new String("glBlendEquation(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glStringMarkerGREMEDY(int arg0,java.nio.Buffer arg1)
  {
        checkContext();
downstreamGL4bc.glStringMarkerGREMEDY(arg0,arg1);
    String txt = new String("glStringMarkerGREMEDY(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4fvARB(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4fvARB(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMateriali(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMateriali(arg0,arg1,arg2);
    String txt = new String("glMateriali(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void setSwapInterval(int arg0)
  {
    downstreamGL4bc.setSwapInterval(arg0);
  }
  public  void glVertexAttrib4Nbv(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4Nbv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4Nbv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetLocalConstantBooleanvEXT(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetLocalConstantBooleanvEXT(arg0,arg1,arg2);
    String txt = new String("glGetLocalConstantBooleanvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord1sv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord1sv(arg0,arg1);
    String txt = new String("glMultiTexCoord1sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glFinishFenceNV(int arg0)
  {
        checkContext();
downstreamGL4bc.glFinishFenceNV(arg0);
    String txt = new String("glFinishFenceNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryObjectui64v(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetQueryObjectui64v(arg0,arg1,arg2);
    String txt = new String("glGetQueryObjectui64v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2d(double arg0,double arg1)
  {
        checkContext();
downstreamGL4bc.glVertex2d(arg0,arg1);
    String txt = new String("glVertex2d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor4fv(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor4fv(arg0,arg1);
    String txt = new String("glColor4fv(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2f(float arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glVertex2f(arg0,arg1);
    String txt = new String("glVertex2f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexiv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glIndexiv(arg0);
    String txt = new String("glIndexiv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathSpacingNV(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4,float arg5,float arg6,int arg7,java.nio.FloatBuffer arg8)
  {
        checkContext();
downstreamGL4bc.glGetPathSpacingNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glGetPathSpacingNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<float> "+arg5 +    ", " +
    "<float> "+arg6 +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix3x4fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix3x4fv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix3x4fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetFramebufferAttachmentParameteriv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetFramebufferAttachmentParameteriv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetFramebufferAttachmentParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2h(short arg0,short arg1)
  {
        checkContext();
downstreamGL4bc.glVertex2h(arg0,arg1);
    String txt = new String("glVertex2h(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParametersI4uivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParametersI4uivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramEnvParametersI4uivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glClearDepth(double arg0)
  {
        checkContext();
downstreamGL4bc.glClearDepth(arg0);
    String txt = new String("glClearDepth(" +
    "<double> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix3x2fvEXT(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix3x2fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix3x2fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glFlushMappedBufferRange(int arg0,long arg1,long arg2)
  {
        checkContext();
downstreamGL4bc.glFlushMappedBufferRange(arg0,arg1,arg2);
    String txt = new String("glFlushMappedBufferRange(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedFramebufferParameterivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetNamedFramebufferParameterivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetNamedFramebufferParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexWeighthv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glVertexWeighthv(arg0,arg1);
    String txt = new String("glVertexWeighthv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetObjectPtrLabel(java.nio.Buffer arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetObjectPtrLabel(arg0,arg1,arg2,arg3);
    String txt = new String("glGetObjectPtrLabel(" +
    "<java.nio.Buffer> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<java.nio.ByteBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4dARB(int arg0,double arg1,double arg2,double arg3,double arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4dARB(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttrib4dARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ", " +
    "<double> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4s(short arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glVertex4s(arg0,arg1,arg2,arg3);
    String txt = new String("glVertex4s(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glTessellationFactorAMD(float arg0)
  {
        checkContext();
downstreamGL4bc.glTessellationFactorAMD(arg0);
    String txt = new String("glTessellationFactorAMD(" +
    "<float> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedBufferParameterui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetNamedBufferParameterui64vNV(arg0,arg1,arg2);
    String txt = new String("glGetNamedBufferParameterui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPerfMonitorCounterStringAMD(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.ByteBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetPerfMonitorCounterStringAMD(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetPerfMonitorCounterStringAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.ByteBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI2ui(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI2ui(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI2ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTextureLevelParameterivEXT(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetTextureLevelParameterivEXT(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetTextureLevelParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4i64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform4i64vNV(arg0,arg1,arg2);
    String txt = new String("glUniform4i64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glFogCoordPointer(int arg0,int arg1,java.nio.Buffer arg2)
  {
        checkContext();
downstreamGL4bc.glFogCoordPointer(arg0,arg1,arg2);
    String txt = new String("glFogCoordPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glFogf(int arg0,float arg1)
  {
        checkContext();
downstreamGL4bc.glFogf(arg0,arg1);
    String txt = new String("glFogf(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetOcclusionQueryuivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetOcclusionQueryuivNV(arg0,arg1,arg2);
    String txt = new String("glGetOcclusionQueryuivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInteger64i_v(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetInteger64i_v(arg0,arg1,arg2,arg3);
    String txt = new String("glGetInteger64i_v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTransformFeedbackVaryings(int arg0,int arg1,java.lang.String[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glTransformFeedbackVaryings(arg0,arg1,arg2,arg3);
    String txt = new String("glTransformFeedbackVaryings(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[Ljava.lang.String;>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTextureParameterIivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetTextureParameterIivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetTextureParameterIivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glCopyImageSubDataNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,int arg10,int arg11,int arg12,int arg13,int arg14)
  {
        checkContext();
downstreamGL4bc.glCopyImageSubDataNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
    String txt = new String("glCopyImageSubDataNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg10).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg11).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg12).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg13).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg14).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformSubroutineuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetUniformSubroutineuiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetUniformSubroutineuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
        checkContext();
downstreamGL4bc.glTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glTexImage2D(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glBlendEquationi(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glBlendEquationi(arg0,arg1);
    String txt = new String("glBlendEquationi(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParameterI4ivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParameterI4ivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramEnvParameterI4ivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRectiv(int[] arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glRectiv(arg0,arg1,arg2,arg3);
    String txt = new String("glRectiv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRectiv(java.nio.IntBuffer arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glRectiv(arg0,arg1);
    String txt = new String("glRectiv(" +
    "<java.nio.IntBuffer> "+arg0 +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4ivARB(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4ivARB(arg0,arg1);
    String txt = new String("glVertexAttrib4ivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribIiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribIiv(arg0,arg1,arg2);
    String txt = new String("glGetVertexAttribIiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glPathSubCommandsNV(int arg0,int arg1,int arg2,int arg3,byte[] arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
        checkContext();
downstreamGL4bc.glPathSubCommandsNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    String txt = new String("glPathSubCommandsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg8 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4dv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform4dv(arg0,arg1,arg2);
    String txt = new String("glUniform4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4h(short arg0,short arg1,short arg2,short arg3)
  {
        checkContext();
downstreamGL4bc.glVertex4h(arg0,arg1,arg2,arg3);
    String txt = new String("glVertex4h(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ", " +
    "<short> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4i(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glVertex4i(arg0,arg1,arg2,arg3);
    String txt = new String("glVertex4i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramBufferParametersfvNV(int arg0,int arg1,int arg2,int arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramBufferParametersfvNV(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramBufferParametersfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4d(double arg0,double arg1,double arg2,double arg3)
  {
        checkContext();
downstreamGL4bc.glVertex4d(arg0,arg1,arg2,arg3);
    String txt = new String("glVertex4d(" +
    "<double> "+arg0 +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<double> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4f(float arg0,float arg1,float arg2,float arg3)
  {
        checkContext();
downstreamGL4bc.glVertex4f(arg0,arg1,arg2,arg3);
    String txt = new String("glVertex4f(" +
    "<float> "+arg0 +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribs2hv(int arg0,int arg1,java.nio.ShortBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribs2hv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribs2hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColorPointer(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glSecondaryColorPointer(arg0,arg1,arg2,arg3);
    String txt = new String("glSecondaryColorPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureStorage2DMultisampleEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,boolean arg6)
  {
        checkContext();
downstreamGL4bc.glTextureStorage2DMultisampleEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glTextureStorage2DMultisampleEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<boolean> "+arg6 +    ")");
    checkGLGetError( txt );
  }
  public  void glEnable(int arg0)
  {
        checkContext();
downstreamGL4bc.glEnable(arg0);
    String txt = new String("glEnable(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  boolean glIsList(int arg0)
  {
        checkContext();
    boolean _res = downstreamGL4bc.glIsList(arg0);
    String txt = new String("glIsList(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glGetProgramiv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetProgramiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteShader(int arg0)
  {
        checkContext();
downstreamGL4bc.glDeleteShader(arg0);
    String txt = new String("glDeleteShader(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetBooleanIndexedv(int arg0,int arg1,byte[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetBooleanIndexedv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetBooleanIndexedv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2ivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform2ivARB(arg0,arg1,arg2);
    String txt = new String("glUniform2ivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glDisableVertexAttribAPPLE(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glDisableVertexAttribAPPLE(arg0,arg1);
    String txt = new String("glDisableVertexAttribAPPLE(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawTextureNV(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5,float arg6,float arg7,float arg8,float arg9,float arg10)
  {
        checkContext();
downstreamGL4bc.glDrawTextureNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glDrawTextureNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ", " +
    "<float> "+arg5 +    ", " +
    "<float> "+arg6 +    ", " +
    "<float> "+arg7 +    ", " +
    "<float> "+arg8 +    ", " +
    "<float> "+arg9 +    ", " +
    "<float> "+arg10 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramLocalParameterI4iNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramLocalParameterI4iNV(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramLocalParameterI4iNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL2d(int arg0,double arg1,double arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL2d(arg0,arg1,arg2);
    String txt = new String("glVertexAttribL2d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInteger64v(int arg0,java.nio.LongBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGetInteger64v(arg0,arg1);
    String txt = new String("glGetInteger64v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  int glGetDebugMessageLog(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4,java.nio.IntBuffer arg5,java.nio.IntBuffer arg6,java.nio.ByteBuffer arg7)
  {
        checkContext();
    int _res = downstreamGL4bc.glGetDebugMessageLog(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glGetDebugMessageLog(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ", " +
    "<java.nio.IntBuffer> "+arg5 +    ", " +
    "<java.nio.IntBuffer> "+arg6 +    ", " +
    "<java.nio.ByteBuffer> "+arg7 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glTexCoord1bvOES(byte[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glTexCoord1bvOES(arg0,arg1);
    String txt = new String("glTexCoord1bvOES(" +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedStringARB(int arg0,java.lang.String arg1,int arg2,java.nio.IntBuffer arg3,java.nio.ByteBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetNamedStringARB(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetNamedStringARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.lang.String> "+arg1 +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.ByteBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4bvEXT(int arg0,java.nio.ByteBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4bvEXT(arg0,arg1);
    String txt = new String("glVertexAttribI4bvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramBufferParametersIuivNV(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramBufferParametersIuivNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramBufferParametersIuivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glDisableVariantClientStateEXT(int arg0)
  {
        checkContext();
downstreamGL4bc.glDisableVariantClientStateEXT(arg0);
    String txt = new String("glDisableVariantClientStateEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL4dv(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL4dv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribL4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformBufferEXT(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glUniformBufferEXT(arg0,arg1,arg2);
    String txt = new String("glUniformBufferEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord3dv(int arg0,double[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord3dv(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoord3dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix4x2fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix4x2fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix4x2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glPathParameterfvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glPathParameterfvNV(arg0,arg1,arg2);
    String txt = new String("glPathParameterfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveUniformBlockiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetActiveUniformBlockiv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetActiveUniformBlockiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos3i(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glWindowPos3i(arg0,arg1,arg2);
    String txt = new String("glWindowPos3i(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawTransformFeedbackStream(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDrawTransformFeedbackStream(arg0,arg1,arg2);
    String txt = new String("glDrawTransformFeedbackStream(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexWeightPointerEXT(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glVertexWeightPointerEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexWeightPointerEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glConvolutionParameteri(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glConvolutionParameteri(arg0,arg1,arg2);
    String txt = new String("glConvolutionParameteri(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteQueries(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glDeleteQueries(arg0,arg1,arg2);
    String txt = new String("glDeleteQueries(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPixelMapusv(int arg0,long arg1)
  {
        checkContext();
downstreamGL4bc.glGetPixelMapusv(arg0,arg1);
    String txt = new String("glGetPixelMapusv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glPathFogGenNV(int arg0)
  {
        checkContext();
downstreamGL4bc.glPathFogGenNV(arg0);
    String txt = new String("glPathFogGenNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4hv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4hv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2x4fvEXT(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2x4fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramUniformMatrix2x4fvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetIntegeri_v(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetIntegeri_v(arg0,arg1,arg2);
    String txt = new String("glGetIntegeri_v(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glReadBuffer(int arg0)
  {
        checkContext();
downstreamGL4bc.glReadBuffer(arg0);
    String txt = new String("glReadBuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramEnvParametersI4ivNV(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramEnvParametersI4ivNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramEnvParametersI4ivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glLoadMatrixd(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glLoadMatrixd(arg0);
    String txt = new String("glLoadMatrixd(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glIndexsv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glIndexsv(arg0,arg1);
    String txt = new String("glIndexsv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1dv(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform1dv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform1dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawElements(int arg0,int arg1,int arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glDrawElements(arg0,arg1,arg2,arg3);
    String txt = new String("glDrawElements(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform4uivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform4uivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform4uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4Nusv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4Nusv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4Nusv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetSynciv(long arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetSynciv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetSynciv(" +
    "<long> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetSynciv(long arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6)
  {
        checkContext();
downstreamGL4bc.glGetSynciv(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    String txt = new String("glGetSynciv(" +
    "<long> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoord2fv(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoord2fv(arg0,arg1);
    String txt = new String("glMultiTexCoord2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetBufferParameterui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetBufferParameterui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetBufferParameterui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribLui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribLui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexAttribLui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform2iv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform2iv(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform2iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1iv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1iv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform1iv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glBeginVideoCaptureNV(int arg0)
  {
        checkContext();
downstreamGL4bc.glBeginVideoCaptureNV(arg0);
    String txt = new String("glBeginVideoCaptureNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGenerateTextureMipmapEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glGenerateTextureMipmapEXT(arg0,arg1);
    String txt = new String("glGenerateTextureMipmapEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glStencilStrokePathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,int arg6,java.nio.FloatBuffer arg7)
  {
        checkContext();
downstreamGL4bc.glStencilStrokePathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glStencilStrokePathInstancedNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor3sv(arg0,arg1);
    String txt = new String("glColor3sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetActiveSubroutineUniformName(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5,byte[] arg6,int arg7)
  {
        checkContext();
downstreamGL4bc.glGetActiveSubroutineUniformName(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glGetActiveSubroutineUniformName(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex4dv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex4dv(arg0);
    String txt = new String("glVertex4dv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetShaderInfoLog(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetShaderInfoLog(arg0,arg1,arg2,arg3);
    String txt = new String("glGetShaderInfoLog(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<java.nio.ByteBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  boolean isTextureFormatBGRA8888Available()
  {
        return downstreamGL4bc.isTextureFormatBGRA8888Available();
  }
  public  void glProgramBufferParametersIivNV(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glProgramBufferParametersIivNV(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glProgramBufferParametersIivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix2x3fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix2x3fv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix2x3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPerfMonitorCountersAMD(int arg0,java.nio.IntBuffer arg1,java.nio.IntBuffer arg2,int arg3,java.nio.IntBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glGetPerfMonitorCountersAMD(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetPerfMonitorCountersAMD(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glPushDebugGroup(int arg0,int arg1,int arg2,byte[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glPushDebugGroup(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glPushDebugGroup(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glCurrentPaletteMatrix(int arg0)
  {
        checkContext();
downstreamGL4bc.glCurrentPaletteMatrix(arg0);
    String txt = new String("glCurrentPaletteMatrix(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantsvEXT(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVariantsvEXT(arg0,arg1);
    String txt = new String("glVariantsvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3hv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib3hv(arg0,arg1);
    String txt = new String("glVertexAttrib3hv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.ShortBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3fv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniform3fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI2uiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI2uiv(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI2uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramEnvParameterIuivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetProgramEnvParameterIuivNV(arg0,arg1,arg2,arg3);
    String txt = new String("glGetProgramEnvParameterIuivNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMatrixLoadTransposefEXT(int arg0,float[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMatrixLoadTransposefEXT(arg0,arg1,arg2);
    String txt = new String("glMatrixLoadTransposefEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexParameterIuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetTexParameterIuiv(arg0,arg1,arg2);
    String txt = new String("glGetTexParameterIuiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glEdgeFlag(boolean arg0)
  {
        checkContext();
downstreamGL4bc.glEdgeFlag(arg0);
    String txt = new String("glEdgeFlag(" +
    "<boolean> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetPathCoordsNV(int arg0,java.nio.FloatBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGetPathCoordsNV(arg0,arg1);
    String txt = new String("glGetPathCoordsNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetTexParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetTexParameteriv(arg0,arg1,arg2);
    String txt = new String("glGetTexParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform3i64NV(int arg0,long arg1,long arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glUniform3i64NV(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform3i64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetConvolutionParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetConvolutionParameteriv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetConvolutionParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVariantBooleanvEXT(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetVariantBooleanvEXT(arg0,arg1,arg2);
    String txt = new String("glGetVariantBooleanvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform2fv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniform2fv(arg0,arg1,arg2);
    String txt = new String("glUniform2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetBooleanIndexedv(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetBooleanIndexedv(arg0,arg1,arg2);
    String txt = new String("glGetBooleanIndexedv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glUniformui64vNV(arg0,arg1,arg2);
    String txt = new String("glUniformui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawRangeElements(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
        checkContext();
downstreamGL4bc.glDrawRangeElements(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glDrawRangeElements(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramLocalParameterfvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetProgramLocalParameterfvARB(arg0,arg1,arg2);
    String txt = new String("glGetProgramLocalParameterfvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glFogiv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glFogiv(arg0,arg1,arg2);
    String txt = new String("glFogiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord1bvOES(java.nio.ByteBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord1bvOES(arg0);
    String txt = new String("glTexCoord1bvOES(" +
    "<java.nio.ByteBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetCompressedMultiTexImageEXT(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetCompressedMultiTexImageEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetCompressedMultiTexImageEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL3i64NV(int arg0,long arg1,long arg2,long arg3)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL3i64NV(arg0,arg1,arg2,arg3);
    String txt = new String("glVertexAttribL3i64NV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<long> "+arg1 +    ", " +
    "<long> "+arg2 +    ", " +
    "<long> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos2iv(int[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glWindowPos2iv(arg0,arg1);
    String txt = new String("glWindowPos2iv(" +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform4ui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform4ui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform4ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3hv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor3hv(arg0,arg1);
    String txt = new String("glColor3hv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glNormalP3uiv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glNormalP3uiv(arg0,arg1);
    String txt = new String("glNormalP3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertex2fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glVertex2fv(arg0);
    String txt = new String("glVertex2fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetHistogramParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetHistogramParameterfv(arg0,arg1,arg2);
    String txt = new String("glGetHistogramParameterfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glViewportIndexedf(int arg0,float arg1,float arg2,float arg3,float arg4)
  {
        checkContext();
downstreamGL4bc.glViewportIndexedf(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glViewportIndexedf(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<float> "+arg3 +    ", " +
    "<float> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4bvEXT(int arg0,byte[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4bvEXT(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI4bvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glSecondaryColor3b(byte arg0,byte arg1,byte arg2)
  {
        checkContext();
downstreamGL4bc.glSecondaryColor3b(arg0,arg1,arg2);
    String txt = new String("glSecondaryColor3b(" +
    "<byte> "+arg0 +    ", " +
    "<byte> "+arg1 +    ", " +
    "<byte> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glTexGeniv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glTexGeniv(arg0,arg1,arg2);
    String txt = new String("glTexGeniv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glShaderOp1EXT(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glShaderOp1EXT(arg0,arg1,arg2);
    String txt = new String("glShaderOp1EXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform3uivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform3uivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform3uivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVertexAttribdv(int arg0,int arg1,double[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVertexAttribdv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVertexAttribdv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[D>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos3fv(java.nio.FloatBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glRasterPos3fv(arg0);
    String txt = new String("glRasterPos3fv(" +
    "<java.nio.FloatBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformui64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformui64vNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexCoordP4ui(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glMultiTexCoordP4ui(arg0,arg1,arg2);
    String txt = new String("glMultiTexCoordP4ui(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribLPointer(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribLPointer(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribLPointer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  long glVDPAURegisterVideoSurfaceNV(java.nio.Buffer arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
    long _res = downstreamGL4bc.glVDPAURegisterVideoSurfaceNV(arg0,arg1,arg2,arg3);
    String txt = new String("glVDPAURegisterVideoSurfaceNV(" +
    "<java.nio.Buffer> "+arg0 +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
    return _res;
  }
  public  void glDrawTransformFeedbackStreamInstanced(int arg0,int arg1,int arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glDrawTransformFeedbackStreamInstanced(arg0,arg1,arg2,arg3);
    String txt = new String("glDrawTransformFeedbackStreamInstanced(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniform1ui64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glProgramUniform1ui64vNV(arg0,arg1,arg2,arg3);
    String txt = new String("glProgramUniform1ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glPathTexGenNV(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glPathTexGenNV(arg0,arg1,arg2,arg3);
    String txt = new String("glPathTexGenNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetIntegerv(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGetIntegerv(arg0,arg1);
    String txt = new String("glGetIntegerv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glPixelTransformParameterfvEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glPixelTransformParameterfvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glPixelTransformParameterfvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribP3uiv(int arg0,int arg1,boolean arg2,int[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glVertexAttribP3uiv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glVertexAttribP3uiv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawBuffer(int arg0)
  {
        checkContext();
downstreamGL4bc.glDrawBuffer(arg0);
    String txt = new String("glDrawBuffer(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDrawElementsInstanced(int arg0,int arg1,int arg2,long arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glDrawElementsInstanced(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glDrawElementsInstanced(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMapfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetMapfv(arg0,arg1,arg2);
    String txt = new String("glGetMapfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetIntegerIndexedv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetIntegerIndexedv(arg0,arg1,arg2);
    String txt = new String("glGetIntegerIndexedv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetMapAttribParameterfvNV(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glGetMapAttribParameterfvNV(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glGetMapAttribParameterfvNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDeleteTextures(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glDeleteTextures(arg0,arg1);
    String txt = new String("glDeleteTextures(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glTextureParameterIuivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glTextureParameterIuivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glTextureParameterIuivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glLightfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glLightfv(arg0,arg1,arg2,arg3);
    String txt = new String("glLightfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetBufferParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetBufferParameteriv(arg0,arg1,arg2);
    String txt = new String("glGetBufferParameteriv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glColor3usv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glColor3usv(arg0,arg1);
    String txt = new String("glColor3usv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glRasterPos4sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glRasterPos4sv(arg0,arg1);
    String txt = new String("glRasterPos4sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetLightfv(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetLightfv(arg0,arg1,arg2,arg3);
    String txt = new String("glGetLightfv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribI4svEXT(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribI4svEXT(arg0,arg1,arg2);
    String txt = new String("glVertexAttribI4svEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttribL1ui64vNV(int arg0,long[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttribL1ui64vNV(arg0,arg1,arg2);
    String txt = new String("glVertexAttribL1ui64vNV(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[J>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVariantivEXT(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVariantivEXT(arg0,arg1,arg2);
    String txt = new String("glVariantivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix2fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix2fv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glUniformMatrix2fv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetCompressedTexImage(int arg0,int arg1,java.nio.Buffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetCompressedTexImage(arg0,arg1,arg2);
    String txt = new String("glGetCompressedTexImage(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexSubImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
        checkContext();
downstreamGL4bc.glMultiTexSubImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    String txt = new String("glMultiTexSubImage1DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg7 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetAttachedShaders(int arg0,int arg1,int[] arg2,int arg3,int[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetAttachedShaders(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetAttachedShaders(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetAttachedShaders(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.IntBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetAttachedShaders(arg0,arg1,arg2,arg3);
    String txt = new String("glGetAttachedShaders(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<java.nio.IntBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4sv(int arg0,short[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4sv(arg0,arg1,arg2);
    String txt = new String("glVertexAttrib4sv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetUniformivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetUniformivARB(arg0,arg1,arg2);
    String txt = new String("glGetUniformivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetInfoLogARB(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glGetInfoLogARB(arg0,arg1,arg2,arg3);
    String txt = new String("glGetInfoLogARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ", " +
    "<java.nio.ByteBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glEvalMesh2(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
        checkContext();
downstreamGL4bc.glEvalMesh2(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glEvalMesh2(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetSeparableFilter(int arg0,int arg1,int arg2,long arg3,long arg4,long arg5)
  {
        checkContext();
downstreamGL4bc.glGetSeparableFilter(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetSeparableFilter(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<long> "+arg3 +    ", " +
    "<long> "+arg4 +    ", " +
    "<long> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetQueryObjecti64vEXT(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetQueryObjecti64vEXT(arg0,arg1,arg2);
    String txt = new String("glGetQueryObjecti64vEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.LongBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos3s(short arg0,short arg1,short arg2)
  {
        checkContext();
downstreamGL4bc.glWindowPos3s(arg0,arg1,arg2);
    String txt = new String("glWindowPos3s(" +
    "<short> "+arg0 +    ", " +
    "<short> "+arg1 +    ", " +
    "<short> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glProgramUniformMatrix2x4dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
        checkContext();
downstreamGL4bc.glProgramUniformMatrix2x4dv(arg0,arg1,arg2,arg3,arg4);
    String txt = new String("glProgramUniformMatrix2x4dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<boolean> "+arg3 +    ", " +
    "<java.nio.DoubleBuffer> "+arg4 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetNamedBufferParameterivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetNamedBufferParameterivEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetNamedBufferParameterivEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glEvalMesh1(int arg0,int arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glEvalMesh1(arg0,arg1,arg2);
    String txt = new String("glEvalMesh1(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetProgramPipelineInfoLog(int arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
        checkContext();
downstreamGL4bc.glGetProgramPipelineInfoLog(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glGetProgramPipelineInfoLog(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glScissorArrayv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glScissorArrayv(arg0,arg1,arg2);
    String txt = new String("glScissorArrayv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glGenVertexArrays(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glGenVertexArrays(arg0,arg1);
    String txt = new String("glGenVertexArrays(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glFogCoorddv(java.nio.DoubleBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glFogCoorddv(arg0);
    String txt = new String("glFogCoorddv(" +
    "<java.nio.DoubleBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMapGrid2d(int arg0,double arg1,double arg2,int arg3,double arg4,double arg5)
  {
        checkContext();
downstreamGL4bc.glMapGrid2d(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glMapGrid2d(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<double> "+arg1 +    ", " +
    "<double> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<double> "+arg4 +    ", " +
    "<double> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultiTexImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,java.nio.Buffer arg10)
  {
        checkContext();
downstreamGL4bc.glMultiTexImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    String txt = new String("glMultiTexImage3DEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg4).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg5).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg6).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg7).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg8).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg9).toUpperCase() +    ", " +
    "<java.nio.Buffer> "+arg10 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniform1fvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glUniform1fvARB(arg0,arg1,arg2,arg3);
    String txt = new String("glUniform1fvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glLightModeliv(int arg0,int[] arg1,int arg2)
  {
        checkContext();
downstreamGL4bc.glLightModeliv(arg0,arg1,arg2);
    String txt = new String("glLightModeliv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<[I>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glTexCoord4iv(java.nio.IntBuffer arg0)
  {
        checkContext();
downstreamGL4bc.glTexCoord4iv(arg0);
    String txt = new String("glTexCoord4iv(" +
    "<java.nio.IntBuffer> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glMapGrid2f(int arg0,float arg1,float arg2,int arg3,float arg4,float arg5)
  {
        checkContext();
downstreamGL4bc.glMapGrid2f(arg0,arg1,arg2,arg3,arg4,arg5);
    String txt = new String("glMapGrid2f(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<float> "+arg1 +    ", " +
    "<float> "+arg2 +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ", " +
    "<float> "+arg4 +    ", " +
    "<float> "+arg5 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetFloati_vEXT(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
        checkContext();
downstreamGL4bc.glGetFloati_vEXT(arg0,arg1,arg2);
    String txt = new String("glGetFloati_vEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<java.nio.FloatBuffer> "+arg2 +    ")");
    checkGLGetError( txt );
  }
  public  void glPushDebugGroup(int arg0,int arg1,int arg2,java.nio.ByteBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glPushDebugGroup(arg0,arg1,arg2,arg3);
    String txt = new String("glPushDebugGroup(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg2).toUpperCase() +    ", " +
    "<java.nio.ByteBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVariantFloatvEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVariantFloatvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVariantFloatvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glGetVariantBooleanvEXT(int arg0,int arg1,byte[] arg2,int arg3)
  {
        checkContext();
downstreamGL4bc.glGetVariantBooleanvEXT(arg0,arg1,arg2,arg3);
    String txt = new String("glGetVariantBooleanvEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<[B>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg3).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glWindowPos3sv(short[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glWindowPos3sv(arg0,arg1);
    String txt = new String("glWindowPos3sv(" +
    "<[S>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib4NuivARB(int arg0,java.nio.IntBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib4NuivARB(arg0,arg1);
    String txt = new String("glVertexAttrib4NuivARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.IntBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glUniformMatrix3x2dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
        checkContext();
downstreamGL4bc.glUniformMatrix3x2dv(arg0,arg1,arg2,arg3);
    String txt = new String("glUniformMatrix3x2dv(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ", " +
    "<boolean> "+arg2 +    ", " +
    "<java.nio.DoubleBuffer> "+arg3 +    ")");
    checkGLGetError( txt );
  }
  public  void glMultTransposeMatrixf(float[] arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glMultTransposeMatrixf(arg0,arg1);
    String txt = new String("glMultTransposeMatrixf(" +
    "<[F>" +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glDisableClientStateiEXT(int arg0,int arg1)
  {
        checkContext();
downstreamGL4bc.glDisableClientStateiEXT(arg0,arg1);
    String txt = new String("glDisableClientStateiEXT(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<int> 0x"+Integer.toHexString(arg1).toUpperCase() +    ")");
    checkGLGetError( txt );
  }
  public  void glVDPAUUnregisterSurfaceNV(long arg0)
  {
        checkContext();
downstreamGL4bc.glVDPAUUnregisterSurfaceNV(arg0);
    String txt = new String("glVDPAUUnregisterSurfaceNV(" +
    "<long> "+arg0 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib1dvARB(int arg0,java.nio.DoubleBuffer arg1)
  {
        checkContext();
downstreamGL4bc.glVertexAttrib1dvARB(arg0,arg1);
    String txt = new String("glVertexAttrib1dvARB(" +
    "<int> 0x"+Integer.toHexString(arg0).toUpperCase() +    ", " +
    "<java.nio.DoubleBuffer> "+arg1 +    ")");
    checkGLGetError( txt );
  }
  public  void glVertexAttrib3sv(int arg0,java.nio.ShortBuffer arg1)
  {
        checkContext();
downstream