/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.IntBitfield;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.DoubleTapScrollGesture;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MonitorEvent;
import com.jogamp.newt.event.MonitorModeListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventConsumer;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.SurfaceUpdatedListener;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.Rectangle;
import javax.media.nativewindow.util.RectangleImmutable;
import jogamp.nativewindow.SurfaceUpdatedHelper;
import jogamp.newt.Debug;
import jogamp.newt.DisplayImpl;
import jogamp.newt.OffscreenWindow;
import jogamp.newt.ScreenImpl;

public abstract class WindowImpl
implements Window,
NEWTEventConsumer {
    public static final boolean DEBUG_TEST_REPARENT_INCOMPATIBLE;
    protected static final ArrayList<WeakReference<WindowImpl>> windowList;
    static final long QUEUED_EVENT_TO = 1200L;
    private static final MouseEvent.PointerType[] constMousePointerTypes;
    private volatile long windowHandle = 0L;
    private volatile boolean visible = false;
    private volatile boolean hasFocus = false;
    private volatile int width = 128;
    private volatile int height = 128;
    private volatile int x = 64;
    private volatile int y = 64;
    private volatile Insets insets = new Insets();
    private RecursiveLock windowLock = LockFactory.createRecursiveLock();
    private int surfaceLockCount = 0;
    private ScreenImpl screen;
    private boolean screenReferenceAdded = false;
    private NativeWindow parentWindow = null;
    private long parentWindowHandle = 0L;
    private AbstractGraphicsConfiguration config = null;
    protected CapabilitiesImmutable capsRequested = null;
    protected CapabilitiesChooser capabilitiesChooser = null;
    private boolean fullscreen = false;
    private boolean brokenFocusChange = false;
    private List<MonitorDevice> fullscreenMonitors = null;
    private boolean fullscreenUseMainMonitor = true;
    private boolean autoPosition = true;
    private int nfs_width;
    private int nfs_height;
    private int nfs_x;
    private int nfs_y;
    private NativeWindow nfs_parent = null;
    private String title = "Newt Window";
    private boolean undecorated = false;
    private boolean alwaysOnTop = false;
    private boolean pointerVisible = true;
    private boolean pointerConfined = false;
    private LifecycleHook lifecycleHook = null;
    private Runnable windowDestroyNotifyAction = null;
    private Window.FocusRunnable focusAction = null;
    private KeyListener keyboardFocusHandler = null;
    private SurfaceUpdatedHelper surfaceUpdatedHelper = new SurfaceUpdatedHelper();
    private Object childWindowsLock = new Object();
    private ArrayList<NativeWindow> childWindows = new ArrayList();
    private ArrayList<MouseListener> mouseListeners = new ArrayList();
    private PointerState0 pState0 = new PointerState0();
    private PointerState1 pState1 = new PointerState1();
    private final ArrayHashSet<Integer> pName2pID = new ArrayHashSet();
    private boolean defaultGestureHandlerEnabled = true;
    private DoubleTapScrollGesture gesture2PtrTouchScroll = null;
    private ArrayList<GestureHandler> pointerGestureHandler = new ArrayList();
    private ArrayList<GestureHandler.GestureListener> gestureListeners = new ArrayList();
    private ArrayList<KeyListener> keyListeners = new ArrayList();
    private ArrayList<WindowListener> windowListeners = new ArrayList();
    private boolean repaintQueued = false;
    private Object closingListenerLock = new Object();
    private WindowClosingProtocol.WindowClosingMode defaultCloseOperation = WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE;
    public static final int FLAG_CHANGE_PARENTING = 1;
    public static final int FLAG_CHANGE_DECORATION = 2;
    public static final int FLAG_CHANGE_FULLSCREEN = 4;
    public static final int FLAG_CHANGE_ALWAYSONTOP = 8;
    public static final int FLAG_CHANGE_VISIBILITY = 16;
    public static final int FLAG_HAS_PARENT = 256;
    public static final int FLAG_IS_UNDECORATED = 512;
    public static final int FLAG_IS_FULLSCREEN = 1024;
    public static final int FLAG_IS_FULLSCREEN_SPAN = 2048;
    public static final int FLAG_IS_ALWAYSONTOP = 4096;
    public static final int FLAG_IS_VISIBLE = 8192;
    private final DestroyAction destroyAction = new DestroyAction();
    private final ReparentActionRecreate reparentActionRecreate = new ReparentActionRecreate();
    private final Runnable requestFocusAction = new Runnable(){

        @Override
        public final void run() {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.RequestFocusAction: force 0 - (" + WindowImpl.getThreadName() + "): " + WindowImpl.this.hasFocus + " -> true - windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle));
            }
            WindowImpl.this.requestFocusImpl(false);
        }
    };
    private final Runnable requestFocusActionForced = new Runnable(){

        @Override
        public final void run() {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.RequestFocusAction: force 1 - (" + WindowImpl.getThreadName() + "): " + WindowImpl.this.hasFocus + " -> true - windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle));
            }
            WindowImpl.this.requestFocusImpl(true);
        }
    };
    private final FullScreenAction fullScreenAction = new FullScreenAction();
    private final MonitorModeListenerImpl monitorModeListenerImpl = new MonitorModeListenerImpl();
    private static final int keyTrackingRange = 255;
    private final IntBitfield keyPressedState = new IntBitfield(256);
    protected boolean keyboardVisible = false;

    public static final void shutdownAll() {
        int n = windowList.size();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.shutdownAll " + n + " instances, on thread " + WindowImpl.getThreadName());
        }
        for (int i = 0; i < n && windowList.size() > 0; ++i) {
            WindowImpl windowImpl = (WindowImpl)windowList.remove(0).get();
            if (DEBUG_IMPLEMENTATION) {
                long l = null != windowImpl ? windowImpl.getWindowHandle() : 0L;
                System.err.println("Window.shutdownAll[" + (i + 1) + "/" + n + "]: " + WindowImpl.toHexString(l) + ", GCed " + (null == windowImpl));
            }
            if (null == windowImpl) continue;
            windowImpl.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addWindow2List(WindowImpl windowImpl) {
        ArrayList<WeakReference<WindowImpl>> arrayList = windowList;
        synchronized (arrayList) {
            int n = 0;
            int n2 = 0;
            while (n < windowList.size()) {
                if (null == windowList.get(n).get()) {
                    ++n2;
                    windowList.remove(n);
                    continue;
                }
                ++n;
            }
            windowList.add(new WeakReference<WindowImpl>(windowImpl));
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.addWindow2List: GCed " + n2 + ", size " + windowList.size());
            }
        }
    }

    public static void init(String string) {
        if (NativeWindowFactory.TYPE_MACOSX.equals(string)) {
            try {
                WindowImpl.getWindowClass(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static Class<?> getWindowClass(String string) throws ClassNotFoundException {
        Class<?> clazz = NewtFactory.getCustomClass(string, "WindowDriver");
        if (null == clazz) {
            throw new ClassNotFoundException("Failed to find NEWT Window Class <" + string + ".WindowDriver>");
        }
        return clazz;
    }

    public static WindowImpl create(NativeWindow nativeWindow, long l, Screen screen, CapabilitiesImmutable capabilitiesImmutable) {
        try {
            Class clazz = capabilitiesImmutable.isOnscreen() ? WindowImpl.getWindowClass(screen.getDisplay().getType()) : OffscreenWindow.class;
            WindowImpl windowImpl = (WindowImpl)clazz.newInstance();
            windowImpl.parentWindow = nativeWindow;
            windowImpl.parentWindowHandle = l;
            windowImpl.screen = (ScreenImpl)screen;
            windowImpl.capsRequested = (CapabilitiesImmutable)capabilitiesImmutable.cloneMutable();
            windowImpl.instantiationFinished();
            WindowImpl.addWindow2List(windowImpl);
            return windowImpl;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new NativeWindowException(throwable);
        }
    }

    public static WindowImpl create(Object[] objectArray, Screen screen, CapabilitiesImmutable capabilitiesImmutable) {
        try {
            Class<?> clazz = WindowImpl.getWindowClass(screen.getDisplay().getType());
            Class[] classArray = WindowImpl.getCustomConstructorArgumentTypes(clazz);
            if (null == classArray) {
                throw new NativeWindowException("WindowClass " + clazz + " doesn't support custom arguments in constructor");
            }
            int n = WindowImpl.verifyConstructorArgumentTypes(classArray, objectArray);
            if (n < objectArray.length) {
                throw new NativeWindowException("WindowClass " + clazz + " constructor mismatch at argument #" + n + "; Constructor: " + WindowImpl.getTypeStrList(classArray) + ", arguments: " + WindowImpl.getArgsStrList(objectArray));
            }
            WindowImpl windowImpl = (WindowImpl)ReflectionUtil.createInstance(clazz, (Class[])classArray, (Object[])objectArray);
            windowImpl.screen = (ScreenImpl)screen;
            windowImpl.capsRequested = (CapabilitiesImmutable)capabilitiesImmutable.cloneMutable();
            windowImpl.instantiationFinished();
            WindowImpl.addWindow2List(windowImpl);
            return windowImpl;
        }
        catch (Throwable throwable) {
            throw new NativeWindowException(throwable);
        }
    }

    private final void shutdown() {
        if (null != this.lifecycleHook) {
            this.lifecycleHook.shutdownRenderingAction();
        }
        this.setWindowHandle(0L);
        this.visible = false;
        this.fullscreen = false;
        this.fullscreenMonitors = null;
        this.fullscreenUseMainMonitor = true;
        this.hasFocus = false;
        this.parentWindowHandle = 0L;
    }

    protected final void setGraphicsConfiguration(AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        this.config = abstractGraphicsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createNative() {
        long l;
        if (DEBUG_IMPLEMENTATION) {
            l = System.nanoTime();
            System.err.println("Window.createNative() START (" + WindowImpl.getThreadName() + ", " + this + ")");
        } else {
            l = 0L;
        }
        if (null != this.parentWindow && 1 >= this.parentWindow.lockSurface()) {
            throw new NativeWindowException("Parent surface lock: not ready: " + this.parentWindow);
        }
        if (null != this.parentWindow && (this.autoPosition || 0 > this.getX() || 0 > this.getY())) {
            this.definePosition(0, 0);
        }
        boolean bl = false;
        try {
            if (this.validateParentWindowHandle()) {
                if (!this.screenReferenceAdded) {
                    this.screen.addReference();
                    this.screenReferenceAdded = true;
                }
                if (this.canCreateNativeImpl()) {
                    boolean bl2;
                    int n;
                    int n2;
                    if (this.autoPosition) {
                        n2 = 0;
                        n = 0;
                        bl2 = false;
                    } else {
                        n2 = this.getX();
                        n = this.getY();
                        bl2 = true;
                    }
                    long l2 = System.currentTimeMillis();
                    this.createNativeImpl();
                    this.screen.addMonitorModeListener(this.monitorModeListenerImpl);
                    this.setTitleImpl(this.title);
                    this.setPointerVisibleImpl(this.pointerVisible);
                    this.confinePointerImpl(this.pointerConfined);
                    this.setKeyboardVisible(this.keyboardVisible);
                    long l3 = this.waitForVisible(true, false);
                    if (0L <= l3) {
                        if (this.isFullscreen()) {
                            FullScreenAction fullScreenAction = this.fullScreenAction;
                            synchronized (fullScreenAction) {
                                this.fullscreen = false;
                                this.fullScreenAction.init(true);
                                this.fullScreenAction.run();
                            }
                        } else {
                            this.waitForPosition(bl2, n2, n, 1000L);
                        }
                        if (DEBUG_IMPLEMENTATION) {
                            System.err.println("Window.createNative(): elapsed " + (System.currentTimeMillis() - l2) + " ms");
                        }
                        bl = true;
                    }
                }
            }
        }
        finally {
            if (null != this.parentWindow) {
                this.parentWindow.unlockSurface();
            }
        }
        if (bl) {
            this.requestFocusInt(this.isFullscreen());
            ((DisplayImpl)this.screen.getDisplay()).dispatchMessagesNative();
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.createNative() END (" + WindowImpl.getThreadName() + ", " + this + ") total " + (double)(System.nanoTime() - l) / 1000000.0 + "ms");
        }
        return this.isNativeValid();
    }

    private void removeScreenReference() {
        if (this.screenReferenceAdded) {
            this.screenReferenceAdded = false;
            this.screen.removeReference();
        }
    }

    private boolean validateParentWindowHandle() {
        if (null != this.parentWindow) {
            this.parentWindowHandle = WindowImpl.getNativeWindowHandle(this.parentWindow);
            return 0L != this.parentWindowHandle;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNativeWindowHandle(NativeWindow nativeWindow) {
        long l = 0L;
        if (null != nativeWindow) {
            boolean bl = false;
            if (1 < nativeWindow.lockSurface()) {
                bl = true;
                try {
                    l = nativeWindow.getWindowHandle();
                    if (0L == l) {
                        throw new NativeWindowException("Parent native window handle is NULL, after succesful locking: " + nativeWindow);
                    }
                }
                catch (NativeWindowException nativeWindowException) {
                    if (DEBUG_IMPLEMENTATION) {
                        System.err.println("Window.getNativeWindowHandle: not successful yet: " + nativeWindowException);
                    }
                }
                finally {
                    nativeWindow.unlockSurface();
                }
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.getNativeWindowHandle: locked " + bl + ", " + nativeWindow);
            }
        }
        return l;
    }

    protected int lockSurfaceImpl() {
        return 3;
    }

    protected void unlockSurfaceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        Object object = this.closingListenerLock;
        synchronized (object) {
            return this.defaultCloseOperation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        Object object = this.closingListenerLock;
        synchronized (object) {
            WindowClosingProtocol.WindowClosingMode windowClosingMode2 = this.defaultCloseOperation;
            this.defaultCloseOperation = windowClosingMode;
            return windowClosingMode2;
        }
    }

    protected void instantiationFinished() {
    }

    protected boolean canCreateNativeImpl() {
        return true;
    }

    protected abstract void createNativeImpl();

    protected abstract void closeNativeImpl();

    protected abstract void requestFocusImpl(boolean var1);

    protected abstract boolean reconfigureWindowImpl(int var1, int var2, int var3, int var4, int var5);

    protected boolean isReconfigureFlagSupported(int n) {
        return 0 == (n & 0x800);
    }

    protected int getReconfigureFlags(int n, boolean bl) {
        return n |= (0L != this.getParentWindowHandle() ? 256 : 0) | (this.isUndecorated() ? 512 : 0) | (this.isFullscreen() ? 1024 : 0) | (this.isAlwaysOnTop() ? 4096 : 0) | (bl ? 8192 : 0);
    }

    protected static String getReconfigureFlagsAsString(StringBuilder stringBuilder, int n) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("[");
        if (0 != (1 & n)) {
            stringBuilder.append("*");
        }
        stringBuilder.append("PARENT_");
        stringBuilder.append(0 != (0x100 & n));
        stringBuilder.append(", ");
        if (0 != (4 & n)) {
            stringBuilder.append("*");
        }
        stringBuilder.append("FS_");
        stringBuilder.append(0 != (0x400 & n));
        stringBuilder.append("_span_");
        stringBuilder.append(0 != (0x800 & n));
        stringBuilder.append(", ");
        if (0 != (2 & n)) {
            stringBuilder.append("*");
        }
        stringBuilder.append("UNDECOR_");
        stringBuilder.append(0 != (0x200 & n));
        stringBuilder.append(", ");
        if (0 != (8 & n)) {
            stringBuilder.append("*");
        }
        stringBuilder.append("ALWAYSONTOP_");
        stringBuilder.append(0 != (0x1000 & n));
        stringBuilder.append(", ");
        if (0 != (0x10 & n)) {
            stringBuilder.append("*");
        }
        stringBuilder.append("VISIBLE_");
        stringBuilder.append(0 != (0x2000 & n));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected void setTitleImpl(String string) {
    }

    protected abstract Point getLocationOnScreenImpl(int var1, int var2);

    protected abstract void updateInsetsImpl(Insets var1);

    protected boolean setPointerVisibleImpl(boolean bl) {
        return false;
    }

    protected boolean confinePointerImpl(boolean bl) {
        return false;
    }

    protected void warpPointerImpl(int n, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int lockSurface() throws NativeWindowException, RuntimeException {
        int n;
        block9: {
            RecursiveLock recursiveLock = this.windowLock;
            recursiveLock.lock();
            ++this.surfaceLockCount;
            int n2 = n = 1 == this.surfaceLockCount ? 1 : 3;
            if (1 == n) {
                try {
                    if (!this.isNativeValid()) break block9;
                    AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
                    abstractGraphicsDevice.lock();
                    try {
                        n = this.lockSurfaceImpl();
                    }
                    finally {
                        if (1 >= n) {
                            abstractGraphicsDevice.unlock();
                        }
                    }
                }
                finally {
                    if (1 >= n) {
                        --this.surfaceLockCount;
                        recursiveLock.unlock();
                    }
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlockSurface() {
        RecursiveLock recursiveLock = this.windowLock;
        recursiveLock.validateLocked();
        if (1 == this.surfaceLockCount) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
            try {
                this.unlockSurfaceImpl();
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
        --this.surfaceLockCount;
        recursiveLock.unlock();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.windowLock.isLockedByOtherThread();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.windowLock.getOwner();
    }

    public final RecursiveLock getLock() {
        return this.windowLock;
    }

    @Override
    public long getSurfaceHandle() {
        return this.windowHandle;
    }

    @Override
    public boolean surfaceSwap() {
        return false;
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config.getNativeGraphicsConfiguration();
    }

    @Override
    public final long getDisplayHandle() {
        return this.config.getNativeGraphicsConfiguration().getScreen().getDevice().getHandle();
    }

    @Override
    public final int getScreenIndex() {
        return this.screen.getIndex();
    }

    @Override
    public final NativeWindow getParent() {
        return this.parentWindow;
    }

    @Override
    public final long getWindowHandle() {
        return this.windowHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getLocationOnScreen(Point point) {
        if (this.isNativeValid()) {
            Point point2;
            RecursiveLock recursiveLock = this.windowLock;
            recursiveLock.lock();
            try {
                point2 = this.getLocationOnScreenImpl(0, 0);
            }
            finally {
                recursiveLock.unlock();
            }
            if (null != point2) {
                if (null != point) {
                    point.translate(point2.getX(), point2.getY());
                    return point;
                }
                return point2;
            }
        }
        if (null != point) {
            point.translate(this.getX(), this.getY());
        } else {
            point = new Point(this.getX(), this.getY());
        }
        if (null != this.parentWindow) {
            this.parentWindow.getLocationOnScreen(point);
        }
        return point;
    }

    @Override
    public final boolean isNativeValid() {
        return 0L != this.windowHandle;
    }

    @Override
    public final Screen getScreen() {
        return this.screen;
    }

    @Override
    public final MonitorDevice getMainMonitor() {
        return this.screen.getMainMonitor(new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight()));
    }

    protected final void setVisibleImpl(boolean bl, int n, int n2, int n3, int n4) {
        this.reconfigureWindowImpl(n, n2, n3, n4, this.getReconfigureFlags(16, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setVisibleActionImpl(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        RecursiveLock recursiveLock = this.windowLock;
        recursiveLock.lock();
        try {
            NativeWindow nativeWindow;
            int n;
            Object object;
            if (!bl && null != this.childWindows && this.childWindows.size() > 0) {
                object = this.childWindowsLock;
                synchronized (object) {
                    for (n = 0; n < this.childWindows.size(); ++n) {
                        nativeWindow = this.childWindows.get(n);
                        if (!(nativeWindow instanceof WindowImpl)) continue;
                        ((WindowImpl)nativeWindow).setVisible(false);
                    }
                }
            }
            if (!this.isNativeValid() && bl) {
                if (0 < this.getWidth() * this.getHeight()) {
                    bl3 = bl2 = this.createNative();
                }
                this.visible = true;
            } else if (this.visible != bl) {
                if (this.isNativeValid()) {
                    this.setVisibleImpl(bl, this.getX(), this.getY(), this.getWidth(), this.getHeight());
                    this.waitForVisible(bl, false);
                    bl3 = bl;
                } else {
                    this.visible = true;
                }
            }
            if (null != this.lifecycleHook) {
                this.lifecycleHook.setVisibleActionPost(bl, bl2);
            }
            if (this.isNativeValid() && bl && null != this.childWindows && this.childWindows.size() > 0) {
                object = this.childWindowsLock;
                synchronized (object) {
                    for (n = 0; n < this.childWindows.size(); ++n) {
                        nativeWindow = this.childWindows.get(n);
                        if (!(nativeWindow instanceof WindowImpl)) continue;
                        ((WindowImpl)nativeWindow).setVisible(true);
                    }
                }
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window setVisible: END (" + WindowImpl.getThreadName() + ") " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + ", fs " + this.fullscreen + ", windowHandle " + WindowImpl.toHexString(this.windowHandle) + ", visible: " + this.visible + ", nativeWindowCreated: " + bl2 + ", madeVisible: " + bl3);
            }
        }
        finally {
            if (null != this.lifecycleHook) {
                this.lifecycleHook.resetCounter();
            }
            recursiveLock.unlock();
        }
        if (bl2 || bl3) {
            this.sendWindowEvent(100);
        }
    }

    protected void setVisible(boolean bl, boolean bl2) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window setVisible: START (" + WindowImpl.getThreadName() + ") " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + ", fs " + this.fullscreen + ", windowHandle " + WindowImpl.toHexString(this.windowHandle) + ", visible: " + this.visible + " -> " + bl2 + ", parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle) + ", parentWindow " + (null != this.parentWindow));
        }
        this.runOnEDTIfAvail(bl, new VisibleAction(bl2));
    }

    @Override
    public void setVisible(boolean bl) {
        this.setVisible(true, bl);
    }

    private void setFullscreenSize(int n, int n2) {
        this.runOnEDTIfAvail(true, new SetSizeAction(n, n2, true));
    }

    @Override
    public void setSize(int n, int n2) {
        this.runOnEDTIfAvail(true, new SetSizeAction(n, n2, false));
    }

    @Override
    public void setTopLevelSize(int n, int n2) {
        this.setSize(n - this.getInsets().getTotalWidth(), n2 - this.getInsets().getTotalHeight());
    }

    @Override
    public void destroy() {
        this.visible = false;
        this.runOnEDTIfAvail(true, this.destroyAction);
    }

    protected void destroy(boolean bl) {
        if (null != this.lifecycleHook) {
            this.lifecycleHook.preserveGLStateAtDestroy(bl);
        }
        this.destroy();
    }

    protected static boolean isOffscreenInstance(NativeWindow nativeWindow, NativeWindow nativeWindow2) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration;
        boolean bl = false;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration2 = nativeWindow.getGraphicsConfiguration();
        if (null != abstractGraphicsConfiguration2) {
            boolean bl2 = bl = !abstractGraphicsConfiguration2.getChosenCapabilities().isOnscreen();
        }
        if (!bl && null != nativeWindow2 && null != (abstractGraphicsConfiguration = nativeWindow2.getGraphicsConfiguration())) {
            bl = !abstractGraphicsConfiguration.getChosenCapabilities().isOnscreen();
        }
        return bl;
    }

    @Override
    public final Window.ReparentOperation reparentWindow(NativeWindow nativeWindow) {
        return this.reparentWindow(nativeWindow, -1, -1, false);
    }

    @Override
    public Window.ReparentOperation reparentWindow(NativeWindow nativeWindow, int n, int n2, boolean bl) {
        ReparentAction reparentAction = new ReparentAction(nativeWindow, n, n2, bl);
        this.runOnEDTIfAvail(true, reparentAction);
        return reparentAction.getOp();
    }

    @Override
    public CapabilitiesChooser setCapabilitiesChooser(CapabilitiesChooser capabilitiesChooser) {
        CapabilitiesChooser capabilitiesChooser2 = this.capabilitiesChooser;
        this.capabilitiesChooser = capabilitiesChooser;
        return capabilitiesChooser2;
    }

    @Override
    public final CapabilitiesImmutable getChosenCapabilities() {
        return this.getGraphicsConfiguration().getChosenCapabilities();
    }

    @Override
    public final CapabilitiesImmutable getRequestedCapabilities() {
        return this.capsRequested;
    }

    @Override
    public void setUndecorated(boolean bl) {
        this.runOnEDTIfAvail(true, new DecorationAction(bl));
    }

    @Override
    public final boolean isUndecorated() {
        return 0L != this.parentWindowHandle || this.undecorated || this.fullscreen;
    }

    @Override
    public final void setAlwaysOnTop(boolean bl) {
        this.runOnEDTIfAvail(true, new AlwaysOnTopAction(bl));
    }

    @Override
    public final boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        this.title = string;
        if (0L != this.getWindowHandle()) {
            this.setTitleImpl(string);
        }
    }

    @Override
    public boolean isPointerVisible() {
        return this.pointerVisible;
    }

    @Override
    public void setPointerVisible(boolean bl) {
        if (this.pointerVisible != bl) {
            boolean bl2;
            boolean bl3 = bl2 = 0L == this.getWindowHandle();
            if (!bl2) {
                bl2 = this.setPointerVisibleImpl(bl);
            }
            if (bl2) {
                this.pointerVisible = bl;
            }
        }
    }

    @Override
    public boolean isPointerConfined() {
        return this.pointerConfined;
    }

    @Override
    public void confinePointer(boolean bl) {
        if (this.pointerConfined != bl) {
            boolean bl2;
            boolean bl3 = bl2 = 0L == this.getWindowHandle();
            if (!bl2) {
                if (bl) {
                    this.requestFocus();
                    this.warpPointer(this.getWidth() / 2, this.getHeight() / 2);
                }
                bl2 = this.confinePointerImpl(bl);
                if (bl) {
                    try {
                        Thread.sleep(3L * this.screen.getDisplay().getEDTUtil().getPollPeriod());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (bl2) {
                this.pointerConfined = bl;
            }
        }
    }

    @Override
    public void warpPointer(int n, int n2) {
        if (0L != this.getWindowHandle()) {
            this.warpPointerImpl(n, n2);
        }
    }

    @Override
    public final InsetsImmutable getInsets() {
        if (this.isUndecorated()) {
            return Insets.getZero();
        }
        this.updateInsetsImpl(this.insets);
        return this.insets;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final int getX() {
        return this.x;
    }

    @Override
    public final int getY() {
        return this.y;
    }

    protected final boolean autoPosition() {
        return this.autoPosition;
    }

    protected final void definePosition(int n, int n2) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("definePosition: " + this.x + "/" + this.y + " -> " + n + "/" + n2);
        }
        this.autoPosition = false;
        this.x = n;
        this.y = n2;
    }

    protected final void defineSize(int n, int n2) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("defineSize: " + this.width + "x" + this.height + " -> " + n + "x" + n2);
        }
        this.width = n;
        this.height = n2;
    }

    @Override
    public final boolean isVisible() {
        return this.visible;
    }

    @Override
    public final boolean isFullscreen() {
        return this.fullscreen;
    }

    @Override
    public final Window getDelegatedWindow() {
        return this;
    }

    public boolean hasDeviceChanged() {
        return false;
    }

    public LifecycleHook getLifecycleHook() {
        return this.lifecycleHook;
    }

    public LifecycleHook setLifecycleHook(LifecycleHook lifecycleHook) {
        LifecycleHook lifecycleHook2 = this.lifecycleHook;
        this.lifecycleHook = lifecycleHook;
        return lifecycleHook2;
    }

    public NativeSurface getWrappedSurface() {
        return null;
    }

    @Override
    public void setWindowDestroyNotifyAction(Runnable runnable) {
        this.windowDestroyNotifyAction = runnable;
    }

    public final AbstractGraphicsConfiguration getPrivateGraphicsConfiguration() {
        return this.config;
    }

    protected final long getParentWindowHandle() {
        return this.isFullscreen() ? 0L : this.parentWindowHandle;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName() + "[Config " + this.config + "\n, " + this.screen + "\n, ParentWindow " + this.parentWindow + "\n, ParentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle) + " (" + (0L != this.getParentWindowHandle()) + ")" + "\n, WindowHandle " + WindowImpl.toHexString(this.getWindowHandle()) + "\n, SurfaceHandle " + WindowImpl.toHexString(this.getSurfaceHandle()) + " (lockedExt window " + this.windowLock.isLockedByOtherThread() + ", surface " + this.isSurfaceLockedByOtherThread() + ")" + "\n, Pos " + this.getX() + "/" + this.getY() + " (auto " + this.autoPosition() + "), size " + this.getWidth() + "x" + this.getHeight() + "\n, Visible " + this.isVisible() + ", focus " + this.hasFocus() + "\n, Undecorated " + this.undecorated + " (" + this.isUndecorated() + ")" + "\n, AlwaysOnTop " + this.alwaysOnTop + ", Fullscreen " + this.fullscreen + "\n, WrappedSurface " + this.getWrappedSurface() + "\n, ChildWindows " + this.childWindows.size());
        stringBuilder.append(", SurfaceUpdatedListeners num " + this.surfaceUpdatedHelper.size() + " [");
        for (n = 0; n < this.surfaceUpdatedHelper.size(); ++n) {
            stringBuilder.append(this.surfaceUpdatedHelper.get(n) + ", ");
        }
        stringBuilder.append("], WindowListeners num " + this.windowListeners.size() + " [");
        for (n = 0; n < this.windowListeners.size(); ++n) {
            stringBuilder.append(this.windowListeners.get(n) + ", ");
        }
        stringBuilder.append("], MouseListeners num " + this.mouseListeners.size() + " [");
        for (n = 0; n < this.mouseListeners.size(); ++n) {
            stringBuilder.append(this.mouseListeners.get(n) + ", ");
        }
        stringBuilder.append("], PointerGestures default " + this.defaultGestureHandlerEnabled + ", custom " + this.pointerGestureHandler.size() + " [");
        for (n = 0; n < this.pointerGestureHandler.size(); ++n) {
            stringBuilder.append(this.pointerGestureHandler.get(n) + ", ");
        }
        stringBuilder.append("], KeyListeners num " + this.keyListeners.size() + " [");
        for (n = 0; n < this.keyListeners.size(); ++n) {
            stringBuilder.append(this.keyListeners.get(n) + ", ");
        }
        stringBuilder.append("], windowLock " + this.windowLock + ", surfaceLockCount " + this.surfaceLockCount + "]");
        return stringBuilder.toString();
    }

    protected final void setWindowHandle(long l) {
        this.windowHandle = l;
    }

    @Override
    public void runOnEDTIfAvail(boolean bl, Runnable runnable) {
        if (this.windowLock.isOwner(Thread.currentThread())) {
            runnable.run();
        } else {
            ((DisplayImpl)this.screen.getDisplay()).runOnEDTIfAvail(bl, runnable);
        }
    }

    @Override
    public final boolean hasFocus() {
        return this.hasFocus;
    }

    @Override
    public void requestFocus() {
        this.requestFocus(true);
    }

    @Override
    public void requestFocus(boolean bl) {
        this.requestFocus(bl, false, this.brokenFocusChange);
    }

    private void requestFocus(boolean bl, boolean bl2, boolean bl3) {
        if (!(!this.isNativeValid() || !bl3 && this.hasFocus() || !bl2 && this.focusAction())) {
            this.runOnEDTIfAvail(bl, bl3 ? this.requestFocusActionForced : this.requestFocusAction);
        }
    }

    private void requestFocusInt(boolean bl) {
        if (bl || !this.focusAction()) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.RequestFocusInt: forcing - (" + WindowImpl.getThreadName() + "): skipFocusAction " + bl + ", focus " + this.hasFocus + " -> true - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            this.requestFocusImpl(true);
        }
    }

    @Override
    public void setFocusAction(Window.FocusRunnable focusRunnable) {
        this.focusAction = focusRunnable;
    }

    private boolean focusAction() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.focusAction() START - " + WindowImpl.getThreadName() + ", focusAction: " + this.focusAction + " - windowHandle " + WindowImpl.toHexString(this.getWindowHandle()));
        }
        boolean bl = null != this.focusAction ? this.focusAction.run() : false;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.focusAction() END - " + WindowImpl.getThreadName() + ", focusAction: " + this.focusAction + " - windowHandle " + WindowImpl.toHexString(this.getWindowHandle()) + ", res: " + bl);
        }
        return bl;
    }

    protected void setBrokenFocusChange(boolean bl) {
        this.brokenFocusChange = bl;
    }

    @Override
    public void setKeyboardFocusHandler(KeyListener keyListener) {
        this.keyboardFocusHandler = keyListener;
    }

    @Override
    public void setPosition(int n, int n2) {
        this.autoPosition = false;
        this.runOnEDTIfAvail(true, new SetPositionAction(n, n2));
    }

    @Override
    public void setTopLevelPosition(int n, int n2) {
        this.setPosition(n + this.getInsets().getLeftWidth(), n2 + this.getInsets().getTopHeight());
    }

    @Override
    public boolean setFullscreen(boolean bl) {
        return this.setFullscreenImpl(bl, true, null);
    }

    @Override
    public boolean setFullscreen(List<MonitorDevice> list) {
        return this.setFullscreenImpl(true, false, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setFullscreenImpl(boolean bl, boolean bl2, List<MonitorDevice> list) {
        FullScreenAction fullScreenAction = this.fullScreenAction;
        synchronized (fullScreenAction) {
            this.fullscreenMonitors = list;
            this.fullscreenUseMainMonitor = bl2;
            if (this.fullScreenAction.init(bl)) {
                if (this.fullScreenAction.fsOn() && WindowImpl.isOffscreenInstance(this, this.parentWindow)) {
                    if (null != this.parentWindow) {
                        this.nfs_parent = this.parentWindow;
                        this.reparentWindow(null, -1, -1, true);
                    } else {
                        throw new InternalError("Offscreen instance w/o parent unhandled");
                    }
                }
                this.runOnEDTIfAvail(true, this.fullScreenAction);
                if (!this.fullScreenAction.fsOn() && null != this.nfs_parent) {
                    this.reparentWindow(this.nfs_parent, -1, -1, true);
                    this.nfs_parent = null;
                }
            }
            return this.fullscreen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeChild(NativeWindow nativeWindow) {
        Object object = this.childWindowsLock;
        synchronized (object) {
            return this.childWindows.remove(nativeWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addChild(NativeWindow nativeWindow) {
        if (nativeWindow == null) {
            return false;
        }
        Object object = this.childWindowsLock;
        synchronized (object) {
            return this.childWindows.add(nativeWindow);
        }
    }

    private void doEvent(boolean bl, boolean bl2, NEWTEvent nEWTEvent) {
        boolean bl3 = false;
        if (!bl) {
            bl2 = bl3 = this.consumeEvent(nEWTEvent);
        }
        if (!bl3) {
            this.enqueueEvent(bl2, nEWTEvent);
        }
    }

    @Override
    public void enqueueEvent(boolean bl, NEWTEvent nEWTEvent) {
        if (this.isNativeValid()) {
            ((DisplayImpl)this.screen.getDisplay()).enqueueEvent(bl, nEWTEvent);
        }
    }

    @Override
    public final boolean consumeEvent(NEWTEvent nEWTEvent) {
        switch (nEWTEvent.getEventType()) {
            case 105: {
                if (null != this.windowLock.getOwner()) {
                    if (!this.repaintQueued) {
                        boolean bl;
                        this.repaintQueued = true;
                        boolean bl2 = bl = 1200L <= System.currentTimeMillis() - nEWTEvent.getWhen();
                        if (DEBUG_IMPLEMENTATION) {
                            System.err.println("Window.consumeEvent: REPAINT " + Thread.currentThread().getName() + " - queued " + nEWTEvent + ", discard-to " + bl);
                        }
                        return bl;
                    }
                    return true;
                }
                this.repaintQueued = false;
                break;
            }
            case 100: {
                boolean bl;
                if (null == this.windowLock.getOwner()) break;
                boolean bl3 = bl = 1200L <= System.currentTimeMillis() - nEWTEvent.getWhen();
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.consumeEvent: RESIZED " + Thread.currentThread().getName() + " - queued " + nEWTEvent + ", discard-to " + bl);
                }
                return bl;
            }
        }
        if (nEWTEvent instanceof WindowEvent) {
            this.consumeWindowEvent((WindowEvent)nEWTEvent);
        } else if (nEWTEvent instanceof KeyEvent) {
            this.consumeKeyEvent((KeyEvent)nEWTEvent);
        } else if (nEWTEvent instanceof MouseEvent) {
            this.consumePointerEvent((MouseEvent)nEWTEvent);
        } else {
            throw new NativeWindowException("Unexpected NEWTEvent type " + nEWTEvent);
        }
        return true;
    }

    @Override
    public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(n, surfaceUpdatedListener);
    }

    @Override
    public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.removeSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        this.surfaceUpdatedHelper.surfaceUpdated(object, nativeSurface, l);
    }

    public final void sendMouseEvent(short s, int n, int n2, int n3, short s2, float f) {
        this.doMouseEvent(false, false, s, n, n2, n3, s2, MouseEvent.getRotationXYZ(f, n), 1.0f);
    }

    public final void enqueueMouseEvent(boolean bl, short s, int n, int n2, int n3, short s2, float f) {
        this.doMouseEvent(true, bl, s, n, n2, n3, s2, MouseEvent.getRotationXYZ(f, n), 1.0f);
    }

    protected final void doMouseEvent(boolean bl, boolean bl2, short s, int n, int n2, int n3, short s2, float f) {
        this.doMouseEvent(bl, bl2, s, n, n2, n3, s2, MouseEvent.getRotationXYZ(f, n), 1.0f);
    }

    protected void doMouseEvent(boolean bl, boolean bl2, short s, int n, int n2, int n3, short s2, float[] fArray, float f) {
        if (0 > s2 || s2 > 16) {
            throw new NativeWindowException("Invalid mouse button number" + s2);
        }
        this.doPointerEvent(bl, bl2, constMousePointerTypes, s, n, 0, new short[]{(short)(s2 - 1)}, new int[]{n2}, new int[]{n3}, new float[]{0.0f}, 1.0f, fArray, f);
    }

    public final void doPointerEvent(boolean bl, boolean bl2, MouseEvent.PointerType[] pointerTypeArray, short s, int n, int n2, boolean bl3, int[] nArray, int[] nArray2, int[] nArray3, float[] fArray, float f, float[] fArray2, float f2) {
        int n3 = nArray.length;
        short[] sArray = new short[n3];
        for (int i = 0; i < n3; ++i) {
            if (!bl3) {
                int n4;
                short s2;
                int n5 = this.pName2pID.size();
                Integer n6 = (Integer)this.pName2pID.getOrAdd((Object)nArray[i]);
                sArray[i] = s2 = (short)this.pName2pID.indexOf((Object)n6);
                if (DEBUG_MOUSE_EVENT && n5 != (n4 = this.pName2pID.size())) {
                    System.err.println("PointerName2ID[sz " + n4 + "]: Map " + n6 + " == " + s2);
                }
                if (204 != s) continue;
                this.pName2pID.remove((Object)n6);
                if (!DEBUG_MOUSE_EVENT) continue;
                System.err.println("PointerName2ID[sz " + this.pName2pID.size() + "]: Unmap " + n6 + " == " + s2);
                continue;
            }
            sArray[i] = (short)nArray[i];
        }
        this.doPointerEvent(bl, bl2, pointerTypeArray, s, n, n2, sArray, nArray2, nArray3, fArray, f, fArray2, f2);
    }

    public final void doPointerEvent(boolean bl, boolean bl2, MouseEvent.PointerType[] pointerTypeArray, short s, int n, int n2, short[] sArray, int[] nArray, int[] nArray2, float[] fArray, float f, float[] fArray2, float f2) {
        MouseEvent mouseEvent;
        short s2;
        int n3;
        long l = System.currentTimeMillis();
        int n4 = pointerTypeArray.length;
        if (0 > n2 || n2 >= n4) {
            throw new IllegalArgumentException("actionIdx out of bounds [0.." + (n4 - 1) + "]");
        }
        if (0 < n2) {
            MouseEvent.PointerType pointerType = pointerTypeArray[n2];
            pointerTypeArray[n2] = pointerTypeArray[0];
            pointerTypeArray[0] = pointerType;
            int n5 = sArray[n2];
            sArray[n2] = sArray[0];
            sArray[0] = n5;
            n5 = nArray[n2];
            nArray[n2] = nArray[0];
            nArray[0] = n5;
            n5 = nArray2[n2];
            nArray2[n2] = nArray2[0];
            nArray2[0] = n5;
            float f3 = fArray[n2];
            fArray[n2] = fArray[0];
            fArray[0] = f3;
        }
        short s3 = 0 <= (n3 = (s2 = sArray[0]) + 1) && n3 <= 16 ? (short)n3 : (short)1;
        n3 = nArray[0];
        int n6 = nArray2[0];
        Point point = this.pState1.getMovePosition(s2);
        switch (s) {
            case 202: {
                if (null != point) {
                    if (n3 == -1 && n6 == -1) {
                        n3 = point.getX();
                        n6 = point.getY();
                    }
                    point.set(0, 0);
                }
            }
            case 201: {
                n3 = Math.min(Math.max(n3, 0), this.getWidth() - 1);
                n6 = Math.min(Math.max(n6, 0), this.getHeight() - 1);
                this.pState1.insideWindow = s == 201;
                this.pState1.clearButton();
                break;
            }
            case 205: 
            case 206: {
                if (null != point) {
                    if (this.pState1.insideWindow && point.getX() == n3 && point.getY() == n6) {
                        if (DEBUG_MOUSE_EVENT) {
                            System.err.println("doPointerEvent: skip " + MouseEvent.getEventTypeString(s) + " w/ same position: " + point);
                        }
                        return;
                    }
                    point.set(n3, n6);
                }
            }
            default: {
                if (this.pState1.insideWindow) break;
                this.pState1.insideWindow = true;
                this.pState1.clearButton();
            }
        }
        if (n3 < 0 || n6 < 0 || n3 >= this.getWidth() || n6 >= this.getHeight()) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("doPointerEvent: drop: " + MouseEvent.getEventTypeString(s) + ", mod " + n + ", pos " + n3 + "/" + n6 + ", button " + s3 + ", lastMousePosition: " + point);
            }
            return;
        }
        if (DEBUG_MOUSE_EVENT) {
            System.err.println("doPointerEvent: enqueue " + bl + ", wait " + bl2 + ", " + MouseEvent.getEventTypeString(s) + ", mod " + n + ", pos " + n3 + "/" + n6 + ", button " + s3 + ", lastMousePosition: " + point);
        }
        int n7 = InputEvent.getButtonMask(s3);
        n |= n7;
        n |= this.pState1.buttonPressedMask;
        if (this.isPointerConfined()) {
            n |= 0x40000000;
        }
        if (!this.isPointerVisible()) {
            n |= Integer.MIN_VALUE;
        }
        nArray[0] = n3;
        nArray2[0] = n6;
        switch (s) {
            case 200: {
                mouseEvent = null;
                break;
            }
            case 203: {
                if (0.0f >= fArray[0]) {
                    fArray[0] = f;
                }
                this.pState1.buttonPressedMask |= n7;
                if (1 == n4) {
                    this.pState1.lastButtonClickCount = l - this.pState1.lastButtonPressTime < (long)MouseEvent.getClickTimeout() ? (short)(this.pState1.lastButtonClickCount + 1) : (short)1;
                    this.pState1.lastButtonPressTime = l;
                    this.pState1.buttonPressed = s3;
                    mouseEvent = new MouseEvent(s, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, s3, this.pState1.lastButtonClickCount, fArray2, f2);
                    break;
                }
                mouseEvent = new MouseEvent(s, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, s3, 1, fArray2, f2);
                break;
            }
            case 204: {
                if (1 == n4) {
                    mouseEvent = new MouseEvent(s, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, s3, this.pState1.lastButtonClickCount, fArray2, f2);
                    if (l - this.pState1.lastButtonPressTime >= (long)MouseEvent.getClickTimeout()) {
                        this.pState1.lastButtonClickCount = 0;
                        this.pState1.lastButtonPressTime = 0L;
                    }
                    this.pState1.buttonPressed = 0;
                } else {
                    mouseEvent = new MouseEvent(s, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, s3, 1, fArray2, f2);
                }
                this.pState1.buttonPressedMask &= ~n7;
                if (null == point) break;
                point.set(0, 0);
                break;
            }
            case 205: {
                if (0 != this.pState1.buttonPressedMask) {
                    mouseEvent = new MouseEvent(206, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, this.pState1.buttonPressed, 1, fArray2, f2);
                    break;
                }
                mouseEvent = new MouseEvent(s, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, s3, 0, fArray2, f2);
                break;
            }
            case 206: {
                if (0.0f >= fArray[0]) {
                    fArray[0] = f;
                }
            }
            default: {
                mouseEvent = new MouseEvent(s, this, l, n, pointerTypeArray, sArray, nArray, nArray2, fArray, f, s3, 0, fArray2, f2);
            }
        }
        this.doEvent(bl, bl2, mouseEvent);
    }

    @Override
    public final void addMouseListener(MouseListener mouseListener) {
        this.addMouseListener(-1, mouseListener);
    }

    @Override
    public final void addMouseListener(int n, MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, mouseListener);
        this.mouseListeners = arrayList;
    }

    @Override
    public final void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        arrayList.remove(mouseListener);
        this.mouseListeners = arrayList;
    }

    @Override
    public final MouseListener getMouseListener(int n) {
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (MouseListener)arrayList.get(n);
    }

    @Override
    public final MouseListener[] getMouseListeners() {
        return this.mouseListeners.toArray(new MouseListener[this.mouseListeners.size()]);
    }

    @Override
    public final void setDefaultGesturesEnabled(boolean bl) {
        this.defaultGestureHandlerEnabled = bl;
    }

    @Override
    public final boolean areDefaultGesturesEnabled() {
        return this.defaultGestureHandlerEnabled;
    }

    @Override
    public final void addGestureHandler(GestureHandler gestureHandler) {
        this.addGestureHandler(-1, gestureHandler);
    }

    @Override
    public final void addGestureHandler(int n, GestureHandler gestureHandler) {
        if (gestureHandler == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.pointerGestureHandler.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, gestureHandler);
        this.pointerGestureHandler = arrayList;
    }

    @Override
    public final void removeGestureHandler(GestureHandler gestureHandler) {
        if (gestureHandler == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.pointerGestureHandler.clone();
        arrayList.remove(gestureHandler);
        this.pointerGestureHandler = arrayList;
    }

    @Override
    public final void addGestureListener(GestureHandler.GestureListener gestureListener) {
        this.addGestureListener(-1, gestureListener);
    }

    @Override
    public final void addGestureListener(int n, GestureHandler.GestureListener gestureListener) {
        if (gestureListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.gestureListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, gestureListener);
        this.gestureListeners = arrayList;
    }

    @Override
    public final void removeGestureListener(GestureHandler.GestureListener gestureListener) {
        if (gestureListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.gestureListeners.clone();
        arrayList.remove(gestureListener);
        this.gestureListeners = arrayList;
    }

    private static int step(int n, int n2, int n3) {
        return n3 < n2 ? n : n3;
    }

    protected void consumePointerEvent(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2;
        int n;
        int n2;
        Object object;
        MouseEvent mouseEvent3;
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        if (DEBUG_MOUSE_EVENT) {
            System.err.println("consumePointerEvent.in: " + mouseEvent);
        }
        long l = mouseEvent.getWhen();
        short s = mouseEvent.getEventType();
        switch (s) {
            case 201: 
            case 202: {
                n3 = Math.min(Math.max(n3, 0), this.getWidth() - 1);
                n4 = Math.min(Math.max(n4, 0), this.getHeight() - 1);
                this.pState0.insideWindow = s == 201;
                this.pState0.clearButton();
                mouseEvent3 = null;
                break;
            }
            default: {
                if (!this.pState0.insideWindow) {
                    this.pState0.insideWindow = true;
                    this.pState0.clearButton();
                    mouseEvent3 = mouseEvent.createVariant((short)201);
                    break;
                }
                mouseEvent3 = null;
            }
        }
        if (null != mouseEvent3) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("consumePointerEvent.send.0: " + mouseEvent3);
            }
            this.dispatchMouseEvent(mouseEvent3);
        } else if (n3 < 0 || n4 < 0 || n3 >= this.getWidth() || n4 >= this.getHeight()) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("consumePointerEvent.drop: " + mouseEvent);
            }
            return;
        }
        if (this.defaultGestureHandlerEnabled && mouseEvent.getPointerType(0).getPointerClass() == MouseEvent.PointerClass.Onscreen) {
            if (null == this.gesture2PtrTouchScroll) {
                MonitorDevice monitorDevice = this.getMainMonitor();
                if (null != monitorDevice) {
                    object = monitorDevice.getSizeMM();
                    float f = (float)monitorDevice.getCurrentMode().getRotatedWidth() / (float)object.getWidth();
                    float f2 = (float)monitorDevice.getCurrentMode().getRotatedHeight() / (float)object.getHeight();
                    float f3 = Math.min(f2, f);
                    n2 = Math.round(DoubleTapScrollGesture.SCROLL_SLOP_MM * f3);
                    n = Math.round(DoubleTapScrollGesture.DOUBLE_TAP_SLOP_MM * f3);
                    if (DEBUG_MOUSE_EVENT) {
                        System.err.println("consumePointerEvent.gscroll: scrollSlop " + n2 + ", doubleTapSlop " + n + ", pixPerMM " + f3 + ", " + monitorDevice);
                    }
                } else {
                    n2 = DoubleTapScrollGesture.SCROLL_SLOP_PIXEL;
                    n = DoubleTapScrollGesture.DOUBLE_TAP_SLOP_PIXEL;
                }
                this.gesture2PtrTouchScroll = new DoubleTapScrollGesture(WindowImpl.step(DoubleTapScrollGesture.SCROLL_SLOP_PIXEL, DoubleTapScrollGesture.SCROLL_SLOP_PIXEL / 2, n2), WindowImpl.step(DoubleTapScrollGesture.DOUBLE_TAP_SLOP_PIXEL, DoubleTapScrollGesture.DOUBLE_TAP_SLOP_PIXEL / 2, n));
            }
            if (this.gesture2PtrTouchScroll.process(mouseEvent)) {
                mouseEvent = (MouseEvent)this.gesture2PtrTouchScroll.getGestureEvent();
                this.gesture2PtrTouchScroll.clear(false);
                if (DEBUG_MOUSE_EVENT) {
                    System.err.println("consumePointerEvent.gscroll: " + mouseEvent);
                }
                this.dispatchMouseEvent(mouseEvent);
                return;
            }
            if (this.gesture2PtrTouchScroll.isWithinGesture()) {
                return;
            }
        }
        if ((n2 = this.pointerGestureHandler.size()) > 0) {
            n = 0;
            for (int i = 0; !mouseEvent.isConsumed() && i < n2; ++i) {
                object = this.pointerGestureHandler.get(i);
                if (object.process(mouseEvent)) {
                    InputEvent inputEvent = object.getGestureEvent();
                    object.clear(false);
                    if (inputEvent instanceof MouseEvent) {
                        this.dispatchMouseEvent((MouseEvent)inputEvent);
                    } else if (inputEvent instanceof GestureHandler.GestureEvent) {
                        GestureHandler.GestureEvent gestureEvent = (GestureHandler.GestureEvent)inputEvent;
                        for (int j = 0; !gestureEvent.isConsumed() && j < this.gestureListeners.size(); ++j) {
                            this.gestureListeners.get(j).gestureDetected(gestureEvent);
                        }
                    }
                    return;
                }
                n |= object.isWithinGesture();
            }
            if (n != 0) {
                return;
            }
        }
        switch (s) {
            case 203: {
                if (1 == mouseEvent.getPointerCount()) {
                    this.pState0.lastButtonPressTime = l;
                }
                mouseEvent2 = null;
                break;
            }
            case 204: {
                if (1 == mouseEvent.getPointerCount() && l - this.pState0.lastButtonPressTime < (long)MouseEvent.getClickTimeout()) {
                    mouseEvent2 = mouseEvent.createVariant((short)200);
                    break;
                }
                mouseEvent2 = null;
                this.pState0.lastButtonPressTime = 0L;
                break;
            }
            case 200: {
                if (DEBUG_MOUSE_EVENT) {
                    System.err.println("consumePointerEvent: drop recv'ed (synth here) " + mouseEvent);
                }
                mouseEvent = null;
                mouseEvent2 = null;
                break;
            }
            default: {
                mouseEvent2 = null;
            }
        }
        if (null != mouseEvent) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("consumePointerEvent.send.1: " + mouseEvent);
            }
            this.dispatchMouseEvent(mouseEvent);
        }
        if (null != mouseEvent2) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("consumePointerEvent.send.2: " + mouseEvent2);
            }
            this.dispatchMouseEvent(mouseEvent2);
        }
    }

    private final void dispatchMouseEvent(MouseEvent mouseEvent) {
        block10: for (int i = 0; !mouseEvent.isConsumed() && i < this.mouseListeners.size(); ++i) {
            MouseListener mouseListener = this.mouseListeners.get(i);
            switch (mouseEvent.getEventType()) {
                case 200: {
                    mouseListener.mouseClicked(mouseEvent);
                    continue block10;
                }
                case 201: {
                    mouseListener.mouseEntered(mouseEvent);
                    continue block10;
                }
                case 202: {
                    mouseListener.mouseExited(mouseEvent);
                    continue block10;
                }
                case 203: {
                    mouseListener.mousePressed(mouseEvent);
                    continue block10;
                }
                case 204: {
                    mouseListener.mouseReleased(mouseEvent);
                    continue block10;
                }
                case 205: {
                    mouseListener.mouseMoved(mouseEvent);
                    continue block10;
                }
                case 206: {
                    mouseListener.mouseDragged(mouseEvent);
                    continue block10;
                }
                case 207: {
                    mouseListener.mouseWheelMoved(mouseEvent);
                    continue block10;
                }
                default: {
                    throw new NativeWindowException("Unexpected mouse event type " + mouseEvent.getEventType());
                }
            }
        }
    }

    protected final boolean isKeyCodeTracked(short s) {
        return (0xFFFF & s) <= 255;
    }

    protected final boolean setKeyPressed(short s, boolean bl) {
        int n = 0xFFFF & s;
        if (n <= 255) {
            return this.keyPressedState.put(n, bl);
        }
        return false;
    }

    protected final boolean isKeyPressed(short s) {
        int n = 0xFFFF & s;
        if (n <= 255) {
            return this.keyPressedState.get(n);
        }
        return false;
    }

    public void sendKeyEvent(short s, int n, short s2, short s3, char c) {
        this.consumeKeyEvent(KeyEvent.create(s, this, System.currentTimeMillis(), n | this.pState1.buttonPressedMask, s2, s3, c));
    }

    public void enqueueKeyEvent(boolean bl, short s, int n, short s2, short s3, char c) {
        this.enqueueEvent(bl, KeyEvent.create(s, this, System.currentTimeMillis(), n | this.pState1.buttonPressedMask, s2, s3, c));
    }

    @Override
    public final void setKeyboardVisible(boolean bl) {
        if (this.isNativeValid()) {
            boolean bl2 = this.setKeyboardVisibleImpl(bl);
            if (DEBUG_IMPLEMENTATION || DEBUG_KEY_EVENT) {
                System.err.println("setKeyboardVisible(native): visible " + this.keyboardVisible + " -- op[visible:" + bl + ", ok " + bl2 + "] -> " + (bl && bl2));
            }
            this.keyboardVisibilityChanged(bl && bl2);
        } else {
            this.keyboardVisibilityChanged(bl);
        }
    }

    @Override
    public final boolean isKeyboardVisible() {
        return this.keyboardVisible;
    }

    protected boolean setKeyboardVisibleImpl(boolean bl) {
        return false;
    }

    protected void keyboardVisibilityChanged(boolean bl) {
        if (this.keyboardVisible != bl) {
            if (DEBUG_IMPLEMENTATION || DEBUG_KEY_EVENT) {
                System.err.println("keyboardVisibilityChanged: " + this.keyboardVisible + " -> " + bl);
            }
            this.keyboardVisible = bl;
        }
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.addKeyListener(-1, keyListener);
    }

    @Override
    public void addKeyListener(int n, KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, keyListener);
        this.keyListeners = arrayList;
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        arrayList.remove(keyListener);
        this.keyListeners = arrayList;
    }

    @Override
    public KeyListener getKeyListener(int n) {
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (KeyListener)arrayList.get(n);
    }

    @Override
    public KeyListener[] getKeyListeners() {
        return this.keyListeners.toArray(new KeyListener[this.keyListeners.size()]);
    }

    private final boolean propagateKeyEvent(KeyEvent keyEvent, KeyListener keyListener) {
        switch (keyEvent.getEventType()) {
            case 300: {
                keyListener.keyPressed(keyEvent);
                break;
            }
            case 301: {
                keyListener.keyReleased(keyEvent);
                break;
            }
            default: {
                throw new NativeWindowException("Unexpected key event type " + keyEvent.getEventType());
            }
        }
        return keyEvent.isConsumed();
    }

    protected void consumeKeyEvent(KeyEvent keyEvent) {
        boolean bl = false;
        if (null != this.keyboardFocusHandler && !keyEvent.isAutoRepeat()) {
            bl = this.propagateKeyEvent(keyEvent, this.keyboardFocusHandler);
            if (DEBUG_KEY_EVENT && bl) {
                System.err.println("consumeKeyEvent(kfh): " + keyEvent + ", consumed: " + bl);
            }
        }
        if (!bl) {
            for (int i = 0; !bl && i < this.keyListeners.size(); ++i) {
                bl = this.propagateKeyEvent(keyEvent, this.keyListeners.get(i));
            }
            if (DEBUG_KEY_EVENT) {
                System.err.println("consumeKeyEvent(usr): " + keyEvent + ", consumed: " + bl);
            }
        }
    }

    @Override
    public void sendWindowEvent(int n) {
        this.consumeWindowEvent(new WindowEvent((short)n, this, System.currentTimeMillis()));
    }

    public void enqueueWindowEvent(boolean bl, int n) {
        this.enqueueEvent(bl, new WindowEvent((short)n, this, System.currentTimeMillis()));
    }

    @Override
    public void addWindowListener(WindowListener windowListener) {
        this.addWindowListener(-1, windowListener);
    }

    @Override
    public void addWindowListener(int n, WindowListener windowListener) throws IndexOutOfBoundsException {
        if (windowListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, windowListener);
        this.windowListeners = arrayList;
    }

    @Override
    public final void removeWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        arrayList.remove(windowListener);
        this.windowListeners = arrayList;
    }

    @Override
    public WindowListener getWindowListener(int n) {
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (WindowListener)arrayList.get(n);
    }

    @Override
    public WindowListener[] getWindowListeners() {
        return this.windowListeners.toArray(new WindowListener[this.windowListeners.size()]);
    }

    protected void consumeWindowEvent(WindowEvent windowEvent) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("consumeWindowEvent: " + windowEvent + ", visible " + this.isVisible() + " " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight());
        }
        block9: for (int i = 0; !windowEvent.isConsumed() && i < this.windowListeners.size(); ++i) {
            WindowListener windowListener = this.windowListeners.get(i);
            switch (windowEvent.getEventType()) {
                case 100: {
                    windowListener.windowResized(windowEvent);
                    continue block9;
                }
                case 101: {
                    windowListener.windowMoved(windowEvent);
                    continue block9;
                }
                case 102: {
                    windowListener.windowDestroyNotify(windowEvent);
                    continue block9;
                }
                case 106: {
                    windowListener.windowDestroyed(windowEvent);
                    continue block9;
                }
                case 103: {
                    windowListener.windowGainedFocus(windowEvent);
                    continue block9;
                }
                case 104: {
                    windowListener.windowLostFocus(windowEvent);
                    continue block9;
                }
                case 105: {
                    windowListener.windowRepaint((WindowUpdateEvent)windowEvent);
                    continue block9;
                }
                default: {
                    throw new NativeWindowException("Unexpected window event type " + windowEvent.getEventType());
                }
            }
        }
    }

    protected void focusChanged(boolean bl, boolean bl2) {
        if (this.brokenFocusChange || this.hasFocus != bl2) {
            int n;
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.focusChanged: (" + WindowImpl.getThreadName() + "): (defer: " + bl + ") " + this.hasFocus + " -> " + bl2 + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            this.hasFocus = bl2;
            int n2 = n = bl2 ? 103 : 104;
            if (!bl) {
                this.sendWindowEvent(n);
            } else {
                this.enqueueWindowEvent(false, n);
            }
        }
    }

    protected void visibleChanged(boolean bl, boolean bl2) {
        if (this.visible != bl2) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.visibleChanged (" + WindowImpl.getThreadName() + "): (defer: " + bl + ") " + this.visible + " -> " + bl2 + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            this.visible = bl2;
        }
    }

    private long waitForVisible(boolean bl, boolean bl2) {
        return this.waitForVisible(bl, bl2, 1000L);
    }

    private long waitForVisible(boolean bl, boolean bl2, long l) {
        long l2;
        DisplayImpl displayImpl = (DisplayImpl)this.screen.getDisplay();
        displayImpl.dispatchMessagesNative();
        for (l2 = l; 0L < l2 && this.visible != bl; l2 -= 10L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            displayImpl.dispatchMessagesNative();
        }
        if (this.visible != bl) {
            String string = "Visibility not reached as requested within " + l + "ms : requested " + bl + ", is " + this.visible;
            if (bl2) {
                throw new NativeWindowException(string);
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println(string);
                Thread.dumpStack();
            }
            return -1L;
        }
        if (0L < l2) {
            return l2;
        }
        return 0L;
    }

    protected void sizeChanged(boolean bl, int n, int n2, boolean bl2) {
        if (bl2 || this.getWidth() != n || this.getHeight() != n2) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.sizeChanged: (" + WindowImpl.getThreadName() + "): (defer: " + bl + ") force " + bl2 + ", " + this.getWidth() + "x" + this.getHeight() + " -> " + n + "x" + n2 + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            if (0 > n || 0 > n2) {
                throw new NativeWindowException("Illegal width or height " + n + "x" + n2 + " (must be >= 0)");
            }
            this.defineSize(n, n2);
            if (this.isNativeValid()) {
                if (!bl) {
                    this.sendWindowEvent(100);
                } else {
                    this.enqueueWindowEvent(false, 100);
                }
            }
        }
    }

    private boolean waitForSize(int n, int n2, boolean bl, long l) {
        long l2;
        DisplayImpl displayImpl = (DisplayImpl)this.screen.getDisplay();
        displayImpl.dispatchMessagesNative();
        for (l2 = l; 0L < l2 && n != this.getWidth() && n2 != this.getHeight(); l2 -= 10L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            displayImpl.dispatchMessagesNative();
        }
        if (0L >= l2) {
            String string = "Size/Pos not reached as requested within " + l + "ms : requested " + n + "x" + n2 + ", is " + this.getWidth() + "x" + this.getHeight();
            if (bl) {
                throw new NativeWindowException(string);
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println(string);
                Thread.dumpStack();
            }
            return false;
        }
        return true;
    }

    protected void positionChanged(boolean bl, int n, int n2) {
        if (this.getX() != n || this.getY() != n2) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.positionChanged: (" + WindowImpl.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + " -> " + n + "/" + n2 + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            this.definePosition(n, n2);
            if (!bl) {
                this.sendWindowEvent(101);
            } else {
                this.enqueueWindowEvent(false, 101);
            }
        } else {
            this.autoPosition = false;
        }
    }

    private boolean waitForPosition(boolean bl, int n, int n2, long l) {
        boolean bl2;
        DisplayImpl displayImpl = (DisplayImpl)this.screen.getDisplay();
        InsetsImmutable insetsImmutable = this.getInsets();
        int n3 = Math.max(64, insetsImmutable.getLeftWidth() * 2);
        int n4 = Math.max(64, insetsImmutable.getTopHeight() * 2);
        long l2 = l;
        do {
            if (bl) {
                bl2 = Math.abs(n - this.getX()) <= n3 && Math.abs(n2 - this.getY()) <= n4;
            } else {
                boolean bl3 = bl2 = !this.autoPosition;
            }
            if (bl2) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            displayImpl.dispatchMessagesNative();
            l2 -= 10L;
        } while (0L < l2 && !bl2);
        if (DEBUG_IMPLEMENTATION && !bl2) {
            if (bl) {
                System.err.println("Custom position " + n + "/" + n2 + " not reached within timeout, has " + this.getX() + "/" + this.getY() + ", remaining " + l2);
            } else {
                System.err.println("Auto position not reached within timeout, has " + this.getX() + "/" + this.getY() + ", autoPosition " + this.autoPosition + ", remaining " + l2);
            }
            Thread.dumpStack();
        }
        return bl2;
    }

    protected void insetsChanged(boolean bl, int n, int n2, int n3, int n4) {
        if (n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0) {
            if (this.isUndecorated()) {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.insetsChanged: skip insets change for undecoration mode");
                }
            } else if (n != this.insets.getLeftWidth() || n2 != this.insets.getRightWidth() || n3 != this.insets.getTopHeight() || n4 != this.insets.getBottomHeight()) {
                this.insets.set(n, n2, n3, n4);
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.insetsChanged: (defer: " + bl + ") " + this.insets);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean windowDestroyNotify(boolean bl) {
        boolean bl2;
        WindowClosingProtocol.WindowClosingMode windowClosingMode;
        WindowClosingProtocol.WindowClosingMode windowClosingMode2 = this.getDefaultCloseOperation();
        WindowClosingProtocol.WindowClosingMode windowClosingMode3 = windowClosingMode = bl ? WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE : windowClosingMode2;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowDestroyNotify(isNativeValid: " + this.isNativeValid() + ", force: " + bl + ", mode " + (Object)((Object)windowClosingMode2) + " -> " + (Object)((Object)windowClosingMode) + ") " + WindowImpl.getThreadName() + ": " + this);
        }
        if (this.isNativeValid()) {
            if (WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE == windowClosingMode) {
                if (bl) {
                    this.setDefaultCloseOperation(windowClosingMode);
                }
                try {
                    if (null == this.windowDestroyNotifyAction) {
                        this.destroy();
                    }
                    this.windowDestroyNotifyAction.run();
                }
                finally {
                    if (bl) {
                        this.setDefaultCloseOperation(windowClosingMode2);
                    }
                }
            } else {
                this.sendWindowEvent(102);
            }
            bl2 = !this.isNativeValid();
        } else {
            bl2 = true;
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowDestroyNotify(isNativeValid: " + this.isNativeValid() + ", force: " + bl + ", mode " + (Object)((Object)windowClosingMode) + ") END " + WindowImpl.getThreadName() + ": destroyed " + bl2 + ", " + this);
        }
        return bl2;
    }

    @Override
    public void windowRepaint(int n, int n2, int n3, int n4) {
        this.windowRepaint(false, n, n2, n3, n4);
    }

    protected void windowRepaint(boolean bl, int n, int n2, int n3, int n4) {
        n3 = 0 >= n3 ? this.getWidth() : n3;
        int n5 = n4 = 0 >= n4 ? this.getHeight() : n4;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowRepaint " + WindowImpl.getThreadName() + " (defer: " + bl + ") " + n + "/" + n2 + " " + n3 + "x" + n4);
        }
        if (this.isNativeValid()) {
            WindowUpdateEvent windowUpdateEvent = new WindowUpdateEvent(105, this, System.currentTimeMillis(), new Rectangle(n, n2, n3, n4));
            this.doEvent(bl, false, windowUpdateEvent);
        }
    }

    private static Class<?>[] getCustomConstructorArgumentTypes(Class<?> clazz) {
        Class[] classArray = null;
        try {
            Method method = clazz.getDeclaredMethod("getCustomConstructorArgumentTypes", new Class[0]);
            classArray = (Class[])method.invoke(null, (Object[])null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return classArray;
    }

    private static int verifyConstructorArgumentTypes(Class<?>[] classArray, Object[] objectArray) {
        if (classArray.length != objectArray.length) {
            return -1;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (classArray[i].isInstance(objectArray[i])) continue;
            return i;
        }
        return objectArray.length;
    }

    private static String getArgsStrList(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(objectArray[i].getClass());
            if (i >= objectArray.length) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private static String getTypeStrList(Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(classArray[i]);
            if (i >= classArray.length) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    protected final void shouldNotCallThis() {
        throw new NativeWindowException("Should not call this");
    }

    public static String getThreadName() {
        return Display.getThreadName();
    }

    public static String toHexString(int n) {
        return Display.toHexString(n);
    }

    public static String toHexString(long l) {
        return Display.toHexString(l);
    }

    static {
        Debug.initSingleton();
        DEBUG_TEST_REPARENT_INCOMPATIBLE = Debug.isPropertyDefined((String)"newt.test.Window.reparent.incompatible", (boolean)true);
        ScreenImpl.initSingleton();
        windowList = new ArrayList();
        constMousePointerTypes = new MouseEvent.PointerType[]{MouseEvent.PointerType.Mouse};
    }

    private class MonitorModeListenerImpl
    implements MonitorModeListener {
        boolean animatorPaused = false;
        boolean hadFocus = false;
        boolean fullscreenPaused = false;
        List<MonitorDevice> _fullscreenMonitors = null;
        boolean _fullscreenUseMainMonitor = true;

        private MonitorModeListenerImpl() {
        }

        @Override
        public void monitorModeChangeNotify(MonitorEvent monitorEvent) {
            this.hadFocus = WindowImpl.this.hasFocus();
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.monitorModeChangeNotify: hadFocus " + this.hadFocus + ", " + monitorEvent + " @ " + Thread.currentThread().getName());
            }
            if (null != WindowImpl.this.lifecycleHook) {
                this.animatorPaused = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
            if (WindowImpl.this.fullscreen && WindowImpl.this.isReconfigureFlagSupported(2048)) {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.monitorModeChangeNotify: FS Pause");
                }
                this.fullscreenPaused = true;
                this._fullscreenMonitors = WindowImpl.this.fullscreenMonitors;
                this._fullscreenUseMainMonitor = WindowImpl.this.fullscreenUseMainMonitor;
                WindowImpl.this.setFullscreenImpl(false, true, null);
            }
        }

        @Override
        public void monitorModeChanged(MonitorEvent monitorEvent, boolean bl) {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.monitorModeChanged: hadFocus " + this.hadFocus + ", " + monitorEvent + ", success: " + bl + " @ " + Thread.currentThread().getName());
            }
            if (bl) {
                if (!this.animatorPaused && null != WindowImpl.this.lifecycleHook) {
                    this.animatorPaused = WindowImpl.this.lifecycleHook.pauseRenderingAction();
                }
                if (!WindowImpl.this.fullscreen && !this.fullscreenPaused) {
                    RectangleImmutable rectangleImmutable = WindowImpl.this.screen.getViewport();
                    if (rectangleImmutable.getWidth() > 0 && rectangleImmutable.getHeight() > 0) {
                        Rectangle rectangle = new Rectangle(WindowImpl.this.getX(), WindowImpl.this.getY(), WindowImpl.this.getWidth(), WindowImpl.this.getHeight());
                        RectangleImmutable rectangleImmutable2 = rectangleImmutable.intersection(rectangle);
                        if (WindowImpl.this.getHeight() > rectangleImmutable2.getHeight() || WindowImpl.this.getWidth() > rectangleImmutable2.getWidth()) {
                            if (Window.DEBUG_IMPLEMENTATION) {
                                System.err.println("Window.monitorModeChanged: fit window " + rectangle + " into screen viewport " + rectangleImmutable + ", due to minimal intersection " + rectangleImmutable2);
                            }
                            WindowImpl.this.definePosition(rectangleImmutable.getX(), rectangleImmutable.getY());
                            WindowImpl.this.setSize(rectangleImmutable.getWidth(), rectangleImmutable.getHeight());
                        }
                    }
                } else if (this.fullscreenPaused) {
                    if (Window.DEBUG_IMPLEMENTATION) {
                        System.err.println("Window.monitorModeChanged: FS Restore");
                    }
                    WindowImpl.this.setFullscreenImpl(true, this._fullscreenUseMainMonitor, this._fullscreenMonitors);
                    this.fullscreenPaused = false;
                    this._fullscreenMonitors = null;
                    this._fullscreenUseMainMonitor = true;
                } else {
                    MonitorDevice monitorDevice = monitorEvent.getMonitor();
                    if (WindowImpl.this.fullscreenMonitors.contains(monitorDevice)) {
                        Rectangle rectangle = MonitorDevice.unionOfViewports(new Rectangle(), WindowImpl.this.fullscreenMonitors);
                        if (Window.DEBUG_IMPLEMENTATION) {
                            Rectangle rectangle2 = new Rectangle(WindowImpl.this.getX(), WindowImpl.this.getY(), WindowImpl.this.getWidth(), WindowImpl.this.getHeight());
                            System.err.println("Window.monitorModeChanged: FS Monitor Match: Fit window " + rectangle2 + " into new viewport union " + rectangle + ", provoked by " + monitorDevice);
                        }
                        WindowImpl.this.definePosition(rectangle.getX(), rectangle.getY());
                        WindowImpl.this.setFullscreenSize(rectangle.getWidth(), rectangle.getHeight());
                    }
                }
            }
            if (this.animatorPaused) {
                WindowImpl.this.lifecycleHook.resumeRenderingAction();
            }
            WindowImpl.this.sendWindowEvent(100);
            if (this.hadFocus) {
                WindowImpl.this.requestFocus(true);
            }
        }
    }

    private class FullScreenAction
    implements Runnable {
        boolean fullscreen;

        private FullScreenAction() {
        }

        private boolean init(boolean bl) {
            if (WindowImpl.this.isNativeValid()) {
                this.fullscreen = bl;
                return WindowImpl.this.isFullscreen() != bl;
            }
            WindowImpl.this.fullscreen = bl;
            return false;
        }

        public boolean fsOn() {
            return this.fullscreen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                NativeWindow nativeWindow;
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                Rectangle rectangle;
                WindowImpl.this.fullscreen = this.fullscreen;
                int n6 = WindowImpl.this.getX();
                int n7 = WindowImpl.this.getY();
                int n8 = WindowImpl.this.getWidth();
                int n9 = WindowImpl.this.getHeight();
                RectangleImmutable rectangleImmutable = WindowImpl.this.screen.getViewport();
                if (this.fullscreen) {
                    if (null == WindowImpl.this.fullscreenMonitors) {
                        if (WindowImpl.this.fullscreenUseMainMonitor) {
                            WindowImpl.this.fullscreenMonitors = new ArrayList();
                            WindowImpl.this.fullscreenMonitors.add(WindowImpl.this.getMainMonitor());
                        } else {
                            WindowImpl.this.fullscreenMonitors = WindowImpl.this.getScreen().getMonitorDevices();
                        }
                    }
                    rectangle = MonitorDevice.unionOfViewports(new Rectangle(), WindowImpl.this.fullscreenMonitors);
                    n5 = WindowImpl.this.isReconfigureFlagSupported(2048) && (WindowImpl.this.fullscreenMonitors.size() > 1 || rectangleImmutable.compareTo(rectangle) > 0) ? 2048 : 0;
                    WindowImpl.this.nfs_x = n6;
                    WindowImpl.this.nfs_y = n7;
                    WindowImpl.this.nfs_width = n8;
                    WindowImpl.this.nfs_height = n9;
                    n4 = rectangle.getX();
                    n3 = rectangle.getY();
                    n2 = rectangle.getWidth();
                    n = rectangle.getHeight();
                } else {
                    WindowImpl.this.fullscreenUseMainMonitor = true;
                    WindowImpl.this.fullscreenMonitors = null;
                    n5 = 0;
                    rectangle = null;
                    n4 = WindowImpl.this.nfs_x;
                    n3 = WindowImpl.this.nfs_y;
                    n2 = WindowImpl.this.nfs_width;
                    n = WindowImpl.this.nfs_height;
                    if (null != WindowImpl.this.parentWindow) {
                        n4 = 0;
                        n3 = 0;
                        if (n2 > WindowImpl.this.parentWindow.getWidth()) {
                            n2 = WindowImpl.this.parentWindow.getWidth();
                        }
                        if (n > WindowImpl.this.parentWindow.getHeight()) {
                            n = WindowImpl.this.parentWindow.getHeight();
                        }
                    }
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window fs: " + this.fullscreen + " " + n4 + "/" + n3 + " " + n2 + "x" + n + ", " + WindowImpl.this.isUndecorated() + ", virtl-screenSize: " + rectangleImmutable + ", monitorsViewport " + rectangle + ", spanning " + (0 != n5) + " @ " + Thread.currentThread().getName());
                }
                DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                displayImpl.dispatchMessagesNative();
                boolean bl = WindowImpl.this.isVisible();
                if (null != WindowImpl.this.parentWindow) {
                    if (!this.fullscreen && bl && NativeWindowFactory.TYPE_X11 == NativeWindowFactory.getNativeWindowType(true)) {
                        WindowImpl.this.setVisibleImpl(false, n6, n7, n8, n9);
                        WindowImpl.this.waitForVisible(false, false);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        displayImpl.dispatchMessagesNative();
                    }
                    if (1 >= (nativeWindow = WindowImpl.this.parentWindow).lockSurface()) {
                        throw new NativeWindowException("Parent surface lock: not ready: " + WindowImpl.this.parentWindow);
                    }
                } else {
                    nativeWindow = null;
                }
                try {
                    WindowImpl.this.reconfigureWindowImpl(n4, n3, n2, n, WindowImpl.this.getReconfigureFlags((null != nativeWindow ? 1 : 0) | n5 | 4 | 2, WindowImpl.this.isVisible()));
                }
                finally {
                    if (null != nativeWindow) {
                        nativeWindow.unlockSurface();
                    }
                }
                displayImpl.dispatchMessagesNative();
                if (bl) {
                    boolean bl2;
                    WindowImpl.this.setVisibleImpl(true, n4, n3, n2, n);
                    boolean bl3 = bl2 = 0L <= WindowImpl.this.waitForVisible(true, false);
                    if (bl2) {
                        bl2 = WindowImpl.this.waitForSize(n2, n, false, 1000L);
                    }
                    if (bl2 && !this.fullscreen) {
                        bl2 = WindowImpl.this.waitForPosition(true, n4, n3, 1000L);
                    }
                    if (bl2) {
                        WindowImpl.this.requestFocusInt(this.fullscreen);
                        displayImpl.dispatchMessagesNative();
                    }
                    if (Window.DEBUG_IMPLEMENTATION) {
                        System.err.println("Window fs done: ok " + bl2 + ", " + WindowImpl.this);
                    }
                }
            }
            finally {
                recursiveLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class SetPositionAction
    implements Runnable {
        int x;
        int y;

        private SetPositionAction(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window setPosition: " + WindowImpl.this.getX() + "/" + WindowImpl.this.getY() + " -> " + this.x + "/" + this.y + ", fs " + WindowImpl.this.fullscreen + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle));
                }
                if (!(WindowImpl.this.isFullscreen() || WindowImpl.this.getX() == this.x && WindowImpl.this.getY() == this.y)) {
                    if (WindowImpl.this.isNativeValid()) {
                        WindowImpl.this.reconfigureWindowImpl(this.x, this.y, WindowImpl.this.getWidth(), WindowImpl.this.getHeight(), WindowImpl.this.getReconfigureFlags(0, WindowImpl.this.isVisible()));
                        WindowImpl.this.waitForPosition(true, this.x, this.y, 1000L);
                    } else {
                        WindowImpl.this.definePosition(this.x, this.y);
                    }
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    }

    private class AlwaysOnTopAction
    implements Runnable {
        boolean alwaysOnTop;

        private AlwaysOnTopAction(boolean bl) {
            this.alwaysOnTop = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (WindowImpl.this.alwaysOnTop != this.alwaysOnTop) {
                    WindowImpl.this.alwaysOnTop = this.alwaysOnTop;
                    if (WindowImpl.this.isNativeValid()) {
                        int n = WindowImpl.this.getX();
                        int n2 = WindowImpl.this.getY();
                        int n3 = WindowImpl.this.getWidth();
                        int n4 = WindowImpl.this.getHeight();
                        DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                        displayImpl.dispatchMessagesNative();
                        WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, WindowImpl.this.getReconfigureFlags(8, WindowImpl.this.isVisible()));
                        displayImpl.dispatchMessagesNative();
                    }
                }
            }
            finally {
                recursiveLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class DecorationAction
    implements Runnable {
        boolean undecorated;

        private DecorationAction(boolean bl) {
            this.undecorated = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (WindowImpl.this.undecorated != this.undecorated) {
                    WindowImpl.this.undecorated = this.undecorated;
                    if (WindowImpl.this.isNativeValid() && !WindowImpl.this.isFullscreen()) {
                        int n = WindowImpl.this.getX();
                        int n2 = WindowImpl.this.getY();
                        int n3 = WindowImpl.this.getWidth();
                        int n4 = WindowImpl.this.getHeight();
                        DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                        displayImpl.dispatchMessagesNative();
                        WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, WindowImpl.this.getReconfigureFlags(2, WindowImpl.this.isVisible()));
                        displayImpl.dispatchMessagesNative();
                    }
                }
            }
            finally {
                recursiveLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class ReparentActionRecreate
    implements Runnable {
        private ReparentActionRecreate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparent: ReparentActionRecreate (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible: " + WindowImpl.this.visible + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow));
                }
                WindowImpl.this.setVisibleActionImpl(true);
                WindowImpl.this.requestFocusInt(0L == WindowImpl.this.parentWindowHandle);
            }
            finally {
                recursiveLock.unlock();
            }
        }
    }

    private class ReparentAction
    implements Runnable {
        final NativeWindow newParentWindow;
        final int topLevelX;
        final int topLevelY;
        boolean forceDestroyCreate;
        Window.ReparentOperation operation;

        private ReparentAction(NativeWindow nativeWindow, int n, int n2, boolean bl) {
            this.newParentWindow = nativeWindow;
            this.topLevelX = n;
            this.topLevelY = n2;
            this.forceDestroyCreate = bl | DEBUG_TEST_REPARENT_INCOMPATIBLE;
            this.operation = Window.ReparentOperation.ACTION_INVALID;
        }

        private Window.ReparentOperation getOp() {
            return this.operation;
        }

        private void setScreen(ScreenImpl screenImpl) {
            WindowImpl.this.removeScreenReference();
            WindowImpl.this.screen = screenImpl;
        }

        @Override
        public final void run() {
            boolean bl = false;
            if (null != WindowImpl.this.lifecycleHook) {
                bl = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
            this.reparent();
            if (bl) {
                WindowImpl.this.lifecycleHook.resumeRenderingAction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reparent() {
            boolean bl;
            int n = WindowImpl.this.getX();
            int n2 = WindowImpl.this.getY();
            int n3 = WindowImpl.this.getWidth();
            int n4 = WindowImpl.this.getHeight();
            int n5 = n3;
            int n6 = n4;
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                Object object;
                int n7;
                int n8;
                if (WindowImpl.this.isNativeValid()) {
                    this.forceDestroyCreate |= WindowImpl.isOffscreenInstance(WindowImpl.this, this.newParentWindow);
                }
                bl = WindowImpl.this.isVisible();
                Window window = null;
                if (this.newParentWindow instanceof Window) {
                    window = (Window)this.newParentWindow;
                }
                long l = 0L;
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparent: START (" + WindowImpl.getThreadName() + ") valid " + WindowImpl.this.isNativeValid() + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", visible " + bl + ", old parentWindow: " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + ", new parentWindow: " + Display.hashCodeNullSafe(this.newParentWindow) + ", forceDestroyCreate " + this.forceDestroyCreate);
                }
                if (null != this.newParentWindow) {
                    n8 = 0;
                    n7 = 0;
                    if (n5 > this.newParentWindow.getWidth()) {
                        n5 = this.newParentWindow.getWidth();
                    }
                    if (n6 > this.newParentWindow.getHeight()) {
                        n6 = this.newParentWindow.getHeight();
                    }
                    if (0L == (l = WindowImpl.getNativeWindowHandle(this.newParentWindow))) {
                        if (null == window) {
                            throw new NativeWindowException("Reparenting with non NEWT Window type only available after it's realized: " + this.newParentWindow);
                        }
                        WindowImpl.this.destroy(false);
                        this.setScreen((ScreenImpl)window.getScreen());
                        this.operation = Window.ReparentOperation.ACTION_NATIVE_CREATION_PENDING;
                    } else if (this.newParentWindow != WindowImpl.this.getParent()) {
                        if (!WindowImpl.this.isNativeValid()) {
                            if (null != window) {
                                this.setScreen((ScreenImpl)window.getScreen());
                            } else {
                                object = NewtFactory.createCompatibleScreen(this.newParentWindow, WindowImpl.this.screen);
                                if (WindowImpl.this.screen != object) {
                                    this.setScreen((ScreenImpl)object);
                                }
                            }
                            this.operation = 0 < n5 && 0 < n6 ? Window.ReparentOperation.ACTION_NATIVE_CREATION : Window.ReparentOperation.ACTION_NATIVE_CREATION_PENDING;
                        } else if (this.forceDestroyCreate || !NewtFactory.isScreenCompatible(this.newParentWindow, WindowImpl.this.screen)) {
                            WindowImpl.this.destroy(bl);
                            if (null != window) {
                                this.setScreen((ScreenImpl)window.getScreen());
                            } else {
                                this.setScreen((ScreenImpl)NewtFactory.createCompatibleScreen(this.newParentWindow, WindowImpl.this.screen));
                            }
                            this.operation = Window.ReparentOperation.ACTION_NATIVE_CREATION;
                        } else {
                            this.operation = Window.ReparentOperation.ACTION_NATIVE_REPARENTING;
                        }
                    } else {
                        this.operation = Window.ReparentOperation.ACTION_NOP;
                    }
                } else {
                    if (0 <= this.topLevelX && 0 <= this.topLevelY) {
                        n8 = this.topLevelX;
                        n7 = this.topLevelY;
                    } else if (null != WindowImpl.this.parentWindow) {
                        object = WindowImpl.this.getLocationOnScreen(null);
                        n8 = ((Point)object).getX();
                        n7 = ((Point)object).getY();
                    } else {
                        n8 = n;
                        n7 = n2;
                    }
                    if (0L == WindowImpl.this.parentWindowHandle) {
                        this.operation = Window.ReparentOperation.ACTION_NOP;
                    } else if (!WindowImpl.this.isNativeValid() || this.forceDestroyCreate) {
                        WindowImpl.this.destroy(WindowImpl.this.isNativeValid() && bl);
                        this.operation = 0 < n5 && 0 < n6 ? Window.ReparentOperation.ACTION_NATIVE_CREATION : Window.ReparentOperation.ACTION_NATIVE_CREATION_PENDING;
                    } else {
                        this.operation = Window.ReparentOperation.ACTION_NATIVE_REPARENTING;
                    }
                }
                WindowImpl.this.parentWindowHandle = l;
                if (Window.ReparentOperation.ACTION_INVALID == this.operation) {
                    throw new NativeWindowException("Internal Error: reparentAction not set");
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparent: ACTION (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " new parentWindowHandle " + WindowImpl.toHexString(l) + ", reparentAction " + (Object)((Object)this.operation) + ", pos/size " + n8 + "/" + n7 + " " + n5 + "x" + n6 + ", visible " + bl);
                }
                if (Window.ReparentOperation.ACTION_NOP == this.operation) {
                    return;
                }
                if (null != WindowImpl.this.parentWindow && WindowImpl.this.parentWindow instanceof Window) {
                    ((Window)WindowImpl.this.parentWindow).removeChild(WindowImpl.this);
                }
                WindowImpl.this.parentWindow = this.newParentWindow;
                if (WindowImpl.this.parentWindow instanceof Window) {
                    ((Window)WindowImpl.this.parentWindow).addChild(WindowImpl.this);
                }
                if (Window.ReparentOperation.ACTION_NATIVE_REPARENTING == this.operation) {
                    NativeWindow nativeWindow;
                    object = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                    ((DisplayImpl)object).dispatchMessagesNative();
                    if (null != WindowImpl.this.parentWindow && bl && NativeWindowFactory.TYPE_X11 == NativeWindowFactory.getNativeWindowType(true)) {
                        WindowImpl.this.setVisibleImpl(false, n, n2, n3, n4);
                        WindowImpl.this.waitForVisible(false, false);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ((DisplayImpl)object).dispatchMessagesNative();
                    }
                    if (null != WindowImpl.this.parentWindow) {
                        nativeWindow = WindowImpl.this.parentWindow;
                        if (1 >= nativeWindow.lockSurface()) {
                            throw new NativeWindowException("Parent surface lock: not ready: " + nativeWindow);
                        }
                        WindowImpl.this.parentWindowHandle = nativeWindow.getWindowHandle();
                    } else {
                        nativeWindow = null;
                    }
                    boolean bl2 = false;
                    try {
                        bl2 = WindowImpl.this.reconfigureWindowImpl(n8, n7, n5, n6, WindowImpl.this.getReconfigureFlags(3, WindowImpl.this.isVisible()));
                    }
                    finally {
                        if (null != nativeWindow) {
                            nativeWindow.unlockSurface();
                        }
                    }
                    WindowImpl.this.definePosition(n8, n7);
                    if (bl2) {
                        ((DisplayImpl)object).dispatchMessagesNative();
                        if (bl) {
                            WindowImpl.this.setVisibleImpl(true, n8, n7, n5, n6);
                            boolean bl3 = bl2 = 0L <= WindowImpl.this.waitForVisible(true, false);
                            if (bl2) {
                                bl2 = WindowImpl.this.waitForSize(n5, n6, false, 1000L);
                            }
                            if (bl2) {
                                bl2 = WindowImpl.this.waitForPosition(true, n8, n7, 1000L);
                            }
                            if (bl2) {
                                WindowImpl.this.requestFocusInt(0L == WindowImpl.this.parentWindowHandle);
                                ((DisplayImpl)object).dispatchMessagesNative();
                            }
                        }
                    }
                    if (!bl2 || !bl) {
                        WindowImpl.this.definePosition(n8, n7);
                        WindowImpl.this.defineSize(n5, n6);
                    }
                    if (!bl2) {
                        if (Window.DEBUG_IMPLEMENTATION) {
                            System.err.println("Window.reparent: native reparenting failed (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + " -> " + WindowImpl.toHexString(l) + " - Trying recreation");
                        }
                        WindowImpl.this.destroy(bl);
                        this.operation = Window.ReparentOperation.ACTION_NATIVE_CREATION;
                    }
                } else {
                    WindowImpl.this.definePosition(n8, n7);
                    WindowImpl.this.defineSize(n5, n6);
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparent: END-1 (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible: " + WindowImpl.this.visible + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + " " + WindowImpl.this.getX() + "/" + WindowImpl.this.getY() + " " + WindowImpl.this.getWidth() + "x" + WindowImpl.this.getHeight());
                }
            }
            finally {
                if (null != WindowImpl.this.lifecycleHook) {
                    WindowImpl.this.lifecycleHook.resetCounter();
                }
                recursiveLock.unlock();
            }
            if (bl) {
                switch (this.operation) {
                    case ACTION_NATIVE_REPARENTING: {
                        WindowImpl.this.sendWindowEvent(100);
                        break;
                    }
                    case ACTION_NATIVE_CREATION: {
                        WindowImpl.this.runOnEDTIfAvail(true, WindowImpl.this.reparentActionRecreate);
                        break;
                    }
                }
            }
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.reparent: END-X (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible: " + WindowImpl.this.visible + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + " " + WindowImpl.this.getX() + "/" + WindowImpl.this.getY() + " " + WindowImpl.this.getWidth() + "x" + WindowImpl.this.getHeight());
            }
        }
    }

    private class DestroyAction
    implements Runnable {
        private DestroyAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            boolean bl = false;
            if (null != WindowImpl.this.lifecycleHook) {
                bl = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
            if (null != WindowImpl.this.lifecycleHook) {
                WindowImpl.this.lifecycleHook.destroyActionPreLock();
            }
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window DestroyAction() hasScreen " + (null != WindowImpl.this.screen) + ", isNativeValid " + WindowImpl.this.isNativeValid() + " - " + WindowImpl.getThreadName());
                }
                WindowImpl.this.sendWindowEvent(102);
                Object object = WindowImpl.this.childWindowsLock;
                synchronized (object) {
                    if (WindowImpl.this.childWindows.size() > 0) {
                        ArrayList arrayList = (ArrayList)WindowImpl.this.childWindows.clone();
                        while (arrayList.size() > 0) {
                            NativeWindow nativeWindow = (NativeWindow)arrayList.remove(0);
                            if (nativeWindow instanceof WindowImpl) {
                                ((WindowImpl)nativeWindow).windowDestroyNotify(true);
                                continue;
                            }
                            nativeWindow.destroy();
                        }
                    }
                }
                if (null != WindowImpl.this.lifecycleHook) {
                    WindowImpl.this.lifecycleHook.destroyActionInLock();
                }
                if (WindowImpl.this.isNativeValid()) {
                    WindowImpl.this.screen.removeMonitorModeListener(WindowImpl.this.monitorModeListenerImpl);
                    WindowImpl.this.closeNativeImpl();
                    object = WindowImpl.this.config.getScreen().getDevice();
                    if (object != WindowImpl.this.screen.getDisplay().getGraphicsDevice()) {
                        object.close();
                    }
                    WindowImpl.this.setGraphicsConfiguration(null);
                }
                WindowImpl.this.removeScreenReference();
                object = WindowImpl.this.screen.getDisplay();
                if (null != object) {
                    ((Display)object).validateEDTStopped();
                }
                WindowImpl.this.sendWindowEvent(106);
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.destroy() END " + WindowImpl.getThreadName());
                }
            }
            finally {
                WindowImpl.this.setWindowHandle(0L);
                WindowImpl.this.visible = false;
                WindowImpl.this.fullscreen = false;
                WindowImpl.this.fullscreenMonitors = null;
                WindowImpl.this.fullscreenUseMainMonitor = true;
                WindowImpl.this.hasFocus = false;
                WindowImpl.this.parentWindowHandle = 0L;
                recursiveLock.unlock();
            }
            if (bl) {
                WindowImpl.this.lifecycleHook.resumeRenderingAction();
            }
        }
    }

    private class SetSizeAction
    implements Runnable {
        int width;
        int height;
        boolean disregardFS;

        private SetSizeAction(int n, int n2, boolean bl) {
            this.width = n;
            this.height = n2;
            this.disregardFS = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                int n;
                if (!this.disregardFS) {
                    if (WindowImpl.this.isFullscreen()) return;
                }
                if (WindowImpl.this.getWidth() == this.width) {
                    if (WindowImpl.this.getHeight() == this.height) return;
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window setSize: START " + WindowImpl.this.getWidth() + "x" + WindowImpl.this.getHeight() + " -> " + this.width + "x" + this.height + ", fs " + WindowImpl.this.fullscreen + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible " + WindowImpl.this.visible);
                }
                if (WindowImpl.this.visible && WindowImpl.this.isNativeValid() && (0 >= this.width || 0 >= this.height)) {
                    n = 1;
                    WindowImpl.this.defineSize(0, 0);
                } else if (WindowImpl.this.visible && !WindowImpl.this.isNativeValid() && 0 < this.width && 0 < this.height) {
                    n = 2;
                    WindowImpl.this.defineSize(this.width, this.height);
                } else if (WindowImpl.this.visible && WindowImpl.this.isNativeValid()) {
                    n = 0;
                    WindowImpl.this.reconfigureWindowImpl(WindowImpl.this.getX(), WindowImpl.this.getY(), this.width, this.height, WindowImpl.this.getReconfigureFlags(0, WindowImpl.this.isVisible()));
                    WindowImpl.this.waitForSize(this.width, this.height, false, 1000L);
                } else {
                    n = 0;
                    WindowImpl.this.defineSize(this.width, this.height);
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window setSize: END " + WindowImpl.this.getWidth() + "x" + WindowImpl.this.getHeight() + ", visibleAction " + n);
                }
                switch (n) {
                    case 1: {
                        WindowImpl.this.setVisibleActionImpl(false);
                        return;
                    }
                    case 2: {
                        WindowImpl.this.setVisibleActionImpl(true);
                        return;
                    }
                }
                return;
            }
            finally {
                recursiveLock.unlock();
            }
        }
    }

    private class VisibleAction
    implements Runnable {
        boolean visible;

        private VisibleAction(boolean bl) {
            this.visible = bl;
        }

        @Override
        public final void run() {
            WindowImpl.this.setVisibleActionImpl(this.visible);
        }
    }

    public static interface LifecycleHook {
        public void resetCounter();

        public void setVisibleActionPost(boolean var1, boolean var2);

        public void preserveGLStateAtDestroy(boolean var1);

        public void destroyActionPreLock();

        public void destroyActionInLock();

        public boolean pauseRenderingAction();

        public void resumeRenderingAction();

        public void shutdownRenderingAction();
    }

    private static class PointerState1
    extends PointerState0 {
        short buttonPressed = 0;
        int buttonPressedMask = 0;
        short lastButtonClickCount = 0;
        final Point[] movePositions = new Point[]{new Point(), new Point(), new Point(), new Point(), new Point(), new Point(), new Point(), new Point()};

        private PointerState1() {
        }

        @Override
        final void clearButton() {
            super.clearButton();
            this.lastButtonPressTime = 0L;
            this.lastButtonClickCount = 0;
            this.buttonPressed = 0;
            this.buttonPressedMask = 0;
        }

        final Point getMovePosition(int n) {
            if (0 <= n && n < this.movePositions.length) {
                return this.movePositions[n];
            }
            return null;
        }
    }

    private static class PointerState0 {
        boolean insideWindow = false;
        long lastButtonPressTime = 0L;

        private PointerState0() {
        }

        void clearButton() {
            this.lastButtonPressTime = 0L;
        }
    }
}

