/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.util.av.GLMediaPlayerImpl;

public class NullGLMediaPlayer
extends GLMediaPlayerImpl {
    private TextureData texData = null;
    private int pos_ms = 0;
    private long pos_start = 0L;

    @Override
    protected final boolean setPlaySpeedImpl(float f) {
        return false;
    }

    @Override
    protected final boolean playImpl() {
        this.pos_start = Platform.currentTimeMillis();
        return true;
    }

    @Override
    protected final boolean pauseImpl() {
        return true;
    }

    @Override
    protected final int seekImpl(int n) {
        this.pos_ms = n;
        this.validatePos();
        return this.pos_ms;
    }

    @Override
    protected final int getNextTextureImpl(GL gL, TextureSequence.TextureFrame textureFrame) {
        int n = this.getAudioPTSImpl();
        textureFrame.setPTS(n);
        return n;
    }

    @Override
    protected final int getAudioPTSImpl() {
        this.pos_ms = (int)(Platform.currentTimeMillis() - this.pos_start);
        this.validatePos();
        return this.pos_ms;
    }

    @Override
    protected final void destroyImpl(GL gL) {
        if (null != this.texData) {
            this.texData.destroy();
            this.texData = null;
        }
    }

    public static final TextureData createTestTextureData() {
        TextureData textureData = null;
        try {
            URLConnection uRLConnection = IOUtil.getResource((String)"jogl/util/data/av/test-ntsc01-160x90.png", (ClassLoader)NullGLMediaPlayer.class.getClassLoader());
            if (null != uRLConnection) {
                textureData = TextureIO.newTextureData(GLProfile.getGL2ES2(), uRLConnection.getInputStream(), false, "png");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (null == textureData) {
            ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)57600);
            while (byteBuffer.hasRemaining()) {
                byteBuffer.put((byte)-22);
                byteBuffer.put((byte)-22);
                byteBuffer.put((byte)-22);
                byteBuffer.put((byte)-22);
            }
            byteBuffer.rewind();
            textureData = new TextureData(GLProfile.getGL2ES2(), 6408, 160, 90, 0, 6408, 5121, false, false, false, byteBuffer, null);
        }
        return textureData;
    }

    @Override
    protected final void initStreamImpl(int n, int n2) throws IOException {
        this.texData = NullGLMediaPlayer.createTestTextureData();
        this.updateAttributes(0, -2, this.texData.getWidth(), this.texData.getHeight(), 0, 0, 0, 24.0f, 14400, 0, 600000, "png-static", null);
    }

    @Override
    protected final void initGLImpl(GL gL) throws IOException, GLException {
        this.isInGLOrientation = true;
    }

    @Override
    protected int validateTextureCount(int n) {
        return 1;
    }

    @Override
    protected final TextureSequence.TextureFrame createTexImage(GL gL, int n) {
        Texture texture = super.createTexImageImpl(gL, n, this.width, this.height);
        if (null != this.texData) {
            texture.updateImage(gL, this.texData);
        }
        return new TextureSequence.TextureFrame(texture);
    }

    @Override
    protected final void destroyTexFrame(GL gL, TextureSequence.TextureFrame textureFrame) {
        super.destroyTexFrame(gL, textureFrame);
    }

    private void validatePos() {
        boolean bl = false;
        if (0 > this.pos_ms) {
            this.pos_ms = 0;
            bl = true;
        } else if (this.pos_ms > this.getDuration()) {
            this.pos_ms = this.getDuration();
            bl = true;
        }
        if (bl && this.state == GLMediaPlayer.State.Playing) {
            this.state = GLMediaPlayer.State.Paused;
        }
    }
}

