/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event.awt;

import com.jogamp.newt.Window;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventListener;
import java.awt.Component;
import java.util.EventListener;
import javax.media.nativewindow.NativeSurfaceHolder;
import jogamp.newt.Debug;

public abstract class AWTAdapter
implements EventListener {
    public static final boolean DEBUG_IMPLEMENTATION = Debug.debug("Window");
    NEWTEventListener newtListener;
    Window newtWindow;
    NativeSurfaceHolder nsHolder;
    boolean consumeAWTEvent;
    protected boolean isSetup;

    protected AWTAdapter(NEWTEventListener nEWTEventListener, NativeSurfaceHolder nativeSurfaceHolder) {
        if (null == nEWTEventListener) {
            throw new IllegalArgumentException("Argument newtListener is null");
        }
        if (null == nativeSurfaceHolder) {
            throw new IllegalArgumentException("Argument nwProxy is null");
        }
        this.newtListener = nEWTEventListener;
        this.newtWindow = null;
        this.nsHolder = nativeSurfaceHolder;
        this.consumeAWTEvent = false;
        this.isSetup = true;
    }

    protected AWTAdapter(NEWTEventListener nEWTEventListener, Window window) {
        if (null == nEWTEventListener) {
            throw new IllegalArgumentException("Argument newtListener is null");
        }
        if (null == window) {
            throw new IllegalArgumentException("Argument newtProxy is null");
        }
        this.newtListener = nEWTEventListener;
        this.newtWindow = window;
        this.nsHolder = window;
        this.consumeAWTEvent = false;
        this.isSetup = true;
    }

    protected AWTAdapter(Window window) throws IllegalStateException {
        this();
        this.setDownstream(window);
    }

    public AWTAdapter() {
        this.clear();
        this.consumeAWTEvent = false;
    }

    public synchronized AWTAdapter setDownstream(Window window) throws IllegalStateException {
        if (null == window) {
            throw new RuntimeException("Argument downstream is null");
        }
        this.newtListener = null;
        this.newtWindow = window;
        this.nsHolder = window;
        if (null == this.newtWindow.getScreen().getDisplay().getEDTUtil()) {
            throw new IllegalStateException("EDT not enabled");
        }
        this.isSetup = true;
        return this;
    }

    public synchronized AWTAdapter clear() {
        this.newtListener = null;
        this.newtWindow = null;
        this.nsHolder = null;
        this.isSetup = false;
        this.consumeAWTEvent = false;
        return this;
    }

    public final synchronized void setConsumeAWTEvent(boolean bl) {
        this.consumeAWTEvent = bl;
    }

    public final synchronized NativeSurfaceHolder getNativeSurfaceHolder() {
        return this.nsHolder;
    }

    public final synchronized Window getNewtWindow() {
        return this.newtWindow;
    }

    public final synchronized NEWTEventListener getNewtEventListener() {
        return this.newtListener;
    }

    public abstract AWTAdapter addTo(Component var1);

    public abstract AWTAdapter removeFrom(Component var1);

    EventProcRes processEvent(boolean bl, NEWTEvent nEWTEvent) {
        if (null != this.newtListener) {
            return EventProcRes.DISPATCH;
        }
        if (null != this.newtWindow) {
            this.newtWindow.enqueueEvent(bl, nEWTEvent);
            return EventProcRes.ENQUEUED;
        }
        return EventProcRes.NOP;
    }

    static enum EventProcRes {
        DISPATCH,
        ENQUEUED,
        NOP;

    }
}

