/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow.util;

import javax.media.nativewindow.util.DimensionImmutable;

public class SurfaceSize
implements Comparable<SurfaceSize> {
    final DimensionImmutable resolution;
    final int bitsPerPixel;

    public SurfaceSize(DimensionImmutable dimensionImmutable, int n) {
        if (null == dimensionImmutable || n <= 0) {
            throw new IllegalArgumentException("resolution must be set and bitsPerPixel greater 0");
        }
        this.resolution = dimensionImmutable;
        this.bitsPerPixel = n;
    }

    public final DimensionImmutable getResolution() {
        return this.resolution;
    }

    public final int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public final String toString() {
        return "[ " + this.resolution + " pixels x " + this.bitsPerPixel + " bpp ]";
    }

    @Override
    public int compareTo(SurfaceSize surfaceSize) {
        int n = this.resolution.compareTo(surfaceSize.getResolution());
        if (0 != n) {
            return n;
        }
        int n2 = surfaceSize.getBitsPerPixel();
        if (this.bitsPerPixel > n2) {
            return 1;
        }
        if (this.bitsPerPixel < n2) {
            return -1;
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SurfaceSize) {
            SurfaceSize surfaceSize = (SurfaceSize)object;
            return this.getResolution().equals(surfaceSize.getResolution()) && this.getBitsPerPixel() == surfaceSize.getBitsPerPixel();
        }
        return false;
    }

    public final int hashCode() {
        int n = 31 + this.getResolution().hashCode();
        n = (n << 5) - n + this.getBitsPerPixel();
        return n;
    }
}

