/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow;

import javax.media.nativewindow.NativeWindowFactory;

public class SurfaceScaleUtils {
    private static final int[] PlatformMaxPixelScale;
    private static final boolean PlatformUniformPixelScale;
    private static final boolean PlatformPixelScaleSupported;

    public static boolean computePixelScale(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, String string) {
        boolean bl;
        int n = 0 < nArray4[0] ? nArray4[0] : 1;
        int n2 = 0 < nArray4[1] ? nArray4[1] : 1;
        boolean bl2 = 1 != nArray3[0] || 1 != nArray3[1];
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        if (bl2) {
            nArray[0] = n;
            nArray[1] = n2;
        } else {
            nArray[0] = 1;
            nArray[1] = 1;
        }
        boolean bl3 = bl = nArray[0] != n3 || nArray[1] != n4;
        if (null != string) {
            System.err.println(string + ".computePixelScale: useHiDPI " + bl2 + ", [" + n3 + "x" + n4 + " (pre), " + nArray3[0] + "x" + nArray3[1] + " (req)] -> " + nArray4[0] + "x" + nArray4[1] + " (raw) -> " + n + "x" + n2 + " (safe) -> " + nArray[0] + "x" + nArray[1] + " (use), changed " + bl);
        }
        return bl;
    }

    public static void validateReqPixelScale(int[] nArray, int[] nArray2, String string) {
        int n = Math.min(nArray2[0], nArray2[1]);
        if (0 >= n) {
            nArray[0] = 0;
            nArray[1] = 0;
        } else if (PlatformUniformPixelScale) {
            int n2 = Math.max(nArray2[0], nArray2[1]);
            if (n2 >= PlatformMaxPixelScale[0]) {
                nArray[0] = PlatformMaxPixelScale[0];
                nArray[1] = PlatformMaxPixelScale[1];
            } else {
                nArray[0] = n2;
                nArray[1] = n2;
            }
        } else {
            nArray[0] = nArray2[0] >= PlatformMaxPixelScale[0] ? PlatformMaxPixelScale[0] : nArray2[0];
            nArray[1] = nArray2[1] >= PlatformMaxPixelScale[1] ? PlatformMaxPixelScale[1] : nArray2[1];
        }
        if (null != string) {
            System.err.println(string + ".validateReqPixelScale: [" + nArray2[0] + "x" + nArray2[1] + " (req), " + PlatformMaxPixelScale[0] + "x" + PlatformMaxPixelScale[1] + " (max)] -> " + nArray[0] + "x" + nArray[1] + " (valid)");
        }
    }

    public static void replaceAutoMaxWithPlatformMax(int[] nArray) {
        if (0 == nArray[0]) {
            nArray[0] = PlatformMaxPixelScale[0];
        }
        if (0 == nArray[1]) {
            nArray[1] = PlatformMaxPixelScale[1];
        }
    }

    public static int[] getPlatformMaxPixelScale(int[] nArray) {
        System.arraycopy(PlatformMaxPixelScale, 0, nArray, 0, 2);
        return nArray;
    }

    public static boolean isPlatformPixelScaleUniform() {
        return PlatformUniformPixelScale;
    }

    public static boolean isPlatformPixelScaleSupported() {
        return PlatformPixelScaleSupported;
    }

    static {
        if (NativeWindowFactory.TYPE_MACOSX == NativeWindowFactory.getNativeWindowType(true)) {
            PlatformMaxPixelScale = new int[]{2, 2};
            PlatformUniformPixelScale = true;
            PlatformPixelScaleSupported = true;
        } else {
            PlatformMaxPixelScale = new int[]{1, 1};
            PlatformUniformPixelScale = false;
            PlatformPixelScaleSupported = false;
        }
    }
}

