/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt.windows;

import com.jogamp.nativewindow.awt.JAWTWindow;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.nativewindow.jawt.JAWT_DrawingSurface;
import jogamp.nativewindow.jawt.JAWT_DrawingSurfaceInfo;
import jogamp.nativewindow.jawt.windows.JAWT_Win32DrawingSurfaceInfo;
import jogamp.nativewindow.windows.GDIUtil;

public class WindowsJAWTWindow
extends JAWTWindow {
    private JAWT_DrawingSurface ds;
    private boolean dsLocked;
    private JAWT_DrawingSurfaceInfo dsi;
    private JAWT_Win32DrawingSurfaceInfo win32dsi;
    protected long windowHandle;

    public WindowsJAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        super(object, abstractGraphicsConfiguration);
    }

    @Override
    protected void invalidateNative() {
        this.windowHandle = 0L;
    }

    @Override
    protected JAWT fetchJAWTImpl() throws NativeWindowException {
        return JAWTUtil.getJAWT(false);
    }

    @Override
    protected int lockSurfaceImpl() throws NativeWindowException {
        int n = 3;
        this.ds = this.getJAWT().GetDrawingSurface(this.component);
        if (this.ds == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        int n2 = this.ds.Lock();
        boolean bl = this.dsLocked = 0 == (n2 & 1);
        if (!this.dsLocked) {
            this.unlockSurfaceImpl();
            throw new NativeWindowException("Unable to lock surface");
        }
        if ((n2 & 8) != 0) {
            n = 2;
        }
        this.dsi = this.ds.GetDrawingSurfaceInfo();
        if (this.dsi == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        this.updateLockedData(this.dsi.getBounds());
        this.win32dsi = (JAWT_Win32DrawingSurfaceInfo)this.dsi.platformInfo(this.getJAWT());
        if (this.win32dsi == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        this.windowHandle = this.win32dsi.getHandle();
        this.drawable = this.win32dsi.getHdc();
        if (this.windowHandle == 0L || this.drawable == 0L) {
            this.unlockSurfaceImpl();
            return 1;
        }
        return n;
    }

    @Override
    protected void unlockSurfaceImpl() throws NativeWindowException {
        this.drawable = 0L;
        if (null != this.ds) {
            if (null != this.dsi) {
                this.ds.FreeDrawingSurfaceInfo(this.dsi);
            }
            if (this.dsLocked) {
                this.ds.Unlock();
            }
            this.getJAWT().FreeDrawingSurface(this.ds);
        }
        this.ds = null;
        this.dsi = null;
        this.win32dsi = null;
    }

    @Override
    public long getWindowHandle() {
        return this.windowHandle;
    }

    @Override
    protected Point getLocationOnScreenNativeImpl(int n, int n2) {
        return GDIUtil.GetRelativeLocation(this.getWindowHandle(), 0L, n, n2);
    }
}

