/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.swt;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.swt.SWTAccessor;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.opengl.JoglVersion;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.nativewindow.VisualIDHolder;
import javax.media.opengl.GL;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import javax.media.opengl.GLSharedContextSetter;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableHelper;
import jogamp.opengl.GLDrawableImpl;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class GLCanvas
extends Canvas
implements GLAutoDrawable,
GLSharedContextSetter {
    private static final boolean DEBUG = Debug.debug("GLCanvas");
    private final RecursiveLock lock = LockFactory.createRecursiveLock();
    private final GLDrawableHelper helper = new GLDrawableHelper();
    private final GLCapabilitiesImmutable capsRequested;
    private final GLCapabilitiesChooser capsChooser;
    private volatile Rectangle clientArea;
    private volatile GLDrawableImpl drawable;
    private volatile GLContextImpl context;
    private final boolean useX11GTK;
    private volatile long gdkWindow;
    private volatile long x11Window;
    private final AbstractGraphicsScreen screen;
    private int additionalCtxCreationFlags = 0;
    private volatile boolean sendReshape;
    private final Runnable initAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.helper.init(GLCanvas.this, !GLCanvas.this.sendReshape);
        }
    };
    private final Runnable displayAction = new Runnable(){

        @Override
        public void run() {
            if (GLCanvas.this.sendReshape) {
                GLCanvas.this.helper.reshape(GLCanvas.this, 0, 0, ((GLCanvas)GLCanvas.this).clientArea.width, ((GLCanvas)GLCanvas.this).clientArea.height);
                GLCanvas.this.sendReshape = false;
            }
            GLCanvas.this.helper.display(GLCanvas.this);
        }
    };
    private final Runnable makeCurrentAndDisplayOnGLAction = new Runnable(){

        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                if (!GLCanvas.this.isDisposed()) {
                    GLCanvas.this.helper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.displayAction, GLCanvas.this.initAction);
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final Runnable swapBuffersOnGLAction = new Runnable(){

        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                boolean bl;
                boolean bl2 = bl = null != GLCanvas.this.drawable && GLCanvas.this.drawable.isRealized();
                if (bl && !GLCanvas.this.isDisposed()) {
                    GLCanvas.this.drawable.swapBuffers();
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final Runnable disposeOnEDTGLAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                GLAnimatorControl gLAnimatorControl = GLCanvas.this.getAnimator();
                boolean bl = null != gLAnimatorControl ? gLAnimatorControl.pause() : false;
                GLException gLException = null;
                if (null != GLCanvas.this.context) {
                    if (GLCanvas.this.context.isCreated()) {
                        try {
                            if (!GLCanvas.this.isDisposed()) {
                                GLCanvas.this.helper.disposeGL(GLCanvas.this, GLCanvas.this.context, true);
                            } else {
                                GLCanvas.this.context.destroy();
                            }
                        }
                        catch (GLException gLException2) {
                            gLException = gLException2;
                        }
                    }
                    GLCanvas.this.context = null;
                }
                Throwable throwable = null;
                if (null != GLCanvas.this.drawable) {
                    try {
                        GLCanvas.this.drawable.setRealized(false);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                    GLCanvas.this.drawable = null;
                }
                Throwable throwable3 = null;
                try {
                    if (0L != GLCanvas.this.x11Window) {
                        SWTAccessor.destroyX11Window(GLCanvas.this.screen.getDevice(), GLCanvas.this.x11Window);
                        GLCanvas.this.x11Window = 0L;
                    } else if (0L != GLCanvas.this.gdkWindow) {
                        SWTAccessor.destroyGDKWindow(GLCanvas.this.gdkWindow);
                        GLCanvas.this.gdkWindow = 0L;
                    }
                    GLCanvas.this.screen.getDevice().close();
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                }
                if (bl) {
                    gLAnimatorControl.resume();
                }
                if (null != gLException) {
                    throw gLException;
                }
                if (null != throwable) {
                    throw GLException.newGLException(throwable);
                }
                if (null != throwable3) {
                    throw GLException.newGLException(throwable3);
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final UpstreamSurfaceHook swtCanvasUpStreamHook = new UpstreamSurfaceHook(){

        @Override
        public final void create(ProxySurface proxySurface) {
        }

        @Override
        public final void destroy(ProxySurface proxySurface) {
        }

        @Override
        public final int getSurfaceWidth(ProxySurface proxySurface) {
            return ((GLCanvas)GLCanvas.this).clientArea.width;
        }

        @Override
        public final int getSurfaceHeight(ProxySurface proxySurface) {
            return ((GLCanvas)GLCanvas.this).clientArea.height;
        }

        public String toString() {
            return "SWTCanvasUpstreamSurfaceHook[upstream: " + GLCanvas.this.toString() + ", " + ((GLCanvas)GLCanvas.this).clientArea.width + "x" + ((GLCanvas)GLCanvas.this).clientArea.height + "]";
        }

        @Override
        public final NativeSurface getUpstreamSurface() {
            return null;
        }
    };
    private boolean isValidAndVisibleOnEDTActionResult;
    private final Runnable isValidAndVisibleOnEDTAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.isValidAndVisibleOnEDTActionResult = !GLCanvas.this.isDisposed() && GLCanvas.this.isVisible();
        }
    };

    private static String getThreadName() {
        return Thread.currentThread().getName();
    }

    private static String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    private static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    public static GLCanvas create(final Composite composite, final int n, final GLCapabilitiesImmutable gLCapabilitiesImmutable, final GLCapabilitiesChooser gLCapabilitiesChooser) {
        final GLCanvas[] gLCanvasArray = new GLCanvas[]{null};
        composite.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                gLCanvasArray[0] = new GLCanvas(composite, n, gLCapabilitiesImmutable, gLCapabilitiesChooser);
            }
        });
        return gLCanvasArray[0];
    }

    public GLCanvas(Composite composite, int n, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(composite, n | 0x40000);
        GLProfile.initSingleton();
        SWTAccessor.setRealized((Control)this, true);
        this.clientArea = this.getClientArea();
        AbstractGraphicsDevice abstractGraphicsDevice = SWTAccessor.getDevice((Control)this);
        this.useX11GTK = SWTAccessor.useX11GTK();
        if (this.useX11GTK) {
            long l = X11Util.openDisplay(abstractGraphicsDevice.getConnection());
            if (0L == l) {
                throw new RuntimeException("Error creating display(EDT): " + abstractGraphicsDevice.getConnection());
            }
            X11GraphicsDevice x11GraphicsDevice = new X11GraphicsDevice(l, 0, true);
            this.screen = SWTAccessor.getScreen(x11GraphicsDevice, -1);
        } else {
            this.screen = SWTAccessor.getScreen(abstractGraphicsDevice, -1);
        }
        this.capsRequested = null == gLCapabilitiesImmutable ? new GLCapabilities(GLProfile.getDefault(this.screen.getDevice())) : (GLCapabilitiesImmutable)gLCapabilitiesImmutable.cloneMutable();
        this.capsChooser = gLCapabilitiesChooser;
        this.gdkWindow = 0L;
        this.x11Window = 0L;
        this.drawable = null;
        this.context = null;
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        GLCanvas.this.displayIfNoAnimatorNoCheck();
                        break;
                    }
                    case 11: {
                        GLCanvas.this.updateSizeCheck();
                        break;
                    }
                    case 12: {
                        GLCanvas.this.dispose();
                    }
                }
            }
        };
        this.addListener(11, listener);
        this.addListener(9, listener);
        this.addListener(12, listener);
    }

    @Override
    public final void setSharedContext(GLContext gLContext) throws IllegalStateException {
        this.helper.setSharedContext(this.context, gLContext);
    }

    @Override
    public final void setSharedAutoDrawable(GLAutoDrawable gLAutoDrawable) throws IllegalStateException {
        this.helper.setSharedAutoDrawable(this, gLAutoDrawable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateSizeCheck() {
        Rectangle rectangle = this.clientArea;
        Rectangle rectangle2 = this.getClientArea();
        if (rectangle2 != null && (rectangle2.width != rectangle.width || rectangle2.height != rectangle.height)) {
            boolean bl;
            this.clientArea = rectangle2;
            GLDrawableImpl gLDrawableImpl = this.drawable;
            boolean bl2 = bl = null != gLDrawableImpl && gLDrawableImpl.isRealized();
            if (DEBUG) {
                long l = bl ? gLDrawableImpl.getHandle() : 0L;
                System.err.println(GLCanvas.getThreadName() + ": GLCanvas.sizeChanged: (" + Thread.currentThread().getName() + "): " + rectangle2.x + "/" + rectangle2.y + " " + rectangle2.width + "x" + rectangle2.height + " - drawableHandle " + GLCanvas.toHexString(l));
            }
            if (bl && !gLDrawableImpl.getChosenGLCapabilities().isOnscreen()) {
                RecursiveLock recursiveLock = this.lock;
                recursiveLock.lock();
                try {
                    GLDrawableImpl gLDrawableImpl2 = GLDrawableHelper.resizeOffscreenDrawable(gLDrawableImpl, this.context, rectangle2.width, rectangle2.height);
                    if (gLDrawableImpl != gLDrawableImpl2) {
                        this.drawable = gLDrawableImpl2;
                    }
                }
                finally {
                    recursiveLock.unlock();
                }
            }
            if (0L != this.x11Window) {
                SWTAccessor.resizeX11Window(this.screen.getDevice(), this.clientArea, this.x11Window);
            } else if (0L != this.gdkWindow) {
                SWTAccessor.resizeGDKWindow(this.clientArea, this.gdkWindow);
            }
            this.sendReshape = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isValidAndVisibleOnEDT() {
        Runnable runnable = this.isValidAndVisibleOnEDTAction;
        synchronized (runnable) {
            this.runOnEDTIfAvail(true, this.isValidAndVisibleOnEDTAction);
            return this.isValidAndVisibleOnEDTActionResult;
        }
    }

    protected final boolean validateDrawableAndContextWithCheck() {
        if (!this.isValidAndVisibleOnEDT()) {
            return false;
        }
        return this.validateDrawableAndContextPostCheck();
    }

    private final boolean isDrawableAndContextValid() {
        return null != this.drawable && null != this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean validateDrawableAndContextPostCheck() {
        boolean bl;
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            GLDrawableImpl gLDrawableImpl;
            if (null == this.drawable) {
                this.createDrawableImpl();
            }
            if (null != (gLDrawableImpl = this.drawable)) {
                bl = null == this.context ? this.createContextImpl(gLDrawableImpl) : true;
                if (bl) {
                    this.sendReshape = true;
                }
            } else {
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": SWT.GLCanvas.validate " + GLCanvas.toHexString(this.hashCode()) + ": null drawable");
                }
                bl = false;
            }
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": SWT.GLCanvas.validate.X  " + GLCanvas.toHexString(this.hashCode()) + ": " + bl + ", drawable-realized " + this.drawable.isRealized() + ", has context " + (null != this.context));
            }
        }
        finally {
            recursiveLock.unlock();
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void createDrawableImpl() {
        long l;
        Object object;
        Object object2;
        Rectangle rectangle = this.clientArea;
        if (0 >= rectangle.width || 0 >= rectangle.height) {
            if (!DEBUG) return;
            System.err.println(GLCanvas.getThreadName() + ": SWT.GLCanvas.validate.X " + GLCanvas.toHexString(this.hashCode()) + ": drawable could not be created: size < 0x0");
            return;
        }
        AbstractGraphicsDevice abstractGraphicsDevice = this.screen.getDevice();
        abstractGraphicsDevice.open();
        if (this.useX11GTK) {
            object2 = GraphicsConfigurationFactory.getFactory(abstractGraphicsDevice, this.capsRequested);
            object = ((GraphicsConfigurationFactory)object2).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capsChooser, this.screen, 0);
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": SWT.GLCanvas.X11 " + GLCanvas.toHexString(this.hashCode()) + ": factory: " + object2 + ", chosen config: " + object);
            }
            if (null == object) {
                throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
            }
            int n = object.getVisualID(VisualIDHolder.VIDType.NATIVE);
            if (0 == n) throw new GLException("Could not choose valid visualID: " + GLCanvas.toHexString(n) + ", " + this);
            l = this.x11Window = SWTAccessor.createCompatibleX11ChildWindow(this.screen, (Control)this, n, this.clientArea.width, this.clientArea.height);
        } else {
            l = SWTAccessor.getWindowHandle((Control)this);
        }
        object2 = GLDrawableFactory.getFactory(this.capsRequested.getGLProfile());
        object = ((GLDrawableFactory)object2).createProxySurface(abstractGraphicsDevice, this.screen.getIndex(), l, this.capsRequested, this.capsChooser, this.swtCanvasUpStreamHook);
        GLDrawableImpl gLDrawableImpl = (GLDrawableImpl)((GLDrawableFactory)object2).createGLDrawable((NativeSurface)object);
        gLDrawableImpl.setRealized(true);
        if (!gLDrawableImpl.isRealized()) {
            if (!DEBUG) return;
            System.err.println(GLCanvas.getThreadName() + ": SWT.GLCanvas.validate.X " + GLCanvas.toHexString(this.hashCode()) + ": Drawable could not be realized: " + gLDrawableImpl);
            return;
        } else {
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": SWT.GLCanvas.validate " + GLCanvas.toHexString(this.hashCode()) + ": Drawable created and realized");
            }
            this.drawable = gLDrawableImpl;
        }
    }

    private boolean createContextImpl(GLDrawable gLDrawable) {
        GLContext[] gLContextArray = new GLContext[]{null};
        if (!this.helper.isSharedGLContextPending(gLContextArray)) {
            this.context = (GLContextImpl)gLDrawable.createContext(gLContextArray[0]);
            this.context.setContextCreationFlags(this.additionalCtxCreationFlags);
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": SWT.GLCanvas.validate " + GLCanvas.toHexString(this.hashCode()) + ": Context created: has shared " + (null != gLContextArray[0]));
            }
            return true;
        }
        if (DEBUG) {
            System.err.println(GLCanvas.getThreadName() + ": SWT.GLCanvas.validate " + GLCanvas.toHexString(this.hashCode()) + ": Context !created: pending share");
        }
        return false;
    }

    public void update() {
    }

    public void dispose() {
        this.runInGLThread(this.disposeOnEDTGLAction);
        super.dispose();
    }

    private final void displayIfNoAnimatorNoCheck() {
        if (!this.helper.isAnimatorAnimatingOnOtherThread() && (this.isDrawableAndContextValid() || this.validateDrawableAndContextPostCheck())) {
            this.runInGLThread(this.makeCurrentAndDisplayOnGLAction);
        }
    }

    @Override
    public void display() {
        if (this.isDrawableAndContextValid() || this.validateDrawableAndContextWithCheck()) {
            this.runInGLThread(this.makeCurrentAndDisplayOnGLAction);
        }
    }

    @Override
    public final Object getUpstreamWidget() {
        return this;
    }

    @Override
    public final RecursiveLock getUpstreamLock() {
        return this.lock;
    }

    @Override
    public int getSurfaceWidth() {
        return this.clientArea.width;
    }

    @Override
    public int getSurfaceHeight() {
        return this.clientArea.height;
    }

    @Override
    public boolean isGLOriented() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.isGLOriented() : true;
    }

    @Override
    public void addGLEventListener(GLEventListener gLEventListener) {
        this.helper.addGLEventListener(gLEventListener);
    }

    @Override
    public void addGLEventListener(int n, GLEventListener gLEventListener) throws IndexOutOfBoundsException {
        this.helper.addGLEventListener(n, gLEventListener);
    }

    @Override
    public int getGLEventListenerCount() {
        return this.helper.getGLEventListenerCount();
    }

    @Override
    public GLEventListener getGLEventListener(int n) throws IndexOutOfBoundsException {
        return this.helper.getGLEventListener(n);
    }

    @Override
    public boolean areAllGLEventListenerInitialized() {
        return this.helper.areAllGLEventListenerInitialized();
    }

    @Override
    public boolean getGLEventListenerInitState(GLEventListener gLEventListener) {
        return this.helper.getGLEventListenerInitState(gLEventListener);
    }

    @Override
    public void setGLEventListenerInitState(GLEventListener gLEventListener, boolean bl) {
        this.helper.setGLEventListenerInitState(gLEventListener, bl);
    }

    @Override
    public GLEventListener disposeGLEventListener(GLEventListener gLEventListener, boolean bl) {
        DisposeGLEventListenerAction disposeGLEventListenerAction = new DisposeGLEventListenerAction(gLEventListener, bl);
        this.runInGLThread(disposeGLEventListenerAction);
        return disposeGLEventListenerAction.listener;
    }

    @Override
    public GLEventListener removeGLEventListener(GLEventListener gLEventListener) {
        return this.helper.removeGLEventListener(gLEventListener);
    }

    @Override
    public void destroy() {
        this.dispose();
    }

    @Override
    public GLAnimatorControl getAnimator() {
        return this.helper.getAnimator();
    }

    @Override
    public final Thread setExclusiveContextThread(Thread thread) throws GLException {
        return this.helper.setExclusiveContextThread(thread, this.context);
    }

    @Override
    public final Thread getExclusiveContextThread() {
        return this.helper.getExclusiveContextThread();
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        return this.helper.getAutoSwapBufferMode();
    }

    @Override
    public final GLDrawable getDelegatedDrawable() {
        return this.drawable;
    }

    @Override
    public GLContext getContext() {
        return this.context;
    }

    @Override
    public int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public GL getGL() {
        GLContextImpl gLContextImpl = this.context;
        return null == gLContextImpl ? null : ((GLContext)gLContextImpl).getGL();
    }

    @Override
    public boolean invoke(boolean bl, GLRunnable gLRunnable) throws IllegalStateException {
        return this.helper.invoke((GLAutoDrawable)this, bl, gLRunnable);
    }

    @Override
    public boolean invoke(boolean bl, List<GLRunnable> list) throws IllegalStateException {
        return this.helper.invoke((GLAutoDrawable)this, bl, list);
    }

    @Override
    public void flushGLRunnables() {
        this.helper.flushGLRunnables();
    }

    @Override
    public void setAnimator(GLAnimatorControl gLAnimatorControl) throws GLException {
        this.helper.setAnimator(gLAnimatorControl);
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
        this.helper.setAutoSwapBufferMode(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLContext setContext(GLContext gLContext, boolean bl) {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            GLContextImpl gLContextImpl = this.context;
            GLDrawableHelper.switchContext(this.drawable, gLContextImpl, bl, gLContext, this.additionalCtxCreationFlags);
            this.context = (GLContextImpl)gLContext;
            GLContextImpl gLContextImpl2 = gLContextImpl;
            return gLContextImpl2;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public void setContextCreationFlags(int n) {
        this.additionalCtxCreationFlags = n;
        GLContextImpl gLContextImpl = this.context;
        if (null != gLContextImpl) {
            ((GLContext)gLContextImpl).setContextCreationFlags(this.additionalCtxCreationFlags);
        }
    }

    @Override
    public GL setGL(GL gL) {
        GLContextImpl gLContextImpl = this.context;
        if (null != gLContextImpl) {
            ((GLContext)gLContextImpl).setGL(gL);
            return gL;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLContext createContext(GLContext gLContext) {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            if (this.drawable != null) {
                GLContext gLContext2 = this.drawable.createContext(gLContext);
                gLContext2.setContextCreationFlags(this.additionalCtxCreationFlags);
                GLContext gLContext3 = gLContext2;
                return gLContext3;
            }
            GLContext gLContext4 = null;
            return gLContext4;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getChosenGLCapabilities() : null;
    }

    @Override
    public GLCapabilitiesImmutable getRequestedGLCapabilities() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getRequestedGLCapabilities() : null;
    }

    @Override
    public GLDrawableFactory getFactory() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return gLDrawableImpl != null ? gLDrawableImpl.getFactory() : null;
    }

    @Override
    public GLProfile getGLProfile() {
        return this.capsRequested.getGLProfile();
    }

    @Override
    public long getHandle() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return gLDrawableImpl != null ? gLDrawableImpl.getHandle() : 0L;
    }

    @Override
    public NativeSurface getNativeSurface() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return gLDrawableImpl != null ? gLDrawableImpl.getNativeSurface() : null;
    }

    @Override
    public boolean isRealized() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return gLDrawableImpl != null ? gLDrawableImpl.isRealized() : false;
    }

    @Override
    public void setRealized(boolean bl) {
    }

    @Override
    public void swapBuffers() throws GLException {
        this.runInGLThread(this.swapBuffersOnGLAction);
    }

    @Override
    public final boolean isThreadGLCapable() {
        return true;
    }

    private void runInGLThread(Runnable runnable) {
        runnable.run();
    }

    private void runOnEDTIfAvail(boolean bl, Runnable runnable) {
        Display display;
        Display display2 = display = this.isDisposed() ? null : this.getDisplay();
        if (null == display || display.isDisposed() || display.getThread() == Thread.currentThread()) {
            runnable.run();
        } else if (bl) {
            display.syncExec(runnable);
        } else {
            display.asyncExec(runnable);
        }
    }

    @Override
    public String toString() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        int n = null != gLDrawableImpl ? gLDrawableImpl.getSurfaceWidth() : -1;
        int n2 = null != gLDrawableImpl ? gLDrawableImpl.getSurfaceHeight() : -1;
        return "SWT-GLCanvas[Realized " + this.isRealized() + ",\n\t" + (null != gLDrawableImpl ? gLDrawableImpl.getClass().getName() : "null-drawable") + ",\n\tFactory   " + this.getFactory() + ",\n\thandle    " + GLCanvas.toHexString(this.getHandle()) + ",\n\tDrawable size " + n + "x" + n2 + ",\n\tSWT size " + this.getSurfaceWidth() + "x" + this.getSurfaceHeight() + "]";
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println((Object)JoglVersion.getInstance());
        System.err.println(JoglVersion.getDefaultOpenGLInfo(null, null, true).toString());
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault(GLProfile.getDefaultDevice()));
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setSize(128, 128);
        shell.setLayout((Layout)new FillLayout());
        GLCanvas gLCanvas = new GLCanvas((Composite)shell, 0, gLCapabilities, null);
        gLCanvas.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLInfo(gL, null));
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        shell.open();
        gLCanvas.display();
        display.dispose();
    }

    private class DisposeGLEventListenerAction
    implements Runnable {
        private GLEventListener listener;
        private final boolean remove;

        private DisposeGLEventListenerAction(GLEventListener gLEventListener, boolean bl) {
            this.listener = gLEventListener;
            this.remove = bl;
        }

        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                if (!GLCanvas.this.isDisposed()) {
                    this.listener = GLCanvas.this.helper.disposeGLEventListener(GLCanvas.this, GLCanvas.this.drawable, GLCanvas.this.context, this.listener, this.remove);
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    }
}

