/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.macosx;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.opengl.math.FloatUtil;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.util.Rectangle;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.newt.MonitorModeProps;
import jogamp.newt.ScreenImpl;
import jogamp.newt.driver.macosx.DisplayDriver;

public class ScreenDriver
extends ScreenImpl {
    @Override
    protected void createNativeImpl() {
        this.aScreen = new DefaultGraphicsScreen(this.getDisplay().getGraphicsDevice(), this.screen_idx);
    }

    @Override
    protected void closeNativeImpl() {
    }

    private MonitorMode getMonitorModeImpl(MonitorModeProps.Cache cache, int n, int n2) {
        int[] nArray = this.getMonitorMode0(n, n2);
        MonitorMode monitorMode = null == nArray || 0 >= nArray.length ? null : MonitorModeProps.streamInMonitorMode(null, cache, nArray, 0);
        return monitorMode;
    }

    @Override
    protected final void collectNativeMonitorModesAndDevicesImpl(MonitorModeProps.Cache cache) {
        CrtProps crtProps = new CrtProps();
        for (int i = 0; i < crtProps.count; ++i) {
            MonitorMode monitorMode;
            ArrayHashSet arrayHashSet = new ArrayHashSet();
            int n = 0;
            while (null != (monitorMode = this.getMonitorModeImpl(cache, i, n))) {
                if (monitorMode.getSurfaceSize().getBitsPerPixel() >= 24) {
                    arrayHashSet.getOrAdd((Object)monitorMode);
                }
                ++n;
            }
            if (0 >= n) {
                throw new InternalError("Could not gather single mode of device " + i + "/" + crtProps.count);
            }
            monitorMode = this.getMonitorModeImpl(cache, i, -1);
            if (null == monitorMode) {
                throw new InternalError("Could not gather current mode of device " + i + "/" + crtProps.count + ", but gathered " + n + " modes");
            }
            MonitorModeProps.streamInMonitorDevice(null, cache, this, (ArrayHashSet<MonitorMode>)arrayHashSet, monitorMode, crtProps.propsFixedArray[i], 0);
        }
    }

    @Override
    protected boolean updateNativeMonitorDeviceViewportImpl(MonitorDevice monitorDevice, Rectangle rectangle, Rectangle rectangle2) {
        CrtProps crtProps = new CrtProps();
        int n = monitorDevice.getId();
        if (0 > n || n >= crtProps.count) {
            throw new IndexOutOfBoundsException("monitor id " + n + " not withon [0.." + (crtProps.count - 1) + "]");
        }
        int[] nArray = crtProps.propsFixedArray[n];
        int n2 = 4;
        rectangle.set(nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++]);
        rectangle2.set(nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++]);
        return true;
    }

    @Override
    protected MonitorMode queryCurrentMonitorModeImpl(MonitorDevice monitorDevice) {
        return this.getMonitorModeImpl(null, monitorDevice.getId(), -1);
    }

    @Override
    protected boolean setCurrentMonitorModeImpl(MonitorDevice monitorDevice, MonitorMode monitorMode) {
        return this.setMonitorMode0(monitorDevice.getId(), monitorMode.getId(), monitorMode.getRotation());
    }

    @Override
    protected int validateScreenIndex(int n) {
        return 0;
    }

    private native int getMonitorCount0();

    private native int[] getMonitorProps0(int var1);

    private native int[] getMonitorMode0(int var1, int var2);

    private native boolean setMonitorMode0(int var1, int var2, int var3);

    static {
        DisplayDriver.initSingleton();
    }

    private class CrtProps {
        final int count;
        final int[] pixelScaleArray;
        final int[][] propsOrigArray;
        final int[][] propsFixedArray;

        CrtProps() {
            int n;
            int n2;
            this.count = ScreenDriver.this.getMonitorCount0();
            this.pixelScaleArray = new int[this.count];
            this.propsOrigArray = new int[this.count][];
            this.propsFixedArray = new int[this.count][];
            for (n2 = 0; n2 < this.count; ++n2) {
                float f = (float)OSXUtil.GetPixelScale(n2);
                this.pixelScaleArray[n2] = FloatUtil.isZero(f, 1.1920929E-7f) ? 1 : (int)f;
                this.propsOrigArray[n2] = ScreenDriver.this.getMonitorProps0(n2);
                if (null == this.propsOrigArray[n2]) {
                    throw new InternalError("Could not gather device props " + n2 + "/" + this.count);
                }
                n = this.propsOrigArray[n2].length;
                this.propsFixedArray[n2] = new int[n];
                System.arraycopy(this.propsOrigArray[n2], 0, this.propsFixedArray[n2], 0, n);
            }
            block1: for (n2 = 0; n2 < this.count; ++n2) {
                int n3;
                int[] nArray = this.propsFixedArray[n2];
                n = nArray[4];
                int n4 = nArray[5];
                int n5 = this.pixelScaleArray[n2];
                nArray[6] = nArray[6] * n5;
                nArray[7] = nArray[7] * n5;
                if (0 != n) {
                    for (n3 = 0; n3 < this.count; ++n3) {
                        if (n3 == n2 || n != this.propsOrigArray[n3][6]) continue;
                        nArray[4] = nArray[4] * this.pixelScaleArray[n3];
                        break;
                    }
                }
                if (0 == n4) continue;
                for (n3 = 0; n3 < this.count; ++n3) {
                    if (n3 == n2 || n4 != this.propsOrigArray[n3][7]) continue;
                    nArray[5] = nArray[5] * this.pixelScaleArray[n3];
                    continue block1;
                }
            }
        }
    }
}

