/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.VersionNumberString;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLNameResolver;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.opengl.GLRendererQuirks;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES3;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDebugListener;
import javax.media.opengl.GLDebugMessage;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPipelineFactory;
import javax.media.opengl.GLProfile;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.ExtensionAvailabilityCache;
import jogamp.opengl.GLBufferObjectTracker;
import jogamp.opengl.GLBufferStateTracker;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.GLDebugMessageHandler;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLStateTracker;
import jogamp.opengl.GLVersionNumber;

public abstract class GLContextImpl
extends GLContext {
    private String contextFQN;
    private int additionalCtxCreationFlags;
    protected ExtensionAvailabilityCache extensionAvailability;
    private ProcAddressTable glProcAddressTable;
    private String glVendor;
    private String glRenderer;
    private String glRendererLowerCase;
    private String glVersion;
    private final GLBufferObjectTracker bufferObjectTracker;
    private final GLBufferStateTracker bufferStateTracker;
    private final GLStateTracker glStateTracker = new GLStateTracker();
    private GLDebugMessageHandler glDebugHandler = null;
    private final int[] boundFBOTarget = new int[]{0, 0};
    private int defaultVAO = 0;
    protected GLDrawableImpl drawable;
    protected GLDrawableImpl drawableRead;
    private boolean pixelDataEvaluated;
    private int pixelDataFormat;
    private int pixelDataType;
    protected GL gl;
    protected static final Object mappedContextTypeObjectLock = new Object();
    protected static final HashMap<String, ExtensionAvailabilityCache> mappedExtensionAvailabilityCache = new HashMap();
    protected static final HashMap<String, ProcAddressTable> mappedGLProcAddress = new HashMap();
    protected static final HashMap<String, ProcAddressTable> mappedGLXProcAddress = new HashMap();
    private Throwable lastCtxReleaseStack = null;

    public static void shutdownImpl() {
        mappedExtensionAvailabilityCache.clear();
        mappedGLProcAddress.clear();
        mappedGLXProcAddress.clear();
    }

    public GLContextImpl(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        if (null == gLDrawableImpl) {
            throw new IllegalArgumentException("Null drawable");
        }
        this.bufferStateTracker = new GLBufferStateTracker();
        if (null != gLContext) {
            GLContextShareSet.registerSharing(this, gLContext);
            this.bufferObjectTracker = ((GLContextImpl)gLContext).getBufferObjectTracker();
            if (null == this.bufferObjectTracker) {
                throw new InternalError("shared-master context hash null GLBufferObjectTracker: " + GLContextImpl.toHexString(gLContext.hashCode()));
            }
        } else {
            this.bufferObjectTracker = new GLBufferObjectTracker();
        }
        this.drawable = gLDrawableImpl;
        this.drawableRead = gLDrawableImpl;
        this.glDebugHandler = new GLDebugMessageHandler(this);
    }

    private final void clearStates() {
        if (!GLContextShareSet.hasCreatedSharedLeft(this)) {
            this.bufferObjectTracker.clear();
        }
        this.bufferStateTracker.clear();
        this.glStateTracker.setEnabled(false);
        this.glStateTracker.clearStates();
    }

    @Override
    protected void resetStates(boolean bl) {
        if (!bl) {
            this.clearStates();
        }
        this.extensionAvailability = null;
        this.glProcAddressTable = null;
        this.gl = null;
        this.contextFQN = null;
        this.additionalCtxCreationFlags = 0;
        this.glRendererLowerCase = this.glRenderer = (this.glVendor = "");
        this.glVersion = this.glVendor;
        if (!bl && null != this.boundFBOTarget) {
            this.boundFBOTarget[0] = 0;
            this.boundFBOTarget[1] = 0;
        }
        this.pixelDataEvaluated = false;
        super.resetStates(bl);
    }

    @Override
    public final GLDrawable setGLReadDrawable(GLDrawable gLDrawable) {
        if (!this.isGLReadDrawableAvailable()) {
            throw new GLException("Setting read drawable feature not available");
        }
        Thread thread = Thread.currentThread();
        if (this.lock.isLockedByOtherThread()) {
            throw new GLException("GLContext current by other thread " + this.lock.getOwner().getName() + ", operation not allowed on this thread " + thread.getName());
        }
        boolean bl = this.lock.isOwner(thread);
        if (bl && this.lock.getHoldCount() > 1) {
            throw new GLException("GLContext is recursively locked - unsupported for setGLDrawable(..)");
        }
        if (bl) {
            this.release(false);
        }
        GLDrawableImpl gLDrawableImpl = this.drawableRead;
        GLDrawableImpl gLDrawableImpl2 = this.drawableRead = null != gLDrawable ? (GLDrawableImpl)gLDrawable : this.drawable;
        if (bl) {
            this.makeCurrent();
        }
        return gLDrawableImpl;
    }

    @Override
    public final GLDrawable getGLReadDrawable() {
        return this.drawableRead;
    }

    @Override
    public final GLDrawable setGLDrawable(GLDrawable gLDrawable, boolean bl) {
        Thread thread = Thread.currentThread();
        if (this.lock.isLockedByOtherThread()) {
            throw new GLException("GLContext current by other thread " + this.lock.getOwner().getName() + ", operation not allowed on this thread " + thread.getName());
        }
        boolean bl2 = this.lock.isOwner(thread);
        if (bl2 && this.lock.getHoldCount() > 1) {
            throw new GLException("GLContext is recursively locked - unsupported for setGLDrawable(..)");
        }
        if (this.drawable == gLDrawable && (bl || this.drawableRead == gLDrawable)) {
            return this.drawable;
        }
        GLDrawableImpl gLDrawableImpl = this.drawable;
        if (this.isCreated() && null != gLDrawableImpl && gLDrawableImpl.isRealized()) {
            if (!bl2) {
                this.makeCurrent();
            }
            this.gl.glFinish();
            this.associateDrawable(false);
            if (!bl2) {
                this.release(false);
            }
        }
        if (bl2) {
            this.release(false);
        }
        if (!bl || this.drawableRead == this.drawable) {
            this.drawableRead = (GLDrawableImpl)gLDrawable;
        }
        this.drawableRetargeted |= null != this.drawable && gLDrawable != this.drawable;
        this.drawable = (GLDrawableImpl)gLDrawable;
        if (this.isCreated() && null != this.drawable && this.drawable.isRealized()) {
            this.makeCurrent(true);
            if (!bl2) {
                this.release(false);
            }
        }
        return gLDrawableImpl;
    }

    @Override
    public final GLDrawable getGLDrawable() {
        return this.drawable;
    }

    public final GLDrawableImpl getDrawableImpl() {
        return this.drawable;
    }

    @Override
    public final GL getRootGL() {
        GL gL = this.gl;
        GL gL2 = gL.getDownstreamGL();
        while (null != gL2) {
            gL = gL2;
            gL2 = gL.getDownstreamGL();
        }
        return gL;
    }

    @Override
    public final GL getGL() {
        return this.gl;
    }

    @Override
    public GL setGL(GL gL) {
        if (DEBUG) {
            String string = null != this.gl ? this.gl.getClass().getSimpleName() + ", " + this.gl.toString() : "<null>";
            String string2 = null != gL ? gL.getClass().getSimpleName() + ", " + gL.toString() : "<null>";
            System.err.println("Info: setGL (OpenGL " + this.getGLVersion() + "): " + GLContextImpl.getThreadName() + ", " + string + " -> " + string2);
            Thread.dumpStack();
        }
        this.gl = gL;
        return gL;
    }

    @Override
    public final int getDefaultVAO() {
        return this.defaultVAO;
    }

    protected void drawableUpdatedNotify() throws GLException {
    }

    public abstract Object getPlatformGLExtensions();

    @Override
    public void release() throws GLException {
        this.release(false);
    }

    private String getTraceSwitchMsg() {
        long l = null != this.drawable ? this.drawable.getHandle() : 0L;
        return "obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", isShared " + GLContextShareSet.isShared(this) + ", surf " + (null != this.drawable) + " " + GLContextImpl.toHexString(l) + ", " + this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(boolean bl) throws GLException {
        boolean bl2;
        Throwable throwable;
        block17: {
            if (TRACE_SWITCH) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[release.0, inDestruction: " + bl + "]: " + this.getTraceSwitchMsg());
            }
            if (!this.lock.isOwner(Thread.currentThread())) {
                String string = GLContextImpl.getThreadName() + ": Context not current on thread, inDestruction: " + bl + ", " + this.getTraceSwitchMsg();
                if (DEBUG_TRACE_SWITCH) {
                    System.err.println(string);
                    if (null != this.lastCtxReleaseStack) {
                        System.err.print("Last release call: ");
                        this.lastCtxReleaseStack.printStackTrace();
                    } else {
                        System.err.println("Last release call: NONE");
                    }
                }
                throw new GLException(string);
            }
            throwable = null;
            bl2 = (bl || this.lock.getHoldCount() == 1) && 0L != this.contextHandle;
            try {
                if (bl2) {
                    if (!bl) {
                        try {
                            this.contextMadeCurrent(false);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                        }
                    }
                    this.releaseImpl();
                }
                if (!bl2) break block17;
            }
            catch (Throwable throwable3) {
                if (bl2) {
                    GLContextImpl.setCurrent(null);
                }
                this.lock.unlock();
                this.drawable.unlockSurface();
                if (DEBUG_TRACE_SWITCH) {
                    String string = GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[release.X]: " + (bl2 ? "switch" : "keep  ") + " - " + this.getTraceSwitchMsg();
                    this.lastCtxReleaseStack = new Throwable(string);
                    if (TRACE_SWITCH) {
                        System.err.println(string);
                    }
                }
                throw throwable3;
            }
            GLContextImpl.setCurrent(null);
        }
        this.lock.unlock();
        this.drawable.unlockSurface();
        if (DEBUG_TRACE_SWITCH) {
            String string = GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[release.X]: " + (bl2 ? "switch" : "keep  ") + " - " + this.getTraceSwitchMsg();
            this.lastCtxReleaseStack = new Throwable(string);
            if (TRACE_SWITCH) {
                System.err.println(string);
            }
        }
        if (null != throwable) {
            throw new GLException("GLContext.release(false) during GLDrawableImpl.contextMadeCurrent(this, false)", throwable);
        }
    }

    protected abstract void releaseImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        if (DEBUG_TRACE_SWITCH) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContextImpl.destroy.0: " + this.getTraceSwitchMsg());
        }
        if (0L != this.contextHandle) {
            if (null == this.drawable) {
                throw new GLException("GLContext created but drawable is null: " + this.toString());
            }
            int n = this.drawable.lockSurface();
            if (1 >= n) {
                throw new GLException("Surface not ready to lock: " + this.drawable);
            }
            Throwable throwable = null;
            try {
                if (!this.drawable.isRealized()) {
                    throw new GLException("GLContext created but drawable not realized: " + this.toString());
                }
                this.lock.lock();
                if (DEBUG_TRACE_SWITCH && this.lock.getHoldCount() > 2) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContextImpl.destroy: Lock was hold more than once - makeCurrent/release imbalance: " + this.getTraceSwitchMsg());
                    Thread.dumpStack();
                }
                try {
                    if (this.lock.getHoldCount() == 1 && 0 == this.makeCurrent()) {
                        throw new GLException("GLContext.makeCurrent() failed: " + this.toString());
                    }
                    try {
                        this.associateDrawable(false);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                    if (0 != this.defaultVAO) {
                        int[] nArray = new int[]{this.defaultVAO};
                        GL2ES3 gL2ES3 = this.gl.getRootGL().getGL2ES3();
                        gL2ES3.glBindVertexArray(0);
                        gL2ES3.glDeleteVertexArrays(1, nArray, 0);
                        this.defaultVAO = 0;
                    }
                    this.glDebugHandler.enable(false);
                    if (this.lock.getHoldCount() > 1) {
                        this.release(true);
                    }
                    this.destroyImpl();
                    this.contextHandle = 0L;
                    this.glDebugHandler = null;
                    if (GLContextShareSet.contextDestroyed(this) && !GLContextShareSet.hasCreatedSharedLeft(this)) {
                        GLContextShareSet.unregisterSharing(this);
                    }
                    this.resetStates(false);
                }
                finally {
                    this.lock.unlock();
                    if (DEBUG_TRACE_SWITCH) {
                        System.err.println(GLContextImpl.getThreadName() + ": GLContextImpl.destroy.X: " + this.getTraceSwitchMsg());
                    }
                }
            }
            finally {
                this.drawable.unlockSurface();
            }
            if (null != throwable) {
                throw new GLException("Exception @ destroy's associateDrawable(false)", throwable);
            }
        } else {
            this.resetStates(false);
        }
    }

    protected abstract void destroyImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void copy(GLContext gLContext, int n) throws GLException {
        if (gLContext.getHandle() == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (this.getHandle() == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        int n2 = this.drawable.lockSurface();
        if (1 >= n2) {
            throw new GLException("Surface not ready to lock");
        }
        try {
            this.copyImpl(gLContext, n);
        }
        finally {
            this.drawable.unlockSurface();
        }
    }

    protected abstract void copyImpl(GLContext var1, int var2) throws GLException;

    @Override
    public final int makeCurrent() throws GLException {
        return this.makeCurrent(false);
    }

    protected final int makeCurrent(boolean bl) throws GLException {
        int n;
        block31: {
            boolean bl2;
            boolean bl3 = bl2 = null != this.drawable;
            if (TRACE_SWITCH) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.0]: " + this.getTraceSwitchMsg());
            }
            if (!bl2) {
                if (DEBUG_TRACE_SWITCH) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.X0]: NULL Drawable - CONTEXT_NOT_CURRENT - " + this.getTraceSwitchMsg());
                }
                return 0;
            }
            int n2 = this.drawable.lockSurface();
            if (1 >= n2) {
                if (DEBUG_TRACE_SWITCH) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.X1]: Surface Not Ready - CONTEXT_NOT_CURRENT - " + this.getTraceSwitchMsg());
                }
                return 0;
            }
            boolean bl4 = true;
            n = 0;
            try {
                if (!this.drawable.isRealized()) break block31;
                if (0L == this.drawable.getHandle()) {
                    throw new GLException("drawable has invalid handle: " + this.drawable);
                }
                this.lock.lock();
                try {
                    GLContext gLContext = GLContextImpl.getCurrent();
                    if (gLContext != null) {
                        if (gLContext == this) {
                            this.drawableUpdatedNotify();
                            bl4 = false;
                            if (TRACE_SWITCH) {
                                System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.X2]: KEEP - CONTEXT_CURRENT - " + this.getTraceSwitchMsg());
                            }
                            int n3 = 1;
                            return n3;
                        }
                        gLContext.release();
                    }
                    bl4 = 0 == (n = this.makeCurrentWithinLock(n2));
                }
                catch (RuntimeException runtimeException) {
                    bl4 = true;
                    throw runtimeException;
                }
                finally {
                    if (bl4) {
                        if (DEBUG_TRACE_SWITCH) {
                            System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.1]: Context lock.unlock() due to error, res " + GLContextImpl.makeCurrentResultToString(n) + ", " + this.lock);
                        }
                        this.lock.unlock();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                bl4 = true;
                throw runtimeException;
            }
            finally {
                if (bl4) {
                    this.drawable.unlockSurface();
                }
            }
        }
        if (n != 0) {
            GLContextImpl.setCurrent(this);
            if (n == 2) {
                this.drawable.getGLProfile().verifyEquality(this.gl.getGLProfile());
                this.glDebugHandler.init(this.isGL2GL3() && this.isGLDebugEnabled());
                if (DEBUG_GL) {
                    this.setGL(GLPipelineFactory.create("javax.media.opengl.Debug", null, this.gl, null));
                    if (this.glDebugHandler.isEnabled()) {
                        this.glDebugHandler.addListener(new GLDebugMessageHandler.StdErrGLDebugListener(true));
                    }
                }
                if (TRACE_GL) {
                    this.setGL(GLPipelineFactory.create("javax.media.opengl.Trace", null, this.gl, new Object[]{System.err}));
                }
                bl = true;
            }
            if (bl) {
                this.associateDrawable(true);
            }
            this.contextMadeCurrent(true);
        }
        if (TRACE_SWITCH) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.X3]: SWITCH - " + GLContextImpl.makeCurrentResultToString(n) + " - stateTracker.on " + this.glStateTracker.isEnabled() + " - " + this.getTraceSwitchMsg());
        }
        return n;
    }

    private final GLContextImpl getOtherSharedMaster() {
        GLContextImpl gLContextImpl = (GLContextImpl)GLContextShareSet.getSharedMaster(this);
        return this != gLContextImpl ? gLContextImpl : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int makeCurrentWithinLock(int n) throws GLException {
        if (!this.isCreated()) {
            Object object;
            boolean bl;
            GLContextImpl gLContextImpl;
            if (0 >= this.drawable.getSurfaceWidth() || 0 >= this.drawable.getSurfaceHeight()) {
                if (DEBUG_TRACE_SWITCH) {
                    System.err.println(GLContextImpl.getThreadName() + ": Create GL context REJECTED (zero surface size) for " + this.getClass().getName() + " - " + this.getTraceSwitchMsg());
                    System.err.println(this.drawable.toString());
                }
                return 0;
            }
            if (DEBUG_GL) {
                this.additionalCtxCreationFlags |= 0x20;
            }
            if (null != (gLContextImpl = this.getOtherSharedMaster()) && 1 >= gLContextImpl.drawable.lockSurface()) {
                throw new GLException("GLContextShareSet could not lock sharedMaster surface: " + gLContextImpl.drawable);
            }
            try {
                if (null != gLContextImpl) {
                    long l = gLContextImpl.getHandle();
                    if (0L == l) {
                        throw new GLException("GLContextShareSet returned an invalid sharedMaster context: " + gLContextImpl);
                    }
                    bl = this.createImpl(l);
                } else {
                    bl = this.createImpl(0L);
                }
                if (bl && this.hasNoDefaultVAO()) {
                    int[] nArray = new int[1];
                    object = this.gl.getRootGL();
                    if (object.isGL2ES3()) {
                        GL2ES3 gL2ES3 = object.getGL2ES3();
                        gL2ES3.glGenVertexArrays(1, nArray, 0);
                        this.defaultVAO = nArray[0];
                        gL2ES3.glBindVertexArray(this.defaultVAO);
                    }
                }
            }
            finally {
                if (null != gLContextImpl) {
                    gLContextImpl.drawable.unlockSurface();
                }
            }
            if (DEBUG_TRACE_SWITCH) {
                System.err.println(GLContextImpl.getThreadName() + ": Create GL context " + (bl ? "OK" : "FAILED") + ": For " + this.getClass().getName() + " - " + this.getGLVersion() + " - " + this.getTraceSwitchMsg());
            }
            if (!bl) {
                return 0;
            }
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
            object = abstractGraphicsConfiguration.getScreen().getDevice();
            if (!GLContext.getAvailableGLVersionsSet((AbstractGraphicsDevice)object) && 0 == (this.ctxOptions & 8)) {
                boolean bl2;
                int n2;
                int n3 = this.ctxVersion.compareTo(Version300) <= 0 ? 2 : this.ctxVersion.getMajor();
                if (0 != (this.ctxOptions & 4)) {
                    n2 = 4;
                    bl2 = false;
                } else {
                    n2 = 2;
                    bl2 = true;
                }
                GLContext.mapAvailableGLVersion((AbstractGraphicsDevice)object, n3, n2, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                if (bl2) {
                    GLContext.mapAvailableGLVersion((AbstractGraphicsDevice)object, n3, 4, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                    if (n3 >= 4) {
                        GLContext.mapAvailableGLVersion((AbstractGraphicsDevice)object, 3, n2, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                        GLContext.mapAvailableGLVersion((AbstractGraphicsDevice)object, 3, 4, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                    }
                    if (n3 >= 3) {
                        GLContext.mapAvailableGLVersion((AbstractGraphicsDevice)object, 2, n2, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                    }
                } else if (n3 >= 4) {
                    GLContext.mapAvailableGLVersion((AbstractGraphicsDevice)object, 3, n2, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                }
                GLContext.setAvailableGLVersionsSet((AbstractGraphicsDevice)object);
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": createContextOLD-MapVersionsAvailable HAVE: " + object + " -> " + n3 + "." + n2 + " -> " + this.getGLVersion());
                }
            }
            GLContextShareSet.contextCreated(this);
            return 2;
        }
        this.makeCurrentImpl();
        return 1;
    }

    protected abstract void makeCurrentImpl() throws GLException;

    protected void associateDrawable(boolean bl) {
        this.drawable.associateContext(this, bl);
    }

    protected void contextMadeCurrent(boolean bl) {
        this.drawable.contextMadeCurrent(this, bl);
    }

    protected abstract boolean createImpl(long var1) throws GLException;

    protected abstract long createContextARBImpl(long var1, boolean var3, int var4, int var5, int var6);

    protected abstract void destroyContextARBImpl(long var1);

    protected final long createContextARB(long l, boolean bl) {
        if (GLProfile.disableOpenGLARBContext) {
            return 0L;
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": createContextARB: mappedVersionsAvailableSet(" + abstractGraphicsDevice.getConnection() + "): " + GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice));
        }
        if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice) && !this.mapGLVersions(abstractGraphicsDevice)) {
            return 0L;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        int[] nArray = new int[]{0, 0};
        GLContext.getRequestMajorAndCompat(gLCapabilitiesImmutable.getGLProfile(), nArray);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": createContextARB: Requested " + GLContext.getGLVersion(nArray[0], 0, nArray[0], null));
        }
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        long l2 = 0L;
        if (GLContext.getAvailableGLVersion(abstractGraphicsDevice, nArray[0], nArray[1], nArray2, nArray3, nArray4)) {
            nArray4[0] = nArray4[0] | this.additionalCtxCreationFlags;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB: Mapped " + GLContext.getGLVersion(nArray2[0], nArray3[0], nArray4[0], null));
            }
            if (0L != (l2 = this.createContextARBImpl(l, bl, nArray4[0], nArray2[0], nArray3[0])) && !this.setGLFunctionAvailability(true, nArray2[0], nArray3[0], nArray4[0], false, false)) {
                throw new InternalError("setGLFunctionAvailability !strictMatch failed");
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean mapGLVersions(AbstractGraphicsDevice abstractGraphicsDevice) {
        IdentityHashMap<String, Integer> identityHashMap = GLContext.deviceVersionAvailable;
        synchronized (identityHashMap) {
            long l = DEBUG ? System.nanoTime() : 0L;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!(Platform.OSType.MACOS != Platform.getOSType() || Platform.getOSVersionNumber().compareTo(PlatformPropsImpl.OSXVersion.Mavericks) < 0 || GLProfile.disableOpenGLCore || bl5 || bl6)) {
                bl6 = this.createContextARBMapVersionsAvailable(3, 4);
                bl |= bl6;
                if (bl6) {
                    boolean bl7;
                    boolean bl8 = bl7 = 0 == (0x40 & this.ctxOptions);
                    if (bl7 && this.ctxVersion.getMajor() >= 4) {
                        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 4, 4, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                        bl5 = true;
                        if (DEBUG) {
                            System.err.println("Quirk Triggerd: " + GLRendererQuirks.toString(13) + ": cause: OS " + Platform.getOSType() + ", OS Version " + Platform.getOSVersionNumber());
                        }
                    }
                    this.resetStates(false);
                }
            }
            if (!GLProfile.disableOpenGLCore) {
                if (!bl5) {
                    bl5 = this.createContextARBMapVersionsAvailable(4, 4);
                    bl |= bl5;
                    if (bl5) {
                        if (0 == (0x40 & this.ctxOptions)) {
                            GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 3, 4, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                            if (PROFILE_ALIASING) {
                                bl6 = true;
                            }
                        }
                        this.resetStates(false);
                    }
                }
                if (!bl6) {
                    bl6 = this.createContextARBMapVersionsAvailable(3, 4);
                    bl |= bl6;
                    if (bl6) {
                        this.resetStates(false);
                    }
                }
            }
            if (!bl2) {
                bl2 = this.createContextARBMapVersionsAvailable(4, 2);
                bl |= bl2;
                if (bl2) {
                    if (!bl5) {
                        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 4, 4, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                        bl5 = true;
                    }
                    if (!bl6) {
                        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 3, 4, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                        bl6 = true;
                    }
                    if (0 == (0x40 & this.ctxOptions)) {
                        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 3, 2, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 2, 2, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                        if (PROFILE_ALIASING) {
                            bl3 = true;
                            bl4 = true;
                        }
                    }
                    this.resetStates(false);
                }
            }
            if (!bl3) {
                bl3 = this.createContextARBMapVersionsAvailable(3, 2);
                bl |= bl3;
                if (bl3) {
                    if (!bl6) {
                        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 3, 4, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                        bl6 = true;
                    }
                    if (0 == (0x40 & this.ctxOptions)) {
                        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 2, 2, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
                        if (PROFILE_ALIASING) {
                            bl4 = true;
                        }
                    }
                    this.resetStates(false);
                }
            }
            if (!bl4) {
                bl4 = this.createContextARBMapVersionsAvailable(2, 2);
                bl |= bl4;
                if (bl4) {
                    this.resetStates(false);
                }
            }
            if (bl) {
                GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
                if (DEBUG) {
                    long l2 = System.nanoTime();
                    System.err.println("GLContextImpl.mapGLVersions: " + abstractGraphicsDevice + ", profileAliasing: " + PROFILE_ALIASING + ", total " + (double)(l2 - l) / 1000000.0 + "ms");
                    System.err.println(GLContext.dumpAvailableGLVersions(null).toString());
                }
            } else if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapVersions NONE for :" + abstractGraphicsDevice);
            }
            return bl;
        }
    }

    private final boolean createContextARBMapVersionsAvailable(int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 1 | n2;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (4 == n) {
            n6 = 4;
            n5 = GLContext.getMaxMinor(n7, n6);
            n4 = 4;
            n3 = 0;
        } else if (3 == n) {
            n6 = 3;
            n5 = GLContext.getMaxMinor(n7, n6);
            n4 = 3;
            n3 = 1;
        } else {
            n6 = 3;
            n5 = 0;
            n4 = 2;
            n3 = 0;
        }
        long l = this.createContextARBVersions(0L, true, n7, n6, n5, n4, n3, nArray, nArray2);
        if (0L == l && 4 == n2 && !PROFILE_ALIASING) {
            n7 &= 0xFFFFFFFB;
            l = this.createContextARBVersions(0L, true, n7 |= 0x10, n6, n5, n4, n3, nArray, nArray2);
            if (0L == l) {
                n7 &= 0xFFFFFFFB;
                n7 &= 0xFFFFFFEF;
                l = this.createContextARBVersions(0L, true, n7 |= 2, n6, n5, n4, n3, nArray, nArray2);
            }
        }
        if (0L != l) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
            GLContext.mapAvailableGLVersion(abstractGraphicsDevice, n, n2, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
            this.destroyContextARBImpl(l);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapVersionsAvailable HAVE: " + n + "." + n2 + " -> " + this.getGLVersion());
            }
            bl = true;
        } else {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapVersionsAvailable NOPE: " + n + "." + n2);
            }
            bl = false;
        }
        return bl;
    }

    private final long createContextARBVersions(long l, boolean bl, int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        nArray[0] = n2;
        nArray2[0] = n3;
        long l2 = 0L;
        int n6 = 0;
        do {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARBVersions." + ++n6 + ": share " + l + ", direct " + bl + ", version " + nArray[0] + "." + nArray2[0] + ", major[" + n4 + ".." + n2 + "], minor[" + n5 + ".." + n3 + "]");
            }
            if (0L == (l2 = this.createContextARBImpl(l, bl, n, nArray[0], nArray2[0]))) continue;
            if (this.setGLFunctionAvailability(true, nArray[0], nArray2[0], n, true, true)) break;
            this.destroyContextARBImpl(l2);
            l2 = 0L;
        } while ((nArray[0] > n4 || nArray[0] == n4 && nArray2[0] > n5) && GLContext.decrementGLVersion(n, nArray, nArray2));
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": createContextARBVersions.X: ctx " + GLContextImpl.toHexString(l2) + ", share " + l + ", direct " + bl + ", version " + nArray[0] + "." + nArray2[0] + ", major[" + n4 + ".." + n2 + "], minor[" + n5 + ".." + n3 + "]");
        }
        return l2;
    }

    private final void setContextVersion(int n, int n2, int n3, VersionNumberString versionNumberString, boolean bl) {
        if (0 == n3) {
            throw new GLException("Invalid GL Version " + n + "." + n2 + ", ctp " + GLContextImpl.toHexString(n3));
        }
        this.ctxVersion = new VersionNumber(n, n2, 0);
        this.ctxVersionString = GLContextImpl.getGLVersion(n, n2, n3, this.glVersion);
        this.ctxVendorVersion = versionNumberString;
        this.ctxOptions = n3;
        if (bl) {
            this.ctxGLSLVersion = VersionNumber.zeroVersion;
            if (this.hasGLSL()) {
                String string;
                String string2 = string = this.isGLES() ? null : this.gl.glGetString(35724);
                if (null != string) {
                    this.ctxGLSLVersion = new VersionNumber(string);
                    if (this.ctxGLSLVersion.getMajor() < 1) {
                        this.ctxGLSLVersion = VersionNumber.zeroVersion;
                    }
                }
                if (this.ctxGLSLVersion.isZero()) {
                    this.ctxGLSLVersion = GLContextImpl.getStaticGLSLVersionNumber(n, n2, this.ctxOptions);
                }
            }
        }
    }

    private Object createInstance(GLProfile gLProfile, boolean bl, Object[] objectArray) {
        return ReflectionUtil.createInstance(gLProfile.getGLCtor(bl), (Object[])objectArray);
    }

    private boolean verifyInstance(GLProfile gLProfile, String string, Object object) {
        return ReflectionUtil.instanceOf((Object)object, (String)(gLProfile.getGLImplBaseClassName() + string));
    }

    protected GL createGL(GLProfile gLProfile) {
        GL gL = (GL)this.createInstance(gLProfile, true, new Object[]{gLProfile, this});
        return gL;
    }

    private void finalizeInit(GL gL) {
        Method method;
        block3: {
            method = null;
            try {
                method = ReflectionUtil.getMethod(gL.getClass(), (String)"finalizeInit", (Class[])new Class[0]);
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block3;
                System.err.println("Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        if (null != method) {
            ReflectionUtil.callMethod((Object)gL, (Method)method, (Object[])new Object[0]);
        }
    }

    public final ProcAddressTable getGLProcAddressTable() {
        return this.glProcAddressTable;
    }

    public abstract ProcAddressTable getPlatformExtProcAddressTable();

    public abstract ByteBuffer glAllocateMemoryNV(int var1, float var2, float var3, float var4);

    public abstract void glFreeMemoryNV(ByteBuffer var1);

    protected final String mapToRealGLFunctionName(String string) {
        String string2;
        Map<String, String> map = this.getFunctionNameMap();
        String string3 = string2 = null != map ? map.get(string) : null;
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map<String, String> getFunctionNameMap();

    protected final String mapToRealGLExtensionName(String string) {
        String string2;
        Map<String, String> map = this.getExtensionNameMap();
        String string3 = string2 = null != map ? map.get(string) : null;
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map<String, String> getExtensionNameMap();

    protected final void resetProcAddressTable(final ProcAddressTable procAddressTable) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                procAddressTable.reset((DynamicLookupHelper)GLContextImpl.this.getDrawableImpl().getGLDynamicLookupHelper());
                return null;
            }
        });
    }

    private final boolean initGLRendererAndGLVersionStrings() {
        GLDynamicLookupHelper gLDynamicLookupHelper = this.getDrawableImpl().getGLDynamicLookupHelper();
        long l = gLDynamicLookupHelper.dynamicLookupFunction("glGetString");
        if (0L == l) {
            System.err.println("Error: Entry point to 'glGetString' is NULL.");
            if (DEBUG) {
                Thread.dumpStack();
            }
            return false;
        }
        String string = GLContextImpl.glGetStringInt(7936, l);
        if (null == string) {
            if (DEBUG) {
                System.err.println("Warning: GL_VENDOR is NULL.");
                Thread.dumpStack();
            }
            return false;
        }
        this.glVendor = string;
        String string2 = GLContextImpl.glGetStringInt(7937, l);
        if (null == string2) {
            if (DEBUG) {
                System.err.println("Warning: GL_RENDERER is NULL.");
                Thread.dumpStack();
            }
            return false;
        }
        this.glRenderer = string2;
        this.glRendererLowerCase = this.glRenderer.toLowerCase();
        String string3 = GLContextImpl.glGetStringInt(7938, l);
        if (null == string3) {
            if (DEBUG) {
                System.err.println("Warning: GL_VERSION is NULL.");
                Thread.dumpStack();
            }
            return false;
        }
        this.glVersion = string3;
        return true;
    }

    private static final VersionNumber getGLVersionNumber(int n, String string) {
        int[] nArray;
        int[] nArray2;
        GLVersionNumber gLVersionNumber;
        if (null != string && (gLVersionNumber = GLVersionNumber.create(string)).isValid() && GLContext.isValidGLVersion(n, (nArray2 = new int[]{gLVersionNumber.getMajor()})[0], (nArray = new int[]{gLVersionNumber.getMinor()})[0])) {
            return new VersionNumber(nArray2[0], nArray[0], 0);
        }
        return null;
    }

    private final boolean getGLIntVersion(int[] nArray, int[] nArray2) {
        nArray[0] = 0;
        GLDynamicLookupHelper gLDynamicLookupHelper = this.getDrawableImpl().getGLDynamicLookupHelper();
        long l = gLDynamicLookupHelper.dynamicLookupFunction("glGetIntegerv");
        if (0L == l) {
            System.err.println("Error: Entry point to 'glGetIntegerv' is NULL.");
            if (DEBUG) {
                Thread.dumpStack();
            }
            return false;
        }
        GLContextImpl.glGetIntegervInt(33307, nArray, 0, l);
        GLContextImpl.glGetIntegervInt(33308, nArray2, 0, l);
        return true;
    }

    protected final int getCtxOptions() {
        return this.ctxOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean setGLFunctionAvailability(boolean bl, int n, int n2, int n3, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5;
        Object object;
        int[] nArray;
        boolean bl6;
        if (null != this.gl && null != this.glProcAddressTable && !bl) {
            return true;
        }
        if (0 < n && !GLContext.isValidGLVersion(n3, n, n2)) {
            throw new GLException("Invalid GL Version Request " + GLContext.getGLVersion(n, n2, n3, null));
        }
        if (null == this.gl || !this.verifyInstance(this.gl.getGLProfile(), "Impl", this.gl)) {
            this.setGL(this.createGL(this.drawable.getGLProfile()));
        }
        this.updateGLXProcAddressTable();
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        int n4 = n3;
        VersionNumber versionNumber = new VersionNumber(n, n2, 0);
        boolean bl7 = this.initGLRendererAndGLVersionStrings();
        if (!bl7) {
            String string = "Intialization of GL renderer strings failed. " + abstractGraphicsDevice + " - " + GLContext.getGLVersion(n, n2, n3, null);
            if (bl2) {
                if (DEBUG) {
                    System.err.println("Warning: setGLFunctionAvailability: " + string);
                }
                return false;
            }
            throw new GLException(string);
        }
        VersionNumber versionNumber2 = GLContextImpl.getGLVersionNumber(n3, this.glVersion);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: Given " + abstractGraphicsDevice + " - " + GLContext.getGLVersion(n, n2, n3, this.glVersion) + ", Number(Str) " + versionNumber2);
        }
        boolean bl8 = bl7 = 0 != (8 & n3);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: Pre version verification - expected " + GLContext.getGLVersion(n, n2, n3, null) + ", strictMatch " + bl2 + ", glVersionsMapping " + bl3);
        }
        if (!(bl6 = this.getGLIntVersion(nArray = new int[]{0}, (int[])(object = new int[]{0})))) {
            String string = "Fetching GL Integer Version failed. " + abstractGraphicsDevice + " - " + GLContext.getGLVersion(n, n2, n3, null);
            if (bl2) {
                if (DEBUG) {
                    System.err.println("Warning: setGLFunctionAvailability: " + string);
                }
                return false;
            }
            throw new GLException(string);
        }
        VersionNumber versionNumber3 = new VersionNumber(nArray[0], object[0], 0);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: Version verification (Int): String " + this.glVersion + ", Number(Int) " + versionNumber3);
        }
        if ((n >= 3 || versionNumber2.compareTo(Version300) >= 0) && GLContext.isValidGLVersion(n3, versionNumber3.getMajor(), versionNumber3.getMinor())) {
            int n5 = versionNumber3.getMajor();
            if (bl2 && ((bl7 || n >= 3) && versionNumber3.compareTo(versionNumber) < 0 || bl7 && (2 == n && (2 > n5 || n5 > 3) || (1 == n || 3 <= n) && n != n5))) {
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, GL version mismatch (Int): " + GLContext.getGLVersion(n, n2, n3, null) + " -> " + this.glVersion + ", " + versionNumber3);
                }
                return false;
            }
            n = versionNumber3.getMajor();
            n2 = versionNumber3.getMinor();
            bl5 = true;
        } else {
            bl5 = false;
        }
        if (bl5) {
            bl4 = true;
        } else {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: Version verification (String): String " + this.glVersion + ", Number(Str) " + versionNumber2);
            }
            if (null != versionNumber2) {
                int n6 = versionNumber2.getMajor();
                if (bl2 && ((bl7 || n >= 3) && versionNumber2.compareTo(versionNumber) < 0 || bl7 && (2 == n && (2 > n6 || n6 > 3) || (1 == n || 3 <= n) && n != n6))) {
                    if (DEBUG) {
                        System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, GL version mismatch (String): " + GLContext.getGLVersion(n, n2, n3, null) + " -> " + this.glVersion + ", " + versionNumber2);
                    }
                    return false;
                }
                if (bl2 && !bl5 && n >= 3) {
                    if (DEBUG) {
                        System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, GL3/ES3 version Int failed, String: " + GLContext.getGLVersion(n, n2, n3, null) + " -> " + this.glVersion + ", " + versionNumber2);
                    }
                    return false;
                }
                n = versionNumber2.getMajor();
                n2 = versionNumber2.getMinor();
                bl4 = true;
            } else {
                bl4 = false;
            }
        }
        if (bl2 && !bl4) {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, No GL version validation possible: " + GLContext.getGLVersion(n, n2, n3, null) + " -> " + this.glVersion);
            }
            return false;
        }
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: Post version verification req " + GLContext.getGLVersion(versionNumber.getMajor(), versionNumber.getMinor(), n4, null) + " -> has " + GLContext.getGLVersion(n, n2, n3, null) + ", strictMatch " + bl2 + ", versionValidated " + bl4 + ", versionGL3IntOK " + bl5);
        }
        if (n < 2) {
            n3 &= 0xFFFFF3FF;
        }
        if (!this.isCurrentContextHardwareRasterizer()) {
            n3 |= 0x40;
        }
        VersionNumberString versionNumberString = GLVersionNumber.createVendorVersion(this.glVersion);
        this.setRendererQuirks(abstractGraphicsDevice, this.getDrawableImpl().getFactoryImpl(), versionNumber.getMajor(), versionNumber.getMinor(), n4, n, n2, n3, versionNumberString, bl3);
        if (bl2 && this.glRendererQuirks.exist(6)) {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, GL is not compliant: " + GLContext.getGLVersion(n, n2, n3, this.glVersion) + ", " + this.glRenderer);
            }
            return false;
        }
        this.contextFQN = GLContextImpl.getContextFQN(abstractGraphicsDevice, n, n2, n3);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.0 validated FQN: " + this.contextFQN + " - " + GLContext.getGLVersion(n, n2, n3, this.glVersion));
        }
        object = null;
        Object object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedGLProcAddress.get(this.contextFQN);
            if (null != object && !this.verifyInstance(this.gl.getGLProfile(), "ProcAddressTable", object)) {
                throw new InternalError("GLContext GL ProcAddressTable mapped key(" + this.contextFQN + " - " + GLContext.getGLVersion(n, n2, n3, null) + ") -> " + object.getClass().getName() + " not matching " + this.gl.getGLProfile().getGLImplBaseClassName());
            }
        }
        if (null != object) {
            this.glProcAddressTable = (ProcAddressTable)object;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ProcAddressTable reusing key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(object.hashCode()));
            }
        } else {
            this.glProcAddressTable = (ProcAddressTable)this.createInstance(this.gl.getGLProfile(), false, new Object[]{new GLProcAddressResolver()});
            this.resetProcAddressTable(this.getGLProcAddressTable());
            object2 = mappedContextTypeObjectLock;
            synchronized (object2) {
                mappedGLProcAddress.put(this.contextFQN, this.getGLProcAddressTable());
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ProcAddressTable mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(this.getGLProcAddressTable().hashCode()));
                }
            }
        }
        Object object3 = mappedContextTypeObjectLock;
        synchronized (object3) {
            object2 = mappedExtensionAvailabilityCache.get(this.contextFQN);
        }
        if (null != object2) {
            this.extensionAvailability = object2;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ExtensionAvailabilityCache reusing key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(object2.hashCode()) + " - entries: " + ((ExtensionAvailabilityCache)object2).getTotalExtensionCount());
            }
        } else {
            this.extensionAvailability = new ExtensionAvailabilityCache();
            this.setContextVersion(n, n2, n3, versionNumberString, false);
            this.extensionAvailability.reset(this);
            object3 = mappedContextTypeObjectLock;
            synchronized (object3) {
                mappedExtensionAvailabilityCache.put(this.contextFQN, this.extensionAvailability);
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ExtensionAvailabilityCache mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(this.extensionAvailability.hashCode()) + " - entries: " + this.extensionAvailability.getTotalExtensionCount());
                }
            }
        }
        if (bl7) {
            if (n >= 3) {
                n3 |= 0xC00;
                n3 |= 0x1000;
            } else if (n >= 2) {
                n3 |= 0x400;
                n3 |= 0x1000;
            }
        } else if (n > 4 || n == 4 && n2 >= 3 || (n > 3 || n == 3 && n2 >= 1) && this.isExtensionAvailable("GL_ARB_ES3_compatibility")) {
            n3 |= 0xC00;
            n3 |= 0x1000;
        } else if (this.isExtensionAvailable("GL_ARB_ES2_compatibility")) {
            n3 |= 0x400;
            n3 |= 0x1000;
        } else if (GLContextImpl.hasFBOImpl(n, n3, this.extensionAvailability)) {
            n3 |= 0x1000;
        }
        if (bl7 && n == 1 || this.isExtensionAvailable("GL_OES_single_precision")) {
            n3 |= 0x2000;
        }
        if (FORCE_NO_FBO_SUPPORT) {
            n3 &= 0xFFFFEFFF;
        }
        this.setContextVersion(n, n2, n3, versionNumberString, true);
        this.finalizeInit(this.gl);
        this.setDefaultSwapInterval();
        int n7 = this.gl.glGetError();
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: OK " + this.contextFQN + " - " + GLContext.getGLVersion(this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions, null) + " - glErr " + GLContextImpl.toHexString(n7));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void setRendererQuirks(AbstractGraphicsDevice abstractGraphicsDevice, GLDrawableFactoryImpl gLDrawableFactoryImpl, int n, int n2, int n3, int n4, int n5, int n6, VersionNumberString versionNumberString, boolean bl) {
        Object object;
        Object object2;
        GLRendererQuirks gLRendererQuirks;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        block66: {
            block67: {
                boolean bl9;
                block65: {
                    boolean bl10;
                    bl8 = 0 == (n6 & 0x40);
                    bl7 = 0 != (n6 & 2);
                    bl6 = 0 != (n6 & 8);
                    bl5 = NativeWindowFactory.TYPE_X11 == NativeWindowFactory.getNativeWindowType(true);
                    bl4 = Platform.getOSType() == Platform.OSType.WINDOWS;
                    boolean bl11 = bl3 = this.glRenderer.contains("Mesa ") || this.glRenderer.contains("Gallium ");
                    if (!bl3) {
                        bl2 = this.glVendor.contains("ATI Technologies") || this.glRenderer.startsWith("ATI ");
                        bl10 = this.glVendor.contains("NVIDIA Corporation") || this.glRenderer.contains("NVIDIA ");
                        bl9 = this.glVendor.startsWith("Intel");
                    } else {
                        bl2 = false;
                        bl10 = false;
                        bl9 = false;
                    }
                    gLRendererQuirks = new GLRendererQuirks();
                    if (bl6 && 2 == n && 2 < n4) {
                        if (DEBUG) {
                            System.err.println("Quirk: " + GLRendererQuirks.toString(15) + ": cause: ES req " + n + " and 2 < " + n4);
                        }
                        gLRendererQuirks.addQuirk(15);
                        if (bl) {
                            GLRendererQuirks.addStickyDeviceQuirk(abstractGraphicsDevice, 15);
                        } else {
                            object2 = GLContextImpl.class;
                            // MONITORENTER : jogamp.opengl.GLContextImpl.class
                            GLRendererQuirks.addStickyDeviceQuirk(abstractGraphicsDevice, 15);
                            // MONITOREXIT : object2
                        }
                    }
                    if (Platform.getOSType() != Platform.OSType.MACOS) break block65;
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(3) + ": cause: OS " + Platform.getOSType());
                    }
                    gLRendererQuirks.addQuirk(3);
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(20) + ": cause: OS " + Platform.getOSType());
                    }
                    gLRendererQuirks.addQuirk(20);
                    if (Platform.getOSVersionNumber().compareTo(PlatformPropsImpl.OSXVersion.Mavericks) >= 0 && 3 == n && 4 == n4) {
                        if (DEBUG) {
                            System.err.println("Quirk: " + GLRendererQuirks.toString(13) + ": cause: OS " + Platform.getOSType() + ", OS Version " + Platform.getOSVersionNumber() + ", req " + n + "." + n2);
                        }
                        gLRendererQuirks.addQuirk(13);
                        if (bl) {
                            GLRendererQuirks.addStickyDeviceQuirk(abstractGraphicsDevice, 13);
                        }
                    }
                    if (bl10) {
                        object = new VersionNumber(10, 7, 3);
                        if (Platform.getOSVersionNumber().compareTo(object) < 0) {
                            if (DEBUG) {
                                System.err.println("Quirk: " + GLRendererQuirks.toString(7) + ": cause: OS " + Platform.getOSType() + ", OS Version " + Platform.getOSVersionNumber() + ", Renderer " + this.glRenderer);
                            }
                            gLRendererQuirks.addQuirk(7);
                        }
                        if (Platform.getOSVersionNumber().compareTo(PlatformPropsImpl.OSXVersion.Lion) < 0) {
                            if (DEBUG) {
                                System.err.println("Quirk: " + GLRendererQuirks.toString(12) + ": cause: OS " + Platform.getOSType() + ", OS Version " + Platform.getOSVersionNumber() + ", Renderer " + this.glRenderer);
                            }
                            gLRendererQuirks.addQuirk(12);
                        }
                    }
                    break block66;
                }
                if (!bl4) break block67;
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(1) + ": cause: OS " + Platform.getOSType());
                }
                gLRendererQuirks.addQuirk(1);
                if (bl2) {
                    object = new VersionNumber(5, 1, 0);
                    object2 = new VersionNumber(12, 102, 3);
                    if (versionNumberString.compareTo((VersionNumber)object2) < 0) {
                        if (DEBUG) {
                            System.err.println("Quirk: " + GLRendererQuirks.toString(10) + ": cause: OS " + Platform.getOSType() + ", [Vendor " + this.glVendor + " or Renderer " + this.glRenderer + "], driverVersion " + versionNumberString);
                        }
                        gLRendererQuirks.addQuirk(10);
                    }
                    if (Platform.getOSVersionNumber().compareTo(object) <= 0) {
                        if (DEBUG) {
                            System.err.println("Quirk: " + GLRendererQuirks.toString(9) + ": cause: OS-Version " + Platform.getOSType() + " " + Platform.getOSVersionNumber() + ", [Vendor " + this.glVendor + " or Renderer " + this.glRenderer + "]");
                        }
                        gLRendererQuirks.addQuirk(9);
                    }
                    break block66;
                } else if (bl9 && this.glRenderer.equals("Intel Bear Lake B")) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(19) + ": cause: OS " + Platform.getOSType() + ", [Vendor " + this.glVendor + " and Renderer " + this.glRenderer + "]");
                    }
                    gLRendererQuirks.addQuirk(19);
                }
                break block66;
            }
            if (Platform.OSType.ANDROID == Platform.getOSType()) {
                if (this.glRenderer.contains("PowerVR")) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(2) + ": cause: OS " + Platform.getOSType() + ", Renderer " + this.glRenderer);
                    }
                    gLRendererQuirks.addQuirk(2);
                }
                if (this.glRenderer.contains("Immersion.16")) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(14) + ": cause: OS " + Platform.getOSType() + ", Renderer " + this.glRenderer);
                    }
                    gLRendererQuirks.addQuirk(14);
                }
            }
        }
        if (bl5) {
            if (this.glRenderer.contains("Mesa ")) {
                if (this.glRenderer.contains("X11") && versionNumberString.compareTo(Version800) < 0) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(8) + ": cause: X11 Renderer=" + this.glRenderer + ", Version=[vendor " + versionNumberString + ", GL " + this.glVersion + "]");
                    }
                    gLRendererQuirks.addQuirk(8);
                }
            } else if (bl2) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(8) + ": cause: X11 Renderer=" + this.glRenderer);
                }
                gLRendererQuirks.addQuirk(8);
            } else if (X11Util.getMarkAllDisplaysUnclosable()) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(8) + ": cause: X11Util Downstream");
                }
                gLRendererQuirks.addQuirk(8);
            }
        }
        if (bl3) {
            object = new VersionNumber(8, 0, 0);
            object2 = new VersionNumber(9, 2, 1);
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(4) + ": cause: Renderer " + this.glRenderer);
            }
            gLRendererQuirks.addQuirk(4);
            if (bl8) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(0) + ": cause: Renderer " + this.glRenderer);
                }
                gLRendererQuirks.addQuirk(0);
            } else if (versionNumberString.compareTo(object) < 0) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(18) + ": cause: Renderer " + this.glRenderer + " / Mesa-Version " + versionNumberString);
                }
                gLRendererQuirks.addQuirk(18);
            }
            if (bl7 && (n4 > 3 || n4 == 3 && n5 >= 1)) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(6) + ": cause: Renderer " + this.glRenderer);
                }
                gLRendererQuirks.addQuirk(6);
            }
            if (this.glRenderer.contains("Intel(R)") && versionNumberString.compareTo((VersionNumber)object2) >= 0 && bl5) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(14) + ": cause: X11 / Renderer " + this.glRenderer + " / Mesa-Version " + versionNumberString);
                }
                gLRendererQuirks.addQuirk(14);
            }
            if (this.glVendor.contains("nouveau")) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(17) + ": cause: X11 / Renderer " + this.glRenderer + " / Vendor " + this.glVendor);
                }
                gLRendererQuirks.addQuirk(17);
                if (bl) {
                    GLRendererQuirks.addStickyDeviceQuirk(abstractGraphicsDevice, 17);
                }
            }
            if (bl4 && this.glRenderer.contains("SVGA3D") && versionNumberString.compareTo(object) < 0) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(11) + ": cause: OS " + Platform.getOSType() + " / Renderer " + this.glRenderer + " / Mesa-Version " + versionNumberString);
                }
                gLRendererQuirks.addQuirk(11);
            }
        }
        if (FORCE_NO_COLOR_RENDERBUFFER) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(18) + ": cause: property");
            }
            gLRendererQuirks.addQuirk(18);
        }
        if (FORCE_MIN_FBO_SUPPORT || gLRendererQuirks.exist(18)) {
            if (DEBUG) {
                object2 = FORCE_MIN_FBO_SUPPORT ? "property, " : "";
                String string = gLRendererQuirks.exist(18) ? "BuggyColorRenderbuffer" : "";
                System.err.println("Quirk: " + GLRendererQuirks.toString(11) + ": cause: " + (String)object2 + string);
            }
            gLRendererQuirks.addQuirk(11);
        }
        if (DEBUG) {
            System.err.println("Quirks local.0: " + gLRendererQuirks);
        }
        GLRendererQuirks.pushStickyDeviceQuirks(abstractGraphicsDevice, gLRendererQuirks);
        object = gLDrawableFactoryImpl.getDefaultDevice();
        if (!GLRendererQuirks.areSameStickyDevice((AbstractGraphicsDevice)object, abstractGraphicsDevice)) {
            GLRendererQuirks.pushStickyDeviceQuirks((AbstractGraphicsDevice)object, gLRendererQuirks);
        }
        if (bl6 && !GLRendererQuirks.areSameStickyDevice((AbstractGraphicsDevice)(object2 = GLDrawableFactory.getEGLFactory().getDefaultDevice()), abstractGraphicsDevice) && !GLRendererQuirks.areSameStickyDevice((AbstractGraphicsDevice)object2, (AbstractGraphicsDevice)object)) {
            GLRendererQuirks.pushStickyDeviceQuirks((AbstractGraphicsDevice)object2, gLRendererQuirks);
        }
        this.glRendererQuirks = gLRendererQuirks;
        if (!DEBUG) return;
        System.err.println("Quirks local.X: " + this.glRendererQuirks);
        System.err.println("Quirks sticky on " + abstractGraphicsDevice + ": " + GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice));
    }

    private static final boolean hasFBOImpl(int n, int n2, ExtensionAvailabilityCache extensionAvailabilityCache) {
        return 0 != (n2 & 8) && n >= 2 || n >= 3 || null != extensionAvailabilityCache && (extensionAvailabilityCache.isExtensionAvailable("GL_ARB_ES2_compatibility") || extensionAvailabilityCache.isExtensionAvailable("GL_ARB_framebuffer_object") || extensionAvailabilityCache.isExtensionAvailable("GL_EXT_framebuffer_object") || extensionAvailabilityCache.isExtensionAvailable("GL_OES_framebuffer_object"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeCachedVersion(int n, int n2, int n3) {
        int n4;
        Object object;
        if (!this.isCurrentContextHardwareRasterizer()) {
            n3 |= 0x40;
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        this.contextFQN = GLContextImpl.getContextFQN(abstractGraphicsDevice, n, n2, n3);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": RM Context FQN: " + this.contextFQN + " - " + GLContext.getGLVersion(n, n2, n3, null));
        }
        Object object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedGLProcAddress.remove(this.contextFQN);
            if (DEBUG) {
                n4 = null != object ? object.hashCode() : 0;
                System.err.println(GLContextImpl.getThreadName() + ": RM GLContext GL ProcAddressTable mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(n4));
            }
        }
        object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedExtensionAvailabilityCache.remove(this.contextFQN);
            if (DEBUG) {
                n4 = null != object ? object.hashCode() : 0;
                System.err.println(GLContextImpl.getThreadName() + ": RM GLContext GL ExtensionAvailabilityCache mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(n4));
            }
        }
    }

    private final boolean isCurrentContextHardwareRasterizer() {
        boolean bl = true;
        bl = !this.drawable.getChosenGLCapabilities().getHardwareAccelerated() ? false : !this.glRendererLowerCase.contains("software") && !this.glRendererLowerCase.contains("mesa x11") && !this.glRendererLowerCase.contains("softpipe") && !this.glRendererLowerCase.contains("llvmpipe");
        return bl;
    }

    protected abstract void updateGLXProcAddressTable();

    protected abstract StringBuilder getPlatformExtensionsStringImpl();

    @Override
    public final boolean isFunctionAvailable(String string) {
        ProcAddressTable procAddressTable;
        if (null != this.glProcAddressTable) {
            try {
                if (this.glProcAddressTable.isFunctionAvailable(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (procAddressTable = this.getPlatformExtProcAddressTable())) {
            try {
                if (procAddressTable.isFunctionAvailable(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GLDynamicLookupHelper gLDynamicLookupHelper = this.getDrawableImpl().getGLDynamicLookupHelper();
        String string2 = GLNameResolver.normalizeVEN(GLNameResolver.normalizeARB(string, true), true);
        boolean bl = false;
        int n = GLNameResolver.getFuncNamePermutationNumber(string2);
        for (int i = 0; !bl && i < n; ++i) {
            String string3 = GLNameResolver.getFuncNamePermutation(string2, i);
            try {
                bl = gLDynamicLookupHelper.isFunctionAvailable(string3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    @Override
    public final boolean isExtensionAvailable(String string) {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isExtensionAvailable(this.mapToRealGLExtensionName(string));
        }
        return false;
    }

    @Override
    public final int getPlatformExtensionCount() {
        return null != this.extensionAvailability ? this.extensionAvailability.getPlatformExtensionCount() : 0;
    }

    @Override
    public final String getPlatformExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getPlatformExtensionsString();
        }
        return null;
    }

    @Override
    public final int getGLExtensionCount() {
        return null != this.extensionAvailability ? this.extensionAvailability.getGLExtensionCount() : 0;
    }

    @Override
    public final String getGLExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getGLExtensionsString();
        }
        return null;
    }

    public final boolean isExtensionCacheInitialized() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isInitialized();
        }
        return false;
    }

    protected static String getContextFQN(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, int n3) {
        return abstractGraphicsDevice.getUniqueID() + "-" + GLContextImpl.toHexString(GLContextImpl.composeBits(n, n2, n3 &= 0x3FF));
    }

    protected final String getContextFQN() {
        return this.contextFQN;
    }

    @Override
    public int getDefaultPixelDataType() {
        this.evalPixelDataType();
        return this.pixelDataType;
    }

    @Override
    public int getDefaultPixelDataFormat() {
        this.evalPixelDataType();
        return this.pixelDataFormat;
    }

    private final void evalPixelDataType() {
        if (!this.pixelDataEvaluated) {
            boolean bl = false;
            if (this.isGLES2Compatible() || this.isExtensionAvailable("GL_OES_read_format")) {
                int[] nArray = new int[]{0, 0};
                this.gl.glGetIntegerv(35739, nArray, 0);
                this.gl.glGetIntegerv(35738, nArray, 1);
                this.pixelDataFormat = nArray[0];
                this.pixelDataType = nArray[1];
                boolean bl2 = bl = 0 != this.pixelDataFormat && 0 != this.pixelDataType;
            }
            if (!bl) {
                this.pixelDataFormat = 6408;
                this.pixelDataType = 5121;
            }
            this.pixelDataEvaluated = true;
        }
    }

    public final GLBufferObjectTracker getBufferObjectTracker() {
        return this.bufferObjectTracker;
    }

    public final GLBufferStateTracker getBufferStateTracker() {
        return this.bufferStateTracker;
    }

    public final GLStateTracker getGLStateTracker() {
        return this.glStateTracker;
    }

    public final boolean isOwner(Thread thread) {
        return this.lock.isOwner(thread);
    }

    public final boolean hasWaiters() {
        return this.lock.getQueueLength() > 0;
    }

    public final int getLockCount() {
        return this.lock.getHoldCount();
    }

    public final void setBoundFramebuffer(int n, int n2) {
        if (0 > n2) {
            return;
        }
        switch (n) {
            case 36160: {
                this.boundFBOTarget[0] = n2;
                this.boundFBOTarget[1] = n2;
                break;
            }
            case 36009: {
                this.boundFBOTarget[0] = n2;
                break;
            }
            case 36008: {
                this.boundFBOTarget[1] = n2;
                break;
            }
        }
    }

    @Override
    public final int getBoundFramebuffer(int n) {
        switch (n) {
            case 36009: 
            case 36160: {
                return this.boundFBOTarget[0];
            }
            case 36008: {
                return this.boundFBOTarget[1];
            }
        }
        throw new InternalError("Invalid FBO target name: " + GLContextImpl.toHexString(n));
    }

    @Override
    public final int getDefaultDrawFramebuffer() {
        return this.drawable.getDefaultDrawFramebuffer();
    }

    @Override
    public final int getDefaultReadFramebuffer() {
        return this.drawable.getDefaultReadFramebuffer();
    }

    @Override
    public final int getDefaultReadBuffer() {
        return this.drawable.getDefaultReadBuffer(this.gl, this.drawableRead != this.drawable);
    }

    @Override
    public final String getGLDebugMessageExtension() {
        return this.glDebugHandler.getExtension();
    }

    @Override
    public final boolean isGLDebugMessageEnabled() {
        return this.glDebugHandler.isEnabled();
    }

    @Override
    public final int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public final void setContextCreationFlags(int n) {
        if (!this.isCreated()) {
            this.additionalCtxCreationFlags = n & 0x20;
        }
    }

    @Override
    public final boolean isGLDebugSynchronous() {
        return this.glDebugHandler.isSynchronous();
    }

    @Override
    public final void setGLDebugSynchronous(boolean bl) {
        this.glDebugHandler.setSynchronous(bl);
    }

    @Override
    public final void enableGLDebugMessage(boolean bl) throws GLException {
        if (!this.isCreated()) {
            this.additionalCtxCreationFlags = bl ? (this.additionalCtxCreationFlags |= 0x20) : (this.additionalCtxCreationFlags &= 0xFFFFFFDF);
        } else if (0 != (this.additionalCtxCreationFlags & 0x20) && null != this.getGLDebugMessageExtension()) {
            this.glDebugHandler.enable(bl);
        }
    }

    @Override
    public final void addGLDebugListener(GLDebugListener gLDebugListener) {
        this.glDebugHandler.addListener(gLDebugListener);
    }

    @Override
    public final void removeGLDebugListener(GLDebugListener gLDebugListener) {
        this.glDebugHandler.removeListener(gLDebugListener);
    }

    @Override
    public final void glDebugMessageControl(int n, int n2, int n3, int n4, IntBuffer intBuffer, boolean bl) {
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageControl(n, n2, n3, n4, intBuffer, bl);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageEnableAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n3, n4, intBuffer, bl);
        }
    }

    @Override
    public final void glDebugMessageControl(int n, int n2, int n3, int n4, int[] nArray, int n5, boolean bl) {
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageControl(n, n2, n3, n4, nArray, n5, bl);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageEnableAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n3, n4, nArray, n5, bl);
        }
    }

    @Override
    public final void glDebugMessageInsert(int n, int n2, int n3, int n4, String string) {
        int n5;
        int n6 = n5 = null != string ? string.length() : 0;
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageInsert(n, n2, n3, n4, n5, string);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageInsertAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n4, n3, n5, string);
        }
    }

    private static native String glGetStringInt(int var0, long var1);

    private static native void glGetIntegervInt(int var0, int[] var1, int var2, long var3);
}

