/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import jogamp.opengl.GLContextImpl;

public class GLContextShareSet {
    private static final boolean DEBUG = GLContextImpl.DEBUG;
    private static final Map<GLContext, ShareSet> shareMap = new IdentityHashMap<GLContext, ShareSet>();

    public static synchronized void registerSharing(GLContext gLContext, GLContext gLContext2) {
        if (gLContext == null || gLContext2 == null) {
            throw new IllegalArgumentException("Both slave and master must be non-null");
        }
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (null == shareSet) {
            shareSet = GLContextShareSet.entryFor(gLContext2);
        }
        if (null == shareSet) {
            shareSet = new ShareSet();
        }
        shareSet.addNew(gLContext, gLContext2);
        shareSet.addIfNew(gLContext2, gLContext2);
        GLContextShareSet.addEntry(gLContext, shareSet);
        GLContextShareSet.addEntry(gLContext2, shareSet);
        if (DEBUG) {
            System.err.println("GLContextShareSet: registereSharing: 1: " + GLContextShareSet.toHexString(gLContext.hashCode()) + ", 2: " + GLContextShareSet.toHexString(gLContext2.hashCode()));
        }
    }

    public static synchronized void unregisterSharing(GLContext gLContext) {
        if (gLContext == null) {
            throw new IllegalArgumentException("Last context is null");
        }
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet == null) {
            throw new GLException("Last context is unknown: " + gLContext);
        }
        Set<GLContext> set = shareSet.getCreatedShares();
        if (set.size() > 0) {
            throw new GLException("Last context's share set contains " + set.size() + " non destroyed context");
        }
        set = shareSet.getDestroyedShares();
        if (set.size() == 0) {
            throw new GLException("Last context's share set contains no destroyed context");
        }
        if (DEBUG) {
            System.err.println("GLContextShareSet: unregisterSharing: " + GLContextShareSet.toHexString(gLContext.hashCode()) + ", entries: " + set.size());
        }
        for (GLContext gLContext2 : set) {
            if (null != GLContextShareSet.removeEntry(gLContext2)) continue;
            throw new GLException("Removal of shareSet for context failed");
        }
    }

    public static synchronized boolean isShared(GLContext gLContext) {
        if (gLContext == null) {
            throw new IllegalArgumentException("context is null");
        }
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        return shareSet != null;
    }

    public static synchronized GLContext getSharedMaster(GLContext gLContext) {
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet == null) {
            return null;
        }
        return shareSet.getMaster(gLContext);
    }

    private static synchronized Set<GLContext> getCreatedSharesImpl(GLContext gLContext) {
        if (gLContext == null) {
            throw new IllegalArgumentException("context is null");
        }
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet != null) {
            return shareSet.getCreatedShares();
        }
        return null;
    }

    private static synchronized Set<GLContext> getDestroyedSharesImpl(GLContext gLContext) {
        if (gLContext == null) {
            throw new IllegalArgumentException("context is null");
        }
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet != null) {
            return shareSet.getDestroyedShares();
        }
        return null;
    }

    public static synchronized boolean hasCreatedSharedLeft(GLContext gLContext) {
        Set<GLContext> set = GLContextShareSet.getCreatedSharesImpl(gLContext);
        return null != set && set.size() > 0;
    }

    public static synchronized ArrayList<GLContext> getCreatedShares(GLContext gLContext) {
        ArrayList<GLContext> arrayList = new ArrayList<GLContext>();
        Set<GLContext> set = GLContextShareSet.getCreatedSharesImpl(gLContext);
        if (null != set) {
            for (GLContext gLContext2 : set) {
                if (gLContext2 == gLContext) continue;
                arrayList.add(gLContext2);
            }
        }
        return arrayList;
    }

    public static synchronized ArrayList<GLContext> getDestroyedShares(GLContext gLContext) {
        ArrayList<GLContext> arrayList = new ArrayList<GLContext>();
        Set<GLContext> set = GLContextShareSet.getDestroyedSharesImpl(gLContext);
        if (null != set) {
            for (GLContext gLContext2 : set) {
                if (gLContext2 == gLContext) continue;
                arrayList.add(gLContext2);
            }
        }
        return arrayList;
    }

    public static synchronized boolean contextCreated(GLContext gLContext) {
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet != null) {
            shareSet.contextCreated(gLContext);
            return true;
        }
        return false;
    }

    public static synchronized boolean contextDestroyed(GLContext gLContext) {
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet != null) {
            shareSet.contextDestroyed(gLContext);
            return true;
        }
        return false;
    }

    private static ShareSet entryFor(GLContext gLContext) {
        return shareMap.get(gLContext);
    }

    private static void addEntry(GLContext gLContext, ShareSet shareSet) {
        if (shareMap.get(gLContext) == null) {
            shareMap.put(gLContext, shareSet);
        }
    }

    private static ShareSet removeEntry(GLContext gLContext) {
        return shareMap.remove(gLContext);
    }

    private static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    private static class ShareSet {
        private final Map<GLContext, GLContext> createdShares = new IdentityHashMap<GLContext, GLContext>();
        private final Map<GLContext, GLContext> destroyedShares = new IdentityHashMap<GLContext, GLContext>();

        private ShareSet() {
        }

        public final void addNew(GLContext gLContext, GLContext gLContext2) {
            GLContext gLContext3 = gLContext.isCreated() ? this.createdShares.put(gLContext, gLContext2) : this.destroyedShares.put(gLContext, gLContext2);
            if (null != gLContext3) {
                throw new InternalError("State of ShareSet corrupted: Slave " + GLContextShareSet.toHexString(gLContext.hashCode()) + " is not new w/ master " + GLContextShareSet.toHexString(gLContext3.hashCode()));
            }
        }

        public final void addIfNew(GLContext gLContext, GLContext gLContext2) {
            GLContext gLContext3 = this.getMaster(gLContext2);
            if (null == gLContext3) {
                this.addNew(gLContext, gLContext2);
            }
        }

        public final GLContext getMaster(GLContext gLContext) {
            GLContext gLContext2 = this.createdShares.get(gLContext);
            return null != gLContext2 ? gLContext2 : this.destroyedShares.get(gLContext);
        }

        public Set<GLContext> getCreatedShares() {
            return this.createdShares.keySet();
        }

        public Set<GLContext> getDestroyedShares() {
            return this.destroyedShares.keySet();
        }

        public void contextCreated(GLContext gLContext) {
            GLContext gLContext2 = this.destroyedShares.remove(gLContext);
            if (null == gLContext2) {
                throw new InternalError("State of ShareSet corrupted: Context " + GLContextShareSet.toHexString(gLContext.hashCode()) + " should have been in destroyed-set");
            }
            GLContext gLContext3 = this.createdShares.put(gLContext, gLContext2);
            if (null != gLContext3) {
                throw new InternalError("State of ShareSet corrupted: Context " + GLContextShareSet.toHexString(gLContext.hashCode()) + " shouldn't have been in created-set");
            }
        }

        public void contextDestroyed(GLContext gLContext) {
            GLContext gLContext2 = this.createdShares.remove(gLContext);
            if (null == gLContext2) {
                throw new InternalError("State of ShareSet corrupted: Context " + GLContextShareSet.toHexString(gLContext.hashCode()) + " should have been in created-set");
            }
            GLContext gLContext3 = this.destroyedShares.put(gLContext, gLContext2);
            if (null != gLContext3) {
                throw new InternalError("State of ShareSet corrupted: Context " + GLContextShareSet.toHexString(gLContext.hashCode()) + " shouldn't have been in destroyed-set");
            }
        }
    }
}

