/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.faces.bean.ManagedBean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class JoinfacesApplicationAnalyzer
implements ApplicationListener<ApplicationReadyEvent> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JoinfacesApplicationAnalyzer.class);

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.warnAboutJsfManagedBeans(event.getApplicationContext());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="getType() is always non-null when reached")
    private void warnAboutJsfManagedBeans(ConfigurableApplicationContext applicationContext) {
        String[] managedBeanNames;
        for (String managedBeanName : managedBeanNames = applicationContext.getBeanNamesForAnnotation(ManagedBean.class)) {
            log.warn("The spring bean '{}' of type '{}' is also annotated with '@{}'. This may lead to unexpected behaviour.", new Object[]{managedBeanName, applicationContext.getType(managedBeanName).getName(), ManagedBean.class.getName()});
        }
    }
}

