/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.servlet.initializer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.bean.NoneScoped;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.SessionScoped;
import javax.faces.bean.ViewScoped;
import javax.servlet.annotation.HandlesTypes;
import lombok.Generated;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.springframework.lang.Nullable;

public class JsfClassFactory {
    private Configuration jsfAnnotatedClassFactoryConfiguration;
    private Collection<URL> urls;
    private Map<Class<? extends Annotation>, Set<Class<?>>> annotatedClassMap;
    private Map<Class<?>, Set<Class<?>>> otherClassMap;

    public JsfClassFactory(Configuration jsfAnnotatedClassFactoryConfiguration) {
        this.jsfAnnotatedClassFactoryConfiguration = jsfAnnotatedClassFactoryConfiguration;
    }

    private Set<Class<? extends Annotation>> annotationsToExclude() {
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        if (this.jsfAnnotatedClassFactoryConfiguration.isExcludeScopedAnnotations()) {
            result.add(ViewScoped.class);
            result.add(SessionScoped.class);
            result.add(RequestScoped.class);
            result.add(NoneScoped.class);
        }
        return result;
    }

    private TypesHandled handlesTypes() {
        HandlesTypes ht = this.jsfAnnotatedClassFactoryConfiguration.getHandlesTypes();
        return new TypesHandled(ht, this.annotationsToExclude());
    }

    private void add(Collection<URL> urls, Collection<String> strings, Collection<URL> newURLs) {
        for (URL url : newURLs) {
            this.add(urls, strings, url);
        }
    }

    private void add(Collection<URL> urls, Collection<String> strings, URL url) {
        String string = url.toString();
        if (!strings.contains(string)) {
            urls.add(url);
            strings.add(string);
        }
    }

    private boolean isClassesFolder(String file) {
        return (file.endsWith("/classes/") || file.endsWith("/classes!/") || new File(file).isDirectory()) && !file.contains(".war*/WEB-INF/classes");
    }

    public Collection<URL> getURLs() {
        if (this.urls == null) {
            ArrayList<URL> result = new ArrayList<URL>();
            HashSet<String> strings = new HashSet<String>();
            this.add(result, strings, ClasspathHelper.forResource((String)"META-INF/faces-config.xml", (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()}));
            String anotherConfig = this.jsfAnnotatedClassFactoryConfiguration.getAnotherConfig();
            if (anotherConfig != null) {
                this.add(result, strings, ClasspathHelper.forResource((String)anotherConfig, (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()}));
            }
            ArrayList<URL> urlsClassesFolder = new ArrayList<URL>();
            HashSet<String> stringsClassesFolder = new HashSet<String>();
            this.add(urlsClassesFolder, stringsClassesFolder, ClasspathHelper.forJavaClassPath());
            this.add(urlsClassesFolder, stringsClassesFolder, ClasspathHelper.forManifest());
            for (URL url : urlsClassesFolder) {
                String file = url.getFile();
                if (!this.isClassesFolder(file)) continue;
                this.add(result, strings, url);
            }
            this.urls = result;
        }
        return this.urls;
    }

    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClassMap() {
        if (this.annotatedClassMap == null) {
            this.computeClasses();
        }
        return this.annotatedClassMap;
    }

    public Map<Class<?>, Set<Class<?>>> getOtherClassMap() {
        if (this.otherClassMap == null) {
            this.computeClasses();
        }
        return this.otherClassMap;
    }

    private void computeClasses() {
        this.annotatedClassMap = new HashMap();
        this.otherClassMap = new HashMap();
        TypesHandled handlesTypes = this.handlesTypes();
        if (!handlesTypes.isEmpty()) {
            Reflections reflections = new Reflections((org.reflections.Configuration)new ConfigurationBuilder().setExpandSuperTypes(false).setUrls(this.getURLs()));
            for (Class<? extends Annotation> clazz : handlesTypes.getAnnotationTypes()) {
                this.annotatedClassMap.put(clazz, reflections.getTypesAnnotatedWith(clazz));
            }
            for (Class<? extends Annotation> clazz : handlesTypes.getOtherTypes()) {
                this.otherClassMap.put(clazz, reflections.getSubTypesOf(clazz));
            }
        }
    }

    public Set<Class<?>> getAllClasses() {
        HashSet result = new HashSet();
        result.addAll(this.getAnnotatedClasses());
        result.addAll(this.getOtherClasses());
        return result;
    }

    public Set<Class<?>> getAnnotatedClasses() {
        return this.collectValues(this.getAnnotatedClassMap().values());
    }

    public Set<Class<?>> getOtherClasses() {
        return this.collectValues(this.getOtherClassMap().values());
    }

    private Set<Class<?>> collectValues(Collection<Set<Class<?>>> sets) {
        HashSet classes = new HashSet();
        for (Set<Class<?>> values : sets) {
            classes.addAll(values);
        }
        return classes;
    }

    static class TypesHandled {
        private Set<Class<? extends Annotation>> annotationTypes = new HashSet<Class<? extends Annotation>>();
        private Set<Class> otherTypes = new HashSet<Class>();

        TypesHandled(HandlesTypes handlesTypes, Set<Class<? extends Annotation>> annotationsToExclude) {
            if (handlesTypes != null) {
                for (Class type : handlesTypes.value()) {
                    if (type.isAnnotation()) {
                        Class annotation = type;
                        if (annotationsToExclude.contains(annotation)) continue;
                        this.annotationTypes.add(annotation);
                        continue;
                    }
                    this.otherTypes.add(type);
                }
            }
        }

        boolean isEmpty() {
            return this.annotationTypes.isEmpty() && this.otherTypes.isEmpty();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Set<Class<? extends Annotation>> getAnnotationTypes() {
            return this.annotationTypes;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Set<Class> getOtherTypes() {
            return this.otherTypes;
        }
    }

    public static class Configuration {
        @Nullable
        private HandlesTypes handlesTypes;
        private String anotherConfig;
        private boolean excludeScopedAnnotations;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        Configuration(@Nullable HandlesTypes handlesTypes, String anotherConfig, boolean excludeScopedAnnotations) {
            this.handlesTypes = handlesTypes;
            this.anotherConfig = anotherConfig;
            this.excludeScopedAnnotations = excludeScopedAnnotations;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static ConfigurationBuilder builder() {
            return new ConfigurationBuilder();
        }

        @Nullable
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HandlesTypes getHandlesTypes() {
            return this.handlesTypes;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getAnotherConfig() {
            return this.anotherConfig;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isExcludeScopedAnnotations() {
            return this.excludeScopedAnnotations;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setHandlesTypes(@Nullable HandlesTypes handlesTypes) {
            this.handlesTypes = handlesTypes;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setAnotherConfig(String anotherConfig) {
            this.anotherConfig = anotherConfig;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setExcludeScopedAnnotations(boolean excludeScopedAnnotations) {
            this.excludeScopedAnnotations = excludeScopedAnnotations;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Configuration)) {
                return false;
            }
            Configuration other = (Configuration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            HandlesTypes this$handlesTypes = this.getHandlesTypes();
            HandlesTypes other$handlesTypes = other.getHandlesTypes();
            if (this$handlesTypes == null ? other$handlesTypes != null : !this$handlesTypes.equals(other$handlesTypes)) {
                return false;
            }
            String this$anotherConfig = this.getAnotherConfig();
            String other$anotherConfig = other.getAnotherConfig();
            if (this$anotherConfig == null ? other$anotherConfig != null : !this$anotherConfig.equals(other$anotherConfig)) {
                return false;
            }
            return this.isExcludeScopedAnnotations() == other.isExcludeScopedAnnotations();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Configuration;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            HandlesTypes $handlesTypes = this.getHandlesTypes();
            result = result * 59 + ($handlesTypes == null ? 43 : $handlesTypes.hashCode());
            String $anotherConfig = this.getAnotherConfig();
            result = result * 59 + ($anotherConfig == null ? 43 : $anotherConfig.hashCode());
            result = result * 59 + (this.isExcludeScopedAnnotations() ? 79 : 97);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "JsfClassFactory.Configuration(handlesTypes=" + this.getHandlesTypes() + ", anotherConfig=" + this.getAnotherConfig() + ", excludeScopedAnnotations=" + this.isExcludeScopedAnnotations() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static class ConfigurationBuilder {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private HandlesTypes handlesTypes;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private String anotherConfig;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private boolean excludeScopedAnnotations;

            @SuppressFBWarnings(justification="generated code")
            @Generated
            ConfigurationBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public ConfigurationBuilder handlesTypes(HandlesTypes handlesTypes) {
                this.handlesTypes = handlesTypes;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public ConfigurationBuilder anotherConfig(String anotherConfig) {
                this.anotherConfig = anotherConfig;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public ConfigurationBuilder excludeScopedAnnotations(boolean excludeScopedAnnotations) {
                this.excludeScopedAnnotations = excludeScopedAnnotations;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public Configuration build() {
                return new Configuration(this.handlesTypes, this.anotherConfig, this.excludeScopedAnnotations);
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "JsfClassFactory.Configuration.ConfigurationBuilder(handlesTypes=" + this.handlesTypes + ", anotherConfig=" + this.anotherConfig + ", excludeScopedAnnotations=" + this.excludeScopedAnnotations + ")";
            }
        }
    }
}

