/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.myfaces;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import lombok.Generated;
import org.apache.myfaces.spi.AnnotationProvider;
import org.apache.myfaces.spi.AnnotationProviderWrapper;
import org.joinfaces.autoconfigure.ClasspathScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JoinFacesAnnotationProvider
extends AnnotationProviderWrapper {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JoinFacesAnnotationProvider.class);
    private static Map<Class<? extends Annotation>, Set<Class<?>>> annotatedClasses;

    static void setAnnotatedClasses(Map<Class<? extends Annotation>, Set<Class<?>>> annotatedClasses) {
        JoinFacesAnnotationProvider.annotatedClasses = annotatedClasses;
    }

    public JoinFacesAnnotationProvider() {
        this.findPreparedScanResult();
    }

    public JoinFacesAnnotationProvider(AnnotationProvider delegate) {
        super(delegate);
        this.findPreparedScanResult();
    }

    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(ExternalContext ctx) {
        if (annotatedClasses != null) {
            return annotatedClasses;
        }
        return super.getAnnotatedClasses(ctx);
    }

    private void findPreparedScanResult() {
        String resourceName = "META-INF/joinfaces/" + AnnotationProvider.class.getName() + ".classes";
        InputStream resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceName);
        if (resourceAsStream == null) {
            log.debug("No prepared scan result found.");
            return;
        }
        long start = System.nanoTime();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));){
            JoinFacesAnnotationProvider.setAnnotatedClasses(this.readAnnotatedClassesMap(bufferedReader));
            double ms = (double)(System.nanoTime() - start) / 1000000.0;
            log.info("Loading prepared scan result took {}ms", (Object)ms);
        }
        catch (IOException e) {
            log.warn("Failed to load {}", (Object)resourceName, (Object)e);
        }
    }

    private Map<Class<? extends Annotation>, Set<Class<?>>> readAnnotatedClassesMap(BufferedReader bufferedReader) {
        HashMap classes = new HashMap();
        bufferedReader.lines().forEach(line -> {
            Class<?> annotation;
            String[] split = line.split("=", 2);
            String annotationName = split[0];
            String classNameList = split[1];
            try {
                annotation = Class.forName(annotationName);
            }
            catch (ClassNotFoundException | LinkageError e) {
                log.warn("Failed to load annotation class {}", (Object)annotationName, (Object)e);
                return;
            }
            Set<Object> classSet = StringUtils.hasText((String)annotationName) ? ClasspathScanUtil.getClasses(Arrays.stream(classNameList.split(","))) : Collections.emptySet();
            classes.put(annotation, classSet);
        });
        return classes;
    }
}

