/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class JoinfacesApplicationAnalyzer
implements ApplicationListener<ApplicationStartedEvent> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JoinfacesApplicationAnalyzer.class);

    public void onApplicationEvent(ApplicationStartedEvent event) {
        try {
            Class<?> managedBeanClass = Class.forName("javax.faces.bean.ManagedBean");
            this.warnAboutJsfManagedBeans(event.getApplicationContext(), managedBeanClass);
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            // empty catch block
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="getType() is always non-null when reached")
    private void warnAboutJsfManagedBeans(ConfigurableApplicationContext applicationContext, Class<? extends Annotation> managedBeanClass) {
        String[] managedBeanNames;
        for (String managedBeanName : managedBeanNames = applicationContext.getBeanNamesForAnnotation(managedBeanClass)) {
            log.warn("The spring bean '{}' of type '{}' is also annotated with '@javax.faces.bean.ManagedBean'. This may lead to unexpected behaviour.", (Object)managedBeanName, (Object)applicationContext.getType(managedBeanName).getName());
        }
    }
}

