/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.tomcat;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Enumeration;
import lombok.Generated;
import org.apache.catalina.Context;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.JarWarResourceSet;
import org.joinfaces.autoconfigure.tomcat.TomcatRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class JsfTomcatApplicationListener
implements ApplicationListener<ApplicationReadyEvent> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsfTomcatApplicationListener.class);
    private final Context context;

    private JarWarResourceSet getFirstJarWarResourceSetAtJarResources(WebResourceRoot resources) {
        JarWarResourceSet result = null;
        for (WebResourceSet resourceSet : resources.getJarResources()) {
            if (!(resourceSet instanceof JarWarResourceSet)) continue;
            result = (JarWarResourceSet)resourceSet;
            break;
        }
        return result;
    }

    private DirResourceSet getFirstDirResourceSetAtJarResources(WebResourceRoot resources) {
        DirResourceSet result = null;
        for (WebResourceSet resourceSet : resources.getJarResources()) {
            if (!(resourceSet instanceof DirResourceSet)) continue;
            result = (DirResourceSet)resourceSet;
            break;
        }
        return result;
    }

    private URL mainFile(WebResourceRoot resources) {
        URL result = null;
        for (WebResourceSet resourceSet : resources.getJarResources()) {
            if (!(resourceSet instanceof JarWarResourceSet)) continue;
            result = resourceSet.getBaseUrl();
            break;
        }
        return result;
    }

    private String base(URL url) throws URISyntaxException {
        String result;
        if (url.getProtocol().equals("jar")) {
            result = url.getFile();
            result = result.substring("file:".length());
            result = result.substring(0, result.indexOf("!/"));
        } else {
            result = Paths.get(url.toURI()).toString();
        }
        return result;
    }

    private boolean isUberJar(WebResourceRoot resources) {
        JarWarResourceSet jarWarResourceSet = this.getFirstJarWarResourceSetAtJarResources(resources);
        return jarWarResourceSet != null && jarWarResourceSet.getBaseUrl().getFile().endsWith(".jar");
    }

    private boolean isUberWar(WebResourceRoot resources) {
        JarWarResourceSet jarWarResourceSet = this.getFirstJarWarResourceSetAtJarResources(resources);
        return jarWarResourceSet != null && jarWarResourceSet.getBaseUrl().getFile().endsWith(".war");
    }

    private boolean isTesting(WebResourceRoot resources) {
        return !this.isUberJar(resources) && !this.isUberWar(resources) && this.getFirstDirResourceSetAtJarResources(resources) == null;
    }

    private boolean isUnpackagedJar(WebResourceRoot resources) {
        return !this.isUberJar(resources) && this.getFirstDirResourceSetAtJarResources(resources) != null;
    }

    TomcatRuntime getTomcatRuntime(WebResourceRoot resources) {
        TomcatRuntime result = null;
        if (this.isUberJar(resources)) {
            result = TomcatRuntime.UBER_JAR;
        } else if (this.isUberWar(resources)) {
            result = TomcatRuntime.UBER_WAR;
        } else if (this.isTesting(resources)) {
            result = TomcatRuntime.TEST;
        } else if (this.isUnpackagedJar(resources)) {
            result = TomcatRuntime.UNPACKAGED_JAR;
        }
        return result;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        WebResourceRoot resources;
        if (this.context != null && (resources = this.context.getResources()) != null && resources.getJarResources() != null) {
            TomcatRuntime tomcatRuntime = this.getTomcatRuntime(resources);
            switch (tomcatRuntime) {
                case UBER_JAR: {
                    try {
                        this.addMainJarResourceSet(resources);
                    }
                    catch (URISyntaxException ex) {
                        log.error(ex.getMessage());
                    }
                    break;
                }
                case UNPACKAGED_JAR: {
                    break;
                }
                case UBER_WAR: {
                    break;
                }
                case TEST: {
                    try {
                        this.addClasspathResourceSets(resources);
                    }
                    catch (IOException | URISyntaxException ex) {
                        log.error(ex.getMessage());
                    }
                    break;
                }
            }
        }
    }

    private void addMainJarResourceSet(WebResourceRoot resources) throws URISyntaxException {
        String webAppMount = "/";
        String archivePath = null;
        String internalPath = "/META-INF/resources";
        String bootInfPath = "/BOOT-INF/classes";
        resources.createWebResourceSet(WebResourceRoot.ResourceSetType.POST, webAppMount, this.base(this.mainFile(resources)), archivePath, internalPath);
        resources.createWebResourceSet(WebResourceRoot.ResourceSetType.POST, webAppMount, this.base(this.mainFile(resources)), archivePath, bootInfPath + internalPath);
    }

    private void addClasspathResourceSets(WebResourceRoot resources) throws URISyntaxException, IOException {
        String webAppMount = "/";
        String archivePath = null;
        String internalPath = "/META-INF/resources";
        Enumeration<URL> urlEnumeration = this.getClass().getClassLoader().getResources("META-INF/resources/");
        while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            int index = url.toExternalForm().lastIndexOf("META-INF/resources/");
            if (index != -1) {
                url = new URL(url, url.toExternalForm().substring(0, index));
            }
            resources.createWebResourceSet(WebResourceRoot.ResourceSetType.POST, webAppMount, this.base(url), archivePath, internalPath);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsfTomcatApplicationListener(Context context) {
        this.context = context;
    }
}

